import { _decorator, Component, Node, resources, Prefab, instantiate, Animation } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('TestScene')
export class TestScene extends Component {

    @property(Node)
    root: Node = null!;

    onLoad() {
        // 获取上一个场景加载的prefab
        let prefab = resources.get("player1_h01", Prefab);
        const playerNode = instantiate(prefab);
        this.root.addChild(playerNode);

        // 获取动画组件并播放
        const animation = playerNode.getComponent(Animation);
        if (animation) {
            animation.play();
        } else {
            console.error("未找到动画组件");
        }
    }

    start() {
        
    }

    update(deltaTime: number) {

    }
}

