import { _decorator, Component, sp,js, find } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('NewComponent')
export class NewComponent extends Component {
    start() {
        let spine = find('Canvas/spineboy').getComponent(sp.Skeleton);
        let com = find('Canvas/Node').getComponent(sp.Skeleton);
        this.copySkeletonData(com,spine.skeletonData,true)
    }

    update(deltaTime: number) {
        
    }
    copySkeletonData(spine: sp.Skeleton, data: sp.SkeletonData, is_set: boolean = true) {
        let date = new Date();
        // 记录当前播放的动画
        // const animation = spine.animation
        const spdata = data;
        let copy = new sp.SkeletonData();
        js.mixin(copy, spdata);
        // @ts-ignore
        copy._uuid = spdata._uuid + "_" + date.getTime() + "_copy";
        let old = copy.name;
        let newName = copy.name + "_copy";
        copy.name = newName;
        copy.atlasText = copy.atlasText.replace(old, newName);
        // @ts-ignore
        copy.textureNames[0] = newName + ".png";
        // @ts-ignore
        copy.init && copy.init();

        if (is_set) {
            spine.skeletonData = copy;
            // 继续播放的动画，不然会停止
            spine.setAnimation(0, 'walk', true);
            // console.log(animation,' animation')
        }
    }
}


