// clang-format off

/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.1.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

/****************************************************************************
 Copyright (c) 2022-2023 Xiamen Yaji Software Co., Ltd.

 http://www.cocos.com

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights to
 use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
 of the Software, and to permit persons to whom the Software is furnished to do so,
 subject to the following conditions:

 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
****************************************************************************/

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-variable"
#elif defined(__GNUC__) || defined(__GNUG__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wunused-variable"
#elif defined(_MSC_VER)
#pragma warning(push)
#pragma warning(disable : 4101)
#endif


#define SWIG_STD_MOVE(OBJ) std::move(OBJ)


#include <stdio.h>


#include "bindings/jswrapper/SeApi.h"
#include "bindings/manual/jsb_conversions.h"
#include "bindings/manual/jsb_global.h"


#include "bindings/auto/jsb_2d_auto.h"
#include "bindings/auto/jsb_assets_auto.h"
#include "bindings/auto/jsb_cocos_auto.h"
#include "bindings/auto/jsb_spine_4_2_auto.h"
using namespace spine;

#define SWIGINTERN static


#define spine_Animation_name_get(self_) self_->getName()
  

#define spine_Animation_timelines_get(self_) self_->getTimelines()
  

#define spine_Animation_duration_get(self_) self_->getDuration()
#define spine_Animation_duration_set(self_, val_) self_->setDuration(val_)
  

#define spine_RotateTimeline_boneIndex_get(self_) self_->getBoneIndex()
#define spine_RotateTimeline_boneIndex_set(self_, val_) self_->setBoneIndex(val_)
  

#define spine_RotateTimeline_frames_get(self_) self_->getFrames()
  

#define spine_RGBATimeline_slotIndex_get(self_) self_->getSlotIndex()
#define spine_RGBATimeline_slotIndex_set(self_, val_) self_->setSlotIndex(val_)
  

#define spine_RGBTimeline_slotIndex_get(self_) self_->getSlotIndex()
#define spine_RGBTimeline_slotIndex_set(self_, val_) self_->setSlotIndex(val_)
  

#define spine_AlphaTimeline_slotIndex_get(self_) self_->getSlotIndex()
#define spine_AlphaTimeline_slotIndex_set(self_, val_) self_->setSlotIndex(val_)
  

#define spine_RGBA2Timeline_slotIndex_get(self_) self_->getSlotIndex()
#define spine_RGBA2Timeline_slotIndex_set(self_, val_) self_->setSlotIndex(val_)
  

#define spine_RGB2Timeline_slotIndex_get(self_) self_->getSlotIndex()
#define spine_RGB2Timeline_slotIndex_set(self_, val_) self_->setSlotIndex(val_)
  

#define spine_AttachmentTimeline_slotIndex_get(self_) self_->getSlotIndex()
#define spine_AttachmentTimeline_slotIndex_set(self_, val_) self_->setSlotIndex(val_)
  

#define spine_AttachmentTimeline_frames_get(self_) self_->getFrames()
  

#define spine_AttachmentTimeline_attachmentNames_get(self_) self_->getAttachmentNames()
  

#define spine_DeformTimeline_slotIndex_get(self_) self_->getSlotIndex()
#define spine_DeformTimeline_slotIndex_set(self_, val_) self_->setSlotIndex(val_)
  

#define spine_DeformTimeline_frames_get(self_) self_->getFrames()
  

#define spine_DeformTimeline_frameVertices_get(self_) self_->getVertices()
  

#define spine_DeformTimeline_attachment_get(self_) self_->getAttachment()
  

#define spine_EventTimeline_frames_get(self_) self_->getFrames()
  

#define spine_EventTimeline_events_get(self_) self_->getEvents()
  

#define spine_DrawOrderTimeline_frames_get(self_) self_->getFrames()
  

#define spine_DrawOrderTimeline_drawOrders_get(self_) self_->getDrawOrders()
  

#define spine_AnimationState_data_get(self_) self_->getData()
  

#define spine_AnimationState_tracks_get(self_) self_->getTracks()
  

#define spine_AnimationState_timeScale_get(self_) self_->getTimeScale()
#define spine_AnimationState_timeScale_set(self_, val_) self_->setTimeScale(val_)
  

#define spine_TrackEntry_animation_get(self_) self_->getAnimation()
  

#define spine_TrackEntry_next_get(self_) self_->getNext()
  

#define spine_TrackEntry_mixingFrom_get(self_) self_->getMixingFrom()
  

#define spine_TrackEntry_mixingTo_get(self_) self_->getMixingTo()
  

#define spine_TrackEntry_trackIndex_get(self_) self_->getTrackIndex()
  

#define spine_TrackEntry_loop_get(self_) self_->getLoop()
#define spine_TrackEntry_loop_set(self_, val_) self_->setLoop(val_)
  

#define spine_TrackEntry_holdPrevious_get(self_) self_->getHoldPrevious()
#define spine_TrackEntry_holdPrevious_set(self_, val_) self_->setHoldPrevious(val_)
  

#define spine_TrackEntry_eventThreshold_get(self_) self_->getEventThreshold()
#define spine_TrackEntry_eventThreshold_set(self_, val_) self_->setEventThreshold(val_)
  

#define spine_TrackEntry_mixAttachmentThreshold_get(self_) self_->getMixAttachmentThreshold()
#define spine_TrackEntry_mixAttachmentThreshold_set(self_, val_) self_->setMixAttachmentThreshold(val_)
  

#define spine_TrackEntry_mixDrawOrderThreshold_get(self_) self_->getMixDrawOrderThreshold()
#define spine_TrackEntry_mixDrawOrderThreshold_set(self_, val_) self_->setMixDrawOrderThreshold(val_)
  

#define spine_TrackEntry_alphaAttachmentThreshold_get(self_) self_->getAlphaAttachmentThreshold()
#define spine_TrackEntry_alphaAttachmentThreshold_set(self_, val_) self_->setAlphaAttachmentThreshold(val_)
  

#define spine_TrackEntry_animationStart_get(self_) self_->getAnimationStart()
#define spine_TrackEntry_animationStart_set(self_, val_) self_->setAnimationStart(val_)
  

#define spine_TrackEntry_animationEnd_get(self_) self_->getAnimationEnd()
#define spine_TrackEntry_animationEnd_set(self_, val_) self_->setAnimationEnd(val_)
  

#define spine_TrackEntry_animationLast_get(self_) self_->getAnimationLast()
#define spine_TrackEntry_animationLast_set(self_, val_) self_->setAnimationLast(val_)
  

#define spine_TrackEntry_delay_get(self_) self_->getDelay()
#define spine_TrackEntry_delay_set(self_, val_) self_->setDelay(val_)
  

#define spine_TrackEntry_trackTime_get(self_) self_->getTrackTime()
#define spine_TrackEntry_trackTime_set(self_, val_) self_->setTrackTime(val_)
  

#define spine_TrackEntry_trackEnd_get(self_) self_->getTrackEnd()
#define spine_TrackEntry_trackEnd_set(self_, val_) self_->setTrackEnd(val_)
  

#define spine_TrackEntry_timeScale_get(self_) self_->getTimeScale()
#define spine_TrackEntry_timeScale_set(self_, val_) self_->setTimeScale(val_)
  

#define spine_TrackEntry_alpha_get(self_) self_->getAlpha()
#define spine_TrackEntry_alpha_set(self_, val_) self_->setAlpha(val_)
  

#define spine_TrackEntry_mixTime_get(self_) self_->getMixTime()
#define spine_TrackEntry_mixTime_set(self_, val_) self_->setMixTime(val_)
  

#define spine_TrackEntry_mixDuration_get(self_) self_->getMixDuration()
#define spine_TrackEntry_mixDuration_set(self_, val_) self_->setMixDuration(val_)
  

#define spine_TrackEntry_mixBlend_get(self_) self_->getMixBlend()
#define spine_TrackEntry_mixBlend_set(self_, val_) self_->setMixBlend(val_)
  

#define spine_AnimationStateData_skeletonData_get(self_) self_->getSkeletonData()
  

#define spine_AnimationStateData_defaultMix_get(self_) self_->getDefaultMix()
#define spine_AnimationStateData_defaultMix_set(self_, val_) self_->setDefaultMix(val_)
  

#define spine_Bone_data_get(self_) self_->getData()
  

#define spine_Bone_skeleton_get(self_) self_->getSkeleton()
  

#define spine_Bone_parent_get(self_) self_->getParent()
  

#define spine_Bone_children_get(self_) self_->getChildren()
  

#define spine_Bone_x_get(self_) self_->getX()
#define spine_Bone_x_set(self_, val_) self_->setX(val_)
  

#define spine_Bone_y_get(self_) self_->getY()
#define spine_Bone_y_set(self_, val_) self_->setY(val_)
  

#define spine_Bone_rotation_get(self_) self_->getRotation()
#define spine_Bone_rotation_set(self_, val_) self_->setRotation(val_)
  

#define spine_Bone_scaleX_get(self_) self_->getScaleX()
#define spine_Bone_scaleX_set(self_, val_) self_->setScaleX(val_)
  

#define spine_Bone_scaleY_get(self_) self_->getScaleY()
#define spine_Bone_scaleY_set(self_, val_) self_->setScaleY(val_)
  

#define spine_Bone_shearX_get(self_) self_->getShearX()
#define spine_Bone_shearX_set(self_, val_) self_->setShearX(val_)
  

#define spine_Bone_shearY_get(self_) self_->getShearY()
#define spine_Bone_shearY_set(self_, val_) self_->setShearY(val_)
  

#define spine_Bone_ax_get(self_) self_->getAX()
#define spine_Bone_ax_set(self_, val_) self_->setAX(val_)
  

#define spine_Bone_ay_get(self_) self_->getAY()
#define spine_Bone_ay_set(self_, val_) self_->setAY(val_)
  

#define spine_Bone_arotation_get(self_) self_->getAppliedRotation()
#define spine_Bone_arotation_set(self_, val_) self_->setAppliedRotation(val_)
  

#define spine_Bone_ascaleX_get(self_) self_->getAScaleX()
#define spine_Bone_ascaleX_set(self_, val_) self_->setAScaleX(val_)
  

#define spine_Bone_ascaleY_get(self_) self_->getAScaleY()
#define spine_Bone_ascaleY_set(self_, val_) self_->setAScaleY(val_)
  

#define spine_Bone_ashearX_get(self_) self_->getAShearX()
#define spine_Bone_ashearX_set(self_, val_) self_->setAShearX(val_)
  

#define spine_Bone_ashearY_get(self_) self_->getAShearY()
#define spine_Bone_ashearY_set(self_, val_) self_->setAShearY(val_)
  

#define spine_Bone_a_get(self_) self_->getA()
#define spine_Bone_a_set(self_, val_) self_->setA(val_)
  

#define spine_Bone_b_get(self_) self_->getB()
#define spine_Bone_b_set(self_, val_) self_->setB(val_)
  

#define spine_Bone_c_get(self_) self_->getC()
#define spine_Bone_c_set(self_, val_) self_->setC(val_)
  

#define spine_Bone_d_get(self_) self_->getD()
#define spine_Bone_d_set(self_, val_) self_->setD(val_)
  

#define spine_Bone_worldX_get(self_) self_->getWorldX()
#define spine_Bone_worldX_set(self_, val_) self_->setWorldX(val_)
  

#define spine_Bone_worldY_get(self_) self_->getWorldY()
#define spine_Bone_worldY_set(self_, val_) self_->setWorldY(val_)
  

#define spine_Bone_active_get(self_) self_->isActive()
#define spine_Bone_active_set(self_, val_) self_->setActive(val_)
  

#define spine_BoneData_index_get(self_) self_->getIndex()
  

#define spine_BoneData_name_get(self_) self_->getName()
  

#define spine_BoneData_parent_get(self_) self_->getParent()
  

#define spine_BoneData_length_get(self_) self_->getLength()
#define spine_BoneData_length_set(self_, val_) self_->setLength(val_)
  

#define spine_BoneData_x_get(self_) self_->getX()
#define spine_BoneData_x_set(self_, val_) self_->setX(val_)
  

#define spine_BoneData_y_get(self_) self_->getY()
#define spine_BoneData_y_set(self_, val_) self_->setY(val_)
  

#define spine_BoneData_rotation_get(self_) self_->getRotation()
#define spine_BoneData_rotation_set(self_, val_) self_->setRotation(val_)
  

#define spine_BoneData_scaleX_get(self_) self_->getScaleX()
#define spine_BoneData_scaleX_set(self_, val_) self_->setScaleX(val_)
  

#define spine_BoneData_scaleY_get(self_) self_->getScaleY()
#define spine_BoneData_scaleY_set(self_, val_) self_->setScaleY(val_)
  

#define spine_BoneData_shearX_get(self_) self_->getShearX()
#define spine_BoneData_shearX_set(self_, val_) self_->setShearX(val_)
  

#define spine_BoneData_shearY_get(self_) self_->getShearY()
#define spine_BoneData_shearY_set(self_, val_) self_->setShearY(val_)
  

#define spine_BoneData_skinRequired_get(self_) self_->isSkinRequired()
#define spine_BoneData_skinRequired_set(self_, val_) self_->setSkinRequired(val_)
  

#define spine_BoneData_icon_get(self_) self_->getIcon()
#define spine_BoneData_icon_set(self_, val_) self_->setIcon(val_)
  

#define spine_BoneData_visible_get(self_) self_->isVisible()
#define spine_BoneData_visible_set(self_, val_) self_->setVisible(val_)
  

#define spine_ConstraintData_name_get(self_) self_->getName()
  

#define spine_ConstraintData_order_get(self_) self_->getOrder()
#define spine_ConstraintData_order_set(self_, val_) self_->setOrder(val_)
  

#define spine_ConstraintData_skinRequired_get(self_) self_->isSkinRequired()
#define spine_ConstraintData_skinRequired_set(self_, val_) self_->setSkinRequired(val_)
  

#define spine_Event_data_get(self_) self_->getData()
  

#define spine_Event_intValue_get(self_) self_->getIntValue()
#define spine_Event_intValue_set(self_, val_) self_->setIntValue(val_)
  

#define spine_Event_floatValue_get(self_) self_->getFloatValue()
#define spine_Event_floatValue_set(self_, val_) self_->setFloatValue(val_)
  

#define spine_Event_stringValue_get(self_) self_->getStringValue()
#define spine_Event_stringValue_set(self_, val_) self_->setStringValue(val_)
  

#define spine_Event_time_get(self_) self_->getTime()
  

#define spine_Event_volume_get(self_) self_->getVolume()
#define spine_Event_volume_set(self_, val_) self_->setVolume(val_)
  

#define spine_Event_balance_get(self_) self_->getBalance()
#define spine_Event_balance_set(self_, val_) self_->setBalance(val_)
  

#define spine_EventData_name_get(self_) self_->getName()
  

#define spine_EventData_intValue_get(self_) self_->getIntValue()
#define spine_EventData_intValue_set(self_, val_) self_->setIntValue(val_)
  

#define spine_EventData_floatValue_get(self_) self_->getFloatValue()
#define spine_EventData_floatValue_set(self_, val_) self_->setFloatValue(val_)
  

#define spine_EventData_stringValue_get(self_) self_->getStringValue()
#define spine_EventData_stringValue_set(self_, val_) self_->setStringValue(val_)
  

#define spine_EventData_volume_get(self_) self_->getVolume()
#define spine_EventData_volume_set(self_, val_) self_->setVolume(val_)
  

#define spine_EventData_balance_get(self_) self_->getBalance()
#define spine_EventData_balance_set(self_, val_) self_->setBalance(val_)
  

#define spine_EventData_audioPath_get(self_) self_->getAudioPath()
#define spine_EventData_audioPath_set(self_, val_) self_->setAudioPath(val_)
  

#define spine_IkConstraint_data_get(self_) self_->getData()
  

#define spine_IkConstraint_bones_get(self_) self_->getBones()
  

#define spine_IkConstraint_target_get(self_) self_->getTarget()
#define spine_IkConstraint_target_set(self_, val_) self_->setTarget(val_)
  

#define spine_IkConstraint_bendDirection_get(self_) self_->getBendDirection()
#define spine_IkConstraint_bendDirection_set(self_, val_) self_->setBendDirection(val_)
  

#define spine_IkConstraint_compress_get(self_) self_->getCompress()
#define spine_IkConstraint_compress_set(self_, val_) self_->setCompress(val_)
  

#define spine_IkConstraint_stretch_get(self_) self_->getStretch()
#define spine_IkConstraint_stretch_set(self_, val_) self_->setStretch(val_)
  

#define spine_IkConstraint_mix_get(self_) self_->getMix()
#define spine_IkConstraint_mix_set(self_, val_) self_->setMix(val_)
  

#define spine_IkConstraint_softness_get(self_) self_->getSoftness()
#define spine_IkConstraint_softness_set(self_, val_) self_->setSoftness(val_)
  

#define spine_IkConstraint_active_get(self_) self_->isActive()
#define spine_IkConstraint_active_set(self_, val_) self_->setActive(val_)
  

#define spine_IkConstraintData_bones_get(self_) self_->getBones()
  

#define spine_IkConstraintData_target_get(self_) self_->getTarget()
  

#define spine_IkConstraintData_bendDirection_get(self_) self_->getBendDirection()
#define spine_IkConstraintData_bendDirection_set(self_, val_) self_->setBendDirection(val_)
  

#define spine_IkConstraintData_compress_get(self_) self_->getCompress()
#define spine_IkConstraintData_compress_set(self_, val_) self_->setCompress(val_)
  

#define spine_IkConstraintData_stretch_get(self_) self_->getStretch()
#define spine_IkConstraintData_stretch_set(self_, val_) self_->setStretch(val_)
  

#define spine_IkConstraintData_uniform_get(self_) self_->getUniform()
#define spine_IkConstraintData_uniform_set(self_, val_) self_->setUniform(val_)
  

#define spine_IkConstraintData_mix_get(self_) self_->getMix()
#define spine_IkConstraintData_mix_set(self_, val_) self_->setMix(val_)
  

#define spine_IkConstraintData_softness_get(self_) self_->getSoftness()
#define spine_IkConstraintData_softness_set(self_, val_) self_->setSoftness(val_)
  

#define spine_PathConstraint_data_get(self_) self_->getData()
  

#define spine_PathConstraint_bones_get(self_) self_->getBones()
  

#define spine_PathConstraint_target_get(self_) self_->getTarget()
#define spine_PathConstraint_target_set(self_, val_) self_->setTarget(val_)
  

#define spine_PathConstraint_position_get(self_) self_->getPosition()
#define spine_PathConstraint_position_set(self_, val_) self_->setPosition(val_)
  

#define spine_PathConstraint_spacing_get(self_) self_->getSpacing()
#define spine_PathConstraint_spacing_set(self_, val_) self_->setSpacing(val_)
  

#define spine_PathConstraint_mixRotate_get(self_) self_->getMixRotate()
#define spine_PathConstraint_mixRotate_set(self_, val_) self_->setMixRotate(val_)
  

#define spine_PathConstraint_mixX_get(self_) self_->getMixX()
#define spine_PathConstraint_mixX_set(self_, val_) self_->setMixX(val_)
  

#define spine_PathConstraint_mixY_get(self_) self_->getMixY()
#define spine_PathConstraint_mixY_set(self_, val_) self_->setMixY(val_)
  

#define spine_PathConstraint_active_get(self_) self_->isActive()
#define spine_PathConstraint_active_set(self_, val_) self_->setActive(val_)
  

#define spine_PathConstraintData_bones_get(self_) self_->getBones()
  

#define spine_PathConstraintData_target_get(self_) self_->getTarget()
#define spine_PathConstraintData_target_set(self_, val_) self_->setTarget(val_)
  

#define spine_PathConstraintData_positionMode_get(self_) self_->getPositionMode()
#define spine_PathConstraintData_positionMode_set(self_, val_) self_->setPositionMode(val_)
  

#define spine_PathConstraintData_spacingMode_get(self_) self_->getSpacingMode()
#define spine_PathConstraintData_spacingMode_set(self_, val_) self_->setSpacingMode(val_)
  

#define spine_PathConstraintData_rotateMode_get(self_) self_->getRotateMode()
#define spine_PathConstraintData_rotateMode_set(self_, val_) self_->setRotateMode(val_)
  

#define spine_PathConstraintData_offsetRotation_get(self_) self_->getOffsetRotation()
#define spine_PathConstraintData_offsetRotation_set(self_, val_) self_->setOffsetRotation(val_)
  

#define spine_PathConstraintData_position_get(self_) self_->getPosition()
#define spine_PathConstraintData_position_set(self_, val_) self_->setPosition(val_)
  

#define spine_PathConstraintData_spacing_get(self_) self_->getSpacing()
#define spine_PathConstraintData_spacing_set(self_, val_) self_->setSpacing(val_)
  

#define spine_PathConstraintData_mixRotate_get(self_) self_->getMixRotate()
#define spine_PathConstraintData_mixRotate_set(self_, val_) self_->setMixRotate(val_)
  

#define spine_PathConstraintData_mixX_get(self_) self_->getMixX()
#define spine_PathConstraintData_mixX_set(self_, val_) self_->setMixX(val_)
  

#define spine_PathConstraintData_mixY_get(self_) self_->getMixY()
#define spine_PathConstraintData_mixY_set(self_, val_) self_->setMixY(val_)
  

#define spine_Skeleton_data_get(self_) self_->getData()
  

#define spine_Skeleton_bones_get(self_) self_->getBones()
  

#define spine_Skeleton_slots_get(self_) self_->getSlots()
  

#define spine_Skeleton_drawOrder_get(self_) self_->getDrawOrder()
  

#define spine_Skeleton_ikConstraints_get(self_) self_->getIkConstraints()
  

#define spine_Skeleton_transformConstraints_get(self_) self_->getTransformConstraints()
  

#define spine_Skeleton_pathConstraints_get(self_) self_->getPathConstraints()
  

#define spine_Skeleton__updateCache_get(self_) self_->getUpdateCacheList()
  

#define spine_Skeleton_skin_get(self_) self_->getSkin()
#define spine_Skeleton_skin_set(self_, val_) self_->setSkin(val_)
  

#define spine_Skeleton_color_get(self_) self_->getColor()
  

#define spine_Skeleton_time_get(self_) self_->getTime()
#define spine_Skeleton_time_set(self_, val_) self_->setTime(val_)
  

#define spine_Skeleton_scaleX_get(self_) self_->getScaleX()
#define spine_Skeleton_scaleX_set(self_, val_) self_->setScaleX(val_)
  

#define spine_Skeleton_scaleY_get(self_) self_->getScaleY()
#define spine_Skeleton_scaleY_set(self_, val_) self_->setScaleY(val_)
  

#define spine_Skeleton_x_get(self_) self_->getX()
#define spine_Skeleton_x_set(self_, val_) self_->setX(val_)
  

#define spine_Skeleton_y_get(self_) self_->getY()
#define spine_Skeleton_y_set(self_, val_) self_->setY(val_)
  

#define spine_SkeletonData_name_get(self_) self_->getName()
#define spine_SkeletonData_name_set(self_, val_) self_->setName(val_)
  

#define spine_SkeletonData_bones_get(self_) self_->getBones()
  

#define spine_SkeletonData_slots_get(self_) self_->getSlots()
  

#define spine_SkeletonData_skins_get(self_) self_->getSkins()
  

#define spine_SkeletonData_defaultSkin_get(self_) self_->getDefaultSkin()
#define spine_SkeletonData_defaultSkin_set(self_, val_) self_->setDefaultSkin(val_)
  

#define spine_SkeletonData_events_get(self_) self_->getEvents()
  

#define spine_SkeletonData_animations_get(self_) self_->getAnimations()
  

#define spine_SkeletonData_ikConstraints_get(self_) self_->getIkConstraints()
  

#define spine_SkeletonData_transformConstraints_get(self_) self_->getTransformConstraints()
  

#define spine_SkeletonData_pathConstraints_get(self_) self_->getPathConstraints()
  

#define spine_SkeletonData_x_get(self_) self_->getX()
#define spine_SkeletonData_x_set(self_, val_) self_->setX(val_)
  

#define spine_SkeletonData_y_get(self_) self_->getY()
#define spine_SkeletonData_y_set(self_, val_) self_->setY(val_)
  

#define spine_SkeletonData_width_get(self_) self_->getWidth()
#define spine_SkeletonData_width_set(self_, val_) self_->setWidth(val_)
  

#define spine_SkeletonData_height_get(self_) self_->getHeight()
#define spine_SkeletonData_height_set(self_, val_) self_->setHeight(val_)
  

#define spine_SkeletonData_version_get(self_) self_->getVersion()
#define spine_SkeletonData_version_set(self_, val_) self_->setVersion(val_)
  

#define spine_SkeletonData_hash_get(self_) self_->getHash()
#define spine_SkeletonData_hash_set(self_, val_) self_->setHash(val_)
  

#define spine_SkeletonData_fps_get(self_) self_->getFps()
#define spine_SkeletonData_fps_set(self_, val_) self_->setFps(val_)
  

#define spine_SkeletonData_imagesPath_get(self_) self_->getImagesPath()
#define spine_SkeletonData_imagesPath_set(self_, val_) self_->setImagesPath(val_)
  

#define spine_SkeletonData_audioPath_get(self_) self_->getAudioPath()
#define spine_SkeletonData_audioPath_set(self_, val_) self_->setAudioPath(val_)
  

#define spine_Skin_name_get(self_) self_->getName()
  

#define spine_Skin_bones_get(self_) self_->getBones()
  

#define spine_Skin_constraints_get(self_) self_->getConstraints()
  

#define spine_Slot_data_get(self_) self_->getData()
  

#define spine_Slot_bone_get(self_) self_->getBone()
  

#define spine_Slot_color_get(self_) self_->getColor()
  

#define spine_Slot_darkColor_get(self_) self_->getDarkColor()
  

#define spine_Slot_attachment_get(self_) self_->getAttachment()
#define spine_Slot_attachment_set(self_, val_) self_->setAttachment(val_)
  

#define spine_Slot_deform_get(self_) self_->getDeform()
  

#define spine_SlotData_index_get(self_) self_->getIndex()
  

#define spine_SlotData_name_get(self_) self_->getName()
  

#define spine_SlotData_boneData_get(self_) self_->getBoneData()
  

#define spine_SlotData_color_get(self_) self_->getColor()
  

#define spine_SlotData_darkColor_get(self_) self_->getDarkColor()
  

#define spine_SlotData_attachmentName_get(self_) self_->getAttachmentName()
#define spine_SlotData_attachmentName_set(self_, val_) self_->setAttachmentName(val_)
  

#define spine_SlotData_blendMode_get(self_) self_->getBlendMode()
#define spine_SlotData_blendMode_set(self_, val_) self_->setBlendMode(val_)
  

#define spine_TransformConstraint_data_get(self_) self_->getData()
  

#define spine_TransformConstraint_bones_get(self_) self_->getBones()
  

#define spine_TransformConstraint_target_get(self_) self_->getTarget()
#define spine_TransformConstraint_target_set(self_, val_) self_->setTarget(val_)
  

#define spine_TransformConstraint_mixRotate_get(self_) self_->getMixRotate()
#define spine_TransformConstraint_mixRotate_set(self_, val_) self_->setMixRotate(val_)
  

#define spine_TransformConstraint_mixX_get(self_) self_->getMixX()
#define spine_TransformConstraint_mixX_set(self_, val_) self_->setMixX(val_)
  

#define spine_TransformConstraint_mixY_get(self_) self_->getMixY()
#define spine_TransformConstraint_mixY_set(self_, val_) self_->setMixY(val_)
  

#define spine_TransformConstraint_mixScaleX_get(self_) self_->getMixScaleX()
#define spine_TransformConstraint_mixScaleX_set(self_, val_) self_->setMixScaleX(val_)
  

#define spine_TransformConstraint_mixScaleY_get(self_) self_->getMixScaleY()
#define spine_TransformConstraint_mixScaleY_set(self_, val_) self_->setMixScaleY(val_)
  

#define spine_TransformConstraint_mixShearY_get(self_) self_->getMixShearY()
#define spine_TransformConstraint_mixShearY_set(self_, val_) self_->setMixShearY(val_)
  

#define spine_TransformConstraint_active_get(self_) self_->isActive()
#define spine_TransformConstraint_active_set(self_, val_) self_->setActive(val_)
  

#define spine_TransformConstraintData_bones_get(self_) self_->getBones()
  

#define spine_TransformConstraintData_target_get(self_) self_->getTarget()
  

#define spine_TransformConstraintData_mixX_get(self_) self_->getMixX()
  

#define spine_TransformConstraintData_mixY_get(self_) self_->getMixY()
  

#define spine_TransformConstraintData_mixRotate_get(self_) self_->getMixRotate()
  

#define spine_TransformConstraintData_mixScaleX_get(self_) self_->getMixScaleX()
  

#define spine_TransformConstraintData_mixScaleY_get(self_) self_->getMixScaleY()
  

#define spine_TransformConstraintData_mixShearY_get(self_) self_->getMixShearY()
  

#define spine_TransformConstraintData_offsetRotation_get(self_) self_->getOffsetRotation()
  

#define spine_TransformConstraintData_offsetX_get(self_) self_->getOffsetX()
  

#define spine_TransformConstraintData_offsetY_get(self_) self_->getOffsetY()
  

#define spine_TransformConstraintData_offsetScaleX_get(self_) self_->getOffsetScaleX()
  

#define spine_TransformConstraintData_offsetScaleY_get(self_) self_->getOffsetScaleY()
  

#define spine_TransformConstraintData_offsetShearY_get(self_) self_->getOffsetShearY()
  

#define spine_TransformConstraintData_relative_get(self_) self_->isRelative()
  

#define spine_TransformConstraintData_local_get(self_) self_->isLocal()
  

#define spine_Attachment_name_get(self_) self_->getName()
  

#define spine_VertexAttachment_id_get(self_) self_->getId()
  

#define spine_VertexAttachment_bones_get(self_) self_->getBones()
  

#define spine_VertexAttachment_vertices_get(self_) self_->getVertices()
  

#define spine_VertexAttachment_worldVerticesLength_get(self_) self_->getWorldVerticesLength()
#define spine_VertexAttachment_worldVerticesLength_set(self_, val_) self_->setWorldVerticesLength(val_)
  

#define spine_VertexAttachment_timelineAttachment_get(self_) self_->getTimelineAttachment()
#define spine_VertexAttachment_timelineAttachment_set(self_, val_) self_->setTimelineAttachment(val_)
  

#define spine_ClippingAttachment_endSlot_get(self_) self_->getEndSlot()
#define spine_ClippingAttachment_endSlot_set(self_, val_) self_->setEndSlot(val_)
  

#define spine_MeshAttachment_path_get(self_) self_->getPath()
#define spine_MeshAttachment_path_set(self_, val_) self_->setPath(val_)
  

#define spine_MeshAttachment_regionUVs_get(self_) self_->getRegionUVs()
  

#define spine_MeshAttachment_uvs_get(self_) self_->getUVs()
  

#define spine_MeshAttachment_triangles_get(self_) self_->getTriangles()
  

#define spine_MeshAttachment_color_get(self_) self_->getColor()
  

#define spine_MeshAttachment_width_get(self_) self_->getWidth()
#define spine_MeshAttachment_width_set(self_, val_) self_->setWidth(val_)
  

#define spine_MeshAttachment_height_get(self_) self_->getHeight()
#define spine_MeshAttachment_height_set(self_, val_) self_->setHeight(val_)
  

#define spine_MeshAttachment_hullLength_get(self_) self_->getHullLength()
#define spine_MeshAttachment_hullLength_set(self_, val_) self_->setHullLength(val_)
  

#define spine_MeshAttachment_edges_get(self_) self_->getEdges()
  

#define spine_PathAttachment_lengths_get(self_) self_->getLengths()
  

#define spine_PathAttachment_closed_get(self_) self_->isClosed()
#define spine_PathAttachment_closed_set(self_, val_) self_->setClosed(val_)
  

#define spine_PathAttachment_constantSpeed_get(self_) self_->isConstantSpeed()
#define spine_PathAttachment_constantSpeed_set(self_, val_) self_->setConstantSpeed(val_)
  

#define spine_PointAttachment_x_get(self_) self_->getX()
#define spine_PointAttachment_x_set(self_, val_) self_->setX(val_)
  

#define spine_PointAttachment_y_get(self_) self_->getY()
#define spine_PointAttachment_y_set(self_, val_) self_->setY(val_)
  

#define spine_PointAttachment_rotation_get(self_) self_->getRotation()
#define spine_PointAttachment_rotation_set(self_, val_) self_->setRotation(val_)
  

#define spine_RegionAttachment_x_get(self_) self_->getX()
#define spine_RegionAttachment_x_set(self_, val_) self_->setX(val_)
  

#define spine_RegionAttachment_y_get(self_) self_->getY()
#define spine_RegionAttachment_y_set(self_, val_) self_->setY(val_)
  

#define spine_RegionAttachment_scaleX_get(self_) self_->getScaleX()
#define spine_RegionAttachment_scaleX_set(self_, val_) self_->setScaleX(val_)
  

#define spine_RegionAttachment_scaleY_get(self_) self_->getScaleY()
#define spine_RegionAttachment_scaleY_set(self_, val_) self_->setScaleY(val_)
  

#define spine_RegionAttachment_rotation_get(self_) self_->getRotation()
#define spine_RegionAttachment_rotation_set(self_, val_) self_->setRotation(val_)
  

#define spine_RegionAttachment_width_get(self_) self_->getWidth()
#define spine_RegionAttachment_width_set(self_, val_) self_->setWidth(val_)
  

#define spine_RegionAttachment_height_get(self_) self_->getHeight()
#define spine_RegionAttachment_height_set(self_, val_) self_->setHeight(val_)
  

#define spine_RegionAttachment_color_get(self_) self_->getColor()
  

#define spine_RegionAttachment_path_get(self_) self_->getPath()
#define spine_RegionAttachment_path_set(self_, val_) self_->setPath(val_)
  

#define spine_RegionAttachment_offset_get(self_) self_->getOffset()
  

#define spine_RegionAttachment_uvs_get(self_) self_->getUVs()
  
SWIGINTERN void spine_Timeline_apply(spine::Timeline *self,spine::Skeleton *skeleton,float lastTime,float time,ccstd::vector< spine::Event * > const &events,float alpha,spine::MixBlend blend,spine::MixDirection direction){
        spine::Vector<spine::Event*> spEvents;
        for (int i = 0; i < events.size(); ++i) {
            spEvents.add(events[i]);
        }
        self->apply(*skeleton, lastTime, time, &spEvents, alpha, blend, direction);
    }
SWIGINTERN void spine_Animation_apply(spine::Animation *self,spine::Skeleton *skeleton,float lastTime,float time,bool loop,ccstd::vector< spine::Event * > const &events,float alpha,spine::MixBlend blend,spine::MixDirection direction){
        spine::Vector<spine::Event*> spEvents;
        for (int i = 0; i < events.size(); ++i) {
            spEvents.add(events[i]);
        }
        self->apply(*skeleton, lastTime, time, loop, &spEvents, alpha, blend, direction);
    }
SWIGINTERN void spine_AnimationState_apply(spine::AnimationState *self,spine::Skeleton *skeleton){
        self->apply(*skeleton);
    }
SWIGINTERN spine::Bone *new_spine_Bone(spine::BoneData *data,spine::Skeleton *skeleton,spine::Bone *parent){
        return new Bone(*data, *skeleton, parent);
    }
SWIGINTERN void spine_Bone_updateWorldTransformWith(spine::Bone *self,float x,float y,float rotation,float scaleX,float scaleY,float shearX,float shearY){
        self->updateWorldTransform(x, y, rotation, scaleX, scaleY, shearX, shearY);
    }
SWIGINTERN spine::Color &spine_Color_setFromColor(spine::Color *self,spine::Color const &other){
        return self->set(other);
    }
SWIGINTERN void spine_DeformTimeline_setFrame(spine::DeformTimeline *self,int frameIndex,float time,ccstd::vector< float > const &vertices){
        spine::Vector<float> spVertices;
        for (int i = 0; i < vertices.size(); ++i) {
            spVertices.add(vertices[i]);
        }
        self->setFrame(frameIndex, time, spVertices);
    }
SWIGINTERN void spine_DrawOrderTimeline_setFrame(spine::DrawOrderTimeline *self,size_t frameIndex,float time,ccstd::vector< int > const &drawOrder){
        spine::Vector<int> spDrawOrder;
        spDrawOrder.ensureCapacity(drawOrder.size());
        for (int i = 0; i < drawOrder.size(); ++i) {
            spDrawOrder.add(drawOrder[i]);
        }
        self->setFrame(frameIndex, time, spDrawOrder);
    }
SWIGINTERN spine::Event *new_spine_Event(float time,spine::EventData *data){
        return new Event(time, *data);
    }
SWIGINTERN void spine_IkConstraint_apply1(spine::IkConstraint *self,spine::Bone *bone,float targetX,float targetY,bool compress,bool stretch,bool uniform,float alpha){
        IkConstraint::apply(*bone, targetX, targetY, compress, stretch, uniform, alpha);
    }
SWIGINTERN void spine_IkConstraint_apply2(spine::IkConstraint *self,spine::Bone *parent,spine::Bone *child,float targetX,float targetY,int bendDir,bool stretch,bool uniform,float softness,float alpha){
        IkConstraint::apply(*parent, *child, targetX, targetY, bendDir, stretch, uniform, softness, alpha);
    }
SWIGINTERN spine::IkConstraint *new_spine_IkConstraint(spine::IkConstraintData *data,spine::Skeleton *skeleton){
        return new IkConstraint(*data, *skeleton);
    }
SWIGINTERN spine::PathConstraint *new_spine_PathConstraint(spine::PathConstraintData *data,spine::Skeleton *skeleton){
        return new PathConstraint(*data, *skeleton);
    }
SWIGINTERN float spine_PointAttachment_computeWorldRotation(spine::PointAttachment *self,spine::Bone *bone){
        return self->computeWorldRotation(*bone);
    }
SWIGINTERN spine::Attachment &spine_Skeleton_getAttachmentByName(spine::Skeleton *self,std::string const &slotName,std::string const &attachmentName){
        spine::String slot(slotName.data());
        spine::String attachment(attachmentName.data());
        return *(self->getAttachment(slot, attachment));
    }
SWIGINTERN spine::Slot *new_spine_Slot(spine::SlotData *data,spine::Bone *bone){
        return new Slot(*data, *bone);
    }
SWIGINTERN void spine_SkeletonBounds_update(spine::SkeletonBounds *self,spine::Skeleton *skeleton,bool updateAabb){
        self->update(*skeleton, updateAabb);
    }
SWIGINTERN spine::SlotData *new_spine_SlotData(int index,ccstd::string const *name,spine::BoneData *boneData){
        spine::String spName(name->data());
        return new SlotData(index, spName, *boneData);
    }
SWIGINTERN void spine_TextureLoader_load(spine::TextureLoader *self,spine::AtlasPage *page,spine::String const &path){
        self->load(*page, path);
    }
SWIGINTERN spine::TransformConstraint *new_spine_TransformConstraint(spine::TransformConstraintData *data,spine::Skeleton *skeleton){
        return new TransformConstraint(*data, *skeleton);
    }


se::Class* __jsb_spine_MathUtil_class = nullptr;
se::Object* __jsb_spine_MathUtil_proto = nullptr;
SE_DECLARE_FINALIZE_FUNC(js_delete_spine_MathUtil) 

static bool js_spine_MathUtil_signum_static(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    float arg1 ;
    float result;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    
    ok &= sevalue_to_native(args[0], &arg1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (float)spine::MathUtil::sign(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_MathUtil_signum_static) 

static bool js_spine_MathUtil_clamp_static(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    float arg1 ;
    float arg2 ;
    float arg3 ;
    float result;
    
    if(argc != 3) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 3);
        return false;
    }
    
    ok &= sevalue_to_native(args[0], &arg1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[1], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[2], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (float)spine::MathUtil::clamp(arg1,arg2,arg3);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_MathUtil_clamp_static) 

static bool js_spine_MathUtil_abs_static(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    float arg1 ;
    float result;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    
    ok &= sevalue_to_native(args[0], &arg1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (float)spine::MathUtil::abs(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_MathUtil_abs_static) 

static bool js_spine_MathUtil_sin_static(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    float arg1 ;
    float result;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    
    ok &= sevalue_to_native(args[0], &arg1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (float)spine::MathUtil::sin(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_MathUtil_sin_static) 

static bool js_spine_MathUtil_cos_static(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    float arg1 ;
    float result;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    
    ok &= sevalue_to_native(args[0], &arg1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (float)spine::MathUtil::cos(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_MathUtil_cos_static) 

static bool js_spine_MathUtil_sinDeg_static(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    float arg1 ;
    float result;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    
    ok &= sevalue_to_native(args[0], &arg1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (float)spine::MathUtil::sinDeg(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_MathUtil_sinDeg_static) 

static bool js_spine_MathUtil_cosDeg_static(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    float arg1 ;
    float result;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    
    ok &= sevalue_to_native(args[0], &arg1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (float)spine::MathUtil::cosDeg(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_MathUtil_cosDeg_static) 

static bool js_spine_MathUtil_atan2_static(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    float arg1 ;
    float arg2 ;
    float result;
    
    if(argc != 2) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 2);
        return false;
    }
    
    ok &= sevalue_to_native(args[0], &arg1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[1], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (float)spine::MathUtil::atan2(arg1,arg2);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_MathUtil_atan2_static) 

static bool js_spine_MathUtil_atan2Deg_static(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    float arg1 ;
    float arg2 ;
    float result;
    
    if(argc != 2) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 2);
        return false;
    }
    
    ok &= sevalue_to_native(args[0], &arg1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[1], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (float)spine::MathUtil::atan2Deg(arg1,arg2);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_MathUtil_atan2Deg_static) 

static bool js_spine_MathUtil_acos_static(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    float arg1 ;
    float result;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    
    ok &= sevalue_to_native(args[0], &arg1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (float)spine::MathUtil::acos(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_MathUtil_acos_static) 

static bool js_spine_MathUtil_sqrt_static(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    float arg1 ;
    float result;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    
    ok &= sevalue_to_native(args[0], &arg1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (float)spine::MathUtil::sqrt(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_MathUtil_sqrt_static) 

static bool js_spine_MathUtil_fmod_static(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    float arg1 ;
    float arg2 ;
    float result;
    
    if(argc != 2) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 2);
        return false;
    }
    
    ok &= sevalue_to_native(args[0], &arg1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[1], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (float)spine::MathUtil::fmod(arg1,arg2);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_MathUtil_fmod_static) 

static bool js_spine_MathUtil_isNan_static(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    float arg1 ;
    bool result;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    
    ok &= sevalue_to_native(args[0], &arg1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (bool)spine::MathUtil::isNan(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    
    
    return true;
}
SE_BIND_FUNC(js_spine_MathUtil_isNan_static) 

static bool js_spine_MathUtil_quietNan_static(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    float result;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    result = (float)spine::MathUtil::quietNan();
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_MathUtil_quietNan_static) 

static bool js_spine_MathUtil_random_static(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    float result;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    result = (float)spine::MathUtil::random();
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_MathUtil_random_static) 

static bool js_spine_MathUtil_randomTriangular_static__SWIG_0(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    float arg1 ;
    float arg2 ;
    float result;
    
    
    ok &= sevalue_to_native(args[0], &arg1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[1], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (float)spine::MathUtil::randomTriangular(arg1,arg2);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}

static bool js_spine_MathUtil_randomTriangular_static__SWIG_1(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    float arg1 ;
    float arg2 ;
    float arg3 ;
    float result;
    
    
    ok &= sevalue_to_native(args[0], &arg1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[1], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[2], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (float)spine::MathUtil::randomTriangular(arg1,arg2,arg3);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}

static bool js_spine_MathUtil_randomTriangular_static(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    
    if (argc == 2) {
        ok = js_spine_MathUtil_randomTriangular_static__SWIG_0(s);
        if (ok) {
            return true; 
        }
    } 
    if (argc == 3) {
        ok = js_spine_MathUtil_randomTriangular_static__SWIG_1(s);
        if (ok) {
            return true; 
        }
    } 
    SE_REPORT_ERROR("wrong number of arguments: %d", (int)argc);
    return false;
}
SE_BIND_FUNC(js_spine_MathUtil_randomTriangular_static) 

static bool js_spine_MathUtil_pow_static(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    float arg1 ;
    float arg2 ;
    float result;
    
    if(argc != 2) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 2);
        return false;
    }
    
    ok &= sevalue_to_native(args[0], &arg1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[1], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (float)spine::MathUtil::pow(arg1,arg2);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_MathUtil_pow_static) 

static bool js_spine_MathUtil_ceil_static(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    float arg1 ;
    float result;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    
    ok &= sevalue_to_native(args[0], &arg1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (float)spine::MathUtil::ceil(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_MathUtil_ceil_static) 

static bool js_delete_spine_MathUtil(se::State& s)
{
    return true;
}
SE_BIND_FINALIZE_FUNC(js_delete_spine_MathUtil) 

bool js_register_spine_MathUtil(se::Object* obj) {
    auto* cls = se::Class::create("MathUtil", obj, nullptr, nullptr); 
    
    cls->defineStaticProperty("__isJSB", se::Value(true), se::PropertyAttribute::READ_ONLY | se::PropertyAttribute::DONT_ENUM | se::PropertyAttribute::DONT_DELETE);
    
    
    
    cls->defineStaticFunction("signum", _SE(js_spine_MathUtil_signum_static)); 
    cls->defineStaticFunction("clamp", _SE(js_spine_MathUtil_clamp_static)); 
    cls->defineStaticFunction("abs", _SE(js_spine_MathUtil_abs_static)); 
    cls->defineStaticFunction("sin", _SE(js_spine_MathUtil_sin_static)); 
    cls->defineStaticFunction("cos", _SE(js_spine_MathUtil_cos_static)); 
    cls->defineStaticFunction("sinDeg", _SE(js_spine_MathUtil_sinDeg_static)); 
    cls->defineStaticFunction("cosDeg", _SE(js_spine_MathUtil_cosDeg_static)); 
    cls->defineStaticFunction("atan2", _SE(js_spine_MathUtil_atan2_static)); 
    cls->defineStaticFunction("atan2Deg", _SE(js_spine_MathUtil_atan2Deg_static)); 
    cls->defineStaticFunction("acos", _SE(js_spine_MathUtil_acos_static)); 
    cls->defineStaticFunction("sqrt", _SE(js_spine_MathUtil_sqrt_static)); 
    cls->defineStaticFunction("fmod", _SE(js_spine_MathUtil_fmod_static)); 
    cls->defineStaticFunction("isNan", _SE(js_spine_MathUtil_isNan_static)); 
    cls->defineStaticFunction("quietNan", _SE(js_spine_MathUtil_quietNan_static)); 
    cls->defineStaticFunction("random", _SE(js_spine_MathUtil_random_static)); 
    cls->defineStaticFunction("randomTriangular", _SE(js_spine_MathUtil_randomTriangular_static)); 
    cls->defineStaticFunction("pow", _SE(js_spine_MathUtil_pow_static)); 
    cls->defineStaticFunction("ceil", _SE(js_spine_MathUtil_ceil_static)); 
    
    
    cls->defineFinalizeFunction(_SE(js_delete_spine_MathUtil));
    
    
    cls->install();
    JSBClassType::registerClass<spine::MathUtil>(cls);
    
    __jsb_spine_MathUtil_proto = cls->getProto();
    __jsb_spine_MathUtil_class = cls;
    se::ScriptEngine::getInstance()->clearException();
    return true;
}


se::Class* __jsb_spine_Interpolation_class = nullptr;
se::Object* __jsb_spine_Interpolation_proto = nullptr;
SE_DECLARE_FINALIZE_FUNC(js_delete_spine_Interpolation) 

static bool js_spine_Interpolation_apply(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Interpolation *arg1 = (spine::Interpolation *) NULL ;
    float arg2 ;
    float result;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Interpolation>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (float)(arg1)->apply(arg2);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Interpolation_apply) 

static bool js_spine_Interpolation_interpolate(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Interpolation *arg1 = (spine::Interpolation *) NULL ;
    float arg2 ;
    float arg3 ;
    float arg4 ;
    float result;
    
    if(argc != 3) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 3);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Interpolation>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[1], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[2], &arg4, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (float)(arg1)->interpolate(arg2,arg3,arg4);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Interpolation_interpolate) 

static bool js_delete_spine_Interpolation(se::State& s)
{
    return true;
}
SE_BIND_FINALIZE_FUNC(js_delete_spine_Interpolation) 

template<>
bool sevalue_to_native(const se::Value &from, spine::Interpolation * to, se::Object *ctx)
{
    assert(from.isObject());
    se::Object *json = from.toObject();
    auto* data = reinterpret_cast<spine::Interpolation*>(json->getPrivateData());
    if (data) {
        *to = *data;
        return true;
    }
    se::Value field;
    bool ok = true;
    
    return ok;
}


bool js_register_spine_Interpolation(se::Object* obj) {
    auto* cls = se::Class::create("Interpolation", obj, nullptr, nullptr); 
    
    cls->defineStaticProperty("__isJSB", se::Value(true), se::PropertyAttribute::READ_ONLY | se::PropertyAttribute::DONT_ENUM | se::PropertyAttribute::DONT_DELETE);
    
    cls->defineFunction("apply", _SE(js_spine_Interpolation_apply)); 
    cls->defineFunction("interpolate", _SE(js_spine_Interpolation_interpolate)); 
    
    
    
    
    cls->defineFinalizeFunction(_SE(js_delete_spine_Interpolation));
    
    
    cls->install();
    JSBClassType::registerClass<spine::Interpolation>(cls);
    
    __jsb_spine_Interpolation_proto = cls->getProto();
    __jsb_spine_Interpolation_class = cls;
    se::ScriptEngine::getInstance()->clearException();
    return true;
}


se::Class* __jsb_spine_PowInterpolation_class = nullptr;
se::Object* __jsb_spine_PowInterpolation_proto = nullptr;
SE_DECLARE_FINALIZE_FUNC(js_delete_spine_PowInterpolation) 

static bool js_new_spine_PowInterpolation(se::State& s) // NOLINT(readability-identifier-naming)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    if (argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    
    int arg1 ;
    spine::PowInterpolation *result;
    
    ok &= sevalue_to_native(args[0], &arg1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (spine::PowInterpolation *)new spine::PowInterpolation(arg1);
    
    
    auto *ptr = JSB_MAKE_PRIVATE_OBJECT_WITH_INSTANCE(result);
    s.thisObject()->setPrivateObject(ptr);
    return true;
}
SE_BIND_CTOR(js_new_spine_PowInterpolation, __jsb_spine_PowInterpolation_class, js_delete_spine_PowInterpolation)

static bool js_spine_PowInterpolation_power_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::PowInterpolation *arg1 = (spine::PowInterpolation *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::PowInterpolation>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg1->power, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_PowInterpolation_power_set) 

static bool js_spine_PowInterpolation_power_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::PowInterpolation *arg1 = (spine::PowInterpolation *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::PowInterpolation>(s);
    if (nullptr == arg1) return true;
    
    ok &= nativevalue_to_se(arg1->power, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_PowInterpolation_power_get) 

static bool js_delete_spine_PowInterpolation(se::State& s)
{
    return true;
}
SE_BIND_FINALIZE_FUNC(js_delete_spine_PowInterpolation) 

template<>
bool sevalue_to_native(const se::Value &from, spine::PowInterpolation * to, se::Object *ctx)
{
    assert(from.isObject());
    se::Object *json = from.toObject();
    auto* data = reinterpret_cast<spine::PowInterpolation*>(json->getPrivateData());
    if (data) {
        *to = *data;
        return true;
    }
    se::Value field;
    bool ok = true;
    
    json->getProperty("power", &field, true);
    if (!field.isNullOrUndefined()) {
        ok &= sevalue_to_native(field, &(to->power), ctx);
    }
    
    
    return ok;
}


bool js_register_spine_PowInterpolation(se::Object* obj) {
    auto* cls = se::Class::create("PowInterpolation", obj, __jsb_spine_Interpolation_proto, _SE(js_new_spine_PowInterpolation)); 
    
    cls->defineStaticProperty("__isJSB", se::Value(true), se::PropertyAttribute::READ_ONLY | se::PropertyAttribute::DONT_ENUM | se::PropertyAttribute::DONT_DELETE);
    cls->defineProperty("power", _SE(js_spine_PowInterpolation_power_get), _SE(js_spine_PowInterpolation_power_set)); 
    
    
    
    
    
    cls->defineFinalizeFunction(_SE(js_delete_spine_PowInterpolation));
    
    
    cls->install();
    JSBClassType::registerClass<spine::PowInterpolation>(cls);
    
    __jsb_spine_PowInterpolation_proto = cls->getProto();
    __jsb_spine_PowInterpolation_class = cls;
    se::ScriptEngine::getInstance()->clearException();
    return true;
}


se::Class* __jsb_spine_PowOutInterpolation_class = nullptr;
se::Object* __jsb_spine_PowOutInterpolation_proto = nullptr;
SE_DECLARE_FINALIZE_FUNC(js_delete_spine_PowOutInterpolation) 

static bool js_new_spine_PowOutInterpolation(se::State& s) // NOLINT(readability-identifier-naming)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    if (argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    
    int arg1 ;
    spine::PowOutInterpolation *result;
    
    ok &= sevalue_to_native(args[0], &arg1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (spine::PowOutInterpolation *)new spine::PowOutInterpolation(arg1);
    
    
    auto *ptr = JSB_MAKE_PRIVATE_OBJECT_WITH_INSTANCE(result);
    s.thisObject()->setPrivateObject(ptr);
    return true;
}
SE_BIND_CTOR(js_new_spine_PowOutInterpolation, __jsb_spine_PowOutInterpolation_class, js_delete_spine_PowOutInterpolation)

static bool js_spine_PowOutInterpolation_power_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::PowOutInterpolation *arg1 = (spine::PowOutInterpolation *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::PowOutInterpolation>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg1->power, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_PowOutInterpolation_power_set) 

static bool js_spine_PowOutInterpolation_power_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::PowOutInterpolation *arg1 = (spine::PowOutInterpolation *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::PowOutInterpolation>(s);
    if (nullptr == arg1) return true;
    
    ok &= nativevalue_to_se(arg1->power, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_PowOutInterpolation_power_get) 

static bool js_delete_spine_PowOutInterpolation(se::State& s)
{
    return true;
}
SE_BIND_FINALIZE_FUNC(js_delete_spine_PowOutInterpolation) 

template<>
bool sevalue_to_native(const se::Value &from, spine::PowOutInterpolation * to, se::Object *ctx)
{
    assert(from.isObject());
    se::Object *json = from.toObject();
    auto* data = reinterpret_cast<spine::PowOutInterpolation*>(json->getPrivateData());
    if (data) {
        *to = *data;
        return true;
    }
    se::Value field;
    bool ok = true;
    
    json->getProperty("power", &field, true);
    if (!field.isNullOrUndefined()) {
        ok &= sevalue_to_native(field, &(to->power), ctx);
    }
    
    
    return ok;
}


bool js_register_spine_PowOutInterpolation(se::Object* obj) {
    auto* cls = se::Class::create("PowOutInterpolation", obj, __jsb_spine_Interpolation_proto, _SE(js_new_spine_PowOutInterpolation)); 
    
    cls->defineStaticProperty("__isJSB", se::Value(true), se::PropertyAttribute::READ_ONLY | se::PropertyAttribute::DONT_ENUM | se::PropertyAttribute::DONT_DELETE);
    cls->defineProperty("power", _SE(js_spine_PowOutInterpolation_power_get), _SE(js_spine_PowOutInterpolation_power_set)); 
    
    
    
    
    
    cls->defineFinalizeFunction(_SE(js_delete_spine_PowOutInterpolation));
    
    
    cls->install();
    JSBClassType::registerClass<spine::PowOutInterpolation>(cls);
    
    __jsb_spine_PowOutInterpolation_proto = cls->getProto();
    __jsb_spine_PowOutInterpolation_class = cls;
    se::ScriptEngine::getInstance()->clearException();
    return true;
}


se::Class* __jsb_spine_Timeline_class = nullptr;
se::Object* __jsb_spine_Timeline_proto = nullptr;
SE_DECLARE_FINALIZE_FUNC(js_delete_spine_Timeline) 

static bool js_delete_spine_Timeline(se::State& s)
{
    return true;
}
SE_BIND_FINALIZE_FUNC(js_delete_spine_Timeline) 

static bool js_spine_Timeline_getFrameEntries(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Timeline *arg1 = (spine::Timeline *) NULL ;
    size_t result;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Timeline>(s);
    if (nullptr == arg1) return true;
    result = (arg1)->getFrameEntries();
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Timeline_getFrameEntries) 

static bool js_spine_Timeline_getFrameCount(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Timeline *arg1 = (spine::Timeline *) NULL ;
    size_t result;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Timeline>(s);
    if (nullptr == arg1) return true;
    result = (arg1)->getFrameCount();
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Timeline_getFrameCount) 

static bool js_spine_Timeline_getFrames(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Timeline *arg1 = (spine::Timeline *) NULL ;
    spine::Vector< float > *result = 0 ;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Timeline>(s);
    if (nullptr == arg1) return true;
    result = (spine::Vector< float > *) &(arg1)->getFrames();
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Timeline_getFrames) 

static bool js_spine_Timeline_getDuration(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Timeline *arg1 = (spine::Timeline *) NULL ;
    float result;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Timeline>(s);
    if (nullptr == arg1) return true;
    result = (float)(arg1)->getDuration();
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Timeline_getDuration) 

static bool js_spine_Timeline_getPropertyIds(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Timeline *arg1 = (spine::Timeline *) NULL ;
    spine::Vector< PropertyId > *result = 0 ;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Timeline>(s);
    if (nullptr == arg1) return true;
    result = (spine::Vector< PropertyId > *) &(arg1)->getPropertyIds();
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Timeline_getPropertyIds) 

static bool js_spine_Timeline_apply(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Timeline *arg1 = (spine::Timeline *) NULL ;
    spine::Skeleton *arg2 = (spine::Skeleton *) NULL ;
    float arg3 ;
    float arg4 ;
    ccstd::vector< spine::Event * > *arg5 = 0 ;
    float arg6 ;
    spine::MixBlend arg7 ;
    spine::MixDirection arg8 ;
    ccstd::vector< spine::Event * > temp5 ;
    
    if(argc != 7) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 7);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Timeline>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[1], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[2], &arg4, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[3], &temp5, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg5 = &temp5;
    
    
    ok &= sevalue_to_native(args[4], &arg6, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[5], &arg7, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    
    ok &= sevalue_to_native(args[6], &arg8, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    spine_Timeline_apply(arg1,arg2,arg3,arg4,(ccstd::vector< spine::Event * > const &)*arg5,arg6,arg7,arg8);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Timeline_apply) 

bool js_register_spine_Timeline(se::Object* obj) {
    auto* cls = se::Class::create("Timeline", obj, nullptr, nullptr); 
    
    cls->defineStaticProperty("__isJSB", se::Value(true), se::PropertyAttribute::READ_ONLY | se::PropertyAttribute::DONT_ENUM | se::PropertyAttribute::DONT_DELETE);
    
    cls->defineFunction("getFrameEntries", _SE(js_spine_Timeline_getFrameEntries)); 
    cls->defineFunction("getFrameCount", _SE(js_spine_Timeline_getFrameCount)); 
    cls->defineFunction("getFrames", _SE(js_spine_Timeline_getFrames)); 
    cls->defineFunction("getDuration", _SE(js_spine_Timeline_getDuration)); 
    cls->defineFunction("getPropertyIds", _SE(js_spine_Timeline_getPropertyIds)); 
    cls->defineFunction("apply", _SE(js_spine_Timeline_apply)); 
    
    
    
    
    cls->defineFinalizeFunction(_SE(js_delete_spine_Timeline));
    
    
    cls->install();
    JSBClassType::registerClass<spine::Timeline>(cls);
    
    __jsb_spine_Timeline_proto = cls->getProto();
    __jsb_spine_Timeline_class = cls;
    se::ScriptEngine::getInstance()->clearException();
    return true;
}


se::Class* __jsb_spine_Animation_class = nullptr;
se::Object* __jsb_spine_Animation_proto = nullptr;
SE_DECLARE_FINALIZE_FUNC(js_delete_spine_Animation) 

static bool js_new_spine_Animation(se::State& s) // NOLINT(readability-identifier-naming)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    if (argc != 3) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 3);
        return false;
    }
    
    spine::String *arg1 = 0 ;
    spine::Vector< spine::Timeline * > *arg2 = 0 ;
    float arg3 ;
    spine::String temp1 ;
    spine::Vector< spine::Timeline * > temp2 ;
    spine::Animation *result;
    
    ok &= sevalue_to_native(args[0], &temp1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg1 = &temp1;
    
    
    ok &= sevalue_to_native(args[1], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    
    ok &= sevalue_to_native(args[2], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (spine::Animation *)new spine::Animation((spine::String const &)*arg1,*arg2,arg3);
    
    
    auto *ptr = JSB_MAKE_PRIVATE_OBJECT_WITH_INSTANCE(result);
    s.thisObject()->setPrivateObject(ptr);
    return true;
}
SE_BIND_CTOR(js_new_spine_Animation, __jsb_spine_Animation_class, js_delete_spine_Animation)

static bool js_delete_spine_Animation(se::State& s)
{
    return true;
}
SE_BIND_FINALIZE_FUNC(js_delete_spine_Animation) 

static bool js_spine_Animation_hasTimeline(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Animation *arg1 = (spine::Animation *) NULL ;
    spine::Vector< PropertyId > *arg2 = 0 ;
    spine::Vector< PropertyId > temp2 ;
    bool result;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Animation>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    result = (bool)(arg1)->hasTimeline(*arg2);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Animation_hasTimeline) 

static bool js_spine_Animation_search_static__SWIG_0(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    spine::Vector< float > *arg1 = 0 ;
    float arg2 ;
    spine::Vector< float > temp1 ;
    int result;
    
    
    ok &= sevalue_to_native(args[0], &temp1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg1 = &temp1;
    
    
    ok &= sevalue_to_native(args[1], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (int)spine::Animation::search(*arg1,arg2);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}

static bool js_spine_Animation_search_static__SWIG_1(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    spine::Vector< float > *arg1 = 0 ;
    float arg2 ;
    int arg3 ;
    spine::Vector< float > temp1 ;
    int result;
    
    
    ok &= sevalue_to_native(args[0], &temp1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg1 = &temp1;
    
    
    ok &= sevalue_to_native(args[1], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[2], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (int)spine::Animation::search(*arg1,arg2,arg3);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}

static bool js_spine_Animation_search_static(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    
    if (argc == 2) {
        ok = js_spine_Animation_search_static__SWIG_0(s);
        if (ok) {
            return true; 
        }
    } 
    if (argc == 3) {
        ok = js_spine_Animation_search_static__SWIG_1(s);
        if (ok) {
            return true; 
        }
    } 
    SE_REPORT_ERROR("wrong number of arguments: %d", (int)argc);
    return false;
}
SE_BIND_FUNC(js_spine_Animation_search_static) 

static bool js_spine_Animation_name_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::Animation *arg1 = (spine::Animation *) NULL ;
    spine::String *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::Animation>(s);
    if (nullptr == arg1) return true;
    result = (spine::String *) &spine_Animation_name_get(arg1);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_Animation_name_get) 

static bool js_spine_Animation_timelines_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::Animation *arg1 = (spine::Animation *) NULL ;
    spine::Vector< spine::Timeline * > *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::Animation>(s);
    if (nullptr == arg1) return true;
    result = (spine::Vector< spine::Timeline * > *) &spine_Animation_timelines_get(arg1);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_Animation_timelines_get) 

static bool js_spine_Animation_duration_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Animation *arg1 = (spine::Animation *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::Animation>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_Animation_duration_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_Animation_duration_set) 

static bool js_spine_Animation_duration_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::Animation *arg1 = (spine::Animation *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::Animation>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_Animation_duration_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_Animation_duration_get) 

static bool js_spine_Animation_apply(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Animation *arg1 = (spine::Animation *) NULL ;
    spine::Skeleton *arg2 = (spine::Skeleton *) NULL ;
    float arg3 ;
    float arg4 ;
    bool arg5 ;
    ccstd::vector< spine::Event * > *arg6 = 0 ;
    float arg7 ;
    spine::MixBlend arg8 ;
    spine::MixDirection arg9 ;
    ccstd::vector< spine::Event * > temp6 ;
    
    if(argc != 8) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 8);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Animation>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[1], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[2], &arg4, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[3], &arg5);
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[4], &temp6, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg6 = &temp6;
    
    
    ok &= sevalue_to_native(args[5], &arg7, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[6], &arg8, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    
    ok &= sevalue_to_native(args[7], &arg9, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    spine_Animation_apply(arg1,arg2,arg3,arg4,arg5,(ccstd::vector< spine::Event * > const &)*arg6,arg7,arg8,arg9);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Animation_apply) 

bool js_register_spine_Animation(se::Object* obj) {
    auto* cls = se::Class::create("Animation", obj, nullptr, _SE(js_new_spine_Animation)); 
    
    cls->defineStaticProperty("__isJSB", se::Value(true), se::PropertyAttribute::READ_ONLY | se::PropertyAttribute::DONT_ENUM | se::PropertyAttribute::DONT_DELETE);
    cls->defineProperty("name", _SE(js_spine_Animation_name_get), nullptr); 
    cls->defineProperty("timelines", _SE(js_spine_Animation_timelines_get), nullptr); 
    cls->defineProperty("duration", _SE(js_spine_Animation_duration_get), _SE(js_spine_Animation_duration_set)); 
    
    cls->defineFunction("hasTimeline", _SE(js_spine_Animation_hasTimeline)); 
    cls->defineFunction("apply", _SE(js_spine_Animation_apply)); 
    
    
    cls->defineStaticFunction("search", _SE(js_spine_Animation_search_static)); 
    
    
    cls->defineFinalizeFunction(_SE(js_delete_spine_Animation));
    
    
    cls->install();
    JSBClassType::registerClass<spine::Animation>(cls);
    
    __jsb_spine_Animation_proto = cls->getProto();
    __jsb_spine_Animation_class = cls;
    se::ScriptEngine::getInstance()->clearException();
    return true;
}


se::Class* __jsb_spine_AnimationStateListenerObject_class = nullptr;
se::Object* __jsb_spine_AnimationStateListenerObject_proto = nullptr;
SE_DECLARE_FINALIZE_FUNC(js_delete_spine_AnimationStateListenerObject) 

static bool js_delete_spine_AnimationStateListenerObject(se::State& s)
{
    return true;
}
SE_BIND_FINALIZE_FUNC(js_delete_spine_AnimationStateListenerObject) 

static bool js_spine_AnimationStateListenerObject_callback(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::AnimationStateListenerObject *arg1 = (spine::AnimationStateListenerObject *) NULL ;
    spine::AnimationState *arg2 = (spine::AnimationState *) NULL ;
    spine::EventType arg3 ;
    spine::TrackEntry *arg4 = (spine::TrackEntry *) NULL ;
    spine::Event *arg5 = (spine::Event *) NULL ;
    
    if(argc != 4) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 4);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::AnimationStateListenerObject>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[1], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    
    ok &= sevalue_to_native(args[2], &arg4, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[3], &arg5, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->callback(arg2,arg3,arg4,arg5);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_AnimationStateListenerObject_callback) 

bool js_register_spine_AnimationStateListenerObject(se::Object* obj) {
    auto* cls = se::Class::create("AnimationStateListenerObject", obj, nullptr, nullptr); 
    
    cls->defineStaticProperty("__isJSB", se::Value(true), se::PropertyAttribute::READ_ONLY | se::PropertyAttribute::DONT_ENUM | se::PropertyAttribute::DONT_DELETE);
    
    cls->defineFunction("callback", _SE(js_spine_AnimationStateListenerObject_callback)); 
    
    
    
    
    cls->defineFinalizeFunction(_SE(js_delete_spine_AnimationStateListenerObject));
    
    
    cls->install();
    JSBClassType::registerClass<spine::AnimationStateListenerObject>(cls);
    
    __jsb_spine_AnimationStateListenerObject_proto = cls->getProto();
    __jsb_spine_AnimationStateListenerObject_class = cls;
    se::ScriptEngine::getInstance()->clearException();
    return true;
}


se::Class* __jsb_spine_TrackEntry_class = nullptr;
se::Object* __jsb_spine_TrackEntry_proto = nullptr;
SE_DECLARE_FINALIZE_FUNC(js_delete_spine_TrackEntry) 

static bool js_new_spine_TrackEntry(se::State& s) // NOLINT(readability-identifier-naming)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    spine::TrackEntry *result;
    result = (spine::TrackEntry *)new spine::TrackEntry();
    
    
    auto *ptr = JSB_MAKE_PRIVATE_OBJECT_WITH_INSTANCE(result);
    s.thisObject()->setPrivateObject(ptr);
    return true;
}
SE_BIND_CTOR(js_new_spine_TrackEntry, __jsb_spine_TrackEntry_class, js_delete_spine_TrackEntry)

static bool js_delete_spine_TrackEntry(se::State& s)
{
    return true;
}
SE_BIND_FINALIZE_FUNC(js_delete_spine_TrackEntry) 

static bool js_spine_TrackEntry_getPrevious(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::TrackEntry *arg1 = (spine::TrackEntry *) NULL ;
    spine::TrackEntry *result = 0 ;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::TrackEntry>(s);
    if (nullptr == arg1) return true;
    result = (spine::TrackEntry *)(arg1)->getPrevious();
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_TrackEntry_getPrevious) 

static bool js_spine_TrackEntry_getReverse(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::TrackEntry *arg1 = (spine::TrackEntry *) NULL ;
    bool result;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::TrackEntry>(s);
    if (nullptr == arg1) return true;
    result = (bool)(arg1)->getReverse();
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    
    
    return true;
}
SE_BIND_FUNC(js_spine_TrackEntry_getReverse) 

static bool js_spine_TrackEntry_setReverse(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::TrackEntry *arg1 = (spine::TrackEntry *) NULL ;
    bool arg2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::TrackEntry>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2);
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setReverse(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_TrackEntry_setReverse) 

static bool js_spine_TrackEntry_getShortestRotation(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::TrackEntry *arg1 = (spine::TrackEntry *) NULL ;
    bool result;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::TrackEntry>(s);
    if (nullptr == arg1) return true;
    result = (bool)(arg1)->getShortestRotation();
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    
    
    return true;
}
SE_BIND_FUNC(js_spine_TrackEntry_getShortestRotation) 

static bool js_spine_TrackEntry_setShortestRotation(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::TrackEntry *arg1 = (spine::TrackEntry *) NULL ;
    bool arg2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::TrackEntry>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2);
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setShortestRotation(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_TrackEntry_setShortestRotation) 

static bool js_spine_TrackEntry_getAnimationTime(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::TrackEntry *arg1 = (spine::TrackEntry *) NULL ;
    float result;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::TrackEntry>(s);
    if (nullptr == arg1) return true;
    result = (float)(arg1)->getAnimationTime();
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_TrackEntry_getAnimationTime) 

static bool js_spine_TrackEntry_isComplete(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::TrackEntry *arg1 = (spine::TrackEntry *) NULL ;
    bool result;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::TrackEntry>(s);
    if (nullptr == arg1) return true;
    result = (bool)(arg1)->isComplete();
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    
    
    return true;
}
SE_BIND_FUNC(js_spine_TrackEntry_isComplete) 

static bool js_spine_TrackEntry_resetRotationDirections(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::TrackEntry *arg1 = (spine::TrackEntry *) NULL ;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::TrackEntry>(s);
    if (nullptr == arg1) return true;
    (arg1)->resetRotationDirections();
    
    
    return true;
}
SE_BIND_FUNC(js_spine_TrackEntry_resetRotationDirections) 

static bool js_spine_TrackEntry_getTrackComplete(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::TrackEntry *arg1 = (spine::TrackEntry *) NULL ;
    float result;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::TrackEntry>(s);
    if (nullptr == arg1) return true;
    result = (float)(arg1)->getTrackComplete();
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_TrackEntry_getTrackComplete) 

static bool js_spine_TrackEntry_wasApplied(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::TrackEntry *arg1 = (spine::TrackEntry *) NULL ;
    bool result;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::TrackEntry>(s);
    if (nullptr == arg1) return true;
    result = (bool)(arg1)->wasApplied();
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    
    
    return true;
}
SE_BIND_FUNC(js_spine_TrackEntry_wasApplied) 

static bool js_spine_TrackEntry_isNextReady(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::TrackEntry *arg1 = (spine::TrackEntry *) NULL ;
    bool result;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::TrackEntry>(s);
    if (nullptr == arg1) return true;
    result = (bool)(arg1)->isNextReady();
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    
    
    return true;
}
SE_BIND_FUNC(js_spine_TrackEntry_isNextReady) 

static bool js_spine_TrackEntry_animation_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::TrackEntry *arg1 = (spine::TrackEntry *) NULL ;
    spine::Animation *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::TrackEntry>(s);
    if (nullptr == arg1) return true;
    result = (spine::Animation *)spine_TrackEntry_animation_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_TrackEntry_animation_get) 

static bool js_spine_TrackEntry_next_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::TrackEntry *arg1 = (spine::TrackEntry *) NULL ;
    spine::TrackEntry *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::TrackEntry>(s);
    if (nullptr == arg1) return true;
    result = (spine::TrackEntry *)spine_TrackEntry_next_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_TrackEntry_next_get) 

static bool js_spine_TrackEntry_mixingFrom_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::TrackEntry *arg1 = (spine::TrackEntry *) NULL ;
    spine::TrackEntry *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::TrackEntry>(s);
    if (nullptr == arg1) return true;
    result = (spine::TrackEntry *)spine_TrackEntry_mixingFrom_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_TrackEntry_mixingFrom_get) 

static bool js_spine_TrackEntry_mixingTo_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::TrackEntry *arg1 = (spine::TrackEntry *) NULL ;
    spine::TrackEntry *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::TrackEntry>(s);
    if (nullptr == arg1) return true;
    result = (spine::TrackEntry *)spine_TrackEntry_mixingTo_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_TrackEntry_mixingTo_get) 

static bool js_spine_TrackEntry_trackIndex_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::TrackEntry *arg1 = (spine::TrackEntry *) NULL ;
    int result;
    
    arg1 = SE_THIS_OBJECT<spine::TrackEntry>(s);
    if (nullptr == arg1) return true;
    result = (int)spine_TrackEntry_trackIndex_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_TrackEntry_trackIndex_get) 

static bool js_spine_TrackEntry_loop_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::TrackEntry *arg1 = (spine::TrackEntry *) NULL ;
    bool arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::TrackEntry>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2);
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_TrackEntry_loop_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_TrackEntry_loop_set) 

static bool js_spine_TrackEntry_loop_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::TrackEntry *arg1 = (spine::TrackEntry *) NULL ;
    bool result;
    
    arg1 = SE_THIS_OBJECT<spine::TrackEntry>(s);
    if (nullptr == arg1) return true;
    result = (bool)spine_TrackEntry_loop_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_TrackEntry_loop_get) 

static bool js_spine_TrackEntry_holdPrevious_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::TrackEntry *arg1 = (spine::TrackEntry *) NULL ;
    bool arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::TrackEntry>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2);
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_TrackEntry_holdPrevious_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_TrackEntry_holdPrevious_set) 

static bool js_spine_TrackEntry_holdPrevious_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::TrackEntry *arg1 = (spine::TrackEntry *) NULL ;
    bool result;
    
    arg1 = SE_THIS_OBJECT<spine::TrackEntry>(s);
    if (nullptr == arg1) return true;
    result = (bool)spine_TrackEntry_holdPrevious_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_TrackEntry_holdPrevious_get) 

static bool js_spine_TrackEntry_eventThreshold_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::TrackEntry *arg1 = (spine::TrackEntry *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::TrackEntry>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_TrackEntry_eventThreshold_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_TrackEntry_eventThreshold_set) 

static bool js_spine_TrackEntry_eventThreshold_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::TrackEntry *arg1 = (spine::TrackEntry *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::TrackEntry>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_TrackEntry_eventThreshold_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_TrackEntry_eventThreshold_get) 

static bool js_spine_TrackEntry_mixAttachmentThreshold_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::TrackEntry *arg1 = (spine::TrackEntry *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::TrackEntry>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_TrackEntry_mixAttachmentThreshold_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_TrackEntry_mixAttachmentThreshold_set) 

static bool js_spine_TrackEntry_mixAttachmentThreshold_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::TrackEntry *arg1 = (spine::TrackEntry *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::TrackEntry>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_TrackEntry_mixAttachmentThreshold_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_TrackEntry_mixAttachmentThreshold_get) 

static bool js_spine_TrackEntry_mixDrawOrderThreshold_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::TrackEntry *arg1 = (spine::TrackEntry *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::TrackEntry>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_TrackEntry_mixDrawOrderThreshold_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_TrackEntry_mixDrawOrderThreshold_set) 

static bool js_spine_TrackEntry_mixDrawOrderThreshold_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::TrackEntry *arg1 = (spine::TrackEntry *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::TrackEntry>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_TrackEntry_mixDrawOrderThreshold_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_TrackEntry_mixDrawOrderThreshold_get) 

static bool js_spine_TrackEntry_alphaAttachmentThreshold_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::TrackEntry *arg1 = (spine::TrackEntry *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::TrackEntry>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_TrackEntry_alphaAttachmentThreshold_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_TrackEntry_alphaAttachmentThreshold_set) 

static bool js_spine_TrackEntry_alphaAttachmentThreshold_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::TrackEntry *arg1 = (spine::TrackEntry *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::TrackEntry>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_TrackEntry_alphaAttachmentThreshold_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_TrackEntry_alphaAttachmentThreshold_get) 

static bool js_spine_TrackEntry_animationStart_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::TrackEntry *arg1 = (spine::TrackEntry *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::TrackEntry>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_TrackEntry_animationStart_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_TrackEntry_animationStart_set) 

static bool js_spine_TrackEntry_animationStart_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::TrackEntry *arg1 = (spine::TrackEntry *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::TrackEntry>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_TrackEntry_animationStart_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_TrackEntry_animationStart_get) 

static bool js_spine_TrackEntry_animationEnd_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::TrackEntry *arg1 = (spine::TrackEntry *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::TrackEntry>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_TrackEntry_animationEnd_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_TrackEntry_animationEnd_set) 

static bool js_spine_TrackEntry_animationEnd_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::TrackEntry *arg1 = (spine::TrackEntry *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::TrackEntry>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_TrackEntry_animationEnd_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_TrackEntry_animationEnd_get) 

static bool js_spine_TrackEntry_animationLast_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::TrackEntry *arg1 = (spine::TrackEntry *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::TrackEntry>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_TrackEntry_animationLast_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_TrackEntry_animationLast_set) 

static bool js_spine_TrackEntry_animationLast_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::TrackEntry *arg1 = (spine::TrackEntry *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::TrackEntry>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_TrackEntry_animationLast_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_TrackEntry_animationLast_get) 

static bool js_spine_TrackEntry_delay_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::TrackEntry *arg1 = (spine::TrackEntry *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::TrackEntry>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_TrackEntry_delay_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_TrackEntry_delay_set) 

static bool js_spine_TrackEntry_delay_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::TrackEntry *arg1 = (spine::TrackEntry *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::TrackEntry>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_TrackEntry_delay_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_TrackEntry_delay_get) 

static bool js_spine_TrackEntry_trackTime_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::TrackEntry *arg1 = (spine::TrackEntry *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::TrackEntry>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_TrackEntry_trackTime_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_TrackEntry_trackTime_set) 

static bool js_spine_TrackEntry_trackTime_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::TrackEntry *arg1 = (spine::TrackEntry *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::TrackEntry>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_TrackEntry_trackTime_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_TrackEntry_trackTime_get) 

static bool js_spine_TrackEntry_trackEnd_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::TrackEntry *arg1 = (spine::TrackEntry *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::TrackEntry>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_TrackEntry_trackEnd_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_TrackEntry_trackEnd_set) 

static bool js_spine_TrackEntry_trackEnd_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::TrackEntry *arg1 = (spine::TrackEntry *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::TrackEntry>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_TrackEntry_trackEnd_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_TrackEntry_trackEnd_get) 

static bool js_spine_TrackEntry_timeScale_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::TrackEntry *arg1 = (spine::TrackEntry *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::TrackEntry>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_TrackEntry_timeScale_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_TrackEntry_timeScale_set) 

static bool js_spine_TrackEntry_timeScale_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::TrackEntry *arg1 = (spine::TrackEntry *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::TrackEntry>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_TrackEntry_timeScale_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_TrackEntry_timeScale_get) 

static bool js_spine_TrackEntry_alpha_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::TrackEntry *arg1 = (spine::TrackEntry *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::TrackEntry>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_TrackEntry_alpha_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_TrackEntry_alpha_set) 

static bool js_spine_TrackEntry_alpha_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::TrackEntry *arg1 = (spine::TrackEntry *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::TrackEntry>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_TrackEntry_alpha_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_TrackEntry_alpha_get) 

static bool js_spine_TrackEntry_mixTime_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::TrackEntry *arg1 = (spine::TrackEntry *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::TrackEntry>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_TrackEntry_mixTime_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_TrackEntry_mixTime_set) 

static bool js_spine_TrackEntry_mixTime_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::TrackEntry *arg1 = (spine::TrackEntry *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::TrackEntry>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_TrackEntry_mixTime_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_TrackEntry_mixTime_get) 

static bool js_spine_TrackEntry_mixDuration_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::TrackEntry *arg1 = (spine::TrackEntry *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::TrackEntry>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_TrackEntry_mixDuration_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_TrackEntry_mixDuration_set) 

static bool js_spine_TrackEntry_mixDuration_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::TrackEntry *arg1 = (spine::TrackEntry *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::TrackEntry>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_TrackEntry_mixDuration_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_TrackEntry_mixDuration_get) 

static bool js_spine_TrackEntry_mixBlend_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::TrackEntry *arg1 = (spine::TrackEntry *) NULL ;
    spine::MixBlend arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::TrackEntry>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    spine_TrackEntry_mixBlend_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_TrackEntry_mixBlend_set) 

static bool js_spine_TrackEntry_mixBlend_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::TrackEntry *arg1 = (spine::TrackEntry *) NULL ;
    spine::MixBlend result;
    
    arg1 = SE_THIS_OBJECT<spine::TrackEntry>(s);
    if (nullptr == arg1) return true;
    result = (spine::MixBlend)spine_TrackEntry_mixBlend_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject() /*ctx*/);
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval());
    
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_TrackEntry_mixBlend_get) 

bool js_register_spine_TrackEntry(se::Object* obj) {
    auto* cls = se::Class::create("TrackEntry", obj, nullptr, _SE(js_new_spine_TrackEntry)); 
    
    cls->defineStaticProperty("__isJSB", se::Value(true), se::PropertyAttribute::READ_ONLY | se::PropertyAttribute::DONT_ENUM | se::PropertyAttribute::DONT_DELETE);
    cls->defineProperty("animation", _SE(js_spine_TrackEntry_animation_get), nullptr); 
    cls->defineProperty("next", _SE(js_spine_TrackEntry_next_get), nullptr); 
    cls->defineProperty("mixingFrom", _SE(js_spine_TrackEntry_mixingFrom_get), nullptr); 
    cls->defineProperty("mixingTo", _SE(js_spine_TrackEntry_mixingTo_get), nullptr); 
    cls->defineProperty("trackIndex", _SE(js_spine_TrackEntry_trackIndex_get), nullptr); 
    cls->defineProperty("loop", _SE(js_spine_TrackEntry_loop_get), _SE(js_spine_TrackEntry_loop_set)); 
    cls->defineProperty("holdPrevious", _SE(js_spine_TrackEntry_holdPrevious_get), _SE(js_spine_TrackEntry_holdPrevious_set)); 
    cls->defineProperty("eventThreshold", _SE(js_spine_TrackEntry_eventThreshold_get), _SE(js_spine_TrackEntry_eventThreshold_set)); 
    cls->defineProperty("mixAttachmentThreshold", _SE(js_spine_TrackEntry_mixAttachmentThreshold_get), _SE(js_spine_TrackEntry_mixAttachmentThreshold_set)); 
    cls->defineProperty("mixDrawOrderThreshold", _SE(js_spine_TrackEntry_mixDrawOrderThreshold_get), _SE(js_spine_TrackEntry_mixDrawOrderThreshold_set)); 
    cls->defineProperty("alphaAttachmentThreshold", _SE(js_spine_TrackEntry_alphaAttachmentThreshold_get), _SE(js_spine_TrackEntry_alphaAttachmentThreshold_set)); 
    cls->defineProperty("animationStart", _SE(js_spine_TrackEntry_animationStart_get), _SE(js_spine_TrackEntry_animationStart_set)); 
    cls->defineProperty("animationEnd", _SE(js_spine_TrackEntry_animationEnd_get), _SE(js_spine_TrackEntry_animationEnd_set)); 
    cls->defineProperty("animationLast", _SE(js_spine_TrackEntry_animationLast_get), _SE(js_spine_TrackEntry_animationLast_set)); 
    cls->defineProperty("delay", _SE(js_spine_TrackEntry_delay_get), _SE(js_spine_TrackEntry_delay_set)); 
    cls->defineProperty("trackTime", _SE(js_spine_TrackEntry_trackTime_get), _SE(js_spine_TrackEntry_trackTime_set)); 
    cls->defineProperty("trackEnd", _SE(js_spine_TrackEntry_trackEnd_get), _SE(js_spine_TrackEntry_trackEnd_set)); 
    cls->defineProperty("timeScale", _SE(js_spine_TrackEntry_timeScale_get), _SE(js_spine_TrackEntry_timeScale_set)); 
    cls->defineProperty("alpha", _SE(js_spine_TrackEntry_alpha_get), _SE(js_spine_TrackEntry_alpha_set)); 
    cls->defineProperty("mixTime", _SE(js_spine_TrackEntry_mixTime_get), _SE(js_spine_TrackEntry_mixTime_set)); 
    cls->defineProperty("mixDuration", _SE(js_spine_TrackEntry_mixDuration_get), _SE(js_spine_TrackEntry_mixDuration_set)); 
    cls->defineProperty("mixBlend", _SE(js_spine_TrackEntry_mixBlend_get), _SE(js_spine_TrackEntry_mixBlend_set)); 
    
    cls->defineFunction("getPrevious", _SE(js_spine_TrackEntry_getPrevious)); 
    cls->defineFunction("getReverse", _SE(js_spine_TrackEntry_getReverse)); 
    cls->defineFunction("setReverse", _SE(js_spine_TrackEntry_setReverse)); 
    cls->defineFunction("getShortestRotation", _SE(js_spine_TrackEntry_getShortestRotation)); 
    cls->defineFunction("setShortestRotation", _SE(js_spine_TrackEntry_setShortestRotation)); 
    cls->defineFunction("getAnimationTime", _SE(js_spine_TrackEntry_getAnimationTime)); 
    cls->defineFunction("isComplete", _SE(js_spine_TrackEntry_isComplete)); 
    cls->defineFunction("resetRotationDirections", _SE(js_spine_TrackEntry_resetRotationDirections)); 
    cls->defineFunction("getTrackComplete", _SE(js_spine_TrackEntry_getTrackComplete)); 
    cls->defineFunction("wasApplied", _SE(js_spine_TrackEntry_wasApplied)); 
    cls->defineFunction("isNextReady", _SE(js_spine_TrackEntry_isNextReady)); 
    
    
    
    
    cls->defineFinalizeFunction(_SE(js_delete_spine_TrackEntry));
    
    
    cls->install();
    JSBClassType::registerClass<spine::TrackEntry>(cls);
    
    __jsb_spine_TrackEntry_proto = cls->getProto();
    __jsb_spine_TrackEntry_class = cls;
    se::ScriptEngine::getInstance()->clearException();
    return true;
}


se::Class* __jsb_spine_EventQueueEntry_class = nullptr;
se::Object* __jsb_spine_EventQueueEntry_proto = nullptr;
SE_DECLARE_FINALIZE_FUNC(js_delete_spine_EventQueueEntry) 

static bool js_spine_EventQueueEntry__type_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::EventQueueEntry *arg1 = (spine::EventQueueEntry *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::EventQueueEntry>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg1->_type, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_EventQueueEntry__type_set) 

static bool js_spine_EventQueueEntry__type_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::EventQueueEntry *arg1 = (spine::EventQueueEntry *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::EventQueueEntry>(s);
    if (nullptr == arg1) return true;
    
    ok &= nativevalue_to_se(arg1->_type, s.rval(), s.thisObject() /*ctx*/);
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(arg1->_type, s.thisObject(), s.rval());
    
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_EventQueueEntry__type_get) 

static bool js_spine_EventQueueEntry__entry_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::EventQueueEntry *arg1 = (spine::EventQueueEntry *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::EventQueueEntry>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg1->_entry, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_EventQueueEntry__entry_set) 

static bool js_spine_EventQueueEntry__entry_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::EventQueueEntry *arg1 = (spine::EventQueueEntry *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::EventQueueEntry>(s);
    if (nullptr == arg1) return true;
    
    ok &= nativevalue_to_se(arg1->_entry, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(arg1->_entry, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_EventQueueEntry__entry_get) 

static bool js_spine_EventQueueEntry__event_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::EventQueueEntry *arg1 = (spine::EventQueueEntry *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::EventQueueEntry>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg1->_event, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_EventQueueEntry__event_set) 

static bool js_spine_EventQueueEntry__event_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::EventQueueEntry *arg1 = (spine::EventQueueEntry *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::EventQueueEntry>(s);
    if (nullptr == arg1) return true;
    
    ok &= nativevalue_to_se(arg1->_event, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(arg1->_event, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_EventQueueEntry__event_get) 

static bool js_new_spine_EventQueueEntry__SWIG_0(se::State& s) // NOLINT(readability-identifier-naming)
{
    const auto& args = s.args();
    CC_UNUSED bool ok = true;
    spine::EventType arg1 ;
    spine::TrackEntry *arg2 = (spine::TrackEntry *) NULL ;
    spine::Event *arg3 = (spine::Event *) NULL ;
    spine::EventQueueEntry *result;
    
    ok &= sevalue_to_native(args[0], &arg1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    
    ok &= sevalue_to_native(args[1], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[2], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (spine::EventQueueEntry *)new spine::EventQueueEntry(arg1,arg2,arg3);
    
    
    auto *ptr = JSB_MAKE_PRIVATE_OBJECT_WITH_INSTANCE(result);
    s.thisObject()->setPrivateObject(ptr);
    return true;
}


static bool js_new_spine_EventQueueEntry__SWIG_1(se::State& s) // NOLINT(readability-identifier-naming)
{
    const auto& args = s.args();
    CC_UNUSED bool ok = true;
    spine::EventType arg1 ;
    spine::TrackEntry *arg2 = (spine::TrackEntry *) NULL ;
    spine::EventQueueEntry *result;
    
    ok &= sevalue_to_native(args[0], &arg1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    
    ok &= sevalue_to_native(args[1], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (spine::EventQueueEntry *)new spine::EventQueueEntry(arg1,arg2);
    
    
    auto *ptr = JSB_MAKE_PRIVATE_OBJECT_WITH_INSTANCE(result);
    s.thisObject()->setPrivateObject(ptr);
    return true;
}


static bool js_new_spine_EventQueueEntry(se::State& s) // NOLINT(readability-identifier-naming)
{
    size_t argc = s.args().size();
    bool ret = false;
    
    if(argc == 3) {
        ret = js_new_spine_EventQueueEntry__SWIG_0(s);
        if (ret) {
            return ret; 
        } /* reset exception and return */
    }
    
    if(argc == 2) {
        ret = js_new_spine_EventQueueEntry__SWIG_1(s);
        if (ret) {
            return ret; 
        } /* reset exception and return */
    }
    
    SE_REPORT_ERROR("Illegal arguments for construction of EventQueueEntry");
    return false;
}
SE_BIND_CTOR(js_new_spine_EventQueueEntry, __jsb_spine_EventQueueEntry_class, js_delete_spine_EventQueueEntry)

static bool js_delete_spine_EventQueueEntry(se::State& s)
{
    return true;
}
SE_BIND_FINALIZE_FUNC(js_delete_spine_EventQueueEntry) 

bool js_register_spine_EventQueueEntry(se::Object* obj) {
    auto* cls = se::Class::create("EventQueueEntry", obj, nullptr, _SE(js_new_spine_EventQueueEntry)); 
    
    cls->defineStaticProperty("__isJSB", se::Value(true), se::PropertyAttribute::READ_ONLY | se::PropertyAttribute::DONT_ENUM | se::PropertyAttribute::DONT_DELETE);
    cls->defineProperty("_type", _SE(js_spine_EventQueueEntry__type_get), _SE(js_spine_EventQueueEntry__type_set)); 
    cls->defineProperty("_entry", _SE(js_spine_EventQueueEntry__entry_get), _SE(js_spine_EventQueueEntry__entry_set)); 
    cls->defineProperty("_event", _SE(js_spine_EventQueueEntry__event_get), _SE(js_spine_EventQueueEntry__event_set)); 
    
    
    
    
    
    cls->defineFinalizeFunction(_SE(js_delete_spine_EventQueueEntry));
    
    
    cls->install();
    JSBClassType::registerClass<spine::EventQueueEntry>(cls);
    
    __jsb_spine_EventQueueEntry_proto = cls->getProto();
    __jsb_spine_EventQueueEntry_class = cls;
    se::ScriptEngine::getInstance()->clearException();
    return true;
}


se::Class* __jsb_spine_EventQueue_class = nullptr;
se::Object* __jsb_spine_EventQueue_proto = nullptr;
SE_DECLARE_FINALIZE_FUNC(js_delete_spine_EventQueue) 

bool js_register_spine_EventQueue(se::Object* obj) {
    auto* cls = se::Class::create("EventQueue", obj, nullptr, nullptr); 
    
    cls->defineStaticProperty("__isJSB", se::Value(true), se::PropertyAttribute::READ_ONLY | se::PropertyAttribute::DONT_ENUM | se::PropertyAttribute::DONT_DELETE);
    
    
    
    
    
    cls->install();
    JSBClassType::registerClass<spine::EventQueue>(cls);
    
    __jsb_spine_EventQueue_proto = cls->getProto();
    __jsb_spine_EventQueue_class = cls;
    se::ScriptEngine::getInstance()->clearException();
    return true;
}


se::Class* __jsb_spine_AnimationState_class = nullptr;
se::Object* __jsb_spine_AnimationState_proto = nullptr;
SE_DECLARE_FINALIZE_FUNC(js_delete_spine_AnimationState) 

static bool js_new_spine_AnimationState(se::State& s) // NOLINT(readability-identifier-naming)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    if (argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    
    spine::AnimationStateData *arg1 = (spine::AnimationStateData *) NULL ;
    spine::AnimationState *result;
    
    ok &= sevalue_to_native(args[0], &arg1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (spine::AnimationState *)new spine::AnimationState(arg1);
    
    
    auto *ptr = JSB_MAKE_PRIVATE_OBJECT_WITH_INSTANCE(result);
    s.thisObject()->setPrivateObject(ptr);
    return true;
}
SE_BIND_CTOR(js_new_spine_AnimationState, __jsb_spine_AnimationState_class, js_delete_spine_AnimationState)

static bool js_delete_spine_AnimationState(se::State& s)
{
    return true;
}
SE_BIND_FINALIZE_FUNC(js_delete_spine_AnimationState) 

static bool js_spine_AnimationState_update(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::AnimationState *arg1 = (spine::AnimationState *) NULL ;
    float arg2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::AnimationState>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->update(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_AnimationState_update) 

static bool js_spine_AnimationState_clearTracks(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::AnimationState *arg1 = (spine::AnimationState *) NULL ;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::AnimationState>(s);
    if (nullptr == arg1) return true;
    (arg1)->clearTracks();
    
    
    return true;
}
SE_BIND_FUNC(js_spine_AnimationState_clearTracks) 

static bool js_spine_AnimationState_clearTrack(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::AnimationState *arg1 = (spine::AnimationState *) NULL ;
    size_t arg2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::AnimationState>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    
    (arg1)->clearTrack(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_AnimationState_clearTrack) 

static bool js_spine_AnimationState_setAnimation__SWIG_0(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    spine::AnimationState *arg1 = (spine::AnimationState *) NULL ;
    size_t arg2 ;
    spine::String *arg3 = 0 ;
    bool arg4 ;
    spine::String temp3 ;
    spine::TrackEntry *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::AnimationState>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    
    
    ok &= sevalue_to_native(args[1], &temp3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg3 = &temp3;
    
    
    ok &= sevalue_to_native(args[2], &arg4);
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (spine::TrackEntry *)(arg1)->setAnimation(arg2,(spine::String const &)*arg3,arg4);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}

static bool js_spine_AnimationState_setAnimation__SWIG_1(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    spine::AnimationState *arg1 = (spine::AnimationState *) NULL ;
    size_t arg2 ;
    spine::Animation *arg3 = (spine::Animation *) NULL ;
    bool arg4 ;
    spine::TrackEntry *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::AnimationState>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    
    
    ok &= sevalue_to_native(args[1], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[2], &arg4);
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (spine::TrackEntry *)(arg1)->setAnimation(arg2,arg3,arg4);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}

static bool js_spine_AnimationState_setAnimation(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    
    if (argc == 3) {
        ok = js_spine_AnimationState_setAnimation__SWIG_0(s);
        if (ok) {
            return true; 
        }
    } 
    if (argc == 3) {
        ok = js_spine_AnimationState_setAnimation__SWIG_1(s);
        if (ok) {
            return true; 
        }
    } 
    SE_REPORT_ERROR("wrong number of arguments: %d", (int)argc);
    return false;
}
SE_BIND_FUNC(js_spine_AnimationState_setAnimation) 

static bool js_spine_AnimationState_addAnimation__SWIG_0(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    spine::AnimationState *arg1 = (spine::AnimationState *) NULL ;
    size_t arg2 ;
    spine::String *arg3 = 0 ;
    bool arg4 ;
    float arg5 ;
    spine::String temp3 ;
    spine::TrackEntry *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::AnimationState>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    
    
    ok &= sevalue_to_native(args[1], &temp3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg3 = &temp3;
    
    
    ok &= sevalue_to_native(args[2], &arg4);
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[3], &arg5, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (spine::TrackEntry *)(arg1)->addAnimation(arg2,(spine::String const &)*arg3,arg4,arg5);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}

static bool js_spine_AnimationState_addAnimation__SWIG_1(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    spine::AnimationState *arg1 = (spine::AnimationState *) NULL ;
    size_t arg2 ;
    spine::Animation *arg3 = (spine::Animation *) NULL ;
    bool arg4 ;
    float arg5 ;
    spine::TrackEntry *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::AnimationState>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    
    
    ok &= sevalue_to_native(args[1], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[2], &arg4);
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[3], &arg5, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (spine::TrackEntry *)(arg1)->addAnimation(arg2,arg3,arg4,arg5);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}

static bool js_spine_AnimationState_addAnimation(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    
    if (argc == 4) {
        ok = js_spine_AnimationState_addAnimation__SWIG_0(s);
        if (ok) {
            return true; 
        }
    } 
    if (argc == 4) {
        ok = js_spine_AnimationState_addAnimation__SWIG_1(s);
        if (ok) {
            return true; 
        }
    } 
    SE_REPORT_ERROR("wrong number of arguments: %d", (int)argc);
    return false;
}
SE_BIND_FUNC(js_spine_AnimationState_addAnimation) 

static bool js_spine_AnimationState_setEmptyAnimation(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::AnimationState *arg1 = (spine::AnimationState *) NULL ;
    size_t arg2 ;
    float arg3 ;
    spine::TrackEntry *result = 0 ;
    
    if(argc != 2) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 2);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::AnimationState>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    
    
    ok &= sevalue_to_native(args[1], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (spine::TrackEntry *)(arg1)->setEmptyAnimation(arg2,arg3);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_AnimationState_setEmptyAnimation) 

static bool js_spine_AnimationState_addEmptyAnimation(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::AnimationState *arg1 = (spine::AnimationState *) NULL ;
    size_t arg2 ;
    float arg3 ;
    float arg4 ;
    spine::TrackEntry *result = 0 ;
    
    if(argc != 3) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 3);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::AnimationState>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    
    
    ok &= sevalue_to_native(args[1], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[2], &arg4, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (spine::TrackEntry *)(arg1)->addEmptyAnimation(arg2,arg3,arg4);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_AnimationState_addEmptyAnimation) 

static bool js_spine_AnimationState_setEmptyAnimations(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::AnimationState *arg1 = (spine::AnimationState *) NULL ;
    float arg2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::AnimationState>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setEmptyAnimations(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_AnimationState_setEmptyAnimations) 

static bool js_spine_AnimationState_getCurrent(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::AnimationState *arg1 = (spine::AnimationState *) NULL ;
    size_t arg2 ;
    spine::TrackEntry *result = 0 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::AnimationState>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    
    result = (spine::TrackEntry *)(arg1)->getCurrent(arg2);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_AnimationState_getCurrent) 

static bool js_spine_AnimationState_disableQueue(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::AnimationState *arg1 = (spine::AnimationState *) NULL ;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::AnimationState>(s);
    if (nullptr == arg1) return true;
    (arg1)->disableQueue();
    
    
    return true;
}
SE_BIND_FUNC(js_spine_AnimationState_disableQueue) 

static bool js_spine_AnimationState_enableQueue(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::AnimationState *arg1 = (spine::AnimationState *) NULL ;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::AnimationState>(s);
    if (nullptr == arg1) return true;
    (arg1)->enableQueue();
    
    
    return true;
}
SE_BIND_FUNC(js_spine_AnimationState_enableQueue) 

static bool js_spine_AnimationState_setManualTrackEntryDisposal(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::AnimationState *arg1 = (spine::AnimationState *) NULL ;
    bool arg2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::AnimationState>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2);
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setManualTrackEntryDisposal(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_AnimationState_setManualTrackEntryDisposal) 

static bool js_spine_AnimationState_getManualTrackEntryDisposal(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::AnimationState *arg1 = (spine::AnimationState *) NULL ;
    bool result;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::AnimationState>(s);
    if (nullptr == arg1) return true;
    result = (bool)(arg1)->getManualTrackEntryDisposal();
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    
    
    return true;
}
SE_BIND_FUNC(js_spine_AnimationState_getManualTrackEntryDisposal) 

static bool js_spine_AnimationState_disposeTrackEntry(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::AnimationState *arg1 = (spine::AnimationState *) NULL ;
    spine::TrackEntry *arg2 = (spine::TrackEntry *) NULL ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::AnimationState>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->disposeTrackEntry(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_AnimationState_disposeTrackEntry) 

static bool js_spine_AnimationState_data_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::AnimationState *arg1 = (spine::AnimationState *) NULL ;
    spine::AnimationStateData *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::AnimationState>(s);
    if (nullptr == arg1) return true;
    result = (spine::AnimationStateData *)spine_AnimationState_data_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_AnimationState_data_get) 

static bool js_spine_AnimationState_tracks_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::AnimationState *arg1 = (spine::AnimationState *) NULL ;
    spine::Vector< spine::TrackEntry * > *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::AnimationState>(s);
    if (nullptr == arg1) return true;
    result = (spine::Vector< spine::TrackEntry * > *) &spine_AnimationState_tracks_get(arg1);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_AnimationState_tracks_get) 

static bool js_spine_AnimationState_timeScale_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::AnimationState *arg1 = (spine::AnimationState *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::AnimationState>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_AnimationState_timeScale_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_AnimationState_timeScale_set) 

static bool js_spine_AnimationState_timeScale_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::AnimationState *arg1 = (spine::AnimationState *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::AnimationState>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_AnimationState_timeScale_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_AnimationState_timeScale_get) 

static bool js_spine_AnimationState_apply(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::AnimationState *arg1 = (spine::AnimationState *) NULL ;
    spine::Skeleton *arg2 = (spine::Skeleton *) NULL ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::AnimationState>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_AnimationState_apply(arg1,arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_AnimationState_apply) 

bool js_register_spine_AnimationState(se::Object* obj) {
    auto* cls = se::Class::create("AnimationState", obj, nullptr, _SE(js_new_spine_AnimationState)); 
    
    cls->defineStaticProperty("__isJSB", se::Value(true), se::PropertyAttribute::READ_ONLY | se::PropertyAttribute::DONT_ENUM | se::PropertyAttribute::DONT_DELETE);
    cls->defineProperty("data", _SE(js_spine_AnimationState_data_get), nullptr); 
    cls->defineProperty("tracks", _SE(js_spine_AnimationState_tracks_get), nullptr); 
    cls->defineProperty("timeScale", _SE(js_spine_AnimationState_timeScale_get), _SE(js_spine_AnimationState_timeScale_set)); 
    
    cls->defineFunction("update", _SE(js_spine_AnimationState_update)); 
    cls->defineFunction("clearTracks", _SE(js_spine_AnimationState_clearTracks)); 
    cls->defineFunction("clearTrack", _SE(js_spine_AnimationState_clearTrack)); 
    cls->defineFunction("setAnimation", _SE(js_spine_AnimationState_setAnimation)); 
    cls->defineFunction("addAnimation", _SE(js_spine_AnimationState_addAnimation)); 
    cls->defineFunction("setEmptyAnimation", _SE(js_spine_AnimationState_setEmptyAnimation)); 
    cls->defineFunction("addEmptyAnimation", _SE(js_spine_AnimationState_addEmptyAnimation)); 
    cls->defineFunction("setEmptyAnimations", _SE(js_spine_AnimationState_setEmptyAnimations)); 
    cls->defineFunction("getCurrent", _SE(js_spine_AnimationState_getCurrent)); 
    cls->defineFunction("disableQueue", _SE(js_spine_AnimationState_disableQueue)); 
    cls->defineFunction("enableQueue", _SE(js_spine_AnimationState_enableQueue)); 
    cls->defineFunction("setManualTrackEntryDisposal", _SE(js_spine_AnimationState_setManualTrackEntryDisposal)); 
    cls->defineFunction("getManualTrackEntryDisposal", _SE(js_spine_AnimationState_getManualTrackEntryDisposal)); 
    cls->defineFunction("disposeTrackEntry", _SE(js_spine_AnimationState_disposeTrackEntry)); 
    cls->defineFunction("apply", _SE(js_spine_AnimationState_apply)); 
    
    
    
    
    cls->defineFinalizeFunction(_SE(js_delete_spine_AnimationState));
    
    
    cls->install();
    JSBClassType::registerClass<spine::AnimationState>(cls);
    
    __jsb_spine_AnimationState_proto = cls->getProto();
    __jsb_spine_AnimationState_class = cls;
    se::ScriptEngine::getInstance()->clearException();
    return true;
}


se::Class* __jsb_spine_AnimationStateData_class = nullptr;
se::Object* __jsb_spine_AnimationStateData_proto = nullptr;
SE_DECLARE_FINALIZE_FUNC(js_delete_spine_AnimationStateData) 

static bool js_new_spine_AnimationStateData(se::State& s) // NOLINT(readability-identifier-naming)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    if (argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    
    spine::SkeletonData *arg1 = (spine::SkeletonData *) NULL ;
    spine::AnimationStateData *result;
    
    ok &= sevalue_to_native(args[0], &arg1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (spine::AnimationStateData *)new spine::AnimationStateData(arg1);
    
    
    auto *ptr = JSB_MAKE_PRIVATE_OBJECT_WITH_INSTANCE(result);
    s.thisObject()->setPrivateObject(ptr);
    return true;
}
SE_BIND_CTOR(js_new_spine_AnimationStateData, __jsb_spine_AnimationStateData_class, js_delete_spine_AnimationStateData)

static bool js_spine_AnimationStateData_setMixWith__SWIG_0(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    spine::AnimationStateData *arg1 = (spine::AnimationStateData *) NULL ;
    spine::String *arg2 = 0 ;
    spine::String *arg3 = 0 ;
    float arg4 ;
    spine::String temp2 ;
    spine::String temp3 ;
    
    arg1 = SE_THIS_OBJECT<spine::AnimationStateData>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    
    ok &= sevalue_to_native(args[1], &temp3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg3 = &temp3;
    
    
    ok &= sevalue_to_native(args[2], &arg4, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setMix((spine::String const &)*arg2,(spine::String const &)*arg3,arg4);
    
    
    return true;
}

static bool js_spine_AnimationStateData_setMixWith__SWIG_1(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    spine::AnimationStateData *arg1 = (spine::AnimationStateData *) NULL ;
    spine::Animation *arg2 = (spine::Animation *) NULL ;
    spine::Animation *arg3 = (spine::Animation *) NULL ;
    float arg4 ;
    
    arg1 = SE_THIS_OBJECT<spine::AnimationStateData>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[1], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[2], &arg4, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setMix(arg2,arg3,arg4);
    
    
    return true;
}

static bool js_spine_AnimationStateData_setMixWith(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    
    if (argc == 3) {
        ok = js_spine_AnimationStateData_setMixWith__SWIG_0(s);
        if (ok) {
            return true; 
        }
    } 
    if (argc == 3) {
        ok = js_spine_AnimationStateData_setMixWith__SWIG_1(s);
        if (ok) {
            return true; 
        }
    } 
    SE_REPORT_ERROR("wrong number of arguments: %d", (int)argc);
    return false;
}
SE_BIND_FUNC(js_spine_AnimationStateData_setMixWith) 

static bool js_spine_AnimationStateData_getMix(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::AnimationStateData *arg1 = (spine::AnimationStateData *) NULL ;
    spine::Animation *arg2 = (spine::Animation *) NULL ;
    spine::Animation *arg3 = (spine::Animation *) NULL ;
    float result;
    
    if(argc != 2) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 2);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::AnimationStateData>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[1], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (float)(arg1)->getMix(arg2,arg3);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_AnimationStateData_getMix) 

static bool js_spine_AnimationStateData_clear(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::AnimationStateData *arg1 = (spine::AnimationStateData *) NULL ;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::AnimationStateData>(s);
    if (nullptr == arg1) return true;
    (arg1)->clear();
    
    
    return true;
}
SE_BIND_FUNC(js_spine_AnimationStateData_clear) 

static bool js_spine_AnimationStateData_skeletonData_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::AnimationStateData *arg1 = (spine::AnimationStateData *) NULL ;
    spine::SkeletonData *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::AnimationStateData>(s);
    if (nullptr == arg1) return true;
    result = (spine::SkeletonData *)spine_AnimationStateData_skeletonData_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_AnimationStateData_skeletonData_get) 

static bool js_spine_AnimationStateData_defaultMix_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::AnimationStateData *arg1 = (spine::AnimationStateData *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::AnimationStateData>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_AnimationStateData_defaultMix_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_AnimationStateData_defaultMix_set) 

static bool js_spine_AnimationStateData_defaultMix_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::AnimationStateData *arg1 = (spine::AnimationStateData *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::AnimationStateData>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_AnimationStateData_defaultMix_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_AnimationStateData_defaultMix_get) 

static bool js_delete_spine_AnimationStateData(se::State& s)
{
    return true;
}
SE_BIND_FINALIZE_FUNC(js_delete_spine_AnimationStateData) 

bool js_register_spine_AnimationStateData(se::Object* obj) {
    auto* cls = se::Class::create("AnimationStateData", obj, nullptr, _SE(js_new_spine_AnimationStateData)); 
    
    cls->defineStaticProperty("__isJSB", se::Value(true), se::PropertyAttribute::READ_ONLY | se::PropertyAttribute::DONT_ENUM | se::PropertyAttribute::DONT_DELETE);
    cls->defineProperty("skeletonData", _SE(js_spine_AnimationStateData_skeletonData_get), nullptr); 
    cls->defineProperty("defaultMix", _SE(js_spine_AnimationStateData_defaultMix_get), _SE(js_spine_AnimationStateData_defaultMix_set)); 
    
    cls->defineFunction("setMixWith", _SE(js_spine_AnimationStateData_setMixWith)); 
    cls->defineFunction("getMix", _SE(js_spine_AnimationStateData_getMix)); 
    cls->defineFunction("clear", _SE(js_spine_AnimationStateData_clear)); 
    
    
    
    
    cls->defineFinalizeFunction(_SE(js_delete_spine_AnimationStateData));
    
    
    cls->install();
    JSBClassType::registerClass<spine::AnimationStateData>(cls);
    
    __jsb_spine_AnimationStateData_proto = cls->getProto();
    __jsb_spine_AnimationStateData_class = cls;
    se::ScriptEngine::getInstance()->clearException();
    return true;
}


se::Class* __jsb_spine_Attachment_class = nullptr;
se::Object* __jsb_spine_Attachment_proto = nullptr;
SE_DECLARE_FINALIZE_FUNC(js_delete_spine_Attachment) 

static bool js_delete_spine_Attachment(se::State& s)
{
    return true;
}
SE_BIND_FINALIZE_FUNC(js_delete_spine_Attachment) 

static bool js_spine_Attachment_copy(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Attachment *arg1 = (spine::Attachment *) NULL ;
    spine::Attachment *result = 0 ;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Attachment>(s);
    if (nullptr == arg1) return true;
    result = (spine::Attachment *)(arg1)->copy();
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Attachment_copy) 

static bool js_spine_Attachment_getRefCount(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Attachment *arg1 = (spine::Attachment *) NULL ;
    int result;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Attachment>(s);
    if (nullptr == arg1) return true;
    result = (int)(arg1)->getRefCount();
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Attachment_getRefCount) 

static bool js_spine_Attachment_reference(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Attachment *arg1 = (spine::Attachment *) NULL ;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Attachment>(s);
    if (nullptr == arg1) return true;
    (arg1)->reference();
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Attachment_reference) 

static bool js_spine_Attachment_dereference(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Attachment *arg1 = (spine::Attachment *) NULL ;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Attachment>(s);
    if (nullptr == arg1) return true;
    (arg1)->dereference();
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Attachment_dereference) 

static bool js_spine_Attachment_name_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::Attachment *arg1 = (spine::Attachment *) NULL ;
    spine::String *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::Attachment>(s);
    if (nullptr == arg1) return true;
    result = (spine::String *) &spine_Attachment_name_get(arg1);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_Attachment_name_get) 

bool js_register_spine_Attachment(se::Object* obj) {
    auto* cls = se::Class::create("Attachment", obj, nullptr, nullptr); 
    
    cls->defineStaticProperty("__isJSB", se::Value(true), se::PropertyAttribute::READ_ONLY | se::PropertyAttribute::DONT_ENUM | se::PropertyAttribute::DONT_DELETE);
    cls->defineProperty("name", _SE(js_spine_Attachment_name_get), nullptr); 
    
    cls->defineFunction("copy", _SE(js_spine_Attachment_copy)); 
    cls->defineFunction("getRefCount", _SE(js_spine_Attachment_getRefCount)); 
    cls->defineFunction("reference", _SE(js_spine_Attachment_reference)); 
    cls->defineFunction("dereference", _SE(js_spine_Attachment_dereference)); 
    
    
    
    
    cls->defineFinalizeFunction(_SE(js_delete_spine_Attachment));
    
    
    cls->install();
    JSBClassType::registerClass<spine::Attachment>(cls);
    
    __jsb_spine_Attachment_proto = cls->getProto();
    __jsb_spine_Attachment_class = cls;
    se::ScriptEngine::getInstance()->clearException();
    return true;
}


se::Class* __jsb_spine_AttachmentTimeline_class = nullptr;
se::Object* __jsb_spine_AttachmentTimeline_proto = nullptr;
SE_DECLARE_FINALIZE_FUNC(js_delete_spine_AttachmentTimeline) 

static bool js_new_spine_AttachmentTimeline(se::State& s) // NOLINT(readability-identifier-naming)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    if (argc != 2) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 2);
        return false;
    }
    
    size_t arg1 ;
    int arg2 ;
    spine::AttachmentTimeline *result;
    
    ok &= sevalue_to_native(args[0], &arg1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    
    
    ok &= sevalue_to_native(args[1], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (spine::AttachmentTimeline *)new spine::AttachmentTimeline(arg1,arg2);
    
    
    auto *ptr = JSB_MAKE_PRIVATE_OBJECT_WITH_INSTANCE(result);
    s.thisObject()->setPrivateObject(ptr);
    return true;
}
SE_BIND_CTOR(js_new_spine_AttachmentTimeline, __jsb_spine_AttachmentTimeline_class, js_delete_spine_AttachmentTimeline)

static bool js_delete_spine_AttachmentTimeline(se::State& s)
{
    return true;
}
SE_BIND_FINALIZE_FUNC(js_delete_spine_AttachmentTimeline) 

static bool js_spine_AttachmentTimeline_setFrame(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::AttachmentTimeline *arg1 = (spine::AttachmentTimeline *) NULL ;
    int arg2 ;
    float arg3 ;
    spine::String *arg4 = 0 ;
    spine::String temp4 ;
    
    if(argc != 3) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 3);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::AttachmentTimeline>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[1], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[2], &temp4, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg4 = &temp4;
    
    (arg1)->setFrame(arg2,arg3,(spine::String const &)*arg4);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_AttachmentTimeline_setFrame) 

static bool js_spine_AttachmentTimeline_slotIndex_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::AttachmentTimeline *arg1 = (spine::AttachmentTimeline *) NULL ;
    size_t arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::AttachmentTimeline>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    
    spine_AttachmentTimeline_slotIndex_set(arg1,SWIG_STD_MOVE(arg2));
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_AttachmentTimeline_slotIndex_set) 

static bool js_spine_AttachmentTimeline_slotIndex_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::AttachmentTimeline *arg1 = (spine::AttachmentTimeline *) NULL ;
    size_t result;
    
    arg1 = SE_THIS_OBJECT<spine::AttachmentTimeline>(s);
    if (nullptr == arg1) return true;
    result = spine_AttachmentTimeline_slotIndex_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_AttachmentTimeline_slotIndex_get) 

static bool js_spine_AttachmentTimeline_frames_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::AttachmentTimeline *arg1 = (spine::AttachmentTimeline *) NULL ;
    spine::Vector< float > *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::AttachmentTimeline>(s);
    if (nullptr == arg1) return true;
    result = (spine::Vector< float > *) &spine_AttachmentTimeline_frames_get(arg1);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_AttachmentTimeline_frames_get) 

static bool js_spine_AttachmentTimeline_attachmentNames_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::AttachmentTimeline *arg1 = (spine::AttachmentTimeline *) NULL ;
    spine::Vector< spine::String > *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::AttachmentTimeline>(s);
    if (nullptr == arg1) return true;
    result = (spine::Vector< spine::String > *) &spine_AttachmentTimeline_attachmentNames_get(arg1);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_AttachmentTimeline_attachmentNames_get) 

bool js_register_spine_AttachmentTimeline(se::Object* obj) {
    auto* cls = se::Class::create("AttachmentTimeline", obj, __jsb_spine_Timeline_proto, _SE(js_new_spine_AttachmentTimeline)); 
    
    cls->defineStaticProperty("__isJSB", se::Value(true), se::PropertyAttribute::READ_ONLY | se::PropertyAttribute::DONT_ENUM | se::PropertyAttribute::DONT_DELETE);
    cls->defineProperty("slotIndex", _SE(js_spine_AttachmentTimeline_slotIndex_get), _SE(js_spine_AttachmentTimeline_slotIndex_set)); 
    cls->defineProperty("frames", _SE(js_spine_AttachmentTimeline_frames_get), nullptr); 
    cls->defineProperty("attachmentNames", _SE(js_spine_AttachmentTimeline_attachmentNames_get), nullptr); 
    
    cls->defineFunction("setFrame", _SE(js_spine_AttachmentTimeline_setFrame)); 
    
    
    
    
    cls->defineFinalizeFunction(_SE(js_delete_spine_AttachmentTimeline));
    
    
    cls->install();
    JSBClassType::registerClass<spine::AttachmentTimeline>(cls);
    
    __jsb_spine_AttachmentTimeline_proto = cls->getProto();
    __jsb_spine_AttachmentTimeline_class = cls;
    se::ScriptEngine::getInstance()->clearException();
    return true;
}


se::Class* __jsb_spine_VertexAttachment_class = nullptr;
se::Object* __jsb_spine_VertexAttachment_proto = nullptr;
SE_DECLARE_FINALIZE_FUNC(js_delete_spine_VertexAttachment) 

static bool js_delete_spine_VertexAttachment(se::State& s)
{
    return true;
}
SE_BIND_FINALIZE_FUNC(js_delete_spine_VertexAttachment) 

static bool js_spine_VertexAttachment_copyTo(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::VertexAttachment *arg1 = (spine::VertexAttachment *) NULL ;
    spine::VertexAttachment *arg2 = (spine::VertexAttachment *) NULL ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::VertexAttachment>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->copyTo(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_VertexAttachment_copyTo) 

static bool js_spine_VertexAttachment_id_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::VertexAttachment *arg1 = (spine::VertexAttachment *) NULL ;
    int result;
    
    arg1 = SE_THIS_OBJECT<spine::VertexAttachment>(s);
    if (nullptr == arg1) return true;
    result = (int)spine_VertexAttachment_id_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_VertexAttachment_id_get) 

static bool js_spine_VertexAttachment_bones_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::VertexAttachment *arg1 = (spine::VertexAttachment *) NULL ;
    spine::Vector< size_t > *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::VertexAttachment>(s);
    if (nullptr == arg1) return true;
    result = (spine::Vector< size_t > *) &spine_VertexAttachment_bones_get(arg1);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_VertexAttachment_bones_get) 

static bool js_spine_VertexAttachment_vertices_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::VertexAttachment *arg1 = (spine::VertexAttachment *) NULL ;
    spine::Vector< float > *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::VertexAttachment>(s);
    if (nullptr == arg1) return true;
    result = (spine::Vector< float > *) &spine_VertexAttachment_vertices_get(arg1);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_VertexAttachment_vertices_get) 

static bool js_spine_VertexAttachment_worldVerticesLength_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::VertexAttachment *arg1 = (spine::VertexAttachment *) NULL ;
    size_t arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::VertexAttachment>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    
    spine_VertexAttachment_worldVerticesLength_set(arg1,SWIG_STD_MOVE(arg2));
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_VertexAttachment_worldVerticesLength_set) 

static bool js_spine_VertexAttachment_worldVerticesLength_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::VertexAttachment *arg1 = (spine::VertexAttachment *) NULL ;
    size_t result;
    
    arg1 = SE_THIS_OBJECT<spine::VertexAttachment>(s);
    if (nullptr == arg1) return true;
    result = spine_VertexAttachment_worldVerticesLength_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_VertexAttachment_worldVerticesLength_get) 

static bool js_spine_VertexAttachment_timelineAttachment_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::VertexAttachment *arg1 = (spine::VertexAttachment *) NULL ;
    spine::Attachment *arg2 = (spine::Attachment *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::VertexAttachment>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_VertexAttachment_timelineAttachment_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_VertexAttachment_timelineAttachment_set) 

static bool js_spine_VertexAttachment_timelineAttachment_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::VertexAttachment *arg1 = (spine::VertexAttachment *) NULL ;
    spine::Attachment *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::VertexAttachment>(s);
    if (nullptr == arg1) return true;
    result = (spine::Attachment *)spine_VertexAttachment_timelineAttachment_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_VertexAttachment_timelineAttachment_get) 

bool js_register_spine_VertexAttachment(se::Object* obj) {
    auto* cls = se::Class::create("VertexAttachment", obj, __jsb_spine_Attachment_proto, nullptr); 
    
    cls->defineStaticProperty("__isJSB", se::Value(true), se::PropertyAttribute::READ_ONLY | se::PropertyAttribute::DONT_ENUM | se::PropertyAttribute::DONT_DELETE);
    cls->defineProperty("id", _SE(js_spine_VertexAttachment_id_get), nullptr); 
    cls->defineProperty("bones", _SE(js_spine_VertexAttachment_bones_get), nullptr); 
    cls->defineProperty("vertices", _SE(js_spine_VertexAttachment_vertices_get), nullptr); 
    cls->defineProperty("worldVerticesLength", _SE(js_spine_VertexAttachment_worldVerticesLength_get), _SE(js_spine_VertexAttachment_worldVerticesLength_set)); 
    cls->defineProperty("timelineAttachment", _SE(js_spine_VertexAttachment_timelineAttachment_get), _SE(js_spine_VertexAttachment_timelineAttachment_set)); 
    
    cls->defineFunction("copyTo", _SE(js_spine_VertexAttachment_copyTo)); 
    
    
    
    
    cls->defineFinalizeFunction(_SE(js_delete_spine_VertexAttachment));
    
    
    cls->install();
    JSBClassType::registerClass<spine::VertexAttachment>(cls);
    
    __jsb_spine_VertexAttachment_proto = cls->getProto();
    __jsb_spine_VertexAttachment_class = cls;
    se::ScriptEngine::getInstance()->clearException();
    return true;
}


se::Class* __jsb_spine_BoundingBoxAttachment_class = nullptr;
se::Object* __jsb_spine_BoundingBoxAttachment_proto = nullptr;
SE_DECLARE_FINALIZE_FUNC(js_delete_spine_BoundingBoxAttachment) 

static bool js_new_spine_BoundingBoxAttachment(se::State& s) // NOLINT(readability-identifier-naming)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    if (argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    
    spine::String *arg1 = 0 ;
    spine::String temp1 ;
    spine::BoundingBoxAttachment *result;
    
    ok &= sevalue_to_native(args[0], &temp1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg1 = &temp1;
    
    result = (spine::BoundingBoxAttachment *)new spine::BoundingBoxAttachment((spine::String const &)*arg1);
    
    
    auto *ptr = JSB_MAKE_PRIVATE_OBJECT_WITH_INSTANCE(result);
    s.thisObject()->setPrivateObject(ptr);
    return true;
}
SE_BIND_CTOR(js_new_spine_BoundingBoxAttachment, __jsb_spine_BoundingBoxAttachment_class, js_delete_spine_BoundingBoxAttachment)

static bool js_spine_BoundingBoxAttachment_getColor(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::BoundingBoxAttachment *arg1 = (spine::BoundingBoxAttachment *) NULL ;
    Color *result = 0 ;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::BoundingBoxAttachment>(s);
    if (nullptr == arg1) return true;
    result = (Color *) &(arg1)->getColor();
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_BoundingBoxAttachment_getColor) 

static bool js_delete_spine_BoundingBoxAttachment(se::State& s)
{
    return true;
}
SE_BIND_FINALIZE_FUNC(js_delete_spine_BoundingBoxAttachment) 

bool js_register_spine_BoundingBoxAttachment(se::Object* obj) {
    auto* cls = se::Class::create("BoundingBoxAttachment", obj, __jsb_spine_VertexAttachment_proto, _SE(js_new_spine_BoundingBoxAttachment)); 
    
    cls->defineStaticProperty("__isJSB", se::Value(true), se::PropertyAttribute::READ_ONLY | se::PropertyAttribute::DONT_ENUM | se::PropertyAttribute::DONT_DELETE);
    
    cls->defineFunction("getColor", _SE(js_spine_BoundingBoxAttachment_getColor)); 
    
    
    
    
    cls->defineFinalizeFunction(_SE(js_delete_spine_BoundingBoxAttachment));
    
    
    cls->install();
    JSBClassType::registerClass<spine::BoundingBoxAttachment>(cls);
    
    __jsb_spine_BoundingBoxAttachment_proto = cls->getProto();
    __jsb_spine_BoundingBoxAttachment_class = cls;
    se::ScriptEngine::getInstance()->clearException();
    return true;
}


se::Class* __jsb_spine_Bone_class = nullptr;
se::Object* __jsb_spine_Bone_proto = nullptr;
SE_DECLARE_FINALIZE_FUNC(js_delete_spine_Bone) 

static bool js_spine_Bone_setYDown_static(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    bool arg1 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    
    ok &= sevalue_to_native(args[0], &arg1);
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine::Bone::setYDown(arg1);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Bone_setYDown_static) 

static bool js_spine_Bone_isYDown_static(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    bool result;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    result = (bool)spine::Bone::isYDown();
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Bone_isYDown_static) 

static bool js_spine_Bone_update(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Bone *arg1 = (spine::Bone *) NULL ;
    Physics arg2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Bone>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    (arg1)->update(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Bone_update) 

static bool js_spine_Bone_updateWorldTransform(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Bone *arg1 = (spine::Bone *) NULL ;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Bone>(s);
    if (nullptr == arg1) return true;
    (arg1)->updateWorldTransform();
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Bone_updateWorldTransform) 

static bool js_spine_Bone_updateAppliedTransform(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Bone *arg1 = (spine::Bone *) NULL ;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Bone>(s);
    if (nullptr == arg1) return true;
    (arg1)->updateAppliedTransform();
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Bone_updateAppliedTransform) 

static bool js_spine_Bone_setToSetupPose(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Bone *arg1 = (spine::Bone *) NULL ;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Bone>(s);
    if (nullptr == arg1) return true;
    (arg1)->setToSetupPose();
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Bone_setToSetupPose) 

static bool js_spine_Bone_worldToParent(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Bone *arg1 = (spine::Bone *) NULL ;
    float arg2 ;
    float arg3 ;
    float *arg4 = 0 ;
    float *arg5 = 0 ;
    float temp4 ;
    float temp5 ;
    
    if(argc != 4) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 4);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Bone>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[1], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[2], &temp4, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg4 = &temp4;
    
    
    ok &= sevalue_to_native(args[3], &temp5, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg5 = &temp5;
    
    (arg1)->worldToParent(arg2,arg3,*arg4,*arg5);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Bone_worldToParent) 

static bool js_spine_Bone_parentToWorld(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Bone *arg1 = (spine::Bone *) NULL ;
    float arg2 ;
    float arg3 ;
    float *arg4 = 0 ;
    float *arg5 = 0 ;
    float temp4 ;
    float temp5 ;
    
    if(argc != 4) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 4);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Bone>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[1], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[2], &temp4, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg4 = &temp4;
    
    
    ok &= sevalue_to_native(args[3], &temp5, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg5 = &temp5;
    
    (arg1)->parentToWorld(arg2,arg3,*arg4,*arg5);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Bone_parentToWorld) 

static bool js_spine_Bone_worldToLocalRotation(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Bone *arg1 = (spine::Bone *) NULL ;
    float arg2 ;
    float result;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Bone>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (float)(arg1)->worldToLocalRotation(arg2);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Bone_worldToLocalRotation) 

static bool js_spine_Bone_localToWorldRotation(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Bone *arg1 = (spine::Bone *) NULL ;
    float arg2 ;
    float result;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Bone>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (float)(arg1)->localToWorldRotation(arg2);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Bone_localToWorldRotation) 

static bool js_spine_Bone_rotateWorld(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Bone *arg1 = (spine::Bone *) NULL ;
    float arg2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Bone>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->rotateWorld(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Bone_rotateWorld) 

static bool js_spine_Bone_getWorldToLocalRotationX(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Bone *arg1 = (spine::Bone *) NULL ;
    float result;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Bone>(s);
    if (nullptr == arg1) return true;
    result = (float)(arg1)->getWorldToLocalRotationX();
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Bone_getWorldToLocalRotationX) 

static bool js_spine_Bone_getWorldToLocalRotationY(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Bone *arg1 = (spine::Bone *) NULL ;
    float result;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Bone>(s);
    if (nullptr == arg1) return true;
    result = (float)(arg1)->getWorldToLocalRotationY();
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Bone_getWorldToLocalRotationY) 

static bool js_spine_Bone_getWorldRotationX(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Bone *arg1 = (spine::Bone *) NULL ;
    float result;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Bone>(s);
    if (nullptr == arg1) return true;
    result = (float)(arg1)->getWorldRotationX();
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Bone_getWorldRotationX) 

static bool js_spine_Bone_getWorldRotationY(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Bone *arg1 = (spine::Bone *) NULL ;
    float result;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Bone>(s);
    if (nullptr == arg1) return true;
    result = (float)(arg1)->getWorldRotationY();
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Bone_getWorldRotationY) 

static bool js_spine_Bone_getWorldScaleX(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Bone *arg1 = (spine::Bone *) NULL ;
    float result;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Bone>(s);
    if (nullptr == arg1) return true;
    result = (float)(arg1)->getWorldScaleX();
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Bone_getWorldScaleX) 

static bool js_spine_Bone_getWorldScaleY(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Bone *arg1 = (spine::Bone *) NULL ;
    float result;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Bone>(s);
    if (nullptr == arg1) return true;
    result = (float)(arg1)->getWorldScaleY();
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Bone_getWorldScaleY) 

static bool js_spine_Bone_getInherit(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Bone *arg1 = (spine::Bone *) NULL ;
    Inherit result;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Bone>(s);
    if (nullptr == arg1) return true;
    result = (arg1)->getInherit();
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject() /*ctx*/);
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval());
    
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Bone_getInherit) 

static bool js_spine_Bone_setInherit(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Bone *arg1 = (spine::Bone *) NULL ;
    Inherit arg2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Bone>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    (arg1)->setInherit(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Bone_setInherit) 

static bool js_spine_Bone_data_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::Bone *arg1 = (spine::Bone *) NULL ;
    spine::BoneData *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::Bone>(s);
    if (nullptr == arg1) return true;
    result = (spine::BoneData *) &spine_Bone_data_get(arg1);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_Bone_data_get) 

static bool js_spine_Bone_skeleton_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::Bone *arg1 = (spine::Bone *) NULL ;
    spine::Skeleton *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::Bone>(s);
    if (nullptr == arg1) return true;
    result = (spine::Skeleton *) &spine_Bone_skeleton_get(arg1);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_Bone_skeleton_get) 

static bool js_spine_Bone_parent_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::Bone *arg1 = (spine::Bone *) NULL ;
    spine::Bone *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::Bone>(s);
    if (nullptr == arg1) return true;
    result = (spine::Bone *)spine_Bone_parent_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_Bone_parent_get) 

static bool js_spine_Bone_children_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::Bone *arg1 = (spine::Bone *) NULL ;
    spine::Vector< spine::Bone * > *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::Bone>(s);
    if (nullptr == arg1) return true;
    result = (spine::Vector< spine::Bone * > *) &spine_Bone_children_get(arg1);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_Bone_children_get) 

static bool js_spine_Bone_x_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Bone *arg1 = (spine::Bone *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::Bone>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_Bone_x_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_Bone_x_set) 

static bool js_spine_Bone_x_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::Bone *arg1 = (spine::Bone *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::Bone>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_Bone_x_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_Bone_x_get) 

static bool js_spine_Bone_y_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Bone *arg1 = (spine::Bone *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::Bone>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_Bone_y_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_Bone_y_set) 

static bool js_spine_Bone_y_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::Bone *arg1 = (spine::Bone *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::Bone>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_Bone_y_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_Bone_y_get) 

static bool js_spine_Bone_rotation_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Bone *arg1 = (spine::Bone *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::Bone>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_Bone_rotation_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_Bone_rotation_set) 

static bool js_spine_Bone_rotation_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::Bone *arg1 = (spine::Bone *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::Bone>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_Bone_rotation_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_Bone_rotation_get) 

static bool js_spine_Bone_scaleX_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Bone *arg1 = (spine::Bone *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::Bone>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_Bone_scaleX_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_Bone_scaleX_set) 

static bool js_spine_Bone_scaleX_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::Bone *arg1 = (spine::Bone *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::Bone>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_Bone_scaleX_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_Bone_scaleX_get) 

static bool js_spine_Bone_scaleY_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Bone *arg1 = (spine::Bone *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::Bone>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_Bone_scaleY_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_Bone_scaleY_set) 

static bool js_spine_Bone_scaleY_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::Bone *arg1 = (spine::Bone *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::Bone>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_Bone_scaleY_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_Bone_scaleY_get) 

static bool js_spine_Bone_shearX_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Bone *arg1 = (spine::Bone *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::Bone>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_Bone_shearX_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_Bone_shearX_set) 

static bool js_spine_Bone_shearX_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::Bone *arg1 = (spine::Bone *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::Bone>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_Bone_shearX_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_Bone_shearX_get) 

static bool js_spine_Bone_shearY_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Bone *arg1 = (spine::Bone *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::Bone>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_Bone_shearY_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_Bone_shearY_set) 

static bool js_spine_Bone_shearY_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::Bone *arg1 = (spine::Bone *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::Bone>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_Bone_shearY_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_Bone_shearY_get) 

static bool js_spine_Bone_ax_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Bone *arg1 = (spine::Bone *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::Bone>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_Bone_ax_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_Bone_ax_set) 

static bool js_spine_Bone_ax_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::Bone *arg1 = (spine::Bone *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::Bone>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_Bone_ax_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_Bone_ax_get) 

static bool js_spine_Bone_ay_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Bone *arg1 = (spine::Bone *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::Bone>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_Bone_ay_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_Bone_ay_set) 

static bool js_spine_Bone_ay_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::Bone *arg1 = (spine::Bone *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::Bone>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_Bone_ay_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_Bone_ay_get) 

static bool js_spine_Bone_arotation_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Bone *arg1 = (spine::Bone *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::Bone>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_Bone_arotation_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_Bone_arotation_set) 

static bool js_spine_Bone_arotation_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::Bone *arg1 = (spine::Bone *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::Bone>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_Bone_arotation_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_Bone_arotation_get) 

static bool js_spine_Bone_ascaleX_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Bone *arg1 = (spine::Bone *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::Bone>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_Bone_ascaleX_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_Bone_ascaleX_set) 

static bool js_spine_Bone_ascaleX_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::Bone *arg1 = (spine::Bone *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::Bone>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_Bone_ascaleX_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_Bone_ascaleX_get) 

static bool js_spine_Bone_ascaleY_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Bone *arg1 = (spine::Bone *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::Bone>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_Bone_ascaleY_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_Bone_ascaleY_set) 

static bool js_spine_Bone_ascaleY_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::Bone *arg1 = (spine::Bone *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::Bone>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_Bone_ascaleY_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_Bone_ascaleY_get) 

static bool js_spine_Bone_ashearX_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Bone *arg1 = (spine::Bone *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::Bone>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_Bone_ashearX_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_Bone_ashearX_set) 

static bool js_spine_Bone_ashearX_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::Bone *arg1 = (spine::Bone *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::Bone>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_Bone_ashearX_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_Bone_ashearX_get) 

static bool js_spine_Bone_ashearY_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Bone *arg1 = (spine::Bone *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::Bone>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_Bone_ashearY_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_Bone_ashearY_set) 

static bool js_spine_Bone_ashearY_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::Bone *arg1 = (spine::Bone *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::Bone>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_Bone_ashearY_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_Bone_ashearY_get) 

static bool js_spine_Bone_a_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Bone *arg1 = (spine::Bone *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::Bone>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_Bone_a_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_Bone_a_set) 

static bool js_spine_Bone_a_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::Bone *arg1 = (spine::Bone *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::Bone>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_Bone_a_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_Bone_a_get) 

static bool js_spine_Bone_b_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Bone *arg1 = (spine::Bone *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::Bone>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_Bone_b_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_Bone_b_set) 

static bool js_spine_Bone_b_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::Bone *arg1 = (spine::Bone *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::Bone>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_Bone_b_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_Bone_b_get) 

static bool js_spine_Bone_c_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Bone *arg1 = (spine::Bone *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::Bone>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_Bone_c_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_Bone_c_set) 

static bool js_spine_Bone_c_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::Bone *arg1 = (spine::Bone *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::Bone>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_Bone_c_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_Bone_c_get) 

static bool js_spine_Bone_d_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Bone *arg1 = (spine::Bone *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::Bone>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_Bone_d_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_Bone_d_set) 

static bool js_spine_Bone_d_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::Bone *arg1 = (spine::Bone *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::Bone>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_Bone_d_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_Bone_d_get) 

static bool js_spine_Bone_worldX_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Bone *arg1 = (spine::Bone *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::Bone>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_Bone_worldX_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_Bone_worldX_set) 

static bool js_spine_Bone_worldX_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::Bone *arg1 = (spine::Bone *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::Bone>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_Bone_worldX_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_Bone_worldX_get) 

static bool js_spine_Bone_worldY_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Bone *arg1 = (spine::Bone *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::Bone>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_Bone_worldY_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_Bone_worldY_set) 

static bool js_spine_Bone_worldY_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::Bone *arg1 = (spine::Bone *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::Bone>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_Bone_worldY_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_Bone_worldY_get) 

static bool js_spine_Bone_active_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Bone *arg1 = (spine::Bone *) NULL ;
    bool arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::Bone>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2);
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_Bone_active_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_Bone_active_set) 

static bool js_spine_Bone_active_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::Bone *arg1 = (spine::Bone *) NULL ;
    bool result;
    
    arg1 = SE_THIS_OBJECT<spine::Bone>(s);
    if (nullptr == arg1) return true;
    result = (bool)spine_Bone_active_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_Bone_active_get) 

static bool js_new_spine_Bone(se::State& s) // NOLINT(readability-identifier-naming)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    if (argc != 3) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 3);
        return false;
    }
    
    spine::BoneData *arg1 = (spine::BoneData *) NULL ;
    spine::Skeleton *arg2 = (spine::Skeleton *) NULL ;
    spine::Bone *arg3 = (spine::Bone *) NULL ;
    spine::Bone *result;
    
    ok &= sevalue_to_native(args[0], &arg1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[1], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[2], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (spine::Bone *)new_spine_Bone(arg1,arg2,arg3);
    
    
    auto *ptr = JSB_MAKE_PRIVATE_OBJECT_WITH_INSTANCE(result);
    s.thisObject()->setPrivateObject(ptr);
    return true;
}
SE_BIND_CTOR(js_new_spine_Bone, __jsb_spine_Bone_class, js_delete_spine_Bone)

static bool js_spine_Bone_updateWorldTransformWith(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Bone *arg1 = (spine::Bone *) NULL ;
    float arg2 ;
    float arg3 ;
    float arg4 ;
    float arg5 ;
    float arg6 ;
    float arg7 ;
    float arg8 ;
    
    if(argc != 7) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 7);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Bone>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[1], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[2], &arg4, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[3], &arg5, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[4], &arg6, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[5], &arg7, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[6], &arg8, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_Bone_updateWorldTransformWith(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Bone_updateWorldTransformWith) 

static bool js_delete_spine_Bone(se::State& s)
{
    return true;
}
SE_BIND_FINALIZE_FUNC(js_delete_spine_Bone) 

bool js_register_spine_Bone(se::Object* obj) {
    auto* cls = se::Class::create("Bone", obj, nullptr, _SE(js_new_spine_Bone)); 
    
    cls->defineStaticProperty("__isJSB", se::Value(true), se::PropertyAttribute::READ_ONLY | se::PropertyAttribute::DONT_ENUM | se::PropertyAttribute::DONT_DELETE);
    cls->defineProperty("data", _SE(js_spine_Bone_data_get), nullptr); 
    cls->defineProperty("skeleton", _SE(js_spine_Bone_skeleton_get), nullptr); 
    cls->defineProperty("parent", _SE(js_spine_Bone_parent_get), nullptr); 
    cls->defineProperty("children", _SE(js_spine_Bone_children_get), nullptr); 
    cls->defineProperty("x", _SE(js_spine_Bone_x_get), _SE(js_spine_Bone_x_set)); 
    cls->defineProperty("y", _SE(js_spine_Bone_y_get), _SE(js_spine_Bone_y_set)); 
    cls->defineProperty("rotation", _SE(js_spine_Bone_rotation_get), _SE(js_spine_Bone_rotation_set)); 
    cls->defineProperty("scaleX", _SE(js_spine_Bone_scaleX_get), _SE(js_spine_Bone_scaleX_set)); 
    cls->defineProperty("scaleY", _SE(js_spine_Bone_scaleY_get), _SE(js_spine_Bone_scaleY_set)); 
    cls->defineProperty("shearX", _SE(js_spine_Bone_shearX_get), _SE(js_spine_Bone_shearX_set)); 
    cls->defineProperty("shearY", _SE(js_spine_Bone_shearY_get), _SE(js_spine_Bone_shearY_set)); 
    cls->defineProperty("ax", _SE(js_spine_Bone_ax_get), _SE(js_spine_Bone_ax_set)); 
    cls->defineProperty("ay", _SE(js_spine_Bone_ay_get), _SE(js_spine_Bone_ay_set)); 
    cls->defineProperty("arotation", _SE(js_spine_Bone_arotation_get), _SE(js_spine_Bone_arotation_set)); 
    cls->defineProperty("ascaleX", _SE(js_spine_Bone_ascaleX_get), _SE(js_spine_Bone_ascaleX_set)); 
    cls->defineProperty("ascaleY", _SE(js_spine_Bone_ascaleY_get), _SE(js_spine_Bone_ascaleY_set)); 
    cls->defineProperty("ashearX", _SE(js_spine_Bone_ashearX_get), _SE(js_spine_Bone_ashearX_set)); 
    cls->defineProperty("ashearY", _SE(js_spine_Bone_ashearY_get), _SE(js_spine_Bone_ashearY_set)); 
    cls->defineProperty("a", _SE(js_spine_Bone_a_get), _SE(js_spine_Bone_a_set)); 
    cls->defineProperty("b", _SE(js_spine_Bone_b_get), _SE(js_spine_Bone_b_set)); 
    cls->defineProperty("c", _SE(js_spine_Bone_c_get), _SE(js_spine_Bone_c_set)); 
    cls->defineProperty("d", _SE(js_spine_Bone_d_get), _SE(js_spine_Bone_d_set)); 
    cls->defineProperty("worldX", _SE(js_spine_Bone_worldX_get), _SE(js_spine_Bone_worldX_set)); 
    cls->defineProperty("worldY", _SE(js_spine_Bone_worldY_get), _SE(js_spine_Bone_worldY_set)); 
    cls->defineProperty("active", _SE(js_spine_Bone_active_get), _SE(js_spine_Bone_active_set)); 
    
    cls->defineFunction("update", _SE(js_spine_Bone_update)); 
    cls->defineFunction("updateWorldTransform", _SE(js_spine_Bone_updateWorldTransform)); 
    cls->defineFunction("updateAppliedTransform", _SE(js_spine_Bone_updateAppliedTransform)); 
    cls->defineFunction("setToSetupPose", _SE(js_spine_Bone_setToSetupPose)); 
    cls->defineFunction("worldToParent", _SE(js_spine_Bone_worldToParent)); 
    cls->defineFunction("parentToWorld", _SE(js_spine_Bone_parentToWorld)); 
    cls->defineFunction("worldToLocalRotation", _SE(js_spine_Bone_worldToLocalRotation)); 
    cls->defineFunction("localToWorldRotation", _SE(js_spine_Bone_localToWorldRotation)); 
    cls->defineFunction("rotateWorld", _SE(js_spine_Bone_rotateWorld)); 
    cls->defineFunction("getWorldToLocalRotationX", _SE(js_spine_Bone_getWorldToLocalRotationX)); 
    cls->defineFunction("getWorldToLocalRotationY", _SE(js_spine_Bone_getWorldToLocalRotationY)); 
    cls->defineFunction("getWorldRotationX", _SE(js_spine_Bone_getWorldRotationX)); 
    cls->defineFunction("getWorldRotationY", _SE(js_spine_Bone_getWorldRotationY)); 
    cls->defineFunction("getWorldScaleX", _SE(js_spine_Bone_getWorldScaleX)); 
    cls->defineFunction("getWorldScaleY", _SE(js_spine_Bone_getWorldScaleY)); 
    cls->defineFunction("getInherit", _SE(js_spine_Bone_getInherit)); 
    cls->defineFunction("setInherit", _SE(js_spine_Bone_setInherit)); 
    cls->defineFunction("updateWorldTransformWith", _SE(js_spine_Bone_updateWorldTransformWith)); 
    
    
    cls->defineStaticFunction("setYDown", _SE(js_spine_Bone_setYDown_static)); 
    cls->defineStaticFunction("isYDown", _SE(js_spine_Bone_isYDown_static)); 
    
    
    cls->defineFinalizeFunction(_SE(js_delete_spine_Bone));
    
    
    cls->install();
    JSBClassType::registerClass<spine::Bone>(cls);
    
    __jsb_spine_Bone_proto = cls->getProto();
    __jsb_spine_Bone_class = cls;
    se::ScriptEngine::getInstance()->clearException();
    return true;
}


se::Class* __jsb_spine_BoneData_class = nullptr;
se::Object* __jsb_spine_BoneData_proto = nullptr;
SE_DECLARE_FINALIZE_FUNC(js_delete_spine_BoneData) 

static bool js_new_spine_BoneData__SWIG_0(se::State& s) // NOLINT(readability-identifier-naming)
{
    const auto& args = s.args();
    CC_UNUSED bool ok = true;
    int arg1 ;
    spine::String *arg2 = 0 ;
    spine::BoneData *arg3 = (spine::BoneData *) NULL ;
    spine::String temp2 ;
    spine::BoneData *result;
    
    ok &= sevalue_to_native(args[0], &arg1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[1], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    
    ok &= sevalue_to_native(args[2], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (spine::BoneData *)new spine::BoneData(arg1,(spine::String const &)*arg2,arg3);
    
    
    auto *ptr = JSB_MAKE_PRIVATE_OBJECT_WITH_INSTANCE(result);
    s.thisObject()->setPrivateObject(ptr);
    return true;
}


static bool js_new_spine_BoneData__SWIG_1(se::State& s) // NOLINT(readability-identifier-naming)
{
    const auto& args = s.args();
    CC_UNUSED bool ok = true;
    int arg1 ;
    spine::String *arg2 = 0 ;
    spine::String temp2 ;
    spine::BoneData *result;
    
    ok &= sevalue_to_native(args[0], &arg1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[1], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    result = (spine::BoneData *)new spine::BoneData(arg1,(spine::String const &)*arg2);
    
    
    auto *ptr = JSB_MAKE_PRIVATE_OBJECT_WITH_INSTANCE(result);
    s.thisObject()->setPrivateObject(ptr);
    return true;
}


static bool js_new_spine_BoneData(se::State& s) // NOLINT(readability-identifier-naming)
{
    size_t argc = s.args().size();
    bool ret = false;
    
    if(argc == 3) {
        ret = js_new_spine_BoneData__SWIG_0(s);
        if (ret) {
            return ret; 
        } /* reset exception and return */
    }
    
    if(argc == 2) {
        ret = js_new_spine_BoneData__SWIG_1(s);
        if (ret) {
            return ret; 
        } /* reset exception and return */
    }
    
    SE_REPORT_ERROR("Illegal arguments for construction of BoneData");
    return false;
}
SE_BIND_CTOR(js_new_spine_BoneData, __jsb_spine_BoneData_class, js_delete_spine_BoneData)

static bool js_spine_BoneData_getInherit(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::BoneData *arg1 = (spine::BoneData *) NULL ;
    Inherit result;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::BoneData>(s);
    if (nullptr == arg1) return true;
    result = (arg1)->getInherit();
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject() /*ctx*/);
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval());
    
    
    
    return true;
}
SE_BIND_FUNC(js_spine_BoneData_getInherit) 

static bool js_spine_BoneData_setInherit(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::BoneData *arg1 = (spine::BoneData *) NULL ;
    Inherit arg2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::BoneData>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    (arg1)->setInherit(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_BoneData_setInherit) 

static bool js_spine_BoneData_getColor(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::BoneData *arg1 = (spine::BoneData *) NULL ;
    Color *result = 0 ;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::BoneData>(s);
    if (nullptr == arg1) return true;
    result = (Color *) &(arg1)->getColor();
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_BoneData_getColor) 

static bool js_spine_BoneData_index_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::BoneData *arg1 = (spine::BoneData *) NULL ;
    int result;
    
    arg1 = SE_THIS_OBJECT<spine::BoneData>(s);
    if (nullptr == arg1) return true;
    result = (int)spine_BoneData_index_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_BoneData_index_get) 

static bool js_spine_BoneData_name_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::BoneData *arg1 = (spine::BoneData *) NULL ;
    spine::String *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::BoneData>(s);
    if (nullptr == arg1) return true;
    result = (spine::String *) &spine_BoneData_name_get(arg1);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_BoneData_name_get) 

static bool js_spine_BoneData_parent_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::BoneData *arg1 = (spine::BoneData *) NULL ;
    spine::BoneData *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::BoneData>(s);
    if (nullptr == arg1) return true;
    result = (spine::BoneData *)spine_BoneData_parent_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_BoneData_parent_get) 

static bool js_spine_BoneData_length_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::BoneData *arg1 = (spine::BoneData *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::BoneData>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_BoneData_length_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_BoneData_length_set) 

static bool js_spine_BoneData_length_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::BoneData *arg1 = (spine::BoneData *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::BoneData>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_BoneData_length_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_BoneData_length_get) 

static bool js_spine_BoneData_x_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::BoneData *arg1 = (spine::BoneData *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::BoneData>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_BoneData_x_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_BoneData_x_set) 

static bool js_spine_BoneData_x_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::BoneData *arg1 = (spine::BoneData *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::BoneData>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_BoneData_x_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_BoneData_x_get) 

static bool js_spine_BoneData_y_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::BoneData *arg1 = (spine::BoneData *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::BoneData>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_BoneData_y_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_BoneData_y_set) 

static bool js_spine_BoneData_y_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::BoneData *arg1 = (spine::BoneData *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::BoneData>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_BoneData_y_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_BoneData_y_get) 

static bool js_spine_BoneData_rotation_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::BoneData *arg1 = (spine::BoneData *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::BoneData>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_BoneData_rotation_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_BoneData_rotation_set) 

static bool js_spine_BoneData_rotation_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::BoneData *arg1 = (spine::BoneData *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::BoneData>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_BoneData_rotation_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_BoneData_rotation_get) 

static bool js_spine_BoneData_scaleX_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::BoneData *arg1 = (spine::BoneData *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::BoneData>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_BoneData_scaleX_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_BoneData_scaleX_set) 

static bool js_spine_BoneData_scaleX_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::BoneData *arg1 = (spine::BoneData *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::BoneData>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_BoneData_scaleX_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_BoneData_scaleX_get) 

static bool js_spine_BoneData_scaleY_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::BoneData *arg1 = (spine::BoneData *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::BoneData>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_BoneData_scaleY_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_BoneData_scaleY_set) 

static bool js_spine_BoneData_scaleY_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::BoneData *arg1 = (spine::BoneData *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::BoneData>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_BoneData_scaleY_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_BoneData_scaleY_get) 

static bool js_spine_BoneData_shearX_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::BoneData *arg1 = (spine::BoneData *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::BoneData>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_BoneData_shearX_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_BoneData_shearX_set) 

static bool js_spine_BoneData_shearX_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::BoneData *arg1 = (spine::BoneData *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::BoneData>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_BoneData_shearX_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_BoneData_shearX_get) 

static bool js_spine_BoneData_shearY_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::BoneData *arg1 = (spine::BoneData *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::BoneData>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_BoneData_shearY_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_BoneData_shearY_set) 

static bool js_spine_BoneData_shearY_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::BoneData *arg1 = (spine::BoneData *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::BoneData>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_BoneData_shearY_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_BoneData_shearY_get) 

static bool js_spine_BoneData_skinRequired_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::BoneData *arg1 = (spine::BoneData *) NULL ;
    bool arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::BoneData>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2);
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_BoneData_skinRequired_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_BoneData_skinRequired_set) 

static bool js_spine_BoneData_skinRequired_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::BoneData *arg1 = (spine::BoneData *) NULL ;
    bool result;
    
    arg1 = SE_THIS_OBJECT<spine::BoneData>(s);
    if (nullptr == arg1) return true;
    result = (bool)spine_BoneData_skinRequired_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_BoneData_skinRequired_get) 

static bool js_spine_BoneData_icon_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::BoneData *arg1 = (spine::BoneData *) NULL ;
    spine::String *arg2 = 0 ;
    spine::String temp2 ;
    
    arg1 = SE_THIS_OBJECT<spine::BoneData>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    spine_BoneData_icon_set(arg1,*arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_BoneData_icon_set) 

static bool js_spine_BoneData_icon_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::BoneData *arg1 = (spine::BoneData *) NULL ;
    spine::String *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::BoneData>(s);
    if (nullptr == arg1) return true;
    result = (spine::String *) &spine_BoneData_icon_get(arg1);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_BoneData_icon_get) 

static bool js_spine_BoneData_visible_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::BoneData *arg1 = (spine::BoneData *) NULL ;
    bool arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::BoneData>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2);
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_BoneData_visible_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_BoneData_visible_set) 

static bool js_spine_BoneData_visible_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::BoneData *arg1 = (spine::BoneData *) NULL ;
    bool result;
    
    arg1 = SE_THIS_OBJECT<spine::BoneData>(s);
    if (nullptr == arg1) return true;
    result = (bool)spine_BoneData_visible_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_BoneData_visible_get) 

static bool js_delete_spine_BoneData(se::State& s)
{
    return true;
}
SE_BIND_FINALIZE_FUNC(js_delete_spine_BoneData) 

bool js_register_spine_BoneData(se::Object* obj) {
    auto* cls = se::Class::create("BoneData", obj, nullptr, _SE(js_new_spine_BoneData)); 
    
    cls->defineStaticProperty("__isJSB", se::Value(true), se::PropertyAttribute::READ_ONLY | se::PropertyAttribute::DONT_ENUM | se::PropertyAttribute::DONT_DELETE);
    cls->defineProperty("index", _SE(js_spine_BoneData_index_get), nullptr); 
    cls->defineProperty("name", _SE(js_spine_BoneData_name_get), nullptr); 
    cls->defineProperty("parent", _SE(js_spine_BoneData_parent_get), nullptr); 
    cls->defineProperty("length", _SE(js_spine_BoneData_length_get), _SE(js_spine_BoneData_length_set)); 
    cls->defineProperty("x", _SE(js_spine_BoneData_x_get), _SE(js_spine_BoneData_x_set)); 
    cls->defineProperty("y", _SE(js_spine_BoneData_y_get), _SE(js_spine_BoneData_y_set)); 
    cls->defineProperty("rotation", _SE(js_spine_BoneData_rotation_get), _SE(js_spine_BoneData_rotation_set)); 
    cls->defineProperty("scaleX", _SE(js_spine_BoneData_scaleX_get), _SE(js_spine_BoneData_scaleX_set)); 
    cls->defineProperty("scaleY", _SE(js_spine_BoneData_scaleY_get), _SE(js_spine_BoneData_scaleY_set)); 
    cls->defineProperty("shearX", _SE(js_spine_BoneData_shearX_get), _SE(js_spine_BoneData_shearX_set)); 
    cls->defineProperty("shearY", _SE(js_spine_BoneData_shearY_get), _SE(js_spine_BoneData_shearY_set)); 
    cls->defineProperty("skinRequired", _SE(js_spine_BoneData_skinRequired_get), _SE(js_spine_BoneData_skinRequired_set)); 
    cls->defineProperty("icon", _SE(js_spine_BoneData_icon_get), _SE(js_spine_BoneData_icon_set)); 
    cls->defineProperty("visible", _SE(js_spine_BoneData_visible_get), _SE(js_spine_BoneData_visible_set)); 
    
    cls->defineFunction("getInherit", _SE(js_spine_BoneData_getInherit)); 
    cls->defineFunction("setInherit", _SE(js_spine_BoneData_setInherit)); 
    cls->defineFunction("getColor", _SE(js_spine_BoneData_getColor)); 
    
    
    
    
    cls->defineFinalizeFunction(_SE(js_delete_spine_BoneData));
    
    
    cls->install();
    JSBClassType::registerClass<spine::BoneData>(cls);
    
    __jsb_spine_BoneData_proto = cls->getProto();
    __jsb_spine_BoneData_class = cls;
    se::ScriptEngine::getInstance()->clearException();
    return true;
}


se::Class* __jsb_spine_ClippingAttachment_class = nullptr;
se::Object* __jsb_spine_ClippingAttachment_proto = nullptr;
SE_DECLARE_FINALIZE_FUNC(js_delete_spine_ClippingAttachment) 

static bool js_new_spine_ClippingAttachment(se::State& s) // NOLINT(readability-identifier-naming)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    if (argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    
    spine::String *arg1 = 0 ;
    spine::String temp1 ;
    spine::ClippingAttachment *result;
    
    ok &= sevalue_to_native(args[0], &temp1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg1 = &temp1;
    
    result = (spine::ClippingAttachment *)new spine::ClippingAttachment((spine::String const &)*arg1);
    
    
    auto *ptr = JSB_MAKE_PRIVATE_OBJECT_WITH_INSTANCE(result);
    s.thisObject()->setPrivateObject(ptr);
    return true;
}
SE_BIND_CTOR(js_new_spine_ClippingAttachment, __jsb_spine_ClippingAttachment_class, js_delete_spine_ClippingAttachment)

static bool js_spine_ClippingAttachment_getColor(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::ClippingAttachment *arg1 = (spine::ClippingAttachment *) NULL ;
    Color *result = 0 ;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::ClippingAttachment>(s);
    if (nullptr == arg1) return true;
    result = (Color *) &(arg1)->getColor();
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_ClippingAttachment_getColor) 

static bool js_spine_ClippingAttachment_endSlot_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::ClippingAttachment *arg1 = (spine::ClippingAttachment *) NULL ;
    spine::SlotData *arg2 = (spine::SlotData *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::ClippingAttachment>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_ClippingAttachment_endSlot_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_ClippingAttachment_endSlot_set) 

static bool js_spine_ClippingAttachment_endSlot_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::ClippingAttachment *arg1 = (spine::ClippingAttachment *) NULL ;
    spine::SlotData *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::ClippingAttachment>(s);
    if (nullptr == arg1) return true;
    result = (spine::SlotData *)spine_ClippingAttachment_endSlot_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_ClippingAttachment_endSlot_get) 

static bool js_delete_spine_ClippingAttachment(se::State& s)
{
    return true;
}
SE_BIND_FINALIZE_FUNC(js_delete_spine_ClippingAttachment) 

bool js_register_spine_ClippingAttachment(se::Object* obj) {
    auto* cls = se::Class::create("ClippingAttachment", obj, __jsb_spine_VertexAttachment_proto, _SE(js_new_spine_ClippingAttachment)); 
    
    cls->defineStaticProperty("__isJSB", se::Value(true), se::PropertyAttribute::READ_ONLY | se::PropertyAttribute::DONT_ENUM | se::PropertyAttribute::DONT_DELETE);
    cls->defineProperty("endSlot", _SE(js_spine_ClippingAttachment_endSlot_get), _SE(js_spine_ClippingAttachment_endSlot_set)); 
    
    cls->defineFunction("getColor", _SE(js_spine_ClippingAttachment_getColor)); 
    
    
    
    
    cls->defineFinalizeFunction(_SE(js_delete_spine_ClippingAttachment));
    
    
    cls->install();
    JSBClassType::registerClass<spine::ClippingAttachment>(cls);
    
    __jsb_spine_ClippingAttachment_proto = cls->getProto();
    __jsb_spine_ClippingAttachment_class = cls;
    se::ScriptEngine::getInstance()->clearException();
    return true;
}


se::Class* __jsb_spine_Color_class = nullptr;
se::Object* __jsb_spine_Color_proto = nullptr;
SE_DECLARE_FINALIZE_FUNC(js_delete_spine_Color) 

static bool js_new_spine_Color__SWIG_0(se::State& s) // NOLINT(readability-identifier-naming)
{
    const auto& args = s.args();
    CC_UNUSED bool ok = true;
    spine::Color *result;
    result = (spine::Color *)new spine::Color();
    
    
    auto *ptr = JSB_MAKE_PRIVATE_OBJECT_WITH_INSTANCE(result);
    s.thisObject()->setPrivateObject(ptr);
    return true;
}


static bool js_new_spine_Color__SWIG_1(se::State& s) // NOLINT(readability-identifier-naming)
{
    const auto& args = s.args();
    CC_UNUSED bool ok = true;
    float arg1 ;
    float arg2 ;
    float arg3 ;
    float arg4 ;
    spine::Color *result;
    
    ok &= sevalue_to_native(args[0], &arg1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[1], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[2], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[3], &arg4, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (spine::Color *)new spine::Color(arg1,arg2,arg3,arg4);
    
    
    auto *ptr = JSB_MAKE_PRIVATE_OBJECT_WITH_INSTANCE(result);
    s.thisObject()->setPrivateObject(ptr);
    return true;
}


static bool js_new_spine_Color(se::State& s) // NOLINT(readability-identifier-naming)
{
    size_t argc = s.args().size();
    bool ret = false;
    
    if(argc == 0) {
        ret = js_new_spine_Color__SWIG_0(s);
        if (ret) {
            return ret; 
        } /* reset exception and return */
    }
    
    if(argc == 4) {
        ret = js_new_spine_Color__SWIG_1(s);
        if (ret) {
            return ret; 
        } /* reset exception and return */
    }
    
    SE_REPORT_ERROR("Illegal arguments for construction of Color");
    return false;
}
SE_BIND_CTOR(js_new_spine_Color, __jsb_spine_Color_class, js_delete_spine_Color)

static bool js_spine_Color_set__SWIG_0(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    spine::Color *arg1 = (spine::Color *) NULL ;
    float arg2 ;
    float arg3 ;
    float arg4 ;
    float arg5 ;
    spine::Color *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::Color>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[1], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[2], &arg4, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[3], &arg5, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (spine::Color *) &(arg1)->set(arg2,arg3,arg4,arg5);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}

static bool js_spine_Color_set__SWIG_1(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    spine::Color *arg1 = (spine::Color *) NULL ;
    float arg2 ;
    float arg3 ;
    float arg4 ;
    spine::Color *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::Color>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[1], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[2], &arg4, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (spine::Color *) &(arg1)->set(arg2,arg3,arg4);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}

static bool js_spine_Color_set__SWIG_2(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    spine::Color *arg1 = (spine::Color *) NULL ;
    spine::Color *arg2 = 0 ;
    spine::Color temp2 ;
    spine::Color *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::Color>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    result = (spine::Color *) &(arg1)->set((spine::Color const &)*arg2);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}

static bool js_spine_Color_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    
    if (argc == 4) {
        ok = js_spine_Color_set__SWIG_0(s);
        if (ok) {
            return true; 
        }
    } 
    if (argc == 3) {
        ok = js_spine_Color_set__SWIG_1(s);
        if (ok) {
            return true; 
        }
    } 
    if (argc == 1) {
        ok = js_spine_Color_set__SWIG_2(s);
        if (ok) {
            return true; 
        }
    } 
    SE_REPORT_ERROR("wrong number of arguments: %d", (int)argc);
    return false;
}
SE_BIND_FUNC(js_spine_Color_set) 

static bool js_spine_Color_add__SWIG_0(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    spine::Color *arg1 = (spine::Color *) NULL ;
    float arg2 ;
    float arg3 ;
    float arg4 ;
    float arg5 ;
    spine::Color *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::Color>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[1], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[2], &arg4, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[3], &arg5, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (spine::Color *) &(arg1)->add(arg2,arg3,arg4,arg5);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}

static bool js_spine_Color_add__SWIG_1(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    spine::Color *arg1 = (spine::Color *) NULL ;
    float arg2 ;
    float arg3 ;
    float arg4 ;
    spine::Color *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::Color>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[1], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[2], &arg4, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (spine::Color *) &(arg1)->add(arg2,arg3,arg4);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}

static bool js_spine_Color_add__SWIG_2(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    spine::Color *arg1 = (spine::Color *) NULL ;
    spine::Color *arg2 = 0 ;
    spine::Color temp2 ;
    spine::Color *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::Color>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    result = (spine::Color *) &(arg1)->add((spine::Color const &)*arg2);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}

static bool js_spine_Color_add(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    
    if (argc == 4) {
        ok = js_spine_Color_add__SWIG_0(s);
        if (ok) {
            return true; 
        }
    } 
    if (argc == 3) {
        ok = js_spine_Color_add__SWIG_1(s);
        if (ok) {
            return true; 
        }
    } 
    if (argc == 1) {
        ok = js_spine_Color_add__SWIG_2(s);
        if (ok) {
            return true; 
        }
    } 
    SE_REPORT_ERROR("wrong number of arguments: %d", (int)argc);
    return false;
}
SE_BIND_FUNC(js_spine_Color_add) 

static bool js_spine_Color_clamp(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Color *arg1 = (spine::Color *) NULL ;
    spine::Color *result = 0 ;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Color>(s);
    if (nullptr == arg1) return true;
    result = (spine::Color *) &(arg1)->clamp();
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Color_clamp) 

static bool js_spine_Color_r_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Color *arg1 = (spine::Color *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::Color>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg1->r, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_Color_r_set) 

static bool js_spine_Color_r_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::Color *arg1 = (spine::Color *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::Color>(s);
    if (nullptr == arg1) return true;
    
    ok &= nativevalue_to_se(arg1->r, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_Color_r_get) 

static bool js_spine_Color_g_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Color *arg1 = (spine::Color *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::Color>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg1->g, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_Color_g_set) 

static bool js_spine_Color_g_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::Color *arg1 = (spine::Color *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::Color>(s);
    if (nullptr == arg1) return true;
    
    ok &= nativevalue_to_se(arg1->g, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_Color_g_get) 

static bool js_spine_Color_b_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Color *arg1 = (spine::Color *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::Color>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg1->b, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_Color_b_set) 

static bool js_spine_Color_b_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::Color *arg1 = (spine::Color *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::Color>(s);
    if (nullptr == arg1) return true;
    
    ok &= nativevalue_to_se(arg1->b, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_Color_b_get) 

static bool js_spine_Color_a_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Color *arg1 = (spine::Color *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::Color>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg1->a, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_Color_a_set) 

static bool js_spine_Color_a_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::Color *arg1 = (spine::Color *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::Color>(s);
    if (nullptr == arg1) return true;
    
    ok &= nativevalue_to_se(arg1->a, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_Color_a_get) 

static bool js_spine_Color_setFromColor(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Color *arg1 = (spine::Color *) NULL ;
    spine::Color *arg2 = 0 ;
    spine::Color temp2 ;
    spine::Color *result = 0 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Color>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    result = (spine::Color *) &spine_Color_setFromColor(arg1,(spine::Color const &)*arg2);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Color_setFromColor) 

static bool js_delete_spine_Color(se::State& s)
{
    return true;
}
SE_BIND_FINALIZE_FUNC(js_delete_spine_Color) 

bool js_register_spine_Color(se::Object* obj) {
    auto* cls = se::Class::create("Color", obj, nullptr, _SE(js_new_spine_Color)); 
    
    cls->defineStaticProperty("__isJSB", se::Value(true), se::PropertyAttribute::READ_ONLY | se::PropertyAttribute::DONT_ENUM | se::PropertyAttribute::DONT_DELETE);
    cls->defineProperty("r", _SE(js_spine_Color_r_get), _SE(js_spine_Color_r_set)); 
    cls->defineProperty("g", _SE(js_spine_Color_g_get), _SE(js_spine_Color_g_set)); 
    cls->defineProperty("b", _SE(js_spine_Color_b_get), _SE(js_spine_Color_b_set)); 
    cls->defineProperty("a", _SE(js_spine_Color_a_get), _SE(js_spine_Color_a_set)); 
    
    cls->defineFunction("set", _SE(js_spine_Color_set)); 
    cls->defineFunction("add", _SE(js_spine_Color_add)); 
    cls->defineFunction("clamp", _SE(js_spine_Color_clamp)); 
    cls->defineFunction("setFromColor", _SE(js_spine_Color_setFromColor)); 
    
    
    
    
    cls->defineFinalizeFunction(_SE(js_delete_spine_Color));
    
    
    cls->install();
    JSBClassType::registerClass<spine::Color>(cls);
    
    __jsb_spine_Color_proto = cls->getProto();
    __jsb_spine_Color_class = cls;
    se::ScriptEngine::getInstance()->clearException();
    return true;
}


se::Class* __jsb_spine_CurveTimeline_class = nullptr;
se::Object* __jsb_spine_CurveTimeline_proto = nullptr;
SE_DECLARE_FINALIZE_FUNC(js_delete_spine_CurveTimeline) 

static bool js_delete_spine_CurveTimeline(se::State& s)
{
    return true;
}
SE_BIND_FINALIZE_FUNC(js_delete_spine_CurveTimeline) 

static bool js_spine_CurveTimeline_setLinear(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::CurveTimeline *arg1 = (spine::CurveTimeline *) NULL ;
    size_t arg2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::CurveTimeline>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    
    (arg1)->setLinear(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_CurveTimeline_setLinear) 

static bool js_spine_CurveTimeline_setStepped(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::CurveTimeline *arg1 = (spine::CurveTimeline *) NULL ;
    size_t arg2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::CurveTimeline>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    
    (arg1)->setStepped(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_CurveTimeline_setStepped) 

static bool js_spine_CurveTimeline_setBezier(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::CurveTimeline *arg1 = (spine::CurveTimeline *) NULL ;
    size_t arg2 ;
    size_t arg3 ;
    float arg4 ;
    float arg5 ;
    float arg6 ;
    float arg7 ;
    float arg8 ;
    float arg9 ;
    float arg10 ;
    float arg11 ;
    float arg12 ;
    
    if(argc != 11) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 11);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::CurveTimeline>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    
    
    ok &= sevalue_to_native(args[1], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    
    
    ok &= sevalue_to_native(args[2], &arg4, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[3], &arg5, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[4], &arg6, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[5], &arg7, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[6], &arg8, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[7], &arg9, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[8], &arg10, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[9], &arg11, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[10], &arg12, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setBezier(arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11,arg12);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_CurveTimeline_setBezier) 

static bool js_spine_CurveTimeline_getBezierValue(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::CurveTimeline *arg1 = (spine::CurveTimeline *) NULL ;
    float arg2 ;
    size_t arg3 ;
    size_t arg4 ;
    size_t arg5 ;
    float result;
    
    if(argc != 4) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 4);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::CurveTimeline>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[1], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    
    
    ok &= sevalue_to_native(args[2], &arg4, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    
    
    ok &= sevalue_to_native(args[3], &arg5, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    
    result = (float)(arg1)->getBezierValue(arg2,arg3,arg4,arg5);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_CurveTimeline_getBezierValue) 

static bool js_spine_CurveTimeline_getCurves(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::CurveTimeline *arg1 = (spine::CurveTimeline *) NULL ;
    spine::Vector< float > *result = 0 ;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::CurveTimeline>(s);
    if (nullptr == arg1) return true;
    result = (spine::Vector< float > *) &(arg1)->getCurves();
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_CurveTimeline_getCurves) 

bool js_register_spine_CurveTimeline(se::Object* obj) {
    auto* cls = se::Class::create("CurveTimeline", obj, __jsb_spine_Timeline_proto, nullptr); 
    
    cls->defineStaticProperty("__isJSB", se::Value(true), se::PropertyAttribute::READ_ONLY | se::PropertyAttribute::DONT_ENUM | se::PropertyAttribute::DONT_DELETE);
    
    cls->defineFunction("setLinear", _SE(js_spine_CurveTimeline_setLinear)); 
    cls->defineFunction("setStepped", _SE(js_spine_CurveTimeline_setStepped)); 
    cls->defineFunction("setBezier", _SE(js_spine_CurveTimeline_setBezier)); 
    cls->defineFunction("getBezierValue", _SE(js_spine_CurveTimeline_getBezierValue)); 
    cls->defineFunction("getCurves", _SE(js_spine_CurveTimeline_getCurves)); 
    
    
    
    
    cls->defineFinalizeFunction(_SE(js_delete_spine_CurveTimeline));
    
    
    cls->install();
    JSBClassType::registerClass<spine::CurveTimeline>(cls);
    
    __jsb_spine_CurveTimeline_proto = cls->getProto();
    __jsb_spine_CurveTimeline_class = cls;
    se::ScriptEngine::getInstance()->clearException();
    return true;
}


se::Class* __jsb_spine_CurveTimeline1_class = nullptr;
se::Object* __jsb_spine_CurveTimeline1_proto = nullptr;
SE_DECLARE_FINALIZE_FUNC(js_delete_spine_CurveTimeline1) 

static bool js_delete_spine_CurveTimeline1(se::State& s)
{
    return true;
}
SE_BIND_FINALIZE_FUNC(js_delete_spine_CurveTimeline1) 

static bool js_spine_CurveTimeline1_setFrame(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::CurveTimeline1 *arg1 = (spine::CurveTimeline1 *) NULL ;
    size_t arg2 ;
    float arg3 ;
    float arg4 ;
    
    if(argc != 3) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 3);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::CurveTimeline1>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    
    
    ok &= sevalue_to_native(args[1], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[2], &arg4, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setFrame(arg2,arg3,arg4);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_CurveTimeline1_setFrame) 

static bool js_spine_CurveTimeline1_getCurveValue(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::CurveTimeline1 *arg1 = (spine::CurveTimeline1 *) NULL ;
    float arg2 ;
    float result;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::CurveTimeline1>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (float)(arg1)->getCurveValue(arg2);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_CurveTimeline1_getCurveValue) 

static bool js_spine_CurveTimeline1_getRelativeValue(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::CurveTimeline1 *arg1 = (spine::CurveTimeline1 *) NULL ;
    float arg2 ;
    float arg3 ;
    spine::MixBlend arg4 ;
    float arg5 ;
    float arg6 ;
    float result;
    
    if(argc != 5) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 5);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::CurveTimeline1>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[1], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[2], &arg4, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    
    ok &= sevalue_to_native(args[3], &arg5, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[4], &arg6, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (float)(arg1)->getRelativeValue(arg2,arg3,arg4,arg5,arg6);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_CurveTimeline1_getRelativeValue) 

static bool js_spine_CurveTimeline1_getAbsoluteValue__SWIG_0(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    spine::CurveTimeline1 *arg1 = (spine::CurveTimeline1 *) NULL ;
    float arg2 ;
    float arg3 ;
    spine::MixBlend arg4 ;
    float arg5 ;
    float arg6 ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::CurveTimeline1>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[1], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[2], &arg4, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    
    ok &= sevalue_to_native(args[3], &arg5, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[4], &arg6, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (float)(arg1)->getAbsoluteValue(arg2,arg3,arg4,arg5,arg6);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}

static bool js_spine_CurveTimeline1_getAbsoluteValue__SWIG_1(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    spine::CurveTimeline1 *arg1 = (spine::CurveTimeline1 *) NULL ;
    float arg2 ;
    float arg3 ;
    spine::MixBlend arg4 ;
    float arg5 ;
    float arg6 ;
    float arg7 ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::CurveTimeline1>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[1], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[2], &arg4, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    
    ok &= sevalue_to_native(args[3], &arg5, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[4], &arg6, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[5], &arg7, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (float)(arg1)->getAbsoluteValue(arg2,arg3,arg4,arg5,arg6,arg7);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}

static bool js_spine_CurveTimeline1_getAbsoluteValue(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    
    if (argc == 5) {
        ok = js_spine_CurveTimeline1_getAbsoluteValue__SWIG_0(s);
        if (ok) {
            return true; 
        }
    } 
    if (argc == 6) {
        ok = js_spine_CurveTimeline1_getAbsoluteValue__SWIG_1(s);
        if (ok) {
            return true; 
        }
    } 
    SE_REPORT_ERROR("wrong number of arguments: %d", (int)argc);
    return false;
}
SE_BIND_FUNC(js_spine_CurveTimeline1_getAbsoluteValue) 

static bool js_spine_CurveTimeline1_getScaleValue(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::CurveTimeline1 *arg1 = (spine::CurveTimeline1 *) NULL ;
    float arg2 ;
    float arg3 ;
    spine::MixBlend arg4 ;
    spine::MixDirection arg5 ;
    float arg6 ;
    float arg7 ;
    float result;
    
    if(argc != 6) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 6);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::CurveTimeline1>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[1], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[2], &arg4, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    
    ok &= sevalue_to_native(args[3], &arg5, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    
    ok &= sevalue_to_native(args[4], &arg6, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[5], &arg7, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (float)(arg1)->getScaleValue(arg2,arg3,arg4,arg5,arg6,arg7);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_CurveTimeline1_getScaleValue) 

bool js_register_spine_CurveTimeline1(se::Object* obj) {
    auto* cls = se::Class::create("CurveTimeline1", obj, __jsb_spine_CurveTimeline_proto, nullptr); 
    
    cls->defineStaticProperty("__isJSB", se::Value(true), se::PropertyAttribute::READ_ONLY | se::PropertyAttribute::DONT_ENUM | se::PropertyAttribute::DONT_DELETE);
    
    cls->defineFunction("setFrame", _SE(js_spine_CurveTimeline1_setFrame)); 
    cls->defineFunction("getCurveValue", _SE(js_spine_CurveTimeline1_getCurveValue)); 
    cls->defineFunction("getRelativeValue", _SE(js_spine_CurveTimeline1_getRelativeValue)); 
    cls->defineFunction("getAbsoluteValue", _SE(js_spine_CurveTimeline1_getAbsoluteValue)); 
    cls->defineFunction("getScaleValue", _SE(js_spine_CurveTimeline1_getScaleValue)); 
    
    
    
    
    cls->defineFinalizeFunction(_SE(js_delete_spine_CurveTimeline1));
    
    
    cls->install();
    JSBClassType::registerClass<spine::CurveTimeline1>(cls);
    
    __jsb_spine_CurveTimeline1_proto = cls->getProto();
    __jsb_spine_CurveTimeline1_class = cls;
    se::ScriptEngine::getInstance()->clearException();
    return true;
}


se::Class* __jsb_spine_CurveTimeline2_class = nullptr;
se::Object* __jsb_spine_CurveTimeline2_proto = nullptr;
SE_DECLARE_FINALIZE_FUNC(js_delete_spine_CurveTimeline2) 

static bool js_delete_spine_CurveTimeline2(se::State& s)
{
    return true;
}
SE_BIND_FINALIZE_FUNC(js_delete_spine_CurveTimeline2) 

static bool js_spine_CurveTimeline2_setFrame(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::CurveTimeline2 *arg1 = (spine::CurveTimeline2 *) NULL ;
    size_t arg2 ;
    float arg3 ;
    float arg4 ;
    float arg5 ;
    
    if(argc != 4) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 4);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::CurveTimeline2>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    
    
    ok &= sevalue_to_native(args[1], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[2], &arg4, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[3], &arg5, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setFrame(arg2,arg3,arg4,arg5);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_CurveTimeline2_setFrame) 

bool js_register_spine_CurveTimeline2(se::Object* obj) {
    auto* cls = se::Class::create("CurveTimeline2", obj, __jsb_spine_CurveTimeline_proto, nullptr); 
    
    cls->defineStaticProperty("__isJSB", se::Value(true), se::PropertyAttribute::READ_ONLY | se::PropertyAttribute::DONT_ENUM | se::PropertyAttribute::DONT_DELETE);
    
    cls->defineFunction("setFrame", _SE(js_spine_CurveTimeline2_setFrame)); 
    
    
    
    
    cls->defineFinalizeFunction(_SE(js_delete_spine_CurveTimeline2));
    
    
    cls->install();
    JSBClassType::registerClass<spine::CurveTimeline2>(cls);
    
    __jsb_spine_CurveTimeline2_proto = cls->getProto();
    __jsb_spine_CurveTimeline2_class = cls;
    se::ScriptEngine::getInstance()->clearException();
    return true;
}


se::Class* __jsb_spine_RGBATimeline_class = nullptr;
se::Object* __jsb_spine_RGBATimeline_proto = nullptr;
SE_DECLARE_FINALIZE_FUNC(js_delete_spine_RGBATimeline) 

static bool js_new_spine_RGBATimeline(se::State& s) // NOLINT(readability-identifier-naming)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    if (argc != 3) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 3);
        return false;
    }
    
    size_t arg1 ;
    size_t arg2 ;
    int arg3 ;
    spine::RGBATimeline *result;
    
    ok &= sevalue_to_native(args[0], &arg1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    
    
    ok &= sevalue_to_native(args[1], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    
    
    ok &= sevalue_to_native(args[2], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (spine::RGBATimeline *)new spine::RGBATimeline(arg1,arg2,arg3);
    
    
    auto *ptr = JSB_MAKE_PRIVATE_OBJECT_WITH_INSTANCE(result);
    s.thisObject()->setPrivateObject(ptr);
    return true;
}
SE_BIND_CTOR(js_new_spine_RGBATimeline, __jsb_spine_RGBATimeline_class, js_delete_spine_RGBATimeline)

static bool js_delete_spine_RGBATimeline(se::State& s)
{
    return true;
}
SE_BIND_FINALIZE_FUNC(js_delete_spine_RGBATimeline) 

static bool js_spine_RGBATimeline_setFrame(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::RGBATimeline *arg1 = (spine::RGBATimeline *) NULL ;
    int arg2 ;
    float arg3 ;
    float arg4 ;
    float arg5 ;
    float arg6 ;
    float arg7 ;
    
    if(argc != 6) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 6);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::RGBATimeline>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[1], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[2], &arg4, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[3], &arg5, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[4], &arg6, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[5], &arg7, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setFrame(arg2,arg3,arg4,arg5,arg6,arg7);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_RGBATimeline_setFrame) 

static bool js_spine_RGBATimeline_slotIndex_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::RGBATimeline *arg1 = (spine::RGBATimeline *) NULL ;
    int arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::RGBATimeline>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_RGBATimeline_slotIndex_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_RGBATimeline_slotIndex_set) 

static bool js_spine_RGBATimeline_slotIndex_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::RGBATimeline *arg1 = (spine::RGBATimeline *) NULL ;
    int result;
    
    arg1 = SE_THIS_OBJECT<spine::RGBATimeline>(s);
    if (nullptr == arg1) return true;
    result = (int)spine_RGBATimeline_slotIndex_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_RGBATimeline_slotIndex_get) 

bool js_register_spine_RGBATimeline(se::Object* obj) {
    auto* cls = se::Class::create("RGBATimeline", obj, __jsb_spine_CurveTimeline_proto, _SE(js_new_spine_RGBATimeline)); 
    
    cls->defineStaticProperty("__isJSB", se::Value(true), se::PropertyAttribute::READ_ONLY | se::PropertyAttribute::DONT_ENUM | se::PropertyAttribute::DONT_DELETE);
    cls->defineProperty("slotIndex", _SE(js_spine_RGBATimeline_slotIndex_get), _SE(js_spine_RGBATimeline_slotIndex_set)); 
    
    cls->defineFunction("setFrame", _SE(js_spine_RGBATimeline_setFrame)); 
    
    
    
    
    cls->defineFinalizeFunction(_SE(js_delete_spine_RGBATimeline));
    
    
    cls->install();
    JSBClassType::registerClass<spine::RGBATimeline>(cls);
    
    __jsb_spine_RGBATimeline_proto = cls->getProto();
    __jsb_spine_RGBATimeline_class = cls;
    se::ScriptEngine::getInstance()->clearException();
    return true;
}


se::Class* __jsb_spine_RGBTimeline_class = nullptr;
se::Object* __jsb_spine_RGBTimeline_proto = nullptr;
SE_DECLARE_FINALIZE_FUNC(js_delete_spine_RGBTimeline) 

static bool js_new_spine_RGBTimeline(se::State& s) // NOLINT(readability-identifier-naming)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    if (argc != 3) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 3);
        return false;
    }
    
    size_t arg1 ;
    size_t arg2 ;
    int arg3 ;
    spine::RGBTimeline *result;
    
    ok &= sevalue_to_native(args[0], &arg1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    
    
    ok &= sevalue_to_native(args[1], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    
    
    ok &= sevalue_to_native(args[2], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (spine::RGBTimeline *)new spine::RGBTimeline(arg1,arg2,arg3);
    
    
    auto *ptr = JSB_MAKE_PRIVATE_OBJECT_WITH_INSTANCE(result);
    s.thisObject()->setPrivateObject(ptr);
    return true;
}
SE_BIND_CTOR(js_new_spine_RGBTimeline, __jsb_spine_RGBTimeline_class, js_delete_spine_RGBTimeline)

static bool js_delete_spine_RGBTimeline(se::State& s)
{
    return true;
}
SE_BIND_FINALIZE_FUNC(js_delete_spine_RGBTimeline) 

static bool js_spine_RGBTimeline_setFrame(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::RGBTimeline *arg1 = (spine::RGBTimeline *) NULL ;
    int arg2 ;
    float arg3 ;
    float arg4 ;
    float arg5 ;
    float arg6 ;
    
    if(argc != 5) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 5);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::RGBTimeline>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[1], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[2], &arg4, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[3], &arg5, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[4], &arg6, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setFrame(arg2,arg3,arg4,arg5,arg6);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_RGBTimeline_setFrame) 

static bool js_spine_RGBTimeline_slotIndex_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::RGBTimeline *arg1 = (spine::RGBTimeline *) NULL ;
    int arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::RGBTimeline>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_RGBTimeline_slotIndex_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_RGBTimeline_slotIndex_set) 

static bool js_spine_RGBTimeline_slotIndex_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::RGBTimeline *arg1 = (spine::RGBTimeline *) NULL ;
    int result;
    
    arg1 = SE_THIS_OBJECT<spine::RGBTimeline>(s);
    if (nullptr == arg1) return true;
    result = (int)spine_RGBTimeline_slotIndex_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_RGBTimeline_slotIndex_get) 

bool js_register_spine_RGBTimeline(se::Object* obj) {
    auto* cls = se::Class::create("RGBTimeline", obj, __jsb_spine_CurveTimeline_proto, _SE(js_new_spine_RGBTimeline)); 
    
    cls->defineStaticProperty("__isJSB", se::Value(true), se::PropertyAttribute::READ_ONLY | se::PropertyAttribute::DONT_ENUM | se::PropertyAttribute::DONT_DELETE);
    cls->defineProperty("slotIndex", _SE(js_spine_RGBTimeline_slotIndex_get), _SE(js_spine_RGBTimeline_slotIndex_set)); 
    
    cls->defineFunction("setFrame", _SE(js_spine_RGBTimeline_setFrame)); 
    
    
    
    
    cls->defineFinalizeFunction(_SE(js_delete_spine_RGBTimeline));
    
    
    cls->install();
    JSBClassType::registerClass<spine::RGBTimeline>(cls);
    
    __jsb_spine_RGBTimeline_proto = cls->getProto();
    __jsb_spine_RGBTimeline_class = cls;
    se::ScriptEngine::getInstance()->clearException();
    return true;
}


se::Class* __jsb_spine_AlphaTimeline_class = nullptr;
se::Object* __jsb_spine_AlphaTimeline_proto = nullptr;
SE_DECLARE_FINALIZE_FUNC(js_delete_spine_AlphaTimeline) 

static bool js_new_spine_AlphaTimeline(se::State& s) // NOLINT(readability-identifier-naming)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    if (argc != 3) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 3);
        return false;
    }
    
    size_t arg1 ;
    size_t arg2 ;
    int arg3 ;
    spine::AlphaTimeline *result;
    
    ok &= sevalue_to_native(args[0], &arg1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    
    
    ok &= sevalue_to_native(args[1], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    
    
    ok &= sevalue_to_native(args[2], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (spine::AlphaTimeline *)new spine::AlphaTimeline(arg1,arg2,arg3);
    
    
    auto *ptr = JSB_MAKE_PRIVATE_OBJECT_WITH_INSTANCE(result);
    s.thisObject()->setPrivateObject(ptr);
    return true;
}
SE_BIND_CTOR(js_new_spine_AlphaTimeline, __jsb_spine_AlphaTimeline_class, js_delete_spine_AlphaTimeline)

static bool js_delete_spine_AlphaTimeline(se::State& s)
{
    return true;
}
SE_BIND_FINALIZE_FUNC(js_delete_spine_AlphaTimeline) 

static bool js_spine_AlphaTimeline_slotIndex_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::AlphaTimeline *arg1 = (spine::AlphaTimeline *) NULL ;
    int arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::AlphaTimeline>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_AlphaTimeline_slotIndex_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_AlphaTimeline_slotIndex_set) 

static bool js_spine_AlphaTimeline_slotIndex_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::AlphaTimeline *arg1 = (spine::AlphaTimeline *) NULL ;
    int result;
    
    arg1 = SE_THIS_OBJECT<spine::AlphaTimeline>(s);
    if (nullptr == arg1) return true;
    result = (int)spine_AlphaTimeline_slotIndex_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_AlphaTimeline_slotIndex_get) 

bool js_register_spine_AlphaTimeline(se::Object* obj) {
    auto* cls = se::Class::create("AlphaTimeline", obj, __jsb_spine_CurveTimeline1_proto, _SE(js_new_spine_AlphaTimeline)); 
    
    cls->defineStaticProperty("__isJSB", se::Value(true), se::PropertyAttribute::READ_ONLY | se::PropertyAttribute::DONT_ENUM | se::PropertyAttribute::DONT_DELETE);
    cls->defineProperty("slotIndex", _SE(js_spine_AlphaTimeline_slotIndex_get), _SE(js_spine_AlphaTimeline_slotIndex_set)); 
    
    
    
    
    
    cls->defineFinalizeFunction(_SE(js_delete_spine_AlphaTimeline));
    
    
    cls->install();
    JSBClassType::registerClass<spine::AlphaTimeline>(cls);
    
    __jsb_spine_AlphaTimeline_proto = cls->getProto();
    __jsb_spine_AlphaTimeline_class = cls;
    se::ScriptEngine::getInstance()->clearException();
    return true;
}


se::Class* __jsb_spine_RGBA2Timeline_class = nullptr;
se::Object* __jsb_spine_RGBA2Timeline_proto = nullptr;
SE_DECLARE_FINALIZE_FUNC(js_delete_spine_RGBA2Timeline) 

static bool js_new_spine_RGBA2Timeline(se::State& s) // NOLINT(readability-identifier-naming)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    if (argc != 3) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 3);
        return false;
    }
    
    size_t arg1 ;
    size_t arg2 ;
    int arg3 ;
    spine::RGBA2Timeline *result;
    
    ok &= sevalue_to_native(args[0], &arg1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    
    
    ok &= sevalue_to_native(args[1], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    
    
    ok &= sevalue_to_native(args[2], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (spine::RGBA2Timeline *)new spine::RGBA2Timeline(arg1,arg2,arg3);
    
    
    auto *ptr = JSB_MAKE_PRIVATE_OBJECT_WITH_INSTANCE(result);
    s.thisObject()->setPrivateObject(ptr);
    return true;
}
SE_BIND_CTOR(js_new_spine_RGBA2Timeline, __jsb_spine_RGBA2Timeline_class, js_delete_spine_RGBA2Timeline)

static bool js_delete_spine_RGBA2Timeline(se::State& s)
{
    return true;
}
SE_BIND_FINALIZE_FUNC(js_delete_spine_RGBA2Timeline) 

static bool js_spine_RGBA2Timeline_setFrame(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::RGBA2Timeline *arg1 = (spine::RGBA2Timeline *) NULL ;
    int arg2 ;
    float arg3 ;
    float arg4 ;
    float arg5 ;
    float arg6 ;
    float arg7 ;
    float arg8 ;
    float arg9 ;
    float arg10 ;
    
    if(argc != 9) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 9);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::RGBA2Timeline>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[1], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[2], &arg4, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[3], &arg5, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[4], &arg6, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[5], &arg7, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[6], &arg8, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[7], &arg9, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[8], &arg10, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setFrame(arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_RGBA2Timeline_setFrame) 

static bool js_spine_RGBA2Timeline_slotIndex_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::RGBA2Timeline *arg1 = (spine::RGBA2Timeline *) NULL ;
    int arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::RGBA2Timeline>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_RGBA2Timeline_slotIndex_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_RGBA2Timeline_slotIndex_set) 

static bool js_spine_RGBA2Timeline_slotIndex_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::RGBA2Timeline *arg1 = (spine::RGBA2Timeline *) NULL ;
    int result;
    
    arg1 = SE_THIS_OBJECT<spine::RGBA2Timeline>(s);
    if (nullptr == arg1) return true;
    result = (int)spine_RGBA2Timeline_slotIndex_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_RGBA2Timeline_slotIndex_get) 

bool js_register_spine_RGBA2Timeline(se::Object* obj) {
    auto* cls = se::Class::create("RGBA2Timeline", obj, __jsb_spine_CurveTimeline_proto, _SE(js_new_spine_RGBA2Timeline)); 
    
    cls->defineStaticProperty("__isJSB", se::Value(true), se::PropertyAttribute::READ_ONLY | se::PropertyAttribute::DONT_ENUM | se::PropertyAttribute::DONT_DELETE);
    cls->defineProperty("slotIndex", _SE(js_spine_RGBA2Timeline_slotIndex_get), _SE(js_spine_RGBA2Timeline_slotIndex_set)); 
    
    cls->defineFunction("setFrame", _SE(js_spine_RGBA2Timeline_setFrame)); 
    
    
    
    
    cls->defineFinalizeFunction(_SE(js_delete_spine_RGBA2Timeline));
    
    
    cls->install();
    JSBClassType::registerClass<spine::RGBA2Timeline>(cls);
    
    __jsb_spine_RGBA2Timeline_proto = cls->getProto();
    __jsb_spine_RGBA2Timeline_class = cls;
    se::ScriptEngine::getInstance()->clearException();
    return true;
}


se::Class* __jsb_spine_RGB2Timeline_class = nullptr;
se::Object* __jsb_spine_RGB2Timeline_proto = nullptr;
SE_DECLARE_FINALIZE_FUNC(js_delete_spine_RGB2Timeline) 

static bool js_new_spine_RGB2Timeline(se::State& s) // NOLINT(readability-identifier-naming)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    if (argc != 3) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 3);
        return false;
    }
    
    size_t arg1 ;
    size_t arg2 ;
    int arg3 ;
    spine::RGB2Timeline *result;
    
    ok &= sevalue_to_native(args[0], &arg1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    
    
    ok &= sevalue_to_native(args[1], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    
    
    ok &= sevalue_to_native(args[2], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (spine::RGB2Timeline *)new spine::RGB2Timeline(arg1,arg2,arg3);
    
    
    auto *ptr = JSB_MAKE_PRIVATE_OBJECT_WITH_INSTANCE(result);
    s.thisObject()->setPrivateObject(ptr);
    return true;
}
SE_BIND_CTOR(js_new_spine_RGB2Timeline, __jsb_spine_RGB2Timeline_class, js_delete_spine_RGB2Timeline)

static bool js_delete_spine_RGB2Timeline(se::State& s)
{
    return true;
}
SE_BIND_FINALIZE_FUNC(js_delete_spine_RGB2Timeline) 

static bool js_spine_RGB2Timeline_setFrame(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::RGB2Timeline *arg1 = (spine::RGB2Timeline *) NULL ;
    int arg2 ;
    float arg3 ;
    float arg4 ;
    float arg5 ;
    float arg6 ;
    float arg7 ;
    float arg8 ;
    float arg9 ;
    
    if(argc != 8) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 8);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::RGB2Timeline>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[1], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[2], &arg4, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[3], &arg5, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[4], &arg6, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[5], &arg7, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[6], &arg8, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[7], &arg9, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setFrame(arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_RGB2Timeline_setFrame) 

static bool js_spine_RGB2Timeline_slotIndex_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::RGB2Timeline *arg1 = (spine::RGB2Timeline *) NULL ;
    int arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::RGB2Timeline>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_RGB2Timeline_slotIndex_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_RGB2Timeline_slotIndex_set) 

static bool js_spine_RGB2Timeline_slotIndex_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::RGB2Timeline *arg1 = (spine::RGB2Timeline *) NULL ;
    int result;
    
    arg1 = SE_THIS_OBJECT<spine::RGB2Timeline>(s);
    if (nullptr == arg1) return true;
    result = (int)spine_RGB2Timeline_slotIndex_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_RGB2Timeline_slotIndex_get) 

bool js_register_spine_RGB2Timeline(se::Object* obj) {
    auto* cls = se::Class::create("RGB2Timeline", obj, __jsb_spine_CurveTimeline_proto, _SE(js_new_spine_RGB2Timeline)); 
    
    cls->defineStaticProperty("__isJSB", se::Value(true), se::PropertyAttribute::READ_ONLY | se::PropertyAttribute::DONT_ENUM | se::PropertyAttribute::DONT_DELETE);
    cls->defineProperty("slotIndex", _SE(js_spine_RGB2Timeline_slotIndex_get), _SE(js_spine_RGB2Timeline_slotIndex_set)); 
    
    cls->defineFunction("setFrame", _SE(js_spine_RGB2Timeline_setFrame)); 
    
    
    
    
    cls->defineFinalizeFunction(_SE(js_delete_spine_RGB2Timeline));
    
    
    cls->install();
    JSBClassType::registerClass<spine::RGB2Timeline>(cls);
    
    __jsb_spine_RGB2Timeline_proto = cls->getProto();
    __jsb_spine_RGB2Timeline_class = cls;
    se::ScriptEngine::getInstance()->clearException();
    return true;
}


se::Class* __jsb_spine_DeformTimeline_class = nullptr;
se::Object* __jsb_spine_DeformTimeline_proto = nullptr;
SE_DECLARE_FINALIZE_FUNC(js_delete_spine_DeformTimeline) 

static bool js_new_spine_DeformTimeline(se::State& s) // NOLINT(readability-identifier-naming)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    if (argc != 4) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 4);
        return false;
    }
    
    size_t arg1 ;
    size_t arg2 ;
    int arg3 ;
    spine::VertexAttachment *arg4 = (spine::VertexAttachment *) NULL ;
    spine::DeformTimeline *result;
    
    ok &= sevalue_to_native(args[0], &arg1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    
    
    ok &= sevalue_to_native(args[1], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    
    
    ok &= sevalue_to_native(args[2], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[3], &arg4, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (spine::DeformTimeline *)new spine::DeformTimeline(arg1,arg2,arg3,arg4);
    
    
    auto *ptr = JSB_MAKE_PRIVATE_OBJECT_WITH_INSTANCE(result);
    s.thisObject()->setPrivateObject(ptr);
    return true;
}
SE_BIND_CTOR(js_new_spine_DeformTimeline, __jsb_spine_DeformTimeline_class, js_delete_spine_DeformTimeline)

static bool js_spine_DeformTimeline_setAttachment(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::DeformTimeline *arg1 = (spine::DeformTimeline *) NULL ;
    spine::VertexAttachment *arg2 = (spine::VertexAttachment *) NULL ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::DeformTimeline>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setAttachment(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_DeformTimeline_setAttachment) 

static bool js_spine_DeformTimeline_getCurvePercent(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::DeformTimeline *arg1 = (spine::DeformTimeline *) NULL ;
    float arg2 ;
    int arg3 ;
    float result;
    
    if(argc != 2) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 2);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::DeformTimeline>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[1], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (float)(arg1)->getCurvePercent(arg2,arg3);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_DeformTimeline_getCurvePercent) 

static bool js_spine_DeformTimeline_slotIndex_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::DeformTimeline *arg1 = (spine::DeformTimeline *) NULL ;
    int arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::DeformTimeline>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_DeformTimeline_slotIndex_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_DeformTimeline_slotIndex_set) 

static bool js_spine_DeformTimeline_slotIndex_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::DeformTimeline *arg1 = (spine::DeformTimeline *) NULL ;
    int result;
    
    arg1 = SE_THIS_OBJECT<spine::DeformTimeline>(s);
    if (nullptr == arg1) return true;
    result = (int)spine_DeformTimeline_slotIndex_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_DeformTimeline_slotIndex_get) 

static bool js_spine_DeformTimeline_frames_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::DeformTimeline *arg1 = (spine::DeformTimeline *) NULL ;
    spine::Vector< float > *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::DeformTimeline>(s);
    if (nullptr == arg1) return true;
    result = (spine::Vector< float > *) &spine_DeformTimeline_frames_get(arg1);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_DeformTimeline_frames_get) 

static bool js_spine_DeformTimeline_frameVertices_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::DeformTimeline *arg1 = (spine::DeformTimeline *) NULL ;
    spine::Vector< float > *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::DeformTimeline>(s);
    if (nullptr == arg1) return true;
    result = (spine::Vector< float > *) &spine_DeformTimeline_frameVertices_get(arg1);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_DeformTimeline_frameVertices_get) 

static bool js_spine_DeformTimeline_attachment_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::DeformTimeline *arg1 = (spine::DeformTimeline *) NULL ;
    spine::VertexAttachment *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::DeformTimeline>(s);
    if (nullptr == arg1) return true;
    result = (spine::VertexAttachment *)spine_DeformTimeline_attachment_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_DeformTimeline_attachment_get) 

static bool js_spine_DeformTimeline_setFrame(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::DeformTimeline *arg1 = (spine::DeformTimeline *) NULL ;
    int arg2 ;
    float arg3 ;
    ccstd::vector< float > *arg4 = 0 ;
    ccstd::vector< float > temp4 ;
    
    if(argc != 3) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 3);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::DeformTimeline>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[1], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[2], &temp4, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg4 = &temp4;
    
    spine_DeformTimeline_setFrame(arg1,arg2,arg3,(ccstd::vector< float > const &)*arg4);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_DeformTimeline_setFrame) 

static bool js_delete_spine_DeformTimeline(se::State& s)
{
    return true;
}
SE_BIND_FINALIZE_FUNC(js_delete_spine_DeformTimeline) 

bool js_register_spine_DeformTimeline(se::Object* obj) {
    auto* cls = se::Class::create("DeformTimeline", obj, __jsb_spine_CurveTimeline_proto, _SE(js_new_spine_DeformTimeline)); 
    
    cls->defineStaticProperty("__isJSB", se::Value(true), se::PropertyAttribute::READ_ONLY | se::PropertyAttribute::DONT_ENUM | se::PropertyAttribute::DONT_DELETE);
    cls->defineProperty("slotIndex", _SE(js_spine_DeformTimeline_slotIndex_get), _SE(js_spine_DeformTimeline_slotIndex_set)); 
    cls->defineProperty("frames", _SE(js_spine_DeformTimeline_frames_get), nullptr); 
    cls->defineProperty("frameVertices", _SE(js_spine_DeformTimeline_frameVertices_get), nullptr); 
    cls->defineProperty("attachment", _SE(js_spine_DeformTimeline_attachment_get), nullptr); 
    
    cls->defineFunction("setAttachment", _SE(js_spine_DeformTimeline_setAttachment)); 
    cls->defineFunction("getCurvePercent", _SE(js_spine_DeformTimeline_getCurvePercent)); 
    cls->defineFunction("setFrame", _SE(js_spine_DeformTimeline_setFrame)); 
    
    
    
    
    cls->defineFinalizeFunction(_SE(js_delete_spine_DeformTimeline));
    
    
    cls->install();
    JSBClassType::registerClass<spine::DeformTimeline>(cls);
    
    __jsb_spine_DeformTimeline_proto = cls->getProto();
    __jsb_spine_DeformTimeline_class = cls;
    se::ScriptEngine::getInstance()->clearException();
    return true;
}


se::Class* __jsb_spine_DrawOrderTimeline_class = nullptr;
se::Object* __jsb_spine_DrawOrderTimeline_proto = nullptr;
SE_DECLARE_FINALIZE_FUNC(js_delete_spine_DrawOrderTimeline) 

static bool js_new_spine_DrawOrderTimeline(se::State& s) // NOLINT(readability-identifier-naming)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    if (argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    
    size_t arg1 ;
    spine::DrawOrderTimeline *result;
    
    ok &= sevalue_to_native(args[0], &arg1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    
    result = (spine::DrawOrderTimeline *)new spine::DrawOrderTimeline(arg1);
    
    
    auto *ptr = JSB_MAKE_PRIVATE_OBJECT_WITH_INSTANCE(result);
    s.thisObject()->setPrivateObject(ptr);
    return true;
}
SE_BIND_CTOR(js_new_spine_DrawOrderTimeline, __jsb_spine_DrawOrderTimeline_class, js_delete_spine_DrawOrderTimeline)

static bool js_spine_DrawOrderTimeline_frames_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::DrawOrderTimeline *arg1 = (spine::DrawOrderTimeline *) NULL ;
    spine::Vector< float > *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::DrawOrderTimeline>(s);
    if (nullptr == arg1) return true;
    result = (spine::Vector< float > *) &spine_DrawOrderTimeline_frames_get(arg1);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_DrawOrderTimeline_frames_get) 

static bool js_spine_DrawOrderTimeline_drawOrders_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::DrawOrderTimeline *arg1 = (spine::DrawOrderTimeline *) NULL ;
    spine::Vector< spine::Vector< int > > *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::DrawOrderTimeline>(s);
    if (nullptr == arg1) return true;
    result = (spine::Vector< spine::Vector< int > > *) &spine_DrawOrderTimeline_drawOrders_get(arg1);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_DrawOrderTimeline_drawOrders_get) 

static bool js_spine_DrawOrderTimeline_setFrame(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::DrawOrderTimeline *arg1 = (spine::DrawOrderTimeline *) NULL ;
    size_t arg2 ;
    float arg3 ;
    ccstd::vector< int > *arg4 = 0 ;
    ccstd::vector< int > temp4 ;
    
    if(argc != 3) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 3);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::DrawOrderTimeline>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    
    
    ok &= sevalue_to_native(args[1], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[2], &temp4, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg4 = &temp4;
    
    spine_DrawOrderTimeline_setFrame(arg1,SWIG_STD_MOVE(arg2),arg3,(ccstd::vector< int > const &)*arg4);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_DrawOrderTimeline_setFrame) 

static bool js_delete_spine_DrawOrderTimeline(se::State& s)
{
    return true;
}
SE_BIND_FINALIZE_FUNC(js_delete_spine_DrawOrderTimeline) 

bool js_register_spine_DrawOrderTimeline(se::Object* obj) {
    auto* cls = se::Class::create("DrawOrderTimeline", obj, __jsb_spine_Timeline_proto, _SE(js_new_spine_DrawOrderTimeline)); 
    
    cls->defineStaticProperty("__isJSB", se::Value(true), se::PropertyAttribute::READ_ONLY | se::PropertyAttribute::DONT_ENUM | se::PropertyAttribute::DONT_DELETE);
    cls->defineProperty("frames", _SE(js_spine_DrawOrderTimeline_frames_get), nullptr); 
    cls->defineProperty("drawOrders", _SE(js_spine_DrawOrderTimeline_drawOrders_get), nullptr); 
    
    cls->defineFunction("setFrame", _SE(js_spine_DrawOrderTimeline_setFrame)); 
    
    
    
    
    cls->defineFinalizeFunction(_SE(js_delete_spine_DrawOrderTimeline));
    
    
    cls->install();
    JSBClassType::registerClass<spine::DrawOrderTimeline>(cls);
    
    __jsb_spine_DrawOrderTimeline_proto = cls->getProto();
    __jsb_spine_DrawOrderTimeline_class = cls;
    se::ScriptEngine::getInstance()->clearException();
    return true;
}


se::Class* __jsb_spine_Event_class = nullptr;
se::Object* __jsb_spine_Event_proto = nullptr;
SE_DECLARE_FINALIZE_FUNC(js_delete_spine_Event) 

static bool js_spine_Event_data_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::Event *arg1 = (spine::Event *) NULL ;
    spine::EventData *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::Event>(s);
    if (nullptr == arg1) return true;
    result = (spine::EventData *) &spine_Event_data_get(arg1);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_Event_data_get) 

static bool js_spine_Event_intValue_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Event *arg1 = (spine::Event *) NULL ;
    int arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::Event>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_Event_intValue_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_Event_intValue_set) 

static bool js_spine_Event_intValue_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::Event *arg1 = (spine::Event *) NULL ;
    int result;
    
    arg1 = SE_THIS_OBJECT<spine::Event>(s);
    if (nullptr == arg1) return true;
    result = (int)spine_Event_intValue_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_Event_intValue_get) 

static bool js_spine_Event_floatValue_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Event *arg1 = (spine::Event *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::Event>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_Event_floatValue_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_Event_floatValue_set) 

static bool js_spine_Event_floatValue_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::Event *arg1 = (spine::Event *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::Event>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_Event_floatValue_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_Event_floatValue_get) 

static bool js_spine_Event_stringValue_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Event *arg1 = (spine::Event *) NULL ;
    spine::String *arg2 = 0 ;
    spine::String temp2 ;
    
    arg1 = SE_THIS_OBJECT<spine::Event>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    spine_Event_stringValue_set(arg1,*arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_Event_stringValue_set) 

static bool js_spine_Event_stringValue_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::Event *arg1 = (spine::Event *) NULL ;
    spine::String *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::Event>(s);
    if (nullptr == arg1) return true;
    result = (spine::String *) &spine_Event_stringValue_get(arg1);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_Event_stringValue_get) 

static bool js_spine_Event_time_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::Event *arg1 = (spine::Event *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::Event>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_Event_time_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_Event_time_get) 

static bool js_spine_Event_volume_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Event *arg1 = (spine::Event *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::Event>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_Event_volume_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_Event_volume_set) 

static bool js_spine_Event_volume_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::Event *arg1 = (spine::Event *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::Event>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_Event_volume_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_Event_volume_get) 

static bool js_spine_Event_balance_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Event *arg1 = (spine::Event *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::Event>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_Event_balance_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_Event_balance_set) 

static bool js_spine_Event_balance_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::Event *arg1 = (spine::Event *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::Event>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_Event_balance_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_Event_balance_get) 

static bool js_new_spine_Event(se::State& s) // NOLINT(readability-identifier-naming)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    if (argc != 2) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 2);
        return false;
    }
    
    float arg1 ;
    spine::EventData *arg2 = (spine::EventData *) NULL ;
    spine::Event *result;
    
    ok &= sevalue_to_native(args[0], &arg1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[1], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (spine::Event *)new_spine_Event(arg1,arg2);
    
    
    auto *ptr = JSB_MAKE_PRIVATE_OBJECT_WITH_INSTANCE(result);
    s.thisObject()->setPrivateObject(ptr);
    return true;
}
SE_BIND_CTOR(js_new_spine_Event, __jsb_spine_Event_class, js_delete_spine_Event)

static bool js_delete_spine_Event(se::State& s)
{
    return true;
}
SE_BIND_FINALIZE_FUNC(js_delete_spine_Event) 

bool js_register_spine_Event(se::Object* obj) {
    auto* cls = se::Class::create("Event", obj, nullptr, _SE(js_new_spine_Event)); 
    
    cls->defineStaticProperty("__isJSB", se::Value(true), se::PropertyAttribute::READ_ONLY | se::PropertyAttribute::DONT_ENUM | se::PropertyAttribute::DONT_DELETE);
    cls->defineProperty("data", _SE(js_spine_Event_data_get), nullptr); 
    cls->defineProperty("intValue", _SE(js_spine_Event_intValue_get), _SE(js_spine_Event_intValue_set)); 
    cls->defineProperty("floatValue", _SE(js_spine_Event_floatValue_get), _SE(js_spine_Event_floatValue_set)); 
    cls->defineProperty("stringValue", _SE(js_spine_Event_stringValue_get), _SE(js_spine_Event_stringValue_set)); 
    cls->defineProperty("time", _SE(js_spine_Event_time_get), nullptr); 
    cls->defineProperty("volume", _SE(js_spine_Event_volume_get), _SE(js_spine_Event_volume_set)); 
    cls->defineProperty("balance", _SE(js_spine_Event_balance_get), _SE(js_spine_Event_balance_set)); 
    
    
    
    
    
    cls->defineFinalizeFunction(_SE(js_delete_spine_Event));
    
    
    cls->install();
    JSBClassType::registerClass<spine::Event>(cls);
    
    __jsb_spine_Event_proto = cls->getProto();
    __jsb_spine_Event_class = cls;
    se::ScriptEngine::getInstance()->clearException();
    return true;
}


se::Class* __jsb_spine_EventData_class = nullptr;
se::Object* __jsb_spine_EventData_proto = nullptr;
SE_DECLARE_FINALIZE_FUNC(js_delete_spine_EventData) 

static bool js_new_spine_EventData(se::State& s) // NOLINT(readability-identifier-naming)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    if (argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    
    spine::String *arg1 = 0 ;
    spine::String temp1 ;
    spine::EventData *result;
    
    ok &= sevalue_to_native(args[0], &temp1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg1 = &temp1;
    
    result = (spine::EventData *)new spine::EventData((spine::String const &)*arg1);
    
    
    auto *ptr = JSB_MAKE_PRIVATE_OBJECT_WITH_INSTANCE(result);
    s.thisObject()->setPrivateObject(ptr);
    return true;
}
SE_BIND_CTOR(js_new_spine_EventData, __jsb_spine_EventData_class, js_delete_spine_EventData)

static bool js_spine_EventData_name_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::EventData *arg1 = (spine::EventData *) NULL ;
    spine::String *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::EventData>(s);
    if (nullptr == arg1) return true;
    result = (spine::String *) &spine_EventData_name_get(arg1);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_EventData_name_get) 

static bool js_spine_EventData_intValue_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::EventData *arg1 = (spine::EventData *) NULL ;
    int arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::EventData>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_EventData_intValue_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_EventData_intValue_set) 

static bool js_spine_EventData_intValue_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::EventData *arg1 = (spine::EventData *) NULL ;
    int result;
    
    arg1 = SE_THIS_OBJECT<spine::EventData>(s);
    if (nullptr == arg1) return true;
    result = (int)spine_EventData_intValue_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_EventData_intValue_get) 

static bool js_spine_EventData_floatValue_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::EventData *arg1 = (spine::EventData *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::EventData>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_EventData_floatValue_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_EventData_floatValue_set) 

static bool js_spine_EventData_floatValue_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::EventData *arg1 = (spine::EventData *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::EventData>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_EventData_floatValue_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_EventData_floatValue_get) 

static bool js_spine_EventData_stringValue_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::EventData *arg1 = (spine::EventData *) NULL ;
    spine::String *arg2 = 0 ;
    spine::String temp2 ;
    
    arg1 = SE_THIS_OBJECT<spine::EventData>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    spine_EventData_stringValue_set(arg1,*arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_EventData_stringValue_set) 

static bool js_spine_EventData_stringValue_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::EventData *arg1 = (spine::EventData *) NULL ;
    spine::String *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::EventData>(s);
    if (nullptr == arg1) return true;
    result = (spine::String *) &spine_EventData_stringValue_get(arg1);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_EventData_stringValue_get) 

static bool js_spine_EventData_volume_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::EventData *arg1 = (spine::EventData *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::EventData>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_EventData_volume_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_EventData_volume_set) 

static bool js_spine_EventData_volume_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::EventData *arg1 = (spine::EventData *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::EventData>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_EventData_volume_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_EventData_volume_get) 

static bool js_spine_EventData_balance_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::EventData *arg1 = (spine::EventData *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::EventData>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_EventData_balance_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_EventData_balance_set) 

static bool js_spine_EventData_balance_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::EventData *arg1 = (spine::EventData *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::EventData>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_EventData_balance_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_EventData_balance_get) 

static bool js_spine_EventData_audioPath_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::EventData *arg1 = (spine::EventData *) NULL ;
    spine::String *arg2 = 0 ;
    spine::String temp2 ;
    
    arg1 = SE_THIS_OBJECT<spine::EventData>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    spine_EventData_audioPath_set(arg1,*arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_EventData_audioPath_set) 

static bool js_spine_EventData_audioPath_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::EventData *arg1 = (spine::EventData *) NULL ;
    spine::String *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::EventData>(s);
    if (nullptr == arg1) return true;
    result = (spine::String *) &spine_EventData_audioPath_get(arg1);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_EventData_audioPath_get) 

static bool js_delete_spine_EventData(se::State& s)
{
    return true;
}
SE_BIND_FINALIZE_FUNC(js_delete_spine_EventData) 

bool js_register_spine_EventData(se::Object* obj) {
    auto* cls = se::Class::create("EventData", obj, nullptr, _SE(js_new_spine_EventData)); 
    
    cls->defineStaticProperty("__isJSB", se::Value(true), se::PropertyAttribute::READ_ONLY | se::PropertyAttribute::DONT_ENUM | se::PropertyAttribute::DONT_DELETE);
    cls->defineProperty("name", _SE(js_spine_EventData_name_get), nullptr); 
    cls->defineProperty("intValue", _SE(js_spine_EventData_intValue_get), _SE(js_spine_EventData_intValue_set)); 
    cls->defineProperty("floatValue", _SE(js_spine_EventData_floatValue_get), _SE(js_spine_EventData_floatValue_set)); 
    cls->defineProperty("stringValue", _SE(js_spine_EventData_stringValue_get), _SE(js_spine_EventData_stringValue_set)); 
    cls->defineProperty("volume", _SE(js_spine_EventData_volume_get), _SE(js_spine_EventData_volume_set)); 
    cls->defineProperty("balance", _SE(js_spine_EventData_balance_get), _SE(js_spine_EventData_balance_set)); 
    cls->defineProperty("audioPath", _SE(js_spine_EventData_audioPath_get), _SE(js_spine_EventData_audioPath_set)); 
    
    
    
    
    
    cls->defineFinalizeFunction(_SE(js_delete_spine_EventData));
    
    
    cls->install();
    JSBClassType::registerClass<spine::EventData>(cls);
    
    __jsb_spine_EventData_proto = cls->getProto();
    __jsb_spine_EventData_class = cls;
    se::ScriptEngine::getInstance()->clearException();
    return true;
}


se::Class* __jsb_spine_EventTimeline_class = nullptr;
se::Object* __jsb_spine_EventTimeline_proto = nullptr;
SE_DECLARE_FINALIZE_FUNC(js_delete_spine_EventTimeline) 

static bool js_new_spine_EventTimeline(se::State& s) // NOLINT(readability-identifier-naming)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    if (argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    
    size_t arg1 ;
    spine::EventTimeline *result;
    
    ok &= sevalue_to_native(args[0], &arg1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    
    result = (spine::EventTimeline *)new spine::EventTimeline(arg1);
    
    
    auto *ptr = JSB_MAKE_PRIVATE_OBJECT_WITH_INSTANCE(result);
    s.thisObject()->setPrivateObject(ptr);
    return true;
}
SE_BIND_CTOR(js_new_spine_EventTimeline, __jsb_spine_EventTimeline_class, js_delete_spine_EventTimeline)

static bool js_delete_spine_EventTimeline(se::State& s)
{
    return true;
}
SE_BIND_FINALIZE_FUNC(js_delete_spine_EventTimeline) 

static bool js_spine_EventTimeline_setFrame(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::EventTimeline *arg1 = (spine::EventTimeline *) NULL ;
    size_t arg2 ;
    spine::Event *arg3 = (spine::Event *) NULL ;
    
    if(argc != 2) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 2);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::EventTimeline>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    
    
    ok &= sevalue_to_native(args[1], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setFrame(arg2,arg3);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_EventTimeline_setFrame) 

static bool js_spine_EventTimeline_frames_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::EventTimeline *arg1 = (spine::EventTimeline *) NULL ;
    spine::Vector< float > result;
    
    arg1 = SE_THIS_OBJECT<spine::EventTimeline>(s);
    if (nullptr == arg1) return true;
    result = spine_EventTimeline_frames_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject() /*ctx*/);
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval());
    
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_EventTimeline_frames_get) 

static bool js_spine_EventTimeline_events_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::EventTimeline *arg1 = (spine::EventTimeline *) NULL ;
    spine::Vector< spine::Event * > *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::EventTimeline>(s);
    if (nullptr == arg1) return true;
    result = (spine::Vector< spine::Event * > *) &spine_EventTimeline_events_get(arg1);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_EventTimeline_events_get) 

bool js_register_spine_EventTimeline(se::Object* obj) {
    auto* cls = se::Class::create("EventTimeline", obj, __jsb_spine_Timeline_proto, _SE(js_new_spine_EventTimeline)); 
    
    cls->defineStaticProperty("__isJSB", se::Value(true), se::PropertyAttribute::READ_ONLY | se::PropertyAttribute::DONT_ENUM | se::PropertyAttribute::DONT_DELETE);
    cls->defineProperty("frames", _SE(js_spine_EventTimeline_frames_get), nullptr); 
    cls->defineProperty("events", _SE(js_spine_EventTimeline_events_get), nullptr); 
    
    cls->defineFunction("setFrame", _SE(js_spine_EventTimeline_setFrame)); 
    
    
    
    
    cls->defineFinalizeFunction(_SE(js_delete_spine_EventTimeline));
    
    
    cls->install();
    JSBClassType::registerClass<spine::EventTimeline>(cls);
    
    __jsb_spine_EventTimeline_proto = cls->getProto();
    __jsb_spine_EventTimeline_class = cls;
    se::ScriptEngine::getInstance()->clearException();
    return true;
}


se::Class* __jsb_spine_ConstraintData_class = nullptr;
se::Object* __jsb_spine_ConstraintData_proto = nullptr;
SE_DECLARE_FINALIZE_FUNC(js_delete_spine_ConstraintData) 

static bool js_new_spine_ConstraintData(se::State& s) // NOLINT(readability-identifier-naming)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    if (argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    
    spine::String *arg1 = 0 ;
    spine::String temp1 ;
    spine::ConstraintData *result;
    
    ok &= sevalue_to_native(args[0], &temp1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg1 = &temp1;
    
    result = (spine::ConstraintData *)new spine::ConstraintData((spine::String const &)*arg1);
    
    
    auto *ptr = JSB_MAKE_PRIVATE_OBJECT_WITH_INSTANCE(result);
    s.thisObject()->setPrivateObject(ptr);
    return true;
}
SE_BIND_CTOR(js_new_spine_ConstraintData, __jsb_spine_ConstraintData_class, js_delete_spine_ConstraintData)

static bool js_delete_spine_ConstraintData(se::State& s)
{
    return true;
}
SE_BIND_FINALIZE_FUNC(js_delete_spine_ConstraintData) 

static bool js_spine_ConstraintData_name_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::ConstraintData *arg1 = (spine::ConstraintData *) NULL ;
    spine::String *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::ConstraintData>(s);
    if (nullptr == arg1) return true;
    result = (spine::String *) &spine_ConstraintData_name_get(arg1);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_ConstraintData_name_get) 

static bool js_spine_ConstraintData_order_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::ConstraintData *arg1 = (spine::ConstraintData *) NULL ;
    size_t arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::ConstraintData>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    
    spine_ConstraintData_order_set(arg1,SWIG_STD_MOVE(arg2));
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_ConstraintData_order_set) 

static bool js_spine_ConstraintData_order_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::ConstraintData *arg1 = (spine::ConstraintData *) NULL ;
    size_t result;
    
    arg1 = SE_THIS_OBJECT<spine::ConstraintData>(s);
    if (nullptr == arg1) return true;
    result = spine_ConstraintData_order_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_ConstraintData_order_get) 

static bool js_spine_ConstraintData_skinRequired_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::ConstraintData *arg1 = (spine::ConstraintData *) NULL ;
    bool arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::ConstraintData>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2);
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_ConstraintData_skinRequired_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_ConstraintData_skinRequired_set) 

static bool js_spine_ConstraintData_skinRequired_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::ConstraintData *arg1 = (spine::ConstraintData *) NULL ;
    bool result;
    
    arg1 = SE_THIS_OBJECT<spine::ConstraintData>(s);
    if (nullptr == arg1) return true;
    result = (bool)spine_ConstraintData_skinRequired_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_ConstraintData_skinRequired_get) 

bool js_register_spine_ConstraintData(se::Object* obj) {
    auto* cls = se::Class::create("ConstraintData", obj, nullptr, _SE(js_new_spine_ConstraintData)); 
    
    cls->defineStaticProperty("__isJSB", se::Value(true), se::PropertyAttribute::READ_ONLY | se::PropertyAttribute::DONT_ENUM | se::PropertyAttribute::DONT_DELETE);
    cls->defineProperty("name", _SE(js_spine_ConstraintData_name_get), nullptr); 
    cls->defineProperty("order", _SE(js_spine_ConstraintData_order_get), _SE(js_spine_ConstraintData_order_set)); 
    cls->defineProperty("skinRequired", _SE(js_spine_ConstraintData_skinRequired_get), _SE(js_spine_ConstraintData_skinRequired_set)); 
    
    
    
    
    
    cls->defineFinalizeFunction(_SE(js_delete_spine_ConstraintData));
    
    
    cls->install();
    JSBClassType::registerClass<spine::ConstraintData>(cls);
    
    __jsb_spine_ConstraintData_proto = cls->getProto();
    __jsb_spine_ConstraintData_class = cls;
    se::ScriptEngine::getInstance()->clearException();
    return true;
}


se::Class* __jsb_spine_IkConstraint_class = nullptr;
se::Object* __jsb_spine_IkConstraint_proto = nullptr;
SE_DECLARE_FINALIZE_FUNC(js_delete_spine_IkConstraint) 

static bool js_spine_IkConstraint_update(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::IkConstraint *arg1 = (spine::IkConstraint *) NULL ;
    Physics arg2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::IkConstraint>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    (arg1)->update(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_IkConstraint_update) 

static bool js_spine_IkConstraint_getOrder(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::IkConstraint *arg1 = (spine::IkConstraint *) NULL ;
    int result;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::IkConstraint>(s);
    if (nullptr == arg1) return true;
    result = (int)(arg1)->getOrder();
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_IkConstraint_getOrder) 

static bool js_spine_IkConstraint_setToSetupPose(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::IkConstraint *arg1 = (spine::IkConstraint *) NULL ;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::IkConstraint>(s);
    if (nullptr == arg1) return true;
    (arg1)->setToSetupPose();
    
    
    return true;
}
SE_BIND_FUNC(js_spine_IkConstraint_setToSetupPose) 

static bool js_spine_IkConstraint_data_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::IkConstraint *arg1 = (spine::IkConstraint *) NULL ;
    spine::IkConstraintData *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::IkConstraint>(s);
    if (nullptr == arg1) return true;
    result = (spine::IkConstraintData *) &spine_IkConstraint_data_get(arg1);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_IkConstraint_data_get) 

static bool js_spine_IkConstraint_bones_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::IkConstraint *arg1 = (spine::IkConstraint *) NULL ;
    spine::Vector< spine::Bone * > *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::IkConstraint>(s);
    if (nullptr == arg1) return true;
    result = (spine::Vector< spine::Bone * > *) &spine_IkConstraint_bones_get(arg1);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_IkConstraint_bones_get) 

static bool js_spine_IkConstraint_target_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::IkConstraint *arg1 = (spine::IkConstraint *) NULL ;
    spine::Bone *arg2 = (spine::Bone *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::IkConstraint>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_IkConstraint_target_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_IkConstraint_target_set) 

static bool js_spine_IkConstraint_target_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::IkConstraint *arg1 = (spine::IkConstraint *) NULL ;
    spine::Bone *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::IkConstraint>(s);
    if (nullptr == arg1) return true;
    result = (spine::Bone *)spine_IkConstraint_target_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_IkConstraint_target_get) 

static bool js_spine_IkConstraint_bendDirection_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::IkConstraint *arg1 = (spine::IkConstraint *) NULL ;
    int arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::IkConstraint>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_IkConstraint_bendDirection_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_IkConstraint_bendDirection_set) 

static bool js_spine_IkConstraint_bendDirection_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::IkConstraint *arg1 = (spine::IkConstraint *) NULL ;
    int result;
    
    arg1 = SE_THIS_OBJECT<spine::IkConstraint>(s);
    if (nullptr == arg1) return true;
    result = (int)spine_IkConstraint_bendDirection_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_IkConstraint_bendDirection_get) 

static bool js_spine_IkConstraint_compress_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::IkConstraint *arg1 = (spine::IkConstraint *) NULL ;
    bool arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::IkConstraint>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2);
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_IkConstraint_compress_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_IkConstraint_compress_set) 

static bool js_spine_IkConstraint_compress_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::IkConstraint *arg1 = (spine::IkConstraint *) NULL ;
    bool result;
    
    arg1 = SE_THIS_OBJECT<spine::IkConstraint>(s);
    if (nullptr == arg1) return true;
    result = (bool)spine_IkConstraint_compress_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_IkConstraint_compress_get) 

static bool js_spine_IkConstraint_stretch_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::IkConstraint *arg1 = (spine::IkConstraint *) NULL ;
    bool arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::IkConstraint>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2);
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_IkConstraint_stretch_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_IkConstraint_stretch_set) 

static bool js_spine_IkConstraint_stretch_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::IkConstraint *arg1 = (spine::IkConstraint *) NULL ;
    bool result;
    
    arg1 = SE_THIS_OBJECT<spine::IkConstraint>(s);
    if (nullptr == arg1) return true;
    result = (bool)spine_IkConstraint_stretch_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_IkConstraint_stretch_get) 

static bool js_spine_IkConstraint_mix_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::IkConstraint *arg1 = (spine::IkConstraint *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::IkConstraint>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_IkConstraint_mix_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_IkConstraint_mix_set) 

static bool js_spine_IkConstraint_mix_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::IkConstraint *arg1 = (spine::IkConstraint *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::IkConstraint>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_IkConstraint_mix_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_IkConstraint_mix_get) 

static bool js_spine_IkConstraint_softness_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::IkConstraint *arg1 = (spine::IkConstraint *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::IkConstraint>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_IkConstraint_softness_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_IkConstraint_softness_set) 

static bool js_spine_IkConstraint_softness_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::IkConstraint *arg1 = (spine::IkConstraint *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::IkConstraint>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_IkConstraint_softness_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_IkConstraint_softness_get) 

static bool js_spine_IkConstraint_active_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::IkConstraint *arg1 = (spine::IkConstraint *) NULL ;
    bool arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::IkConstraint>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2);
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_IkConstraint_active_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_IkConstraint_active_set) 

static bool js_spine_IkConstraint_active_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::IkConstraint *arg1 = (spine::IkConstraint *) NULL ;
    bool result;
    
    arg1 = SE_THIS_OBJECT<spine::IkConstraint>(s);
    if (nullptr == arg1) return true;
    result = (bool)spine_IkConstraint_active_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_IkConstraint_active_get) 

static bool js_spine_IkConstraint_apply1(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::IkConstraint *arg1 = (spine::IkConstraint *) NULL ;
    spine::Bone *arg2 = (spine::Bone *) NULL ;
    float arg3 ;
    float arg4 ;
    bool arg5 ;
    bool arg6 ;
    bool arg7 ;
    float arg8 ;
    
    if(argc != 7) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 7);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::IkConstraint>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[1], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[2], &arg4, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[3], &arg5);
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[4], &arg6);
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[5], &arg7);
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[6], &arg8, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_IkConstraint_apply1(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_IkConstraint_apply1) 

static bool js_spine_IkConstraint_apply2(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::IkConstraint *arg1 = (spine::IkConstraint *) NULL ;
    spine::Bone *arg2 = (spine::Bone *) NULL ;
    spine::Bone *arg3 = (spine::Bone *) NULL ;
    float arg4 ;
    float arg5 ;
    int arg6 ;
    bool arg7 ;
    bool arg8 ;
    float arg9 ;
    float arg10 ;
    
    if(argc != 9) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 9);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::IkConstraint>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[1], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[2], &arg4, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[3], &arg5, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[4], &arg6, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[5], &arg7);
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[6], &arg8);
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[7], &arg9, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[8], &arg10, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_IkConstraint_apply2(arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_IkConstraint_apply2) 

static bool js_new_spine_IkConstraint(se::State& s) // NOLINT(readability-identifier-naming)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    if (argc != 2) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 2);
        return false;
    }
    
    spine::IkConstraintData *arg1 = (spine::IkConstraintData *) NULL ;
    spine::Skeleton *arg2 = (spine::Skeleton *) NULL ;
    spine::IkConstraint *result;
    
    ok &= sevalue_to_native(args[0], &arg1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[1], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (spine::IkConstraint *)new_spine_IkConstraint(arg1,arg2);
    
    
    auto *ptr = JSB_MAKE_PRIVATE_OBJECT_WITH_INSTANCE(result);
    s.thisObject()->setPrivateObject(ptr);
    return true;
}
SE_BIND_CTOR(js_new_spine_IkConstraint, __jsb_spine_IkConstraint_class, js_delete_spine_IkConstraint)

static bool js_delete_spine_IkConstraint(se::State& s)
{
    return true;
}
SE_BIND_FINALIZE_FUNC(js_delete_spine_IkConstraint) 

bool js_register_spine_IkConstraint(se::Object* obj) {
    auto* cls = se::Class::create("IkConstraint", obj, nullptr, _SE(js_new_spine_IkConstraint)); 
    
    cls->defineStaticProperty("__isJSB", se::Value(true), se::PropertyAttribute::READ_ONLY | se::PropertyAttribute::DONT_ENUM | se::PropertyAttribute::DONT_DELETE);
    cls->defineProperty("data", _SE(js_spine_IkConstraint_data_get), nullptr); 
    cls->defineProperty("bones", _SE(js_spine_IkConstraint_bones_get), nullptr); 
    cls->defineProperty("target", _SE(js_spine_IkConstraint_target_get), _SE(js_spine_IkConstraint_target_set)); 
    cls->defineProperty("bendDirection", _SE(js_spine_IkConstraint_bendDirection_get), _SE(js_spine_IkConstraint_bendDirection_set)); 
    cls->defineProperty("compress", _SE(js_spine_IkConstraint_compress_get), _SE(js_spine_IkConstraint_compress_set)); 
    cls->defineProperty("stretch", _SE(js_spine_IkConstraint_stretch_get), _SE(js_spine_IkConstraint_stretch_set)); 
    cls->defineProperty("mix", _SE(js_spine_IkConstraint_mix_get), _SE(js_spine_IkConstraint_mix_set)); 
    cls->defineProperty("softness", _SE(js_spine_IkConstraint_softness_get), _SE(js_spine_IkConstraint_softness_set)); 
    cls->defineProperty("active", _SE(js_spine_IkConstraint_active_get), _SE(js_spine_IkConstraint_active_set)); 
    
    cls->defineFunction("update", _SE(js_spine_IkConstraint_update)); 
    cls->defineFunction("getOrder", _SE(js_spine_IkConstraint_getOrder)); 
    cls->defineFunction("setToSetupPose", _SE(js_spine_IkConstraint_setToSetupPose)); 
    cls->defineFunction("apply1", _SE(js_spine_IkConstraint_apply1)); 
    cls->defineFunction("apply2", _SE(js_spine_IkConstraint_apply2)); 
    
    
    
    
    cls->defineFinalizeFunction(_SE(js_delete_spine_IkConstraint));
    
    
    cls->install();
    JSBClassType::registerClass<spine::IkConstraint>(cls);
    
    __jsb_spine_IkConstraint_proto = cls->getProto();
    __jsb_spine_IkConstraint_class = cls;
    se::ScriptEngine::getInstance()->clearException();
    return true;
}


se::Class* __jsb_spine_IkConstraintData_class = nullptr;
se::Object* __jsb_spine_IkConstraintData_proto = nullptr;
SE_DECLARE_FINALIZE_FUNC(js_delete_spine_IkConstraintData) 

static bool js_new_spine_IkConstraintData(se::State& s) // NOLINT(readability-identifier-naming)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    if (argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    
    spine::String *arg1 = 0 ;
    spine::String temp1 ;
    spine::IkConstraintData *result;
    
    ok &= sevalue_to_native(args[0], &temp1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg1 = &temp1;
    
    result = (spine::IkConstraintData *)new spine::IkConstraintData((spine::String const &)*arg1);
    
    
    auto *ptr = JSB_MAKE_PRIVATE_OBJECT_WITH_INSTANCE(result);
    s.thisObject()->setPrivateObject(ptr);
    return true;
}
SE_BIND_CTOR(js_new_spine_IkConstraintData, __jsb_spine_IkConstraintData_class, js_delete_spine_IkConstraintData)

static bool js_spine_IkConstraintData_setTarget(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::IkConstraintData *arg1 = (spine::IkConstraintData *) NULL ;
    spine::BoneData *arg2 = (spine::BoneData *) NULL ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::IkConstraintData>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setTarget(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_IkConstraintData_setTarget) 

static bool js_spine_IkConstraintData_bones_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::IkConstraintData *arg1 = (spine::IkConstraintData *) NULL ;
    spine::Vector< spine::BoneData * > *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::IkConstraintData>(s);
    if (nullptr == arg1) return true;
    result = (spine::Vector< spine::BoneData * > *) &spine_IkConstraintData_bones_get(arg1);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_IkConstraintData_bones_get) 

static bool js_spine_IkConstraintData_target_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::IkConstraintData *arg1 = (spine::IkConstraintData *) NULL ;
    spine::BoneData *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::IkConstraintData>(s);
    if (nullptr == arg1) return true;
    result = (spine::BoneData *)spine_IkConstraintData_target_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_IkConstraintData_target_get) 

static bool js_spine_IkConstraintData_bendDirection_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::IkConstraintData *arg1 = (spine::IkConstraintData *) NULL ;
    int arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::IkConstraintData>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_IkConstraintData_bendDirection_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_IkConstraintData_bendDirection_set) 

static bool js_spine_IkConstraintData_bendDirection_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::IkConstraintData *arg1 = (spine::IkConstraintData *) NULL ;
    int result;
    
    arg1 = SE_THIS_OBJECT<spine::IkConstraintData>(s);
    if (nullptr == arg1) return true;
    result = (int)spine_IkConstraintData_bendDirection_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_IkConstraintData_bendDirection_get) 

static bool js_spine_IkConstraintData_compress_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::IkConstraintData *arg1 = (spine::IkConstraintData *) NULL ;
    bool arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::IkConstraintData>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2);
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_IkConstraintData_compress_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_IkConstraintData_compress_set) 

static bool js_spine_IkConstraintData_compress_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::IkConstraintData *arg1 = (spine::IkConstraintData *) NULL ;
    bool result;
    
    arg1 = SE_THIS_OBJECT<spine::IkConstraintData>(s);
    if (nullptr == arg1) return true;
    result = (bool)spine_IkConstraintData_compress_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_IkConstraintData_compress_get) 

static bool js_spine_IkConstraintData_stretch_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::IkConstraintData *arg1 = (spine::IkConstraintData *) NULL ;
    bool arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::IkConstraintData>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2);
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_IkConstraintData_stretch_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_IkConstraintData_stretch_set) 

static bool js_spine_IkConstraintData_stretch_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::IkConstraintData *arg1 = (spine::IkConstraintData *) NULL ;
    bool result;
    
    arg1 = SE_THIS_OBJECT<spine::IkConstraintData>(s);
    if (nullptr == arg1) return true;
    result = (bool)spine_IkConstraintData_stretch_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_IkConstraintData_stretch_get) 

static bool js_spine_IkConstraintData_uniform_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::IkConstraintData *arg1 = (spine::IkConstraintData *) NULL ;
    bool arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::IkConstraintData>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2);
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_IkConstraintData_uniform_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_IkConstraintData_uniform_set) 

static bool js_spine_IkConstraintData_uniform_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::IkConstraintData *arg1 = (spine::IkConstraintData *) NULL ;
    bool result;
    
    arg1 = SE_THIS_OBJECT<spine::IkConstraintData>(s);
    if (nullptr == arg1) return true;
    result = (bool)spine_IkConstraintData_uniform_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_IkConstraintData_uniform_get) 

static bool js_spine_IkConstraintData_mix_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::IkConstraintData *arg1 = (spine::IkConstraintData *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::IkConstraintData>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_IkConstraintData_mix_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_IkConstraintData_mix_set) 

static bool js_spine_IkConstraintData_mix_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::IkConstraintData *arg1 = (spine::IkConstraintData *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::IkConstraintData>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_IkConstraintData_mix_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_IkConstraintData_mix_get) 

static bool js_spine_IkConstraintData_softness_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::IkConstraintData *arg1 = (spine::IkConstraintData *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::IkConstraintData>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_IkConstraintData_softness_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_IkConstraintData_softness_set) 

static bool js_spine_IkConstraintData_softness_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::IkConstraintData *arg1 = (spine::IkConstraintData *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::IkConstraintData>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_IkConstraintData_softness_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_IkConstraintData_softness_get) 

static bool js_delete_spine_IkConstraintData(se::State& s)
{
    return true;
}
SE_BIND_FINALIZE_FUNC(js_delete_spine_IkConstraintData) 

bool js_register_spine_IkConstraintData(se::Object* obj) {
    auto* cls = se::Class::create("IkConstraintData", obj, __jsb_spine_ConstraintData_proto, _SE(js_new_spine_IkConstraintData)); 
    
    cls->defineStaticProperty("__isJSB", se::Value(true), se::PropertyAttribute::READ_ONLY | se::PropertyAttribute::DONT_ENUM | se::PropertyAttribute::DONT_DELETE);
    cls->defineProperty("bones", _SE(js_spine_IkConstraintData_bones_get), nullptr); 
    cls->defineProperty("target", _SE(js_spine_IkConstraintData_target_get), nullptr); 
    cls->defineProperty("bendDirection", _SE(js_spine_IkConstraintData_bendDirection_get), _SE(js_spine_IkConstraintData_bendDirection_set)); 
    cls->defineProperty("compress", _SE(js_spine_IkConstraintData_compress_get), _SE(js_spine_IkConstraintData_compress_set)); 
    cls->defineProperty("stretch", _SE(js_spine_IkConstraintData_stretch_get), _SE(js_spine_IkConstraintData_stretch_set)); 
    cls->defineProperty("uniform", _SE(js_spine_IkConstraintData_uniform_get), _SE(js_spine_IkConstraintData_uniform_set)); 
    cls->defineProperty("mix", _SE(js_spine_IkConstraintData_mix_get), _SE(js_spine_IkConstraintData_mix_set)); 
    cls->defineProperty("softness", _SE(js_spine_IkConstraintData_softness_get), _SE(js_spine_IkConstraintData_softness_set)); 
    
    cls->defineFunction("setTarget", _SE(js_spine_IkConstraintData_setTarget)); 
    
    
    
    
    cls->defineFinalizeFunction(_SE(js_delete_spine_IkConstraintData));
    
    
    cls->install();
    JSBClassType::registerClass<spine::IkConstraintData>(cls);
    
    __jsb_spine_IkConstraintData_proto = cls->getProto();
    __jsb_spine_IkConstraintData_class = cls;
    se::ScriptEngine::getInstance()->clearException();
    return true;
}


se::Class* __jsb_spine_IkConstraintTimeline_class = nullptr;
se::Object* __jsb_spine_IkConstraintTimeline_proto = nullptr;
SE_DECLARE_FINALIZE_FUNC(js_delete_spine_IkConstraintTimeline) 

static bool js_new_spine_IkConstraintTimeline(se::State& s) // NOLINT(readability-identifier-naming)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    if (argc != 3) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 3);
        return false;
    }
    
    size_t arg1 ;
    size_t arg2 ;
    int arg3 ;
    spine::IkConstraintTimeline *result;
    
    ok &= sevalue_to_native(args[0], &arg1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    
    
    ok &= sevalue_to_native(args[1], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    
    
    ok &= sevalue_to_native(args[2], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (spine::IkConstraintTimeline *)new spine::IkConstraintTimeline(arg1,arg2,arg3);
    
    
    auto *ptr = JSB_MAKE_PRIVATE_OBJECT_WITH_INSTANCE(result);
    s.thisObject()->setPrivateObject(ptr);
    return true;
}
SE_BIND_CTOR(js_new_spine_IkConstraintTimeline, __jsb_spine_IkConstraintTimeline_class, js_delete_spine_IkConstraintTimeline)

static bool js_spine_IkConstraintTimeline_setFrame(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::IkConstraintTimeline *arg1 = (spine::IkConstraintTimeline *) NULL ;
    int arg2 ;
    float arg3 ;
    float arg4 ;
    float arg5 ;
    int arg6 ;
    bool arg7 ;
    bool arg8 ;
    
    if(argc != 7) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 7);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::IkConstraintTimeline>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[1], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[2], &arg4, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[3], &arg5, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[4], &arg6, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[5], &arg7);
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[6], &arg8);
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setFrame(arg2,arg3,arg4,arg5,arg6,arg7,arg8);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_IkConstraintTimeline_setFrame) 

static bool js_spine_IkConstraintTimeline_getIkConstraintIndex(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::IkConstraintTimeline *arg1 = (spine::IkConstraintTimeline *) NULL ;
    int result;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::IkConstraintTimeline>(s);
    if (nullptr == arg1) return true;
    result = (int)(arg1)->getIkConstraintIndex();
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_IkConstraintTimeline_getIkConstraintIndex) 

static bool js_spine_IkConstraintTimeline_setIkConstraintIndex(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::IkConstraintTimeline *arg1 = (spine::IkConstraintTimeline *) NULL ;
    int arg2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::IkConstraintTimeline>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setIkConstraintIndex(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_IkConstraintTimeline_setIkConstraintIndex) 

static bool js_delete_spine_IkConstraintTimeline(se::State& s)
{
    return true;
}
SE_BIND_FINALIZE_FUNC(js_delete_spine_IkConstraintTimeline) 

bool js_register_spine_IkConstraintTimeline(se::Object* obj) {
    auto* cls = se::Class::create("IkConstraintTimeline", obj, __jsb_spine_CurveTimeline_proto, _SE(js_new_spine_IkConstraintTimeline)); 
    
    cls->defineStaticProperty("__isJSB", se::Value(true), se::PropertyAttribute::READ_ONLY | se::PropertyAttribute::DONT_ENUM | se::PropertyAttribute::DONT_DELETE);
    
    cls->defineFunction("setFrame", _SE(js_spine_IkConstraintTimeline_setFrame)); 
    cls->defineFunction("getIkConstraintIndex", _SE(js_spine_IkConstraintTimeline_getIkConstraintIndex)); 
    cls->defineFunction("setIkConstraintIndex", _SE(js_spine_IkConstraintTimeline_setIkConstraintIndex)); 
    
    
    
    
    cls->defineFinalizeFunction(_SE(js_delete_spine_IkConstraintTimeline));
    
    
    cls->install();
    JSBClassType::registerClass<spine::IkConstraintTimeline>(cls);
    
    __jsb_spine_IkConstraintTimeline_proto = cls->getProto();
    __jsb_spine_IkConstraintTimeline_class = cls;
    se::ScriptEngine::getInstance()->clearException();
    return true;
}


se::Class* __jsb_spine_MeshAttachment_class = nullptr;
se::Object* __jsb_spine_MeshAttachment_proto = nullptr;
SE_DECLARE_FINALIZE_FUNC(js_delete_spine_MeshAttachment) 

static bool js_new_spine_MeshAttachment(se::State& s) // NOLINT(readability-identifier-naming)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    if (argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    
    spine::String *arg1 = 0 ;
    spine::String temp1 ;
    spine::MeshAttachment *result;
    
    ok &= sevalue_to_native(args[0], &temp1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg1 = &temp1;
    
    result = (spine::MeshAttachment *)new spine::MeshAttachment((spine::String const &)*arg1);
    
    
    auto *ptr = JSB_MAKE_PRIVATE_OBJECT_WITH_INSTANCE(result);
    s.thisObject()->setPrivateObject(ptr);
    return true;
}
SE_BIND_CTOR(js_new_spine_MeshAttachment, __jsb_spine_MeshAttachment_class, js_delete_spine_MeshAttachment)

static bool js_delete_spine_MeshAttachment(se::State& s)
{
    return true;
}
SE_BIND_FINALIZE_FUNC(js_delete_spine_MeshAttachment) 

static bool js_spine_MeshAttachment_updateRegion(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::MeshAttachment *arg1 = (spine::MeshAttachment *) NULL ;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::MeshAttachment>(s);
    if (nullptr == arg1) return true;
    (arg1)->updateRegion();
    
    
    return true;
}
SE_BIND_FUNC(js_spine_MeshAttachment_updateRegion) 

static bool js_spine_MeshAttachment_getRegion(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::MeshAttachment *arg1 = (spine::MeshAttachment *) NULL ;
    TextureRegion *result = 0 ;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::MeshAttachment>(s);
    if (nullptr == arg1) return true;
    result = (TextureRegion *)(arg1)->getRegion();
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_MeshAttachment_getRegion) 

static bool js_spine_MeshAttachment_setRegion(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::MeshAttachment *arg1 = (spine::MeshAttachment *) NULL ;
    TextureRegion *arg2 = (TextureRegion *) NULL ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::MeshAttachment>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setRegion(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_MeshAttachment_setRegion) 

static bool js_spine_MeshAttachment_getSequence(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::MeshAttachment *arg1 = (spine::MeshAttachment *) NULL ;
    Sequence *result = 0 ;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::MeshAttachment>(s);
    if (nullptr == arg1) return true;
    result = (Sequence *)(arg1)->getSequence();
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_MeshAttachment_getSequence) 

static bool js_spine_MeshAttachment_setSequence(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::MeshAttachment *arg1 = (spine::MeshAttachment *) NULL ;
    Sequence *arg2 = (Sequence *) NULL ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::MeshAttachment>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setSequence(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_MeshAttachment_setSequence) 

static bool js_spine_MeshAttachment_getParentMesh(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::MeshAttachment *arg1 = (spine::MeshAttachment *) NULL ;
    spine::MeshAttachment *result = 0 ;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::MeshAttachment>(s);
    if (nullptr == arg1) return true;
    result = (spine::MeshAttachment *)(arg1)->getParentMesh();
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_MeshAttachment_getParentMesh) 

static bool js_spine_MeshAttachment_setParentMesh(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::MeshAttachment *arg1 = (spine::MeshAttachment *) NULL ;
    spine::MeshAttachment *arg2 = (spine::MeshAttachment *) NULL ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::MeshAttachment>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setParentMesh(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_MeshAttachment_setParentMesh) 

static bool js_spine_MeshAttachment_newLinkedMesh(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::MeshAttachment *arg1 = (spine::MeshAttachment *) NULL ;
    spine::MeshAttachment *result = 0 ;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::MeshAttachment>(s);
    if (nullptr == arg1) return true;
    result = (spine::MeshAttachment *)(arg1)->newLinkedMesh();
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_MeshAttachment_newLinkedMesh) 

static bool js_spine_MeshAttachment_path_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::MeshAttachment *arg1 = (spine::MeshAttachment *) NULL ;
    spine::String *arg2 = 0 ;
    spine::String temp2 ;
    
    arg1 = SE_THIS_OBJECT<spine::MeshAttachment>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    spine_MeshAttachment_path_set(arg1,*arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_MeshAttachment_path_set) 

static bool js_spine_MeshAttachment_path_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::MeshAttachment *arg1 = (spine::MeshAttachment *) NULL ;
    spine::String *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::MeshAttachment>(s);
    if (nullptr == arg1) return true;
    result = (spine::String *) &spine_MeshAttachment_path_get(arg1);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_MeshAttachment_path_get) 

static bool js_spine_MeshAttachment_regionUVs_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::MeshAttachment *arg1 = (spine::MeshAttachment *) NULL ;
    spine::Vector< float > *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::MeshAttachment>(s);
    if (nullptr == arg1) return true;
    result = (spine::Vector< float > *) &spine_MeshAttachment_regionUVs_get(arg1);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_MeshAttachment_regionUVs_get) 

static bool js_spine_MeshAttachment_uvs_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::MeshAttachment *arg1 = (spine::MeshAttachment *) NULL ;
    spine::Vector< float > *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::MeshAttachment>(s);
    if (nullptr == arg1) return true;
    result = (spine::Vector< float > *) &spine_MeshAttachment_uvs_get(arg1);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_MeshAttachment_uvs_get) 

static bool js_spine_MeshAttachment_triangles_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::MeshAttachment *arg1 = (spine::MeshAttachment *) NULL ;
    spine::Vector< unsigned short > *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::MeshAttachment>(s);
    if (nullptr == arg1) return true;
    result = (spine::Vector< unsigned short > *) &spine_MeshAttachment_triangles_get(arg1);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_MeshAttachment_triangles_get) 

static bool js_spine_MeshAttachment_color_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::MeshAttachment *arg1 = (spine::MeshAttachment *) NULL ;
    spine::Color *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::MeshAttachment>(s);
    if (nullptr == arg1) return true;
    result = (spine::Color *) &spine_MeshAttachment_color_get(arg1);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_MeshAttachment_color_get) 

static bool js_spine_MeshAttachment_width_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::MeshAttachment *arg1 = (spine::MeshAttachment *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::MeshAttachment>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_MeshAttachment_width_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_MeshAttachment_width_set) 

static bool js_spine_MeshAttachment_width_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::MeshAttachment *arg1 = (spine::MeshAttachment *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::MeshAttachment>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_MeshAttachment_width_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_MeshAttachment_width_get) 

static bool js_spine_MeshAttachment_height_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::MeshAttachment *arg1 = (spine::MeshAttachment *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::MeshAttachment>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_MeshAttachment_height_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_MeshAttachment_height_set) 

static bool js_spine_MeshAttachment_height_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::MeshAttachment *arg1 = (spine::MeshAttachment *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::MeshAttachment>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_MeshAttachment_height_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_MeshAttachment_height_get) 

static bool js_spine_MeshAttachment_hullLength_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::MeshAttachment *arg1 = (spine::MeshAttachment *) NULL ;
    int arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::MeshAttachment>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_MeshAttachment_hullLength_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_MeshAttachment_hullLength_set) 

static bool js_spine_MeshAttachment_hullLength_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::MeshAttachment *arg1 = (spine::MeshAttachment *) NULL ;
    int result;
    
    arg1 = SE_THIS_OBJECT<spine::MeshAttachment>(s);
    if (nullptr == arg1) return true;
    result = (int)spine_MeshAttachment_hullLength_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_MeshAttachment_hullLength_get) 

static bool js_spine_MeshAttachment_edges_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::MeshAttachment *arg1 = (spine::MeshAttachment *) NULL ;
    spine::Vector< unsigned short > *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::MeshAttachment>(s);
    if (nullptr == arg1) return true;
    result = (spine::Vector< unsigned short > *) &spine_MeshAttachment_edges_get(arg1);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_MeshAttachment_edges_get) 

bool js_register_spine_MeshAttachment(se::Object* obj) {
    auto* cls = se::Class::create("MeshAttachment", obj, __jsb_spine_VertexAttachment_proto, _SE(js_new_spine_MeshAttachment)); 
    
    cls->defineStaticProperty("__isJSB", se::Value(true), se::PropertyAttribute::READ_ONLY | se::PropertyAttribute::DONT_ENUM | se::PropertyAttribute::DONT_DELETE);
    cls->defineProperty("path", _SE(js_spine_MeshAttachment_path_get), _SE(js_spine_MeshAttachment_path_set)); 
    cls->defineProperty("regionUVs", _SE(js_spine_MeshAttachment_regionUVs_get), nullptr); 
    cls->defineProperty("uvs", _SE(js_spine_MeshAttachment_uvs_get), nullptr); 
    cls->defineProperty("triangles", _SE(js_spine_MeshAttachment_triangles_get), nullptr); 
    cls->defineProperty("color", _SE(js_spine_MeshAttachment_color_get), nullptr); 
    cls->defineProperty("width", _SE(js_spine_MeshAttachment_width_get), _SE(js_spine_MeshAttachment_width_set)); 
    cls->defineProperty("height", _SE(js_spine_MeshAttachment_height_get), _SE(js_spine_MeshAttachment_height_set)); 
    cls->defineProperty("hullLength", _SE(js_spine_MeshAttachment_hullLength_get), _SE(js_spine_MeshAttachment_hullLength_set)); 
    cls->defineProperty("edges", _SE(js_spine_MeshAttachment_edges_get), nullptr); 
    
    cls->defineFunction("updateRegion", _SE(js_spine_MeshAttachment_updateRegion)); 
    cls->defineFunction("getRegion", _SE(js_spine_MeshAttachment_getRegion)); 
    cls->defineFunction("setRegion", _SE(js_spine_MeshAttachment_setRegion)); 
    cls->defineFunction("getSequence", _SE(js_spine_MeshAttachment_getSequence)); 
    cls->defineFunction("setSequence", _SE(js_spine_MeshAttachment_setSequence)); 
    cls->defineFunction("getParentMesh", _SE(js_spine_MeshAttachment_getParentMesh)); 
    cls->defineFunction("setParentMesh", _SE(js_spine_MeshAttachment_setParentMesh)); 
    cls->defineFunction("newLinkedMesh", _SE(js_spine_MeshAttachment_newLinkedMesh)); 
    
    
    
    
    cls->defineFinalizeFunction(_SE(js_delete_spine_MeshAttachment));
    
    
    cls->install();
    JSBClassType::registerClass<spine::MeshAttachment>(cls);
    
    __jsb_spine_MeshAttachment_proto = cls->getProto();
    __jsb_spine_MeshAttachment_class = cls;
    se::ScriptEngine::getInstance()->clearException();
    return true;
}


se::Class* __jsb_spine_PathAttachment_class = nullptr;
se::Object* __jsb_spine_PathAttachment_proto = nullptr;
SE_DECLARE_FINALIZE_FUNC(js_delete_spine_PathAttachment) 

static bool js_new_spine_PathAttachment(se::State& s) // NOLINT(readability-identifier-naming)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    if (argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    
    spine::String *arg1 = 0 ;
    spine::String temp1 ;
    spine::PathAttachment *result;
    
    ok &= sevalue_to_native(args[0], &temp1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg1 = &temp1;
    
    result = (spine::PathAttachment *)new spine::PathAttachment((spine::String const &)*arg1);
    
    
    auto *ptr = JSB_MAKE_PRIVATE_OBJECT_WITH_INSTANCE(result);
    s.thisObject()->setPrivateObject(ptr);
    return true;
}
SE_BIND_CTOR(js_new_spine_PathAttachment, __jsb_spine_PathAttachment_class, js_delete_spine_PathAttachment)

static bool js_spine_PathAttachment_getColor(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::PathAttachment *arg1 = (spine::PathAttachment *) NULL ;
    spine::Color *result = 0 ;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::PathAttachment>(s);
    if (nullptr == arg1) return true;
    result = (spine::Color *) &(arg1)->getColor();
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_PathAttachment_getColor) 

static bool js_spine_PathAttachment_lengths_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::PathAttachment *arg1 = (spine::PathAttachment *) NULL ;
    spine::Vector< float > *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::PathAttachment>(s);
    if (nullptr == arg1) return true;
    result = (spine::Vector< float > *) &spine_PathAttachment_lengths_get(arg1);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_PathAttachment_lengths_get) 

static bool js_spine_PathAttachment_closed_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::PathAttachment *arg1 = (spine::PathAttachment *) NULL ;
    bool arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::PathAttachment>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2);
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_PathAttachment_closed_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_PathAttachment_closed_set) 

static bool js_spine_PathAttachment_closed_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::PathAttachment *arg1 = (spine::PathAttachment *) NULL ;
    bool result;
    
    arg1 = SE_THIS_OBJECT<spine::PathAttachment>(s);
    if (nullptr == arg1) return true;
    result = (bool)spine_PathAttachment_closed_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_PathAttachment_closed_get) 

static bool js_spine_PathAttachment_constantSpeed_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::PathAttachment *arg1 = (spine::PathAttachment *) NULL ;
    bool arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::PathAttachment>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2);
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_PathAttachment_constantSpeed_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_PathAttachment_constantSpeed_set) 

static bool js_spine_PathAttachment_constantSpeed_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::PathAttachment *arg1 = (spine::PathAttachment *) NULL ;
    bool result;
    
    arg1 = SE_THIS_OBJECT<spine::PathAttachment>(s);
    if (nullptr == arg1) return true;
    result = (bool)spine_PathAttachment_constantSpeed_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_PathAttachment_constantSpeed_get) 

static bool js_delete_spine_PathAttachment(se::State& s)
{
    return true;
}
SE_BIND_FINALIZE_FUNC(js_delete_spine_PathAttachment) 

bool js_register_spine_PathAttachment(se::Object* obj) {
    auto* cls = se::Class::create("PathAttachment", obj, __jsb_spine_VertexAttachment_proto, _SE(js_new_spine_PathAttachment)); 
    
    cls->defineStaticProperty("__isJSB", se::Value(true), se::PropertyAttribute::READ_ONLY | se::PropertyAttribute::DONT_ENUM | se::PropertyAttribute::DONT_DELETE);
    cls->defineProperty("lengths", _SE(js_spine_PathAttachment_lengths_get), nullptr); 
    cls->defineProperty("closed", _SE(js_spine_PathAttachment_closed_get), _SE(js_spine_PathAttachment_closed_set)); 
    cls->defineProperty("constantSpeed", _SE(js_spine_PathAttachment_constantSpeed_get), _SE(js_spine_PathAttachment_constantSpeed_set)); 
    
    cls->defineFunction("getColor", _SE(js_spine_PathAttachment_getColor)); 
    
    
    
    
    cls->defineFinalizeFunction(_SE(js_delete_spine_PathAttachment));
    
    
    cls->install();
    JSBClassType::registerClass<spine::PathAttachment>(cls);
    
    __jsb_spine_PathAttachment_proto = cls->getProto();
    __jsb_spine_PathAttachment_class = cls;
    se::ScriptEngine::getInstance()->clearException();
    return true;
}


se::Class* __jsb_spine_PathConstraint_class = nullptr;
se::Object* __jsb_spine_PathConstraint_proto = nullptr;
SE_DECLARE_FINALIZE_FUNC(js_delete_spine_PathConstraint) 

static bool js_spine_PathConstraint_update(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::PathConstraint *arg1 = (spine::PathConstraint *) NULL ;
    Physics arg2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::PathConstraint>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    (arg1)->update(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_PathConstraint_update) 

static bool js_spine_PathConstraint_getOrder(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::PathConstraint *arg1 = (spine::PathConstraint *) NULL ;
    int result;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::PathConstraint>(s);
    if (nullptr == arg1) return true;
    result = (int)(arg1)->getOrder();
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_PathConstraint_getOrder) 

static bool js_spine_PathConstraint_setToSetupPose(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::PathConstraint *arg1 = (spine::PathConstraint *) NULL ;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::PathConstraint>(s);
    if (nullptr == arg1) return true;
    (arg1)->setToSetupPose();
    
    
    return true;
}
SE_BIND_FUNC(js_spine_PathConstraint_setToSetupPose) 

static bool js_spine_PathConstraint_data_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::PathConstraint *arg1 = (spine::PathConstraint *) NULL ;
    spine::PathConstraintData *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::PathConstraint>(s);
    if (nullptr == arg1) return true;
    result = (spine::PathConstraintData *) &spine_PathConstraint_data_get(arg1);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_PathConstraint_data_get) 

static bool js_spine_PathConstraint_bones_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::PathConstraint *arg1 = (spine::PathConstraint *) NULL ;
    spine::Vector< spine::Bone * > *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::PathConstraint>(s);
    if (nullptr == arg1) return true;
    result = (spine::Vector< spine::Bone * > *) &spine_PathConstraint_bones_get(arg1);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_PathConstraint_bones_get) 

static bool js_spine_PathConstraint_target_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::PathConstraint *arg1 = (spine::PathConstraint *) NULL ;
    spine::Slot *arg2 = (spine::Slot *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::PathConstraint>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_PathConstraint_target_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_PathConstraint_target_set) 

static bool js_spine_PathConstraint_target_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::PathConstraint *arg1 = (spine::PathConstraint *) NULL ;
    spine::Slot *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::PathConstraint>(s);
    if (nullptr == arg1) return true;
    result = (spine::Slot *)spine_PathConstraint_target_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_PathConstraint_target_get) 

static bool js_spine_PathConstraint_position_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::PathConstraint *arg1 = (spine::PathConstraint *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::PathConstraint>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_PathConstraint_position_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_PathConstraint_position_set) 

static bool js_spine_PathConstraint_position_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::PathConstraint *arg1 = (spine::PathConstraint *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::PathConstraint>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_PathConstraint_position_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_PathConstraint_position_get) 

static bool js_spine_PathConstraint_spacing_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::PathConstraint *arg1 = (spine::PathConstraint *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::PathConstraint>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_PathConstraint_spacing_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_PathConstraint_spacing_set) 

static bool js_spine_PathConstraint_spacing_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::PathConstraint *arg1 = (spine::PathConstraint *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::PathConstraint>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_PathConstraint_spacing_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_PathConstraint_spacing_get) 

static bool js_spine_PathConstraint_mixRotate_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::PathConstraint *arg1 = (spine::PathConstraint *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::PathConstraint>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_PathConstraint_mixRotate_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_PathConstraint_mixRotate_set) 

static bool js_spine_PathConstraint_mixRotate_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::PathConstraint *arg1 = (spine::PathConstraint *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::PathConstraint>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_PathConstraint_mixRotate_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_PathConstraint_mixRotate_get) 

static bool js_spine_PathConstraint_mixX_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::PathConstraint *arg1 = (spine::PathConstraint *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::PathConstraint>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_PathConstraint_mixX_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_PathConstraint_mixX_set) 

static bool js_spine_PathConstraint_mixX_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::PathConstraint *arg1 = (spine::PathConstraint *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::PathConstraint>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_PathConstraint_mixX_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_PathConstraint_mixX_get) 

static bool js_spine_PathConstraint_mixY_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::PathConstraint *arg1 = (spine::PathConstraint *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::PathConstraint>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_PathConstraint_mixY_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_PathConstraint_mixY_set) 

static bool js_spine_PathConstraint_mixY_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::PathConstraint *arg1 = (spine::PathConstraint *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::PathConstraint>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_PathConstraint_mixY_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_PathConstraint_mixY_get) 

static bool js_spine_PathConstraint_active_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::PathConstraint *arg1 = (spine::PathConstraint *) NULL ;
    bool arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::PathConstraint>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2);
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_PathConstraint_active_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_PathConstraint_active_set) 

static bool js_spine_PathConstraint_active_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::PathConstraint *arg1 = (spine::PathConstraint *) NULL ;
    bool result;
    
    arg1 = SE_THIS_OBJECT<spine::PathConstraint>(s);
    if (nullptr == arg1) return true;
    result = (bool)spine_PathConstraint_active_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_PathConstraint_active_get) 

static bool js_new_spine_PathConstraint(se::State& s) // NOLINT(readability-identifier-naming)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    if (argc != 2) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 2);
        return false;
    }
    
    spine::PathConstraintData *arg1 = (spine::PathConstraintData *) NULL ;
    spine::Skeleton *arg2 = (spine::Skeleton *) NULL ;
    spine::PathConstraint *result;
    
    ok &= sevalue_to_native(args[0], &arg1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[1], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (spine::PathConstraint *)new_spine_PathConstraint(arg1,arg2);
    
    
    auto *ptr = JSB_MAKE_PRIVATE_OBJECT_WITH_INSTANCE(result);
    s.thisObject()->setPrivateObject(ptr);
    return true;
}
SE_BIND_CTOR(js_new_spine_PathConstraint, __jsb_spine_PathConstraint_class, js_delete_spine_PathConstraint)

static bool js_delete_spine_PathConstraint(se::State& s)
{
    return true;
}
SE_BIND_FINALIZE_FUNC(js_delete_spine_PathConstraint) 

bool js_register_spine_PathConstraint(se::Object* obj) {
    auto* cls = se::Class::create("PathConstraint", obj, nullptr, _SE(js_new_spine_PathConstraint)); 
    
    cls->defineStaticProperty("__isJSB", se::Value(true), se::PropertyAttribute::READ_ONLY | se::PropertyAttribute::DONT_ENUM | se::PropertyAttribute::DONT_DELETE);
    cls->defineProperty("data", _SE(js_spine_PathConstraint_data_get), nullptr); 
    cls->defineProperty("bones", _SE(js_spine_PathConstraint_bones_get), nullptr); 
    cls->defineProperty("target", _SE(js_spine_PathConstraint_target_get), _SE(js_spine_PathConstraint_target_set)); 
    cls->defineProperty("position", _SE(js_spine_PathConstraint_position_get), _SE(js_spine_PathConstraint_position_set)); 
    cls->defineProperty("spacing", _SE(js_spine_PathConstraint_spacing_get), _SE(js_spine_PathConstraint_spacing_set)); 
    cls->defineProperty("mixRotate", _SE(js_spine_PathConstraint_mixRotate_get), _SE(js_spine_PathConstraint_mixRotate_set)); 
    cls->defineProperty("mixX", _SE(js_spine_PathConstraint_mixX_get), _SE(js_spine_PathConstraint_mixX_set)); 
    cls->defineProperty("mixY", _SE(js_spine_PathConstraint_mixY_get), _SE(js_spine_PathConstraint_mixY_set)); 
    cls->defineProperty("active", _SE(js_spine_PathConstraint_active_get), _SE(js_spine_PathConstraint_active_set)); 
    
    cls->defineFunction("update", _SE(js_spine_PathConstraint_update)); 
    cls->defineFunction("getOrder", _SE(js_spine_PathConstraint_getOrder)); 
    cls->defineFunction("setToSetupPose", _SE(js_spine_PathConstraint_setToSetupPose)); 
    
    
    
    
    cls->defineFinalizeFunction(_SE(js_delete_spine_PathConstraint));
    
    
    cls->install();
    JSBClassType::registerClass<spine::PathConstraint>(cls);
    
    __jsb_spine_PathConstraint_proto = cls->getProto();
    __jsb_spine_PathConstraint_class = cls;
    se::ScriptEngine::getInstance()->clearException();
    return true;
}


se::Class* __jsb_spine_PathConstraintData_class = nullptr;
se::Object* __jsb_spine_PathConstraintData_proto = nullptr;
SE_DECLARE_FINALIZE_FUNC(js_delete_spine_PathConstraintData) 

static bool js_new_spine_PathConstraintData(se::State& s) // NOLINT(readability-identifier-naming)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    if (argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    
    spine::String *arg1 = 0 ;
    spine::String temp1 ;
    spine::PathConstraintData *result;
    
    ok &= sevalue_to_native(args[0], &temp1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg1 = &temp1;
    
    result = (spine::PathConstraintData *)new spine::PathConstraintData((spine::String const &)*arg1);
    
    
    auto *ptr = JSB_MAKE_PRIVATE_OBJECT_WITH_INSTANCE(result);
    s.thisObject()->setPrivateObject(ptr);
    return true;
}
SE_BIND_CTOR(js_new_spine_PathConstraintData, __jsb_spine_PathConstraintData_class, js_delete_spine_PathConstraintData)

static bool js_spine_PathConstraintData_bones_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::PathConstraintData *arg1 = (spine::PathConstraintData *) NULL ;
    spine::Vector< spine::BoneData * > *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::PathConstraintData>(s);
    if (nullptr == arg1) return true;
    result = (spine::Vector< spine::BoneData * > *) &spine_PathConstraintData_bones_get(arg1);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_PathConstraintData_bones_get) 

static bool js_spine_PathConstraintData_target_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::PathConstraintData *arg1 = (spine::PathConstraintData *) NULL ;
    spine::SlotData *arg2 = (spine::SlotData *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::PathConstraintData>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_PathConstraintData_target_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_PathConstraintData_target_set) 

static bool js_spine_PathConstraintData_target_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::PathConstraintData *arg1 = (spine::PathConstraintData *) NULL ;
    spine::SlotData *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::PathConstraintData>(s);
    if (nullptr == arg1) return true;
    result = (spine::SlotData *)spine_PathConstraintData_target_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_PathConstraintData_target_get) 

static bool js_spine_PathConstraintData_positionMode_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::PathConstraintData *arg1 = (spine::PathConstraintData *) NULL ;
    spine::PositionMode arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::PathConstraintData>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    spine_PathConstraintData_positionMode_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_PathConstraintData_positionMode_set) 

static bool js_spine_PathConstraintData_positionMode_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::PathConstraintData *arg1 = (spine::PathConstraintData *) NULL ;
    spine::PositionMode result;
    
    arg1 = SE_THIS_OBJECT<spine::PathConstraintData>(s);
    if (nullptr == arg1) return true;
    result = (spine::PositionMode)spine_PathConstraintData_positionMode_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject() /*ctx*/);
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval());
    
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_PathConstraintData_positionMode_get) 

static bool js_spine_PathConstraintData_spacingMode_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::PathConstraintData *arg1 = (spine::PathConstraintData *) NULL ;
    spine::SpacingMode arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::PathConstraintData>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    spine_PathConstraintData_spacingMode_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_PathConstraintData_spacingMode_set) 

static bool js_spine_PathConstraintData_spacingMode_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::PathConstraintData *arg1 = (spine::PathConstraintData *) NULL ;
    spine::SpacingMode result;
    
    arg1 = SE_THIS_OBJECT<spine::PathConstraintData>(s);
    if (nullptr == arg1) return true;
    result = (spine::SpacingMode)spine_PathConstraintData_spacingMode_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject() /*ctx*/);
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval());
    
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_PathConstraintData_spacingMode_get) 

static bool js_spine_PathConstraintData_rotateMode_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::PathConstraintData *arg1 = (spine::PathConstraintData *) NULL ;
    spine::RotateMode arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::PathConstraintData>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    spine_PathConstraintData_rotateMode_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_PathConstraintData_rotateMode_set) 

static bool js_spine_PathConstraintData_rotateMode_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::PathConstraintData *arg1 = (spine::PathConstraintData *) NULL ;
    spine::RotateMode result;
    
    arg1 = SE_THIS_OBJECT<spine::PathConstraintData>(s);
    if (nullptr == arg1) return true;
    result = (spine::RotateMode)spine_PathConstraintData_rotateMode_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject() /*ctx*/);
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval());
    
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_PathConstraintData_rotateMode_get) 

static bool js_spine_PathConstraintData_offsetRotation_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::PathConstraintData *arg1 = (spine::PathConstraintData *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::PathConstraintData>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_PathConstraintData_offsetRotation_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_PathConstraintData_offsetRotation_set) 

static bool js_spine_PathConstraintData_offsetRotation_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::PathConstraintData *arg1 = (spine::PathConstraintData *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::PathConstraintData>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_PathConstraintData_offsetRotation_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_PathConstraintData_offsetRotation_get) 

static bool js_spine_PathConstraintData_position_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::PathConstraintData *arg1 = (spine::PathConstraintData *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::PathConstraintData>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_PathConstraintData_position_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_PathConstraintData_position_set) 

static bool js_spine_PathConstraintData_position_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::PathConstraintData *arg1 = (spine::PathConstraintData *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::PathConstraintData>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_PathConstraintData_position_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_PathConstraintData_position_get) 

static bool js_spine_PathConstraintData_spacing_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::PathConstraintData *arg1 = (spine::PathConstraintData *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::PathConstraintData>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_PathConstraintData_spacing_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_PathConstraintData_spacing_set) 

static bool js_spine_PathConstraintData_spacing_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::PathConstraintData *arg1 = (spine::PathConstraintData *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::PathConstraintData>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_PathConstraintData_spacing_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_PathConstraintData_spacing_get) 

static bool js_spine_PathConstraintData_mixRotate_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::PathConstraintData *arg1 = (spine::PathConstraintData *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::PathConstraintData>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_PathConstraintData_mixRotate_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_PathConstraintData_mixRotate_set) 

static bool js_spine_PathConstraintData_mixRotate_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::PathConstraintData *arg1 = (spine::PathConstraintData *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::PathConstraintData>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_PathConstraintData_mixRotate_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_PathConstraintData_mixRotate_get) 

static bool js_spine_PathConstraintData_mixX_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::PathConstraintData *arg1 = (spine::PathConstraintData *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::PathConstraintData>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_PathConstraintData_mixX_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_PathConstraintData_mixX_set) 

static bool js_spine_PathConstraintData_mixX_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::PathConstraintData *arg1 = (spine::PathConstraintData *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::PathConstraintData>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_PathConstraintData_mixX_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_PathConstraintData_mixX_get) 

static bool js_spine_PathConstraintData_mixY_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::PathConstraintData *arg1 = (spine::PathConstraintData *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::PathConstraintData>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_PathConstraintData_mixY_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_PathConstraintData_mixY_set) 

static bool js_spine_PathConstraintData_mixY_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::PathConstraintData *arg1 = (spine::PathConstraintData *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::PathConstraintData>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_PathConstraintData_mixY_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_PathConstraintData_mixY_get) 

static bool js_delete_spine_PathConstraintData(se::State& s)
{
    return true;
}
SE_BIND_FINALIZE_FUNC(js_delete_spine_PathConstraintData) 

bool js_register_spine_PathConstraintData(se::Object* obj) {
    auto* cls = se::Class::create("PathConstraintData", obj, __jsb_spine_ConstraintData_proto, _SE(js_new_spine_PathConstraintData)); 
    
    cls->defineStaticProperty("__isJSB", se::Value(true), se::PropertyAttribute::READ_ONLY | se::PropertyAttribute::DONT_ENUM | se::PropertyAttribute::DONT_DELETE);
    cls->defineProperty("bones", _SE(js_spine_PathConstraintData_bones_get), nullptr); 
    cls->defineProperty("target", _SE(js_spine_PathConstraintData_target_get), _SE(js_spine_PathConstraintData_target_set)); 
    cls->defineProperty("positionMode", _SE(js_spine_PathConstraintData_positionMode_get), _SE(js_spine_PathConstraintData_positionMode_set)); 
    cls->defineProperty("spacingMode", _SE(js_spine_PathConstraintData_spacingMode_get), _SE(js_spine_PathConstraintData_spacingMode_set)); 
    cls->defineProperty("rotateMode", _SE(js_spine_PathConstraintData_rotateMode_get), _SE(js_spine_PathConstraintData_rotateMode_set)); 
    cls->defineProperty("offsetRotation", _SE(js_spine_PathConstraintData_offsetRotation_get), _SE(js_spine_PathConstraintData_offsetRotation_set)); 
    cls->defineProperty("position", _SE(js_spine_PathConstraintData_position_get), _SE(js_spine_PathConstraintData_position_set)); 
    cls->defineProperty("spacing", _SE(js_spine_PathConstraintData_spacing_get), _SE(js_spine_PathConstraintData_spacing_set)); 
    cls->defineProperty("mixRotate", _SE(js_spine_PathConstraintData_mixRotate_get), _SE(js_spine_PathConstraintData_mixRotate_set)); 
    cls->defineProperty("mixX", _SE(js_spine_PathConstraintData_mixX_get), _SE(js_spine_PathConstraintData_mixX_set)); 
    cls->defineProperty("mixY", _SE(js_spine_PathConstraintData_mixY_get), _SE(js_spine_PathConstraintData_mixY_set)); 
    
    
    
    
    
    cls->defineFinalizeFunction(_SE(js_delete_spine_PathConstraintData));
    
    
    cls->install();
    JSBClassType::registerClass<spine::PathConstraintData>(cls);
    
    __jsb_spine_PathConstraintData_proto = cls->getProto();
    __jsb_spine_PathConstraintData_class = cls;
    se::ScriptEngine::getInstance()->clearException();
    return true;
}


se::Class* __jsb_spine_PathConstraintMixTimeline_class = nullptr;
se::Object* __jsb_spine_PathConstraintMixTimeline_proto = nullptr;
SE_DECLARE_FINALIZE_FUNC(js_delete_spine_PathConstraintMixTimeline) 

static bool js_new_spine_PathConstraintMixTimeline(se::State& s) // NOLINT(readability-identifier-naming)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    if (argc != 3) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 3);
        return false;
    }
    
    size_t arg1 ;
    size_t arg2 ;
    int arg3 ;
    spine::PathConstraintMixTimeline *result;
    
    ok &= sevalue_to_native(args[0], &arg1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    
    
    ok &= sevalue_to_native(args[1], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    
    
    ok &= sevalue_to_native(args[2], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (spine::PathConstraintMixTimeline *)new spine::PathConstraintMixTimeline(arg1,arg2,arg3);
    
    
    auto *ptr = JSB_MAKE_PRIVATE_OBJECT_WITH_INSTANCE(result);
    s.thisObject()->setPrivateObject(ptr);
    return true;
}
SE_BIND_CTOR(js_new_spine_PathConstraintMixTimeline, __jsb_spine_PathConstraintMixTimeline_class, js_delete_spine_PathConstraintMixTimeline)

static bool js_spine_PathConstraintMixTimeline_setFrame(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::PathConstraintMixTimeline *arg1 = (spine::PathConstraintMixTimeline *) NULL ;
    int arg2 ;
    float arg3 ;
    float arg4 ;
    float arg5 ;
    float arg6 ;
    
    if(argc != 5) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 5);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::PathConstraintMixTimeline>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[1], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[2], &arg4, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[3], &arg5, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[4], &arg6, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setFrame(arg2,arg3,arg4,arg5,arg6);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_PathConstraintMixTimeline_setFrame) 

static bool js_spine_PathConstraintMixTimeline_getPathConstraintIndex(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::PathConstraintMixTimeline *arg1 = (spine::PathConstraintMixTimeline *) NULL ;
    int result;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::PathConstraintMixTimeline>(s);
    if (nullptr == arg1) return true;
    result = (int)(arg1)->getPathConstraintIndex();
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_PathConstraintMixTimeline_getPathConstraintIndex) 

static bool js_spine_PathConstraintMixTimeline_setPathConstraintIndex(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::PathConstraintMixTimeline *arg1 = (spine::PathConstraintMixTimeline *) NULL ;
    int arg2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::PathConstraintMixTimeline>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setPathConstraintIndex(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_PathConstraintMixTimeline_setPathConstraintIndex) 

static bool js_delete_spine_PathConstraintMixTimeline(se::State& s)
{
    return true;
}
SE_BIND_FINALIZE_FUNC(js_delete_spine_PathConstraintMixTimeline) 

bool js_register_spine_PathConstraintMixTimeline(se::Object* obj) {
    auto* cls = se::Class::create("PathConstraintMixTimeline", obj, __jsb_spine_CurveTimeline_proto, _SE(js_new_spine_PathConstraintMixTimeline)); 
    
    cls->defineStaticProperty("__isJSB", se::Value(true), se::PropertyAttribute::READ_ONLY | se::PropertyAttribute::DONT_ENUM | se::PropertyAttribute::DONT_DELETE);
    
    cls->defineFunction("setFrame", _SE(js_spine_PathConstraintMixTimeline_setFrame)); 
    cls->defineFunction("getPathConstraintIndex", _SE(js_spine_PathConstraintMixTimeline_getPathConstraintIndex)); 
    cls->defineFunction("setPathConstraintIndex", _SE(js_spine_PathConstraintMixTimeline_setPathConstraintIndex)); 
    
    
    
    
    cls->defineFinalizeFunction(_SE(js_delete_spine_PathConstraintMixTimeline));
    
    
    cls->install();
    JSBClassType::registerClass<spine::PathConstraintMixTimeline>(cls);
    
    __jsb_spine_PathConstraintMixTimeline_proto = cls->getProto();
    __jsb_spine_PathConstraintMixTimeline_class = cls;
    se::ScriptEngine::getInstance()->clearException();
    return true;
}


se::Class* __jsb_spine_PathConstraintPositionTimeline_class = nullptr;
se::Object* __jsb_spine_PathConstraintPositionTimeline_proto = nullptr;
SE_DECLARE_FINALIZE_FUNC(js_delete_spine_PathConstraintPositionTimeline) 

static bool js_new_spine_PathConstraintPositionTimeline(se::State& s) // NOLINT(readability-identifier-naming)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    if (argc != 3) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 3);
        return false;
    }
    
    size_t arg1 ;
    size_t arg2 ;
    int arg3 ;
    spine::PathConstraintPositionTimeline *result;
    
    ok &= sevalue_to_native(args[0], &arg1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    
    
    ok &= sevalue_to_native(args[1], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    
    
    ok &= sevalue_to_native(args[2], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (spine::PathConstraintPositionTimeline *)new spine::PathConstraintPositionTimeline(arg1,arg2,arg3);
    
    
    auto *ptr = JSB_MAKE_PRIVATE_OBJECT_WITH_INSTANCE(result);
    s.thisObject()->setPrivateObject(ptr);
    return true;
}
SE_BIND_CTOR(js_new_spine_PathConstraintPositionTimeline, __jsb_spine_PathConstraintPositionTimeline_class, js_delete_spine_PathConstraintPositionTimeline)

static bool js_delete_spine_PathConstraintPositionTimeline(se::State& s)
{
    return true;
}
SE_BIND_FINALIZE_FUNC(js_delete_spine_PathConstraintPositionTimeline) 

static bool js_spine_PathConstraintPositionTimeline_getPathConstraintIndex(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::PathConstraintPositionTimeline *arg1 = (spine::PathConstraintPositionTimeline *) NULL ;
    int result;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::PathConstraintPositionTimeline>(s);
    if (nullptr == arg1) return true;
    result = (int)(arg1)->getPathConstraintIndex();
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_PathConstraintPositionTimeline_getPathConstraintIndex) 

static bool js_spine_PathConstraintPositionTimeline_setPathConstraintIndex(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::PathConstraintPositionTimeline *arg1 = (spine::PathConstraintPositionTimeline *) NULL ;
    int arg2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::PathConstraintPositionTimeline>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setPathConstraintIndex(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_PathConstraintPositionTimeline_setPathConstraintIndex) 

bool js_register_spine_PathConstraintPositionTimeline(se::Object* obj) {
    auto* cls = se::Class::create("PathConstraintPositionTimeline", obj, __jsb_spine_CurveTimeline1_proto, _SE(js_new_spine_PathConstraintPositionTimeline)); 
    
    cls->defineStaticProperty("__isJSB", se::Value(true), se::PropertyAttribute::READ_ONLY | se::PropertyAttribute::DONT_ENUM | se::PropertyAttribute::DONT_DELETE);
    
    cls->defineFunction("getPathConstraintIndex", _SE(js_spine_PathConstraintPositionTimeline_getPathConstraintIndex)); 
    cls->defineFunction("setPathConstraintIndex", _SE(js_spine_PathConstraintPositionTimeline_setPathConstraintIndex)); 
    
    
    
    
    cls->defineFinalizeFunction(_SE(js_delete_spine_PathConstraintPositionTimeline));
    
    
    cls->install();
    JSBClassType::registerClass<spine::PathConstraintPositionTimeline>(cls);
    
    __jsb_spine_PathConstraintPositionTimeline_proto = cls->getProto();
    __jsb_spine_PathConstraintPositionTimeline_class = cls;
    se::ScriptEngine::getInstance()->clearException();
    return true;
}


se::Class* __jsb_spine_PathConstraintSpacingTimeline_class = nullptr;
se::Object* __jsb_spine_PathConstraintSpacingTimeline_proto = nullptr;
SE_DECLARE_FINALIZE_FUNC(js_delete_spine_PathConstraintSpacingTimeline) 

static bool js_new_spine_PathConstraintSpacingTimeline(se::State& s) // NOLINT(readability-identifier-naming)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    if (argc != 3) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 3);
        return false;
    }
    
    size_t arg1 ;
    size_t arg2 ;
    int arg3 ;
    spine::PathConstraintSpacingTimeline *result;
    
    ok &= sevalue_to_native(args[0], &arg1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    
    
    ok &= sevalue_to_native(args[1], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    
    
    ok &= sevalue_to_native(args[2], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (spine::PathConstraintSpacingTimeline *)new spine::PathConstraintSpacingTimeline(arg1,arg2,arg3);
    
    
    auto *ptr = JSB_MAKE_PRIVATE_OBJECT_WITH_INSTANCE(result);
    s.thisObject()->setPrivateObject(ptr);
    return true;
}
SE_BIND_CTOR(js_new_spine_PathConstraintSpacingTimeline, __jsb_spine_PathConstraintSpacingTimeline_class, js_delete_spine_PathConstraintSpacingTimeline)

static bool js_spine_PathConstraintSpacingTimeline_getPathConstraintIndex(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::PathConstraintSpacingTimeline *arg1 = (spine::PathConstraintSpacingTimeline *) NULL ;
    int result;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::PathConstraintSpacingTimeline>(s);
    if (nullptr == arg1) return true;
    result = (int)(arg1)->getPathConstraintIndex();
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_PathConstraintSpacingTimeline_getPathConstraintIndex) 

static bool js_spine_PathConstraintSpacingTimeline_setPathConstraintIndex(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::PathConstraintSpacingTimeline *arg1 = (spine::PathConstraintSpacingTimeline *) NULL ;
    int arg2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::PathConstraintSpacingTimeline>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setPathConstraintIndex(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_PathConstraintSpacingTimeline_setPathConstraintIndex) 

static bool js_delete_spine_PathConstraintSpacingTimeline(se::State& s)
{
    return true;
}
SE_BIND_FINALIZE_FUNC(js_delete_spine_PathConstraintSpacingTimeline) 

bool js_register_spine_PathConstraintSpacingTimeline(se::Object* obj) {
    auto* cls = se::Class::create("PathConstraintSpacingTimeline", obj, __jsb_spine_CurveTimeline1_proto, _SE(js_new_spine_PathConstraintSpacingTimeline)); 
    
    cls->defineStaticProperty("__isJSB", se::Value(true), se::PropertyAttribute::READ_ONLY | se::PropertyAttribute::DONT_ENUM | se::PropertyAttribute::DONT_DELETE);
    
    cls->defineFunction("getPathConstraintIndex", _SE(js_spine_PathConstraintSpacingTimeline_getPathConstraintIndex)); 
    cls->defineFunction("setPathConstraintIndex", _SE(js_spine_PathConstraintSpacingTimeline_setPathConstraintIndex)); 
    
    
    
    
    cls->defineFinalizeFunction(_SE(js_delete_spine_PathConstraintSpacingTimeline));
    
    
    cls->install();
    JSBClassType::registerClass<spine::PathConstraintSpacingTimeline>(cls);
    
    __jsb_spine_PathConstraintSpacingTimeline_proto = cls->getProto();
    __jsb_spine_PathConstraintSpacingTimeline_class = cls;
    se::ScriptEngine::getInstance()->clearException();
    return true;
}


se::Class* __jsb_spine_PointAttachment_class = nullptr;
se::Object* __jsb_spine_PointAttachment_proto = nullptr;
SE_DECLARE_FINALIZE_FUNC(js_delete_spine_PointAttachment) 

static bool js_new_spine_PointAttachment(se::State& s) // NOLINT(readability-identifier-naming)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    if (argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    
    spine::String *arg1 = 0 ;
    spine::String temp1 ;
    spine::PointAttachment *result;
    
    ok &= sevalue_to_native(args[0], &temp1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg1 = &temp1;
    
    result = (spine::PointAttachment *)new spine::PointAttachment((spine::String const &)*arg1);
    
    
    auto *ptr = JSB_MAKE_PRIVATE_OBJECT_WITH_INSTANCE(result);
    s.thisObject()->setPrivateObject(ptr);
    return true;
}
SE_BIND_CTOR(js_new_spine_PointAttachment, __jsb_spine_PointAttachment_class, js_delete_spine_PointAttachment)

static bool js_spine_PointAttachment_getColor(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::PointAttachment *arg1 = (spine::PointAttachment *) NULL ;
    spine::Color *result = 0 ;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::PointAttachment>(s);
    if (nullptr == arg1) return true;
    result = (spine::Color *) &(arg1)->getColor();
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_PointAttachment_getColor) 

static bool js_spine_PointAttachment_x_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::PointAttachment *arg1 = (spine::PointAttachment *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::PointAttachment>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_PointAttachment_x_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_PointAttachment_x_set) 

static bool js_spine_PointAttachment_x_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::PointAttachment *arg1 = (spine::PointAttachment *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::PointAttachment>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_PointAttachment_x_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_PointAttachment_x_get) 

static bool js_spine_PointAttachment_y_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::PointAttachment *arg1 = (spine::PointAttachment *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::PointAttachment>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_PointAttachment_y_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_PointAttachment_y_set) 

static bool js_spine_PointAttachment_y_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::PointAttachment *arg1 = (spine::PointAttachment *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::PointAttachment>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_PointAttachment_y_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_PointAttachment_y_get) 

static bool js_spine_PointAttachment_rotation_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::PointAttachment *arg1 = (spine::PointAttachment *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::PointAttachment>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_PointAttachment_rotation_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_PointAttachment_rotation_set) 

static bool js_spine_PointAttachment_rotation_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::PointAttachment *arg1 = (spine::PointAttachment *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::PointAttachment>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_PointAttachment_rotation_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_PointAttachment_rotation_get) 

static bool js_spine_PointAttachment_computeWorldRotation(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::PointAttachment *arg1 = (spine::PointAttachment *) NULL ;
    spine::Bone *arg2 = (spine::Bone *) NULL ;
    float result;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::PointAttachment>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (float)spine_PointAttachment_computeWorldRotation(arg1,arg2);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_PointAttachment_computeWorldRotation) 

static bool js_delete_spine_PointAttachment(se::State& s)
{
    return true;
}
SE_BIND_FINALIZE_FUNC(js_delete_spine_PointAttachment) 

bool js_register_spine_PointAttachment(se::Object* obj) {
    auto* cls = se::Class::create("PointAttachment", obj, __jsb_spine_Attachment_proto, _SE(js_new_spine_PointAttachment)); 
    
    cls->defineStaticProperty("__isJSB", se::Value(true), se::PropertyAttribute::READ_ONLY | se::PropertyAttribute::DONT_ENUM | se::PropertyAttribute::DONT_DELETE);
    cls->defineProperty("x", _SE(js_spine_PointAttachment_x_get), _SE(js_spine_PointAttachment_x_set)); 
    cls->defineProperty("y", _SE(js_spine_PointAttachment_y_get), _SE(js_spine_PointAttachment_y_set)); 
    cls->defineProperty("rotation", _SE(js_spine_PointAttachment_rotation_get), _SE(js_spine_PointAttachment_rotation_set)); 
    
    cls->defineFunction("getColor", _SE(js_spine_PointAttachment_getColor)); 
    cls->defineFunction("computeWorldRotation", _SE(js_spine_PointAttachment_computeWorldRotation)); 
    
    
    
    
    cls->defineFinalizeFunction(_SE(js_delete_spine_PointAttachment));
    
    
    cls->install();
    JSBClassType::registerClass<spine::PointAttachment>(cls);
    
    __jsb_spine_PointAttachment_proto = cls->getProto();
    __jsb_spine_PointAttachment_class = cls;
    se::ScriptEngine::getInstance()->clearException();
    return true;
}


se::Class* __jsb_spine_RegionAttachment_class = nullptr;
se::Object* __jsb_spine_RegionAttachment_proto = nullptr;
SE_DECLARE_FINALIZE_FUNC(js_delete_spine_RegionAttachment) 

static bool js_new_spine_RegionAttachment(se::State& s) // NOLINT(readability-identifier-naming)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    if (argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    
    spine::String *arg1 = 0 ;
    spine::String temp1 ;
    spine::RegionAttachment *result;
    
    ok &= sevalue_to_native(args[0], &temp1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg1 = &temp1;
    
    result = (spine::RegionAttachment *)new spine::RegionAttachment((spine::String const &)*arg1);
    
    
    auto *ptr = JSB_MAKE_PRIVATE_OBJECT_WITH_INSTANCE(result);
    s.thisObject()->setPrivateObject(ptr);
    return true;
}
SE_BIND_CTOR(js_new_spine_RegionAttachment, __jsb_spine_RegionAttachment_class, js_delete_spine_RegionAttachment)

static bool js_delete_spine_RegionAttachment(se::State& s)
{
    return true;
}
SE_BIND_FINALIZE_FUNC(js_delete_spine_RegionAttachment) 

static bool js_spine_RegionAttachment_updateRegion(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::RegionAttachment *arg1 = (spine::RegionAttachment *) NULL ;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::RegionAttachment>(s);
    if (nullptr == arg1) return true;
    (arg1)->updateRegion();
    
    
    return true;
}
SE_BIND_FUNC(js_spine_RegionAttachment_updateRegion) 

static bool js_spine_RegionAttachment_getRegion(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::RegionAttachment *arg1 = (spine::RegionAttachment *) NULL ;
    TextureRegion *result = 0 ;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::RegionAttachment>(s);
    if (nullptr == arg1) return true;
    result = (TextureRegion *)(arg1)->getRegion();
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_RegionAttachment_getRegion) 

static bool js_spine_RegionAttachment_setRegion(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::RegionAttachment *arg1 = (spine::RegionAttachment *) NULL ;
    TextureRegion *arg2 = (TextureRegion *) NULL ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::RegionAttachment>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setRegion(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_RegionAttachment_setRegion) 

static bool js_spine_RegionAttachment_getSequence(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::RegionAttachment *arg1 = (spine::RegionAttachment *) NULL ;
    Sequence *result = 0 ;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::RegionAttachment>(s);
    if (nullptr == arg1) return true;
    result = (Sequence *)(arg1)->getSequence();
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_RegionAttachment_getSequence) 

static bool js_spine_RegionAttachment_setSequence(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::RegionAttachment *arg1 = (spine::RegionAttachment *) NULL ;
    Sequence *arg2 = (Sequence *) NULL ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::RegionAttachment>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setSequence(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_RegionAttachment_setSequence) 

static bool js_spine_RegionAttachment_x_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::RegionAttachment *arg1 = (spine::RegionAttachment *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::RegionAttachment>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_RegionAttachment_x_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_RegionAttachment_x_set) 

static bool js_spine_RegionAttachment_x_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::RegionAttachment *arg1 = (spine::RegionAttachment *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::RegionAttachment>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_RegionAttachment_x_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_RegionAttachment_x_get) 

static bool js_spine_RegionAttachment_y_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::RegionAttachment *arg1 = (spine::RegionAttachment *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::RegionAttachment>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_RegionAttachment_y_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_RegionAttachment_y_set) 

static bool js_spine_RegionAttachment_y_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::RegionAttachment *arg1 = (spine::RegionAttachment *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::RegionAttachment>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_RegionAttachment_y_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_RegionAttachment_y_get) 

static bool js_spine_RegionAttachment_scaleX_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::RegionAttachment *arg1 = (spine::RegionAttachment *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::RegionAttachment>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_RegionAttachment_scaleX_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_RegionAttachment_scaleX_set) 

static bool js_spine_RegionAttachment_scaleX_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::RegionAttachment *arg1 = (spine::RegionAttachment *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::RegionAttachment>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_RegionAttachment_scaleX_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_RegionAttachment_scaleX_get) 

static bool js_spine_RegionAttachment_scaleY_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::RegionAttachment *arg1 = (spine::RegionAttachment *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::RegionAttachment>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_RegionAttachment_scaleY_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_RegionAttachment_scaleY_set) 

static bool js_spine_RegionAttachment_scaleY_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::RegionAttachment *arg1 = (spine::RegionAttachment *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::RegionAttachment>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_RegionAttachment_scaleY_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_RegionAttachment_scaleY_get) 

static bool js_spine_RegionAttachment_rotation_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::RegionAttachment *arg1 = (spine::RegionAttachment *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::RegionAttachment>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_RegionAttachment_rotation_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_RegionAttachment_rotation_set) 

static bool js_spine_RegionAttachment_rotation_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::RegionAttachment *arg1 = (spine::RegionAttachment *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::RegionAttachment>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_RegionAttachment_rotation_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_RegionAttachment_rotation_get) 

static bool js_spine_RegionAttachment_width_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::RegionAttachment *arg1 = (spine::RegionAttachment *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::RegionAttachment>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_RegionAttachment_width_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_RegionAttachment_width_set) 

static bool js_spine_RegionAttachment_width_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::RegionAttachment *arg1 = (spine::RegionAttachment *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::RegionAttachment>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_RegionAttachment_width_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_RegionAttachment_width_get) 

static bool js_spine_RegionAttachment_height_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::RegionAttachment *arg1 = (spine::RegionAttachment *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::RegionAttachment>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_RegionAttachment_height_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_RegionAttachment_height_set) 

static bool js_spine_RegionAttachment_height_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::RegionAttachment *arg1 = (spine::RegionAttachment *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::RegionAttachment>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_RegionAttachment_height_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_RegionAttachment_height_get) 

static bool js_spine_RegionAttachment_color_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::RegionAttachment *arg1 = (spine::RegionAttachment *) NULL ;
    spine::Color *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::RegionAttachment>(s);
    if (nullptr == arg1) return true;
    result = (spine::Color *) &spine_RegionAttachment_color_get(arg1);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_RegionAttachment_color_get) 

static bool js_spine_RegionAttachment_path_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::RegionAttachment *arg1 = (spine::RegionAttachment *) NULL ;
    spine::String *arg2 = 0 ;
    spine::String temp2 ;
    
    arg1 = SE_THIS_OBJECT<spine::RegionAttachment>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    spine_RegionAttachment_path_set(arg1,*arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_RegionAttachment_path_set) 

static bool js_spine_RegionAttachment_path_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::RegionAttachment *arg1 = (spine::RegionAttachment *) NULL ;
    spine::String *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::RegionAttachment>(s);
    if (nullptr == arg1) return true;
    result = (spine::String *) &spine_RegionAttachment_path_get(arg1);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_RegionAttachment_path_get) 

static bool js_spine_RegionAttachment_offset_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::RegionAttachment *arg1 = (spine::RegionAttachment *) NULL ;
    spine::Vector< float > *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::RegionAttachment>(s);
    if (nullptr == arg1) return true;
    result = (spine::Vector< float > *) &spine_RegionAttachment_offset_get(arg1);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_RegionAttachment_offset_get) 

static bool js_spine_RegionAttachment_uvs_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::RegionAttachment *arg1 = (spine::RegionAttachment *) NULL ;
    spine::Vector< float > *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::RegionAttachment>(s);
    if (nullptr == arg1) return true;
    result = (spine::Vector< float > *) &spine_RegionAttachment_uvs_get(arg1);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_RegionAttachment_uvs_get) 

bool js_register_spine_RegionAttachment(se::Object* obj) {
    auto* cls = se::Class::create("RegionAttachment", obj, __jsb_spine_Attachment_proto, _SE(js_new_spine_RegionAttachment)); 
    
    cls->defineStaticProperty("__isJSB", se::Value(true), se::PropertyAttribute::READ_ONLY | se::PropertyAttribute::DONT_ENUM | se::PropertyAttribute::DONT_DELETE);
    cls->defineProperty("x", _SE(js_spine_RegionAttachment_x_get), _SE(js_spine_RegionAttachment_x_set)); 
    cls->defineProperty("y", _SE(js_spine_RegionAttachment_y_get), _SE(js_spine_RegionAttachment_y_set)); 
    cls->defineProperty("scaleX", _SE(js_spine_RegionAttachment_scaleX_get), _SE(js_spine_RegionAttachment_scaleX_set)); 
    cls->defineProperty("scaleY", _SE(js_spine_RegionAttachment_scaleY_get), _SE(js_spine_RegionAttachment_scaleY_set)); 
    cls->defineProperty("rotation", _SE(js_spine_RegionAttachment_rotation_get), _SE(js_spine_RegionAttachment_rotation_set)); 
    cls->defineProperty("width", _SE(js_spine_RegionAttachment_width_get), _SE(js_spine_RegionAttachment_width_set)); 
    cls->defineProperty("height", _SE(js_spine_RegionAttachment_height_get), _SE(js_spine_RegionAttachment_height_set)); 
    cls->defineProperty("color", _SE(js_spine_RegionAttachment_color_get), nullptr); 
    cls->defineProperty("path", _SE(js_spine_RegionAttachment_path_get), _SE(js_spine_RegionAttachment_path_set)); 
    cls->defineProperty("offset", _SE(js_spine_RegionAttachment_offset_get), nullptr); 
    cls->defineProperty("uvs", _SE(js_spine_RegionAttachment_uvs_get), nullptr); 
    
    cls->defineFunction("updateRegion", _SE(js_spine_RegionAttachment_updateRegion)); 
    cls->defineFunction("getRegion", _SE(js_spine_RegionAttachment_getRegion)); 
    cls->defineFunction("setRegion", _SE(js_spine_RegionAttachment_setRegion)); 
    cls->defineFunction("getSequence", _SE(js_spine_RegionAttachment_getSequence)); 
    cls->defineFunction("setSequence", _SE(js_spine_RegionAttachment_setSequence)); 
    
    
    
    
    cls->defineFinalizeFunction(_SE(js_delete_spine_RegionAttachment));
    
    
    cls->install();
    JSBClassType::registerClass<spine::RegionAttachment>(cls);
    
    __jsb_spine_RegionAttachment_proto = cls->getProto();
    __jsb_spine_RegionAttachment_class = cls;
    se::ScriptEngine::getInstance()->clearException();
    return true;
}


se::Class* __jsb_spine_TranslateTimeline_class = nullptr;
se::Object* __jsb_spine_TranslateTimeline_proto = nullptr;
SE_DECLARE_FINALIZE_FUNC(js_delete_spine_TranslateTimeline) 

static bool js_new_spine_TranslateTimeline(se::State& s) // NOLINT(readability-identifier-naming)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    if (argc != 3) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 3);
        return false;
    }
    
    size_t arg1 ;
    size_t arg2 ;
    int arg3 ;
    spine::TranslateTimeline *result;
    
    ok &= sevalue_to_native(args[0], &arg1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    
    
    ok &= sevalue_to_native(args[1], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    
    
    ok &= sevalue_to_native(args[2], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (spine::TranslateTimeline *)new spine::TranslateTimeline(arg1,arg2,arg3);
    
    
    auto *ptr = JSB_MAKE_PRIVATE_OBJECT_WITH_INSTANCE(result);
    s.thisObject()->setPrivateObject(ptr);
    return true;
}
SE_BIND_CTOR(js_new_spine_TranslateTimeline, __jsb_spine_TranslateTimeline_class, js_delete_spine_TranslateTimeline)

static bool js_delete_spine_TranslateTimeline(se::State& s)
{
    return true;
}
SE_BIND_FINALIZE_FUNC(js_delete_spine_TranslateTimeline) 

static bool js_spine_TranslateTimeline_getBoneIndex(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::TranslateTimeline *arg1 = (spine::TranslateTimeline *) NULL ;
    int result;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::TranslateTimeline>(s);
    if (nullptr == arg1) return true;
    result = (int)(arg1)->getBoneIndex();
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_TranslateTimeline_getBoneIndex) 

static bool js_spine_TranslateTimeline_setBoneIndex(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::TranslateTimeline *arg1 = (spine::TranslateTimeline *) NULL ;
    int arg2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::TranslateTimeline>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setBoneIndex(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_TranslateTimeline_setBoneIndex) 

bool js_register_spine_TranslateTimeline(se::Object* obj) {
    auto* cls = se::Class::create("TranslateTimeline", obj, __jsb_spine_CurveTimeline2_proto, _SE(js_new_spine_TranslateTimeline)); 
    
    cls->defineStaticProperty("__isJSB", se::Value(true), se::PropertyAttribute::READ_ONLY | se::PropertyAttribute::DONT_ENUM | se::PropertyAttribute::DONT_DELETE);
    
    cls->defineFunction("getBoneIndex", _SE(js_spine_TranslateTimeline_getBoneIndex)); 
    cls->defineFunction("setBoneIndex", _SE(js_spine_TranslateTimeline_setBoneIndex)); 
    
    
    
    
    cls->defineFinalizeFunction(_SE(js_delete_spine_TranslateTimeline));
    
    
    cls->install();
    JSBClassType::registerClass<spine::TranslateTimeline>(cls);
    
    __jsb_spine_TranslateTimeline_proto = cls->getProto();
    __jsb_spine_TranslateTimeline_class = cls;
    se::ScriptEngine::getInstance()->clearException();
    return true;
}


se::Class* __jsb_spine_TranslateXTimeline_class = nullptr;
se::Object* __jsb_spine_TranslateXTimeline_proto = nullptr;
SE_DECLARE_FINALIZE_FUNC(js_delete_spine_TranslateXTimeline) 

static bool js_new_spine_TranslateXTimeline(se::State& s) // NOLINT(readability-identifier-naming)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    if (argc != 3) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 3);
        return false;
    }
    
    size_t arg1 ;
    size_t arg2 ;
    int arg3 ;
    spine::TranslateXTimeline *result;
    
    ok &= sevalue_to_native(args[0], &arg1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    
    
    ok &= sevalue_to_native(args[1], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    
    
    ok &= sevalue_to_native(args[2], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (spine::TranslateXTimeline *)new spine::TranslateXTimeline(arg1,arg2,arg3);
    
    
    auto *ptr = JSB_MAKE_PRIVATE_OBJECT_WITH_INSTANCE(result);
    s.thisObject()->setPrivateObject(ptr);
    return true;
}
SE_BIND_CTOR(js_new_spine_TranslateXTimeline, __jsb_spine_TranslateXTimeline_class, js_delete_spine_TranslateXTimeline)

static bool js_delete_spine_TranslateXTimeline(se::State& s)
{
    return true;
}
SE_BIND_FINALIZE_FUNC(js_delete_spine_TranslateXTimeline) 

static bool js_spine_TranslateXTimeline_getBoneIndex(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::TranslateXTimeline *arg1 = (spine::TranslateXTimeline *) NULL ;
    int result;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::TranslateXTimeline>(s);
    if (nullptr == arg1) return true;
    result = (int)(arg1)->getBoneIndex();
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_TranslateXTimeline_getBoneIndex) 

static bool js_spine_TranslateXTimeline_setBoneIndex(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::TranslateXTimeline *arg1 = (spine::TranslateXTimeline *) NULL ;
    int arg2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::TranslateXTimeline>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setBoneIndex(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_TranslateXTimeline_setBoneIndex) 

bool js_register_spine_TranslateXTimeline(se::Object* obj) {
    auto* cls = se::Class::create("TranslateXTimeline", obj, __jsb_spine_CurveTimeline1_proto, _SE(js_new_spine_TranslateXTimeline)); 
    
    cls->defineStaticProperty("__isJSB", se::Value(true), se::PropertyAttribute::READ_ONLY | se::PropertyAttribute::DONT_ENUM | se::PropertyAttribute::DONT_DELETE);
    
    cls->defineFunction("getBoneIndex", _SE(js_spine_TranslateXTimeline_getBoneIndex)); 
    cls->defineFunction("setBoneIndex", _SE(js_spine_TranslateXTimeline_setBoneIndex)); 
    
    
    
    
    cls->defineFinalizeFunction(_SE(js_delete_spine_TranslateXTimeline));
    
    
    cls->install();
    JSBClassType::registerClass<spine::TranslateXTimeline>(cls);
    
    __jsb_spine_TranslateXTimeline_proto = cls->getProto();
    __jsb_spine_TranslateXTimeline_class = cls;
    se::ScriptEngine::getInstance()->clearException();
    return true;
}


se::Class* __jsb_spine_TranslateYTimeline_class = nullptr;
se::Object* __jsb_spine_TranslateYTimeline_proto = nullptr;
SE_DECLARE_FINALIZE_FUNC(js_delete_spine_TranslateYTimeline) 

static bool js_new_spine_TranslateYTimeline(se::State& s) // NOLINT(readability-identifier-naming)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    if (argc != 3) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 3);
        return false;
    }
    
    size_t arg1 ;
    size_t arg2 ;
    int arg3 ;
    spine::TranslateYTimeline *result;
    
    ok &= sevalue_to_native(args[0], &arg1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    
    
    ok &= sevalue_to_native(args[1], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    
    
    ok &= sevalue_to_native(args[2], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (spine::TranslateYTimeline *)new spine::TranslateYTimeline(arg1,arg2,arg3);
    
    
    auto *ptr = JSB_MAKE_PRIVATE_OBJECT_WITH_INSTANCE(result);
    s.thisObject()->setPrivateObject(ptr);
    return true;
}
SE_BIND_CTOR(js_new_spine_TranslateYTimeline, __jsb_spine_TranslateYTimeline_class, js_delete_spine_TranslateYTimeline)

static bool js_delete_spine_TranslateYTimeline(se::State& s)
{
    return true;
}
SE_BIND_FINALIZE_FUNC(js_delete_spine_TranslateYTimeline) 

static bool js_spine_TranslateYTimeline_getBoneIndex(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::TranslateYTimeline *arg1 = (spine::TranslateYTimeline *) NULL ;
    int result;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::TranslateYTimeline>(s);
    if (nullptr == arg1) return true;
    result = (int)(arg1)->getBoneIndex();
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_TranslateYTimeline_getBoneIndex) 

static bool js_spine_TranslateYTimeline_setBoneIndex(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::TranslateYTimeline *arg1 = (spine::TranslateYTimeline *) NULL ;
    int arg2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::TranslateYTimeline>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setBoneIndex(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_TranslateYTimeline_setBoneIndex) 

bool js_register_spine_TranslateYTimeline(se::Object* obj) {
    auto* cls = se::Class::create("TranslateYTimeline", obj, __jsb_spine_CurveTimeline1_proto, _SE(js_new_spine_TranslateYTimeline)); 
    
    cls->defineStaticProperty("__isJSB", se::Value(true), se::PropertyAttribute::READ_ONLY | se::PropertyAttribute::DONT_ENUM | se::PropertyAttribute::DONT_DELETE);
    
    cls->defineFunction("getBoneIndex", _SE(js_spine_TranslateYTimeline_getBoneIndex)); 
    cls->defineFunction("setBoneIndex", _SE(js_spine_TranslateYTimeline_setBoneIndex)); 
    
    
    
    
    cls->defineFinalizeFunction(_SE(js_delete_spine_TranslateYTimeline));
    
    
    cls->install();
    JSBClassType::registerClass<spine::TranslateYTimeline>(cls);
    
    __jsb_spine_TranslateYTimeline_proto = cls->getProto();
    __jsb_spine_TranslateYTimeline_class = cls;
    se::ScriptEngine::getInstance()->clearException();
    return true;
}


se::Class* __jsb_spine_RotateTimeline_class = nullptr;
se::Object* __jsb_spine_RotateTimeline_proto = nullptr;
SE_DECLARE_FINALIZE_FUNC(js_delete_spine_RotateTimeline) 

static bool js_new_spine_RotateTimeline(se::State& s) // NOLINT(readability-identifier-naming)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    if (argc != 3) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 3);
        return false;
    }
    
    size_t arg1 ;
    size_t arg2 ;
    int arg3 ;
    spine::RotateTimeline *result;
    
    ok &= sevalue_to_native(args[0], &arg1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    
    
    ok &= sevalue_to_native(args[1], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    
    
    ok &= sevalue_to_native(args[2], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (spine::RotateTimeline *)new spine::RotateTimeline(arg1,arg2,arg3);
    
    
    auto *ptr = JSB_MAKE_PRIVATE_OBJECT_WITH_INSTANCE(result);
    s.thisObject()->setPrivateObject(ptr);
    return true;
}
SE_BIND_CTOR(js_new_spine_RotateTimeline, __jsb_spine_RotateTimeline_class, js_delete_spine_RotateTimeline)

static bool js_spine_RotateTimeline_boneIndex_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::RotateTimeline *arg1 = (spine::RotateTimeline *) NULL ;
    int arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::RotateTimeline>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_RotateTimeline_boneIndex_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_RotateTimeline_boneIndex_set) 

static bool js_spine_RotateTimeline_boneIndex_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::RotateTimeline *arg1 = (spine::RotateTimeline *) NULL ;
    int result;
    
    arg1 = SE_THIS_OBJECT<spine::RotateTimeline>(s);
    if (nullptr == arg1) return true;
    result = (int)spine_RotateTimeline_boneIndex_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_RotateTimeline_boneIndex_get) 

static bool js_spine_RotateTimeline_frames_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::RotateTimeline *arg1 = (spine::RotateTimeline *) NULL ;
    spine::Vector< float > *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::RotateTimeline>(s);
    if (nullptr == arg1) return true;
    result = (spine::Vector< float > *) &spine_RotateTimeline_frames_get(arg1);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_RotateTimeline_frames_get) 

static bool js_delete_spine_RotateTimeline(se::State& s)
{
    return true;
}
SE_BIND_FINALIZE_FUNC(js_delete_spine_RotateTimeline) 

bool js_register_spine_RotateTimeline(se::Object* obj) {
    auto* cls = se::Class::create("RotateTimeline", obj, __jsb_spine_CurveTimeline1_proto, _SE(js_new_spine_RotateTimeline)); 
    
    cls->defineStaticProperty("__isJSB", se::Value(true), se::PropertyAttribute::READ_ONLY | se::PropertyAttribute::DONT_ENUM | se::PropertyAttribute::DONT_DELETE);
    cls->defineProperty("boneIndex", _SE(js_spine_RotateTimeline_boneIndex_get), _SE(js_spine_RotateTimeline_boneIndex_set)); 
    cls->defineProperty("frames", _SE(js_spine_RotateTimeline_frames_get), nullptr); 
    
    
    
    
    
    cls->defineFinalizeFunction(_SE(js_delete_spine_RotateTimeline));
    
    
    cls->install();
    JSBClassType::registerClass<spine::RotateTimeline>(cls);
    
    __jsb_spine_RotateTimeline_proto = cls->getProto();
    __jsb_spine_RotateTimeline_class = cls;
    se::ScriptEngine::getInstance()->clearException();
    return true;
}


se::Class* __jsb_spine_ScaleTimeline_class = nullptr;
se::Object* __jsb_spine_ScaleTimeline_proto = nullptr;
SE_DECLARE_FINALIZE_FUNC(js_delete_spine_ScaleTimeline) 

static bool js_new_spine_ScaleTimeline(se::State& s) // NOLINT(readability-identifier-naming)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    if (argc != 3) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 3);
        return false;
    }
    
    size_t arg1 ;
    size_t arg2 ;
    int arg3 ;
    spine::ScaleTimeline *result;
    
    ok &= sevalue_to_native(args[0], &arg1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    
    
    ok &= sevalue_to_native(args[1], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    
    
    ok &= sevalue_to_native(args[2], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (spine::ScaleTimeline *)new spine::ScaleTimeline(arg1,arg2,arg3);
    
    
    auto *ptr = JSB_MAKE_PRIVATE_OBJECT_WITH_INSTANCE(result);
    s.thisObject()->setPrivateObject(ptr);
    return true;
}
SE_BIND_CTOR(js_new_spine_ScaleTimeline, __jsb_spine_ScaleTimeline_class, js_delete_spine_ScaleTimeline)

static bool js_delete_spine_ScaleTimeline(se::State& s)
{
    return true;
}
SE_BIND_FINALIZE_FUNC(js_delete_spine_ScaleTimeline) 

static bool js_spine_ScaleTimeline_getBoneIndex(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::ScaleTimeline *arg1 = (spine::ScaleTimeline *) NULL ;
    int result;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::ScaleTimeline>(s);
    if (nullptr == arg1) return true;
    result = (int)(arg1)->getBoneIndex();
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_ScaleTimeline_getBoneIndex) 

static bool js_spine_ScaleTimeline_setBoneIndex(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::ScaleTimeline *arg1 = (spine::ScaleTimeline *) NULL ;
    int arg2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::ScaleTimeline>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setBoneIndex(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_ScaleTimeline_setBoneIndex) 

bool js_register_spine_ScaleTimeline(se::Object* obj) {
    auto* cls = se::Class::create("ScaleTimeline", obj, __jsb_spine_CurveTimeline2_proto, _SE(js_new_spine_ScaleTimeline)); 
    
    cls->defineStaticProperty("__isJSB", se::Value(true), se::PropertyAttribute::READ_ONLY | se::PropertyAttribute::DONT_ENUM | se::PropertyAttribute::DONT_DELETE);
    
    cls->defineFunction("getBoneIndex", _SE(js_spine_ScaleTimeline_getBoneIndex)); 
    cls->defineFunction("setBoneIndex", _SE(js_spine_ScaleTimeline_setBoneIndex)); 
    
    
    
    
    cls->defineFinalizeFunction(_SE(js_delete_spine_ScaleTimeline));
    
    
    cls->install();
    JSBClassType::registerClass<spine::ScaleTimeline>(cls);
    
    __jsb_spine_ScaleTimeline_proto = cls->getProto();
    __jsb_spine_ScaleTimeline_class = cls;
    se::ScriptEngine::getInstance()->clearException();
    return true;
}


se::Class* __jsb_spine_ScaleXTimeline_class = nullptr;
se::Object* __jsb_spine_ScaleXTimeline_proto = nullptr;
SE_DECLARE_FINALIZE_FUNC(js_delete_spine_ScaleXTimeline) 

static bool js_new_spine_ScaleXTimeline(se::State& s) // NOLINT(readability-identifier-naming)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    if (argc != 3) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 3);
        return false;
    }
    
    size_t arg1 ;
    size_t arg2 ;
    int arg3 ;
    spine::ScaleXTimeline *result;
    
    ok &= sevalue_to_native(args[0], &arg1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    
    
    ok &= sevalue_to_native(args[1], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    
    
    ok &= sevalue_to_native(args[2], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (spine::ScaleXTimeline *)new spine::ScaleXTimeline(arg1,arg2,arg3);
    
    
    auto *ptr = JSB_MAKE_PRIVATE_OBJECT_WITH_INSTANCE(result);
    s.thisObject()->setPrivateObject(ptr);
    return true;
}
SE_BIND_CTOR(js_new_spine_ScaleXTimeline, __jsb_spine_ScaleXTimeline_class, js_delete_spine_ScaleXTimeline)

static bool js_delete_spine_ScaleXTimeline(se::State& s)
{
    return true;
}
SE_BIND_FINALIZE_FUNC(js_delete_spine_ScaleXTimeline) 

static bool js_spine_ScaleXTimeline_getBoneIndex(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::ScaleXTimeline *arg1 = (spine::ScaleXTimeline *) NULL ;
    int result;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::ScaleXTimeline>(s);
    if (nullptr == arg1) return true;
    result = (int)(arg1)->getBoneIndex();
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_ScaleXTimeline_getBoneIndex) 

static bool js_spine_ScaleXTimeline_setBoneIndex(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::ScaleXTimeline *arg1 = (spine::ScaleXTimeline *) NULL ;
    int arg2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::ScaleXTimeline>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setBoneIndex(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_ScaleXTimeline_setBoneIndex) 

bool js_register_spine_ScaleXTimeline(se::Object* obj) {
    auto* cls = se::Class::create("ScaleXTimeline", obj, __jsb_spine_CurveTimeline1_proto, _SE(js_new_spine_ScaleXTimeline)); 
    
    cls->defineStaticProperty("__isJSB", se::Value(true), se::PropertyAttribute::READ_ONLY | se::PropertyAttribute::DONT_ENUM | se::PropertyAttribute::DONT_DELETE);
    
    cls->defineFunction("getBoneIndex", _SE(js_spine_ScaleXTimeline_getBoneIndex)); 
    cls->defineFunction("setBoneIndex", _SE(js_spine_ScaleXTimeline_setBoneIndex)); 
    
    
    
    
    cls->defineFinalizeFunction(_SE(js_delete_spine_ScaleXTimeline));
    
    
    cls->install();
    JSBClassType::registerClass<spine::ScaleXTimeline>(cls);
    
    __jsb_spine_ScaleXTimeline_proto = cls->getProto();
    __jsb_spine_ScaleXTimeline_class = cls;
    se::ScriptEngine::getInstance()->clearException();
    return true;
}


se::Class* __jsb_spine_ScaleYTimeline_class = nullptr;
se::Object* __jsb_spine_ScaleYTimeline_proto = nullptr;
SE_DECLARE_FINALIZE_FUNC(js_delete_spine_ScaleYTimeline) 

static bool js_new_spine_ScaleYTimeline(se::State& s) // NOLINT(readability-identifier-naming)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    if (argc != 3) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 3);
        return false;
    }
    
    size_t arg1 ;
    size_t arg2 ;
    int arg3 ;
    spine::ScaleYTimeline *result;
    
    ok &= sevalue_to_native(args[0], &arg1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    
    
    ok &= sevalue_to_native(args[1], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    
    
    ok &= sevalue_to_native(args[2], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (spine::ScaleYTimeline *)new spine::ScaleYTimeline(arg1,arg2,arg3);
    
    
    auto *ptr = JSB_MAKE_PRIVATE_OBJECT_WITH_INSTANCE(result);
    s.thisObject()->setPrivateObject(ptr);
    return true;
}
SE_BIND_CTOR(js_new_spine_ScaleYTimeline, __jsb_spine_ScaleYTimeline_class, js_delete_spine_ScaleYTimeline)

static bool js_delete_spine_ScaleYTimeline(se::State& s)
{
    return true;
}
SE_BIND_FINALIZE_FUNC(js_delete_spine_ScaleYTimeline) 

static bool js_spine_ScaleYTimeline_getBoneIndex(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::ScaleYTimeline *arg1 = (spine::ScaleYTimeline *) NULL ;
    int result;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::ScaleYTimeline>(s);
    if (nullptr == arg1) return true;
    result = (int)(arg1)->getBoneIndex();
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_ScaleYTimeline_getBoneIndex) 

static bool js_spine_ScaleYTimeline_setBoneIndex(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::ScaleYTimeline *arg1 = (spine::ScaleYTimeline *) NULL ;
    int arg2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::ScaleYTimeline>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setBoneIndex(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_ScaleYTimeline_setBoneIndex) 

bool js_register_spine_ScaleYTimeline(se::Object* obj) {
    auto* cls = se::Class::create("ScaleYTimeline", obj, __jsb_spine_CurveTimeline1_proto, _SE(js_new_spine_ScaleYTimeline)); 
    
    cls->defineStaticProperty("__isJSB", se::Value(true), se::PropertyAttribute::READ_ONLY | se::PropertyAttribute::DONT_ENUM | se::PropertyAttribute::DONT_DELETE);
    
    cls->defineFunction("getBoneIndex", _SE(js_spine_ScaleYTimeline_getBoneIndex)); 
    cls->defineFunction("setBoneIndex", _SE(js_spine_ScaleYTimeline_setBoneIndex)); 
    
    
    
    
    cls->defineFinalizeFunction(_SE(js_delete_spine_ScaleYTimeline));
    
    
    cls->install();
    JSBClassType::registerClass<spine::ScaleYTimeline>(cls);
    
    __jsb_spine_ScaleYTimeline_proto = cls->getProto();
    __jsb_spine_ScaleYTimeline_class = cls;
    se::ScriptEngine::getInstance()->clearException();
    return true;
}


se::Class* __jsb_spine_ShearTimeline_class = nullptr;
se::Object* __jsb_spine_ShearTimeline_proto = nullptr;
SE_DECLARE_FINALIZE_FUNC(js_delete_spine_ShearTimeline) 

static bool js_new_spine_ShearTimeline(se::State& s) // NOLINT(readability-identifier-naming)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    if (argc != 3) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 3);
        return false;
    }
    
    size_t arg1 ;
    size_t arg2 ;
    int arg3 ;
    spine::ShearTimeline *result;
    
    ok &= sevalue_to_native(args[0], &arg1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    
    
    ok &= sevalue_to_native(args[1], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    
    
    ok &= sevalue_to_native(args[2], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (spine::ShearTimeline *)new spine::ShearTimeline(arg1,arg2,arg3);
    
    
    auto *ptr = JSB_MAKE_PRIVATE_OBJECT_WITH_INSTANCE(result);
    s.thisObject()->setPrivateObject(ptr);
    return true;
}
SE_BIND_CTOR(js_new_spine_ShearTimeline, __jsb_spine_ShearTimeline_class, js_delete_spine_ShearTimeline)

static bool js_delete_spine_ShearTimeline(se::State& s)
{
    return true;
}
SE_BIND_FINALIZE_FUNC(js_delete_spine_ShearTimeline) 

static bool js_spine_ShearTimeline_getBoneIndex(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::ShearTimeline *arg1 = (spine::ShearTimeline *) NULL ;
    int result;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::ShearTimeline>(s);
    if (nullptr == arg1) return true;
    result = (int)(arg1)->getBoneIndex();
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_ShearTimeline_getBoneIndex) 

static bool js_spine_ShearTimeline_setBoneIndex(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::ShearTimeline *arg1 = (spine::ShearTimeline *) NULL ;
    int arg2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::ShearTimeline>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setBoneIndex(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_ShearTimeline_setBoneIndex) 

bool js_register_spine_ShearTimeline(se::Object* obj) {
    auto* cls = se::Class::create("ShearTimeline", obj, __jsb_spine_CurveTimeline2_proto, _SE(js_new_spine_ShearTimeline)); 
    
    cls->defineStaticProperty("__isJSB", se::Value(true), se::PropertyAttribute::READ_ONLY | se::PropertyAttribute::DONT_ENUM | se::PropertyAttribute::DONT_DELETE);
    
    cls->defineFunction("getBoneIndex", _SE(js_spine_ShearTimeline_getBoneIndex)); 
    cls->defineFunction("setBoneIndex", _SE(js_spine_ShearTimeline_setBoneIndex)); 
    
    
    
    
    cls->defineFinalizeFunction(_SE(js_delete_spine_ShearTimeline));
    
    
    cls->install();
    JSBClassType::registerClass<spine::ShearTimeline>(cls);
    
    __jsb_spine_ShearTimeline_proto = cls->getProto();
    __jsb_spine_ShearTimeline_class = cls;
    se::ScriptEngine::getInstance()->clearException();
    return true;
}


se::Class* __jsb_spine_ShearXTimeline_class = nullptr;
se::Object* __jsb_spine_ShearXTimeline_proto = nullptr;
SE_DECLARE_FINALIZE_FUNC(js_delete_spine_ShearXTimeline) 

static bool js_new_spine_ShearXTimeline(se::State& s) // NOLINT(readability-identifier-naming)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    if (argc != 3) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 3);
        return false;
    }
    
    size_t arg1 ;
    size_t arg2 ;
    int arg3 ;
    spine::ShearXTimeline *result;
    
    ok &= sevalue_to_native(args[0], &arg1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    
    
    ok &= sevalue_to_native(args[1], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    
    
    ok &= sevalue_to_native(args[2], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (spine::ShearXTimeline *)new spine::ShearXTimeline(arg1,arg2,arg3);
    
    
    auto *ptr = JSB_MAKE_PRIVATE_OBJECT_WITH_INSTANCE(result);
    s.thisObject()->setPrivateObject(ptr);
    return true;
}
SE_BIND_CTOR(js_new_spine_ShearXTimeline, __jsb_spine_ShearXTimeline_class, js_delete_spine_ShearXTimeline)

static bool js_delete_spine_ShearXTimeline(se::State& s)
{
    return true;
}
SE_BIND_FINALIZE_FUNC(js_delete_spine_ShearXTimeline) 

static bool js_spine_ShearXTimeline_getBoneIndex(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::ShearXTimeline *arg1 = (spine::ShearXTimeline *) NULL ;
    int result;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::ShearXTimeline>(s);
    if (nullptr == arg1) return true;
    result = (int)(arg1)->getBoneIndex();
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_ShearXTimeline_getBoneIndex) 

static bool js_spine_ShearXTimeline_setBoneIndex(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::ShearXTimeline *arg1 = (spine::ShearXTimeline *) NULL ;
    int arg2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::ShearXTimeline>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setBoneIndex(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_ShearXTimeline_setBoneIndex) 

bool js_register_spine_ShearXTimeline(se::Object* obj) {
    auto* cls = se::Class::create("ShearXTimeline", obj, __jsb_spine_CurveTimeline1_proto, _SE(js_new_spine_ShearXTimeline)); 
    
    cls->defineStaticProperty("__isJSB", se::Value(true), se::PropertyAttribute::READ_ONLY | se::PropertyAttribute::DONT_ENUM | se::PropertyAttribute::DONT_DELETE);
    
    cls->defineFunction("getBoneIndex", _SE(js_spine_ShearXTimeline_getBoneIndex)); 
    cls->defineFunction("setBoneIndex", _SE(js_spine_ShearXTimeline_setBoneIndex)); 
    
    
    
    
    cls->defineFinalizeFunction(_SE(js_delete_spine_ShearXTimeline));
    
    
    cls->install();
    JSBClassType::registerClass<spine::ShearXTimeline>(cls);
    
    __jsb_spine_ShearXTimeline_proto = cls->getProto();
    __jsb_spine_ShearXTimeline_class = cls;
    se::ScriptEngine::getInstance()->clearException();
    return true;
}


se::Class* __jsb_spine_ShearYTimeline_class = nullptr;
se::Object* __jsb_spine_ShearYTimeline_proto = nullptr;
SE_DECLARE_FINALIZE_FUNC(js_delete_spine_ShearYTimeline) 

static bool js_new_spine_ShearYTimeline(se::State& s) // NOLINT(readability-identifier-naming)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    if (argc != 3) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 3);
        return false;
    }
    
    size_t arg1 ;
    size_t arg2 ;
    int arg3 ;
    spine::ShearYTimeline *result;
    
    ok &= sevalue_to_native(args[0], &arg1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    
    
    ok &= sevalue_to_native(args[1], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    
    
    ok &= sevalue_to_native(args[2], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (spine::ShearYTimeline *)new spine::ShearYTimeline(arg1,arg2,arg3);
    
    
    auto *ptr = JSB_MAKE_PRIVATE_OBJECT_WITH_INSTANCE(result);
    s.thisObject()->setPrivateObject(ptr);
    return true;
}
SE_BIND_CTOR(js_new_spine_ShearYTimeline, __jsb_spine_ShearYTimeline_class, js_delete_spine_ShearYTimeline)

static bool js_delete_spine_ShearYTimeline(se::State& s)
{
    return true;
}
SE_BIND_FINALIZE_FUNC(js_delete_spine_ShearYTimeline) 

static bool js_spine_ShearYTimeline_getBoneIndex(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::ShearYTimeline *arg1 = (spine::ShearYTimeline *) NULL ;
    int result;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::ShearYTimeline>(s);
    if (nullptr == arg1) return true;
    result = (int)(arg1)->getBoneIndex();
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_ShearYTimeline_getBoneIndex) 

static bool js_spine_ShearYTimeline_setBoneIndex(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::ShearYTimeline *arg1 = (spine::ShearYTimeline *) NULL ;
    int arg2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::ShearYTimeline>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setBoneIndex(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_ShearYTimeline_setBoneIndex) 

bool js_register_spine_ShearYTimeline(se::Object* obj) {
    auto* cls = se::Class::create("ShearYTimeline", obj, __jsb_spine_CurveTimeline1_proto, _SE(js_new_spine_ShearYTimeline)); 
    
    cls->defineStaticProperty("__isJSB", se::Value(true), se::PropertyAttribute::READ_ONLY | se::PropertyAttribute::DONT_ENUM | se::PropertyAttribute::DONT_DELETE);
    
    cls->defineFunction("getBoneIndex", _SE(js_spine_ShearYTimeline_getBoneIndex)); 
    cls->defineFunction("setBoneIndex", _SE(js_spine_ShearYTimeline_setBoneIndex)); 
    
    
    
    
    cls->defineFinalizeFunction(_SE(js_delete_spine_ShearYTimeline));
    
    
    cls->install();
    JSBClassType::registerClass<spine::ShearYTimeline>(cls);
    
    __jsb_spine_ShearYTimeline_proto = cls->getProto();
    __jsb_spine_ShearYTimeline_class = cls;
    se::ScriptEngine::getInstance()->clearException();
    return true;
}


se::Class* __jsb_spine_Skeleton_class = nullptr;
se::Object* __jsb_spine_Skeleton_proto = nullptr;
SE_DECLARE_FINALIZE_FUNC(js_delete_spine_Skeleton) 

static bool js_new_spine_Skeleton(se::State& s) // NOLINT(readability-identifier-naming)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    if (argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    
    spine::SkeletonData *arg1 = (spine::SkeletonData *) NULL ;
    spine::Skeleton *result;
    
    ok &= sevalue_to_native(args[0], &arg1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (spine::Skeleton *)new spine::Skeleton(arg1);
    
    
    auto *ptr = JSB_MAKE_PRIVATE_OBJECT_WITH_INSTANCE(result);
    s.thisObject()->setPrivateObject(ptr);
    return true;
}
SE_BIND_CTOR(js_new_spine_Skeleton, __jsb_spine_Skeleton_class, js_delete_spine_Skeleton)

static bool js_delete_spine_Skeleton(se::State& s)
{
    return true;
}
SE_BIND_FINALIZE_FUNC(js_delete_spine_Skeleton) 

static bool js_spine_Skeleton_updateCache(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Skeleton *arg1 = (spine::Skeleton *) NULL ;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Skeleton>(s);
    if (nullptr == arg1) return true;
    (arg1)->updateCache();
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Skeleton_updateCache) 

static bool js_spine_Skeleton_printUpdateCache(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Skeleton *arg1 = (spine::Skeleton *) NULL ;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Skeleton>(s);
    if (nullptr == arg1) return true;
    (arg1)->printUpdateCache();
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Skeleton_printUpdateCache) 

static bool js_spine_Skeleton_updateWorldTransform__SWIG_0(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    spine::Skeleton *arg1 = (spine::Skeleton *) NULL ;
    Physics arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::Skeleton>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    (arg1)->updateWorldTransform(arg2);
    
    
    return true;
}

static bool js_spine_Skeleton_updateWorldTransform__SWIG_1(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    spine::Skeleton *arg1 = (spine::Skeleton *) NULL ;
    Physics arg2 ;
    spine::Bone *arg3 = (spine::Bone *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::Skeleton>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    
    ok &= sevalue_to_native(args[1], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->updateWorldTransform(arg2,arg3);
    
    
    return true;
}

static bool js_spine_Skeleton_updateWorldTransform(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    
    if (argc == 1) {
        ok = js_spine_Skeleton_updateWorldTransform__SWIG_0(s);
        if (ok) {
            return true; 
        }
    } 
    if (argc == 2) {
        ok = js_spine_Skeleton_updateWorldTransform__SWIG_1(s);
        if (ok) {
            return true; 
        }
    } 
    SE_REPORT_ERROR("wrong number of arguments: %d", (int)argc);
    return false;
}
SE_BIND_FUNC(js_spine_Skeleton_updateWorldTransform) 

static bool js_spine_Skeleton_setToSetupPose(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Skeleton *arg1 = (spine::Skeleton *) NULL ;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Skeleton>(s);
    if (nullptr == arg1) return true;
    (arg1)->setToSetupPose();
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Skeleton_setToSetupPose) 

static bool js_spine_Skeleton_setBonesToSetupPose(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Skeleton *arg1 = (spine::Skeleton *) NULL ;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Skeleton>(s);
    if (nullptr == arg1) return true;
    (arg1)->setBonesToSetupPose();
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Skeleton_setBonesToSetupPose) 

static bool js_spine_Skeleton_setSlotsToSetupPose(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Skeleton *arg1 = (spine::Skeleton *) NULL ;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Skeleton>(s);
    if (nullptr == arg1) return true;
    (arg1)->setSlotsToSetupPose();
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Skeleton_setSlotsToSetupPose) 

static bool js_spine_Skeleton_findBone(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Skeleton *arg1 = (spine::Skeleton *) NULL ;
    spine::String *arg2 = 0 ;
    spine::String temp2 ;
    spine::Bone *result = 0 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Skeleton>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    result = (spine::Bone *)(arg1)->findBone((spine::String const &)*arg2);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Skeleton_findBone) 

static bool js_spine_Skeleton_findSlot(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Skeleton *arg1 = (spine::Skeleton *) NULL ;
    spine::String *arg2 = 0 ;
    spine::String temp2 ;
    spine::Slot *result = 0 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Skeleton>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    result = (spine::Slot *)(arg1)->findSlot((spine::String const &)*arg2);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Skeleton_findSlot) 

static bool js_spine_Skeleton_setSkinByName(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Skeleton *arg1 = (spine::Skeleton *) NULL ;
    spine::String *arg2 = 0 ;
    spine::String temp2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Skeleton>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    (arg1)->setSkin((spine::String const &)*arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Skeleton_setSkinByName) 

static bool js_spine_Skeleton_getAttachment__SWIG_0(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    spine::Skeleton *arg1 = (spine::Skeleton *) NULL ;
    spine::String *arg2 = 0 ;
    spine::String *arg3 = 0 ;
    spine::String temp2 ;
    spine::String temp3 ;
    spine::Attachment *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::Skeleton>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    
    ok &= sevalue_to_native(args[1], &temp3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg3 = &temp3;
    
    result = (spine::Attachment *)(arg1)->getAttachment((spine::String const &)*arg2,(spine::String const &)*arg3);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}

static bool js_spine_Skeleton_getAttachment__SWIG_1(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    spine::Skeleton *arg1 = (spine::Skeleton *) NULL ;
    int arg2 ;
    spine::String *arg3 = 0 ;
    spine::String temp3 ;
    spine::Attachment *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::Skeleton>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[1], &temp3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg3 = &temp3;
    
    result = (spine::Attachment *)(arg1)->getAttachment(arg2,(spine::String const &)*arg3);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}

static bool js_spine_Skeleton_getAttachment(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    
    if (argc == 2) {
        ok = js_spine_Skeleton_getAttachment__SWIG_0(s);
        if (ok) {
            return true; 
        }
    } 
    if (argc == 2) {
        ok = js_spine_Skeleton_getAttachment__SWIG_1(s);
        if (ok) {
            return true; 
        }
    } 
    SE_REPORT_ERROR("wrong number of arguments: %d", (int)argc);
    return false;
}
SE_BIND_FUNC(js_spine_Skeleton_getAttachment) 

static bool js_spine_Skeleton_setAttachment(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Skeleton *arg1 = (spine::Skeleton *) NULL ;
    spine::String *arg2 = 0 ;
    spine::String *arg3 = 0 ;
    spine::String temp2 ;
    spine::String temp3 ;
    
    if(argc != 2) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 2);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Skeleton>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    
    ok &= sevalue_to_native(args[1], &temp3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg3 = &temp3;
    
    (arg1)->setAttachment((spine::String const &)*arg2,(spine::String const &)*arg3);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Skeleton_setAttachment) 

static bool js_spine_Skeleton_findIkConstraint(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Skeleton *arg1 = (spine::Skeleton *) NULL ;
    spine::String *arg2 = 0 ;
    spine::String temp2 ;
    spine::IkConstraint *result = 0 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Skeleton>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    result = (spine::IkConstraint *)(arg1)->findIkConstraint((spine::String const &)*arg2);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Skeleton_findIkConstraint) 

static bool js_spine_Skeleton_findTransformConstraint(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Skeleton *arg1 = (spine::Skeleton *) NULL ;
    spine::String *arg2 = 0 ;
    spine::String temp2 ;
    spine::TransformConstraint *result = 0 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Skeleton>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    result = (spine::TransformConstraint *)(arg1)->findTransformConstraint((spine::String const &)*arg2);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Skeleton_findTransformConstraint) 

static bool js_spine_Skeleton_findPathConstraint(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Skeleton *arg1 = (spine::Skeleton *) NULL ;
    spine::String *arg2 = 0 ;
    spine::String temp2 ;
    spine::PathConstraint *result = 0 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Skeleton>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    result = (spine::PathConstraint *)(arg1)->findPathConstraint((spine::String const &)*arg2);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Skeleton_findPathConstraint) 

static bool js_spine_Skeleton_findPhysicsConstraint(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Skeleton *arg1 = (spine::Skeleton *) NULL ;
    spine::String *arg2 = 0 ;
    spine::String temp2 ;
    spine::PhysicsConstraint *result = 0 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Skeleton>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    result = (spine::PhysicsConstraint *)(arg1)->findPhysicsConstraint((spine::String const &)*arg2);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Skeleton_findPhysicsConstraint) 

static bool js_spine_Skeleton_getRootBone(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Skeleton *arg1 = (spine::Skeleton *) NULL ;
    spine::Bone *result = 0 ;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Skeleton>(s);
    if (nullptr == arg1) return true;
    result = (spine::Bone *)(arg1)->getRootBone();
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Skeleton_getRootBone) 

static bool js_spine_Skeleton_getPhysicsConstraints(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Skeleton *arg1 = (spine::Skeleton *) NULL ;
    spine::Vector< spine::PhysicsConstraint * > *result = 0 ;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Skeleton>(s);
    if (nullptr == arg1) return true;
    result = (spine::Vector< spine::PhysicsConstraint * > *) &(arg1)->getPhysicsConstraints();
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Skeleton_getPhysicsConstraints) 

static bool js_spine_Skeleton_setPosition(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Skeleton *arg1 = (spine::Skeleton *) NULL ;
    float arg2 ;
    float arg3 ;
    
    if(argc != 2) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 2);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Skeleton>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[1], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setPosition(arg2,arg3);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Skeleton_setPosition) 

static bool js_spine_Skeleton_update(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Skeleton *arg1 = (spine::Skeleton *) NULL ;
    float arg2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Skeleton>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->update(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Skeleton_update) 

static bool js_spine_Skeleton_physicsTranslate(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Skeleton *arg1 = (spine::Skeleton *) NULL ;
    float arg2 ;
    float arg3 ;
    
    if(argc != 2) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 2);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Skeleton>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[1], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->physicsTranslate(arg2,arg3);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Skeleton_physicsTranslate) 

static bool js_spine_Skeleton_physicsRotate(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Skeleton *arg1 = (spine::Skeleton *) NULL ;
    float arg2 ;
    float arg3 ;
    float arg4 ;
    
    if(argc != 3) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 3);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Skeleton>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[1], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[2], &arg4, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->physicsRotate(arg2,arg3,arg4);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Skeleton_physicsRotate) 

static bool js_spine_Skeleton_data_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::Skeleton *arg1 = (spine::Skeleton *) NULL ;
    spine::SkeletonData *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::Skeleton>(s);
    if (nullptr == arg1) return true;
    result = (spine::SkeletonData *)spine_Skeleton_data_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_Skeleton_data_get) 

static bool js_spine_Skeleton_bones_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::Skeleton *arg1 = (spine::Skeleton *) NULL ;
    spine::Vector< spine::Bone * > *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::Skeleton>(s);
    if (nullptr == arg1) return true;
    result = (spine::Vector< spine::Bone * > *) &spine_Skeleton_bones_get(arg1);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_Skeleton_bones_get) 

static bool js_spine_Skeleton_slots_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::Skeleton *arg1 = (spine::Skeleton *) NULL ;
    spine::Vector< spine::Slot * > *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::Skeleton>(s);
    if (nullptr == arg1) return true;
    result = (spine::Vector< spine::Slot * > *) &spine_Skeleton_slots_get(arg1);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_Skeleton_slots_get) 

static bool js_spine_Skeleton_drawOrder_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::Skeleton *arg1 = (spine::Skeleton *) NULL ;
    spine::Vector< spine::Slot * > *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::Skeleton>(s);
    if (nullptr == arg1) return true;
    result = (spine::Vector< spine::Slot * > *) &spine_Skeleton_drawOrder_get(arg1);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_Skeleton_drawOrder_get) 

static bool js_spine_Skeleton_ikConstraints_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::Skeleton *arg1 = (spine::Skeleton *) NULL ;
    spine::Vector< spine::IkConstraint * > *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::Skeleton>(s);
    if (nullptr == arg1) return true;
    result = (spine::Vector< spine::IkConstraint * > *) &spine_Skeleton_ikConstraints_get(arg1);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_Skeleton_ikConstraints_get) 

static bool js_spine_Skeleton_transformConstraints_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::Skeleton *arg1 = (spine::Skeleton *) NULL ;
    spine::Vector< spine::TransformConstraint * > *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::Skeleton>(s);
    if (nullptr == arg1) return true;
    result = (spine::Vector< spine::TransformConstraint * > *) &spine_Skeleton_transformConstraints_get(arg1);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_Skeleton_transformConstraints_get) 

static bool js_spine_Skeleton_pathConstraints_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::Skeleton *arg1 = (spine::Skeleton *) NULL ;
    spine::Vector< spine::PathConstraint * > *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::Skeleton>(s);
    if (nullptr == arg1) return true;
    result = (spine::Vector< spine::PathConstraint * > *) &spine_Skeleton_pathConstraints_get(arg1);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_Skeleton_pathConstraints_get) 

static bool js_spine_Skeleton__updateCache_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::Skeleton *arg1 = (spine::Skeleton *) NULL ;
    spine::Vector< spine::Updatable * > *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::Skeleton>(s);
    if (nullptr == arg1) return true;
    result = (spine::Vector< spine::Updatable * > *) &spine_Skeleton__updateCache_get(arg1);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_Skeleton__updateCache_get) 

static bool js_spine_Skeleton_skin_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Skeleton *arg1 = (spine::Skeleton *) NULL ;
    spine::Skin *arg2 = (spine::Skin *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::Skeleton>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_Skeleton_skin_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_Skeleton_skin_set) 

static bool js_spine_Skeleton_skin_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::Skeleton *arg1 = (spine::Skeleton *) NULL ;
    spine::Skin *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::Skeleton>(s);
    if (nullptr == arg1) return true;
    result = (spine::Skin *)spine_Skeleton_skin_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_Skeleton_skin_get) 

static bool js_spine_Skeleton_color_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::Skeleton *arg1 = (spine::Skeleton *) NULL ;
    spine::Color *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::Skeleton>(s);
    if (nullptr == arg1) return true;
    result = (spine::Color *) &spine_Skeleton_color_get(arg1);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_Skeleton_color_get) 

static bool js_spine_Skeleton_time_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Skeleton *arg1 = (spine::Skeleton *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::Skeleton>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_Skeleton_time_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_Skeleton_time_set) 

static bool js_spine_Skeleton_time_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::Skeleton *arg1 = (spine::Skeleton *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::Skeleton>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_Skeleton_time_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_Skeleton_time_get) 

static bool js_spine_Skeleton_scaleX_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Skeleton *arg1 = (spine::Skeleton *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::Skeleton>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_Skeleton_scaleX_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_Skeleton_scaleX_set) 

static bool js_spine_Skeleton_scaleX_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::Skeleton *arg1 = (spine::Skeleton *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::Skeleton>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_Skeleton_scaleX_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_Skeleton_scaleX_get) 

static bool js_spine_Skeleton_scaleY_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Skeleton *arg1 = (spine::Skeleton *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::Skeleton>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_Skeleton_scaleY_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_Skeleton_scaleY_set) 

static bool js_spine_Skeleton_scaleY_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::Skeleton *arg1 = (spine::Skeleton *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::Skeleton>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_Skeleton_scaleY_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_Skeleton_scaleY_get) 

static bool js_spine_Skeleton_x_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Skeleton *arg1 = (spine::Skeleton *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::Skeleton>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_Skeleton_x_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_Skeleton_x_set) 

static bool js_spine_Skeleton_x_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::Skeleton *arg1 = (spine::Skeleton *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::Skeleton>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_Skeleton_x_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_Skeleton_x_get) 

static bool js_spine_Skeleton_y_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Skeleton *arg1 = (spine::Skeleton *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::Skeleton>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_Skeleton_y_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_Skeleton_y_set) 

static bool js_spine_Skeleton_y_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::Skeleton *arg1 = (spine::Skeleton *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::Skeleton>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_Skeleton_y_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_Skeleton_y_get) 

static bool js_spine_Skeleton_getAttachmentByName(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Skeleton *arg1 = (spine::Skeleton *) NULL ;
    std::string *arg2 = 0 ;
    std::string *arg3 = 0 ;
    std::string temp2 ;
    std::string temp3 ;
    spine::Attachment *result = 0 ;
    
    if(argc != 2) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 2);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Skeleton>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    
    ok &= sevalue_to_native(args[1], &temp3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg3 = &temp3;
    
    result = (spine::Attachment *) &spine_Skeleton_getAttachmentByName(arg1,(std::string const &)*arg2,(std::string const &)*arg3);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Skeleton_getAttachmentByName) 

bool js_register_spine_Skeleton(se::Object* obj) {
    auto* cls = se::Class::create("Skeleton", obj, nullptr, _SE(js_new_spine_Skeleton)); 
    
    cls->defineStaticProperty("__isJSB", se::Value(true), se::PropertyAttribute::READ_ONLY | se::PropertyAttribute::DONT_ENUM | se::PropertyAttribute::DONT_DELETE);
    cls->defineProperty("data", _SE(js_spine_Skeleton_data_get), nullptr); 
    cls->defineProperty("bones", _SE(js_spine_Skeleton_bones_get), nullptr); 
    cls->defineProperty("slots", _SE(js_spine_Skeleton_slots_get), nullptr); 
    cls->defineProperty("drawOrder", _SE(js_spine_Skeleton_drawOrder_get), nullptr); 
    cls->defineProperty("ikConstraints", _SE(js_spine_Skeleton_ikConstraints_get), nullptr); 
    cls->defineProperty("transformConstraints", _SE(js_spine_Skeleton_transformConstraints_get), nullptr); 
    cls->defineProperty("pathConstraints", _SE(js_spine_Skeleton_pathConstraints_get), nullptr); 
    cls->defineProperty("_updateCache", _SE(js_spine_Skeleton__updateCache_get), nullptr); 
    cls->defineProperty("skin", _SE(js_spine_Skeleton_skin_get), _SE(js_spine_Skeleton_skin_set)); 
    cls->defineProperty("color", _SE(js_spine_Skeleton_color_get), nullptr); 
    cls->defineProperty("time", _SE(js_spine_Skeleton_time_get), _SE(js_spine_Skeleton_time_set)); 
    cls->defineProperty("scaleX", _SE(js_spine_Skeleton_scaleX_get), _SE(js_spine_Skeleton_scaleX_set)); 
    cls->defineProperty("scaleY", _SE(js_spine_Skeleton_scaleY_get), _SE(js_spine_Skeleton_scaleY_set)); 
    cls->defineProperty("x", _SE(js_spine_Skeleton_x_get), _SE(js_spine_Skeleton_x_set)); 
    cls->defineProperty("y", _SE(js_spine_Skeleton_y_get), _SE(js_spine_Skeleton_y_set)); 
    
    cls->defineFunction("updateCache", _SE(js_spine_Skeleton_updateCache)); 
    cls->defineFunction("printUpdateCache", _SE(js_spine_Skeleton_printUpdateCache)); 
    cls->defineFunction("updateWorldTransform", _SE(js_spine_Skeleton_updateWorldTransform)); 
    cls->defineFunction("setToSetupPose", _SE(js_spine_Skeleton_setToSetupPose)); 
    cls->defineFunction("setBonesToSetupPose", _SE(js_spine_Skeleton_setBonesToSetupPose)); 
    cls->defineFunction("setSlotsToSetupPose", _SE(js_spine_Skeleton_setSlotsToSetupPose)); 
    cls->defineFunction("findBone", _SE(js_spine_Skeleton_findBone)); 
    cls->defineFunction("findSlot", _SE(js_spine_Skeleton_findSlot)); 
    cls->defineFunction("setSkinByName", _SE(js_spine_Skeleton_setSkinByName)); 
    cls->defineFunction("getAttachment", _SE(js_spine_Skeleton_getAttachment)); 
    cls->defineFunction("setAttachment", _SE(js_spine_Skeleton_setAttachment)); 
    cls->defineFunction("findIkConstraint", _SE(js_spine_Skeleton_findIkConstraint)); 
    cls->defineFunction("findTransformConstraint", _SE(js_spine_Skeleton_findTransformConstraint)); 
    cls->defineFunction("findPathConstraint", _SE(js_spine_Skeleton_findPathConstraint)); 
    cls->defineFunction("findPhysicsConstraint", _SE(js_spine_Skeleton_findPhysicsConstraint)); 
    cls->defineFunction("getRootBone", _SE(js_spine_Skeleton_getRootBone)); 
    cls->defineFunction("getPhysicsConstraints", _SE(js_spine_Skeleton_getPhysicsConstraints)); 
    cls->defineFunction("setPosition", _SE(js_spine_Skeleton_setPosition)); 
    cls->defineFunction("update", _SE(js_spine_Skeleton_update)); 
    cls->defineFunction("physicsTranslate", _SE(js_spine_Skeleton_physicsTranslate)); 
    cls->defineFunction("physicsRotate", _SE(js_spine_Skeleton_physicsRotate)); 
    cls->defineFunction("getAttachmentByName", _SE(js_spine_Skeleton_getAttachmentByName)); 
    
    
    
    
    cls->defineFinalizeFunction(_SE(js_delete_spine_Skeleton));
    
    
    cls->install();
    JSBClassType::registerClass<spine::Skeleton>(cls);
    
    __jsb_spine_Skeleton_proto = cls->getProto();
    __jsb_spine_Skeleton_class = cls;
    se::ScriptEngine::getInstance()->clearException();
    return true;
}


se::Class* __jsb_spine_Slot_class = nullptr;
se::Object* __jsb_spine_Slot_proto = nullptr;
SE_DECLARE_FINALIZE_FUNC(js_delete_spine_Slot) 

static bool js_spine_Slot_setToSetupPose(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Slot *arg1 = (spine::Slot *) NULL ;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Slot>(s);
    if (nullptr == arg1) return true;
    (arg1)->setToSetupPose();
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Slot_setToSetupPose) 

static bool js_spine_Slot_getSkeleton(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Slot *arg1 = (spine::Slot *) NULL ;
    spine::Skeleton *result = 0 ;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Slot>(s);
    if (nullptr == arg1) return true;
    result = (spine::Skeleton *) &(arg1)->getSkeleton();
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Slot_getSkeleton) 

static bool js_spine_Slot_hasDarkColor(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Slot *arg1 = (spine::Slot *) NULL ;
    bool result;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Slot>(s);
    if (nullptr == arg1) return true;
    result = (bool)(arg1)->hasDarkColor();
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Slot_hasDarkColor) 

static bool js_spine_Slot_getAttachmentState(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Slot *arg1 = (spine::Slot *) NULL ;
    int result;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Slot>(s);
    if (nullptr == arg1) return true;
    result = (int)(arg1)->getAttachmentState();
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Slot_getAttachmentState) 

static bool js_spine_Slot_setAttachmentState(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Slot *arg1 = (spine::Slot *) NULL ;
    int arg2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Slot>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setAttachmentState(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Slot_setAttachmentState) 

static bool js_spine_Slot_getSequenceIndex(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Slot *arg1 = (spine::Slot *) NULL ;
    int result;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Slot>(s);
    if (nullptr == arg1) return true;
    result = (int)(arg1)->getSequenceIndex();
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Slot_getSequenceIndex) 

static bool js_spine_Slot_setSequenceIndex(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Slot *arg1 = (spine::Slot *) NULL ;
    int arg2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Slot>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setSequenceIndex(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Slot_setSequenceIndex) 

static bool js_spine_Slot_data_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::Slot *arg1 = (spine::Slot *) NULL ;
    spine::SlotData *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::Slot>(s);
    if (nullptr == arg1) return true;
    result = (spine::SlotData *) &spine_Slot_data_get(arg1);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_Slot_data_get) 

static bool js_spine_Slot_bone_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::Slot *arg1 = (spine::Slot *) NULL ;
    spine::Bone *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::Slot>(s);
    if (nullptr == arg1) return true;
    result = (spine::Bone *) &spine_Slot_bone_get(arg1);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_Slot_bone_get) 

static bool js_spine_Slot_color_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::Slot *arg1 = (spine::Slot *) NULL ;
    spine::Color *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::Slot>(s);
    if (nullptr == arg1) return true;
    result = (spine::Color *) &spine_Slot_color_get(arg1);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_Slot_color_get) 

static bool js_spine_Slot_darkColor_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::Slot *arg1 = (spine::Slot *) NULL ;
    spine::Color *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::Slot>(s);
    if (nullptr == arg1) return true;
    result = (spine::Color *) &spine_Slot_darkColor_get(arg1);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_Slot_darkColor_get) 

static bool js_spine_Slot_attachment_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Slot *arg1 = (spine::Slot *) NULL ;
    spine::Attachment *arg2 = (spine::Attachment *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::Slot>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_Slot_attachment_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_Slot_attachment_set) 

static bool js_spine_Slot_attachment_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::Slot *arg1 = (spine::Slot *) NULL ;
    spine::Attachment *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::Slot>(s);
    if (nullptr == arg1) return true;
    result = (spine::Attachment *)spine_Slot_attachment_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_Slot_attachment_get) 

static bool js_spine_Slot_deform_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::Slot *arg1 = (spine::Slot *) NULL ;
    spine::Vector< float > *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::Slot>(s);
    if (nullptr == arg1) return true;
    result = (spine::Vector< float > *) &spine_Slot_deform_get(arg1);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_Slot_deform_get) 

static bool js_new_spine_Slot(se::State& s) // NOLINT(readability-identifier-naming)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    if (argc != 2) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 2);
        return false;
    }
    
    spine::SlotData *arg1 = (spine::SlotData *) NULL ;
    spine::Bone *arg2 = (spine::Bone *) NULL ;
    spine::Slot *result;
    
    ok &= sevalue_to_native(args[0], &arg1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[1], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (spine::Slot *)new_spine_Slot(arg1,arg2);
    
    
    auto *ptr = JSB_MAKE_PRIVATE_OBJECT_WITH_INSTANCE(result);
    s.thisObject()->setPrivateObject(ptr);
    return true;
}
SE_BIND_CTOR(js_new_spine_Slot, __jsb_spine_Slot_class, js_delete_spine_Slot)

static bool js_delete_spine_Slot(se::State& s)
{
    return true;
}
SE_BIND_FINALIZE_FUNC(js_delete_spine_Slot) 

bool js_register_spine_Slot(se::Object* obj) {
    auto* cls = se::Class::create("Slot", obj, nullptr, _SE(js_new_spine_Slot)); 
    
    cls->defineStaticProperty("__isJSB", se::Value(true), se::PropertyAttribute::READ_ONLY | se::PropertyAttribute::DONT_ENUM | se::PropertyAttribute::DONT_DELETE);
    cls->defineProperty("data", _SE(js_spine_Slot_data_get), nullptr); 
    cls->defineProperty("bone", _SE(js_spine_Slot_bone_get), nullptr); 
    cls->defineProperty("color", _SE(js_spine_Slot_color_get), nullptr); 
    cls->defineProperty("darkColor", _SE(js_spine_Slot_darkColor_get), nullptr); 
    cls->defineProperty("attachment", _SE(js_spine_Slot_attachment_get), _SE(js_spine_Slot_attachment_set)); 
    cls->defineProperty("deform", _SE(js_spine_Slot_deform_get), nullptr); 
    
    cls->defineFunction("setToSetupPose", _SE(js_spine_Slot_setToSetupPose)); 
    cls->defineFunction("getSkeleton", _SE(js_spine_Slot_getSkeleton)); 
    cls->defineFunction("hasDarkColor", _SE(js_spine_Slot_hasDarkColor)); 
    cls->defineFunction("getAttachmentState", _SE(js_spine_Slot_getAttachmentState)); 
    cls->defineFunction("setAttachmentState", _SE(js_spine_Slot_setAttachmentState)); 
    cls->defineFunction("getSequenceIndex", _SE(js_spine_Slot_getSequenceIndex)); 
    cls->defineFunction("setSequenceIndex", _SE(js_spine_Slot_setSequenceIndex)); 
    
    
    
    
    cls->defineFinalizeFunction(_SE(js_delete_spine_Slot));
    
    
    cls->install();
    JSBClassType::registerClass<spine::Slot>(cls);
    
    __jsb_spine_Slot_proto = cls->getProto();
    __jsb_spine_Slot_class = cls;
    se::ScriptEngine::getInstance()->clearException();
    return true;
}


se::Class* __jsb_spine_Skin_class = nullptr;
se::Object* __jsb_spine_Skin_proto = nullptr;
SE_DECLARE_FINALIZE_FUNC(js_delete_spine_Skin) 

se::Class* __jsb_spine_Skin_AttachmentMap_class = nullptr;
se::Object* __jsb_spine_Skin_AttachmentMap_proto = nullptr;
SE_DECLARE_FINALIZE_FUNC(js_delete_spine_Skin_AttachmentMap) 

se::Class* __jsb_spine_Skin_AttachmentMap_Entry_class = nullptr;
se::Object* __jsb_spine_Skin_AttachmentMap_Entry_proto = nullptr;
SE_DECLARE_FINALIZE_FUNC(js_delete_spine_Skin_AttachmentMap_Entry) 

static bool js_spine_Skin_AttachmentMap_Entry_slotIndex_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Skin::AttachmentMap::Entry *arg1 = (spine::Skin::AttachmentMap::Entry *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::Skin::AttachmentMap::Entry>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg1->_slotIndex, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_Skin_AttachmentMap_Entry_slotIndex_set) 

static bool js_spine_Skin_AttachmentMap_Entry_slotIndex_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::Skin::AttachmentMap::Entry *arg1 = (spine::Skin::AttachmentMap::Entry *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::Skin::AttachmentMap::Entry>(s);
    if (nullptr == arg1) return true;
    
    ok &= nativevalue_to_se(arg1->_slotIndex, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_Skin_AttachmentMap_Entry_slotIndex_get) 

static bool js_spine_Skin_AttachmentMap_Entry_name_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Skin::AttachmentMap::Entry *arg1 = (spine::Skin::AttachmentMap::Entry *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::Skin::AttachmentMap::Entry>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg1->_name, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_Skin_AttachmentMap_Entry_name_set) 

static bool js_spine_Skin_AttachmentMap_Entry_name_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::Skin::AttachmentMap::Entry *arg1 = (spine::Skin::AttachmentMap::Entry *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::Skin::AttachmentMap::Entry>(s);
    if (nullptr == arg1) return true;
    
    ok &= nativevalue_to_se(arg1->_name, s.rval(), s.thisObject() /*ctx*/);
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(arg1->_name, s.thisObject(), s.rval());
    
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_Skin_AttachmentMap_Entry_name_get) 

static bool js_spine_Skin_AttachmentMap_Entry_attachment_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Skin::AttachmentMap::Entry *arg1 = (spine::Skin::AttachmentMap::Entry *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::Skin::AttachmentMap::Entry>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg1->_attachment, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_Skin_AttachmentMap_Entry_attachment_set) 

static bool js_spine_Skin_AttachmentMap_Entry_attachment_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::Skin::AttachmentMap::Entry *arg1 = (spine::Skin::AttachmentMap::Entry *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::Skin::AttachmentMap::Entry>(s);
    if (nullptr == arg1) return true;
    
    ok &= nativevalue_to_se(arg1->_attachment, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(arg1->_attachment, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_Skin_AttachmentMap_Entry_attachment_get) 

static bool js_new_spine_Skin_AttachmentMap_Entry(se::State& s) // NOLINT(readability-identifier-naming)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    if (argc != 3) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 3);
        return false;
    }
    
    size_t arg1 ;
    spine::String *arg2 = 0 ;
    spine::Attachment *arg3 = (spine::Attachment *) NULL ;
    spine::String temp2 ;
    spine::Skin::AttachmentMap::Entry *result;
    
    ok &= sevalue_to_native(args[0], &arg1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    
    
    ok &= sevalue_to_native(args[1], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    
    ok &= sevalue_to_native(args[2], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (spine::Skin::AttachmentMap::Entry *)new spine::Skin::AttachmentMap::Entry(arg1,(spine::String const &)*arg2,arg3);
    
    
    auto *ptr = JSB_MAKE_PRIVATE_OBJECT_WITH_INSTANCE(result);
    s.thisObject()->setPrivateObject(ptr);
    return true;
}
SE_BIND_CTOR(js_new_spine_Skin_AttachmentMap_Entry, __jsb_spine_Skin_AttachmentMap_Entry_class, js_delete_spine_Skin_AttachmentMap_Entry)

static bool js_delete_spine_Skin_AttachmentMap_Entry(se::State& s)
{
    return true;
}
SE_BIND_FINALIZE_FUNC(js_delete_spine_Skin_AttachmentMap_Entry) 

template<>
bool sevalue_to_native(const se::Value &from, spine::Skin::AttachmentMap::Entry * to, se::Object *ctx)
{
    assert(from.isObject());
    se::Object *json = from.toObject();
    auto* data = reinterpret_cast<spine::Skin::AttachmentMap::Entry*>(json->getPrivateData());
    if (data) {
        *to = *data;
        return true;
    }
    se::Value field;
    bool ok = true;
    
    json->getProperty("slotIndex", &field, true);
    if (!field.isNullOrUndefined()) {
        ok &= sevalue_to_native(field, &(to->_slotIndex), ctx);
    }
    
    
    json->getProperty("name", &field, true);
    if (!field.isNullOrUndefined()) {
        ok &= sevalue_to_native(field, &(to->_name), ctx);
    }
    
    
    json->getProperty("attachment", &field, true);
    if (!field.isNullOrUndefined()) {
        ok &= sevalue_to_native(field, &(to->_attachment), ctx);
    }
    
    
    return ok;
}


bool js_register_spine_Skin_AttachmentMap_Entry(se::Object* obj) {
    auto* cls = se::Class::create({"Skin", "AttachmentMap", "Entry"}, obj, nullptr, _SE(js_new_spine_Skin_AttachmentMap_Entry)); 
    
    cls->defineStaticProperty("__isJSB", se::Value(true), se::PropertyAttribute::READ_ONLY | se::PropertyAttribute::DONT_ENUM | se::PropertyAttribute::DONT_DELETE);
    cls->defineProperty("slotIndex", _SE(js_spine_Skin_AttachmentMap_Entry_slotIndex_get), _SE(js_spine_Skin_AttachmentMap_Entry_slotIndex_set)); 
    cls->defineProperty("name", _SE(js_spine_Skin_AttachmentMap_Entry_name_get), _SE(js_spine_Skin_AttachmentMap_Entry_name_set)); 
    cls->defineProperty("attachment", _SE(js_spine_Skin_AttachmentMap_Entry_attachment_get), _SE(js_spine_Skin_AttachmentMap_Entry_attachment_set)); 
    
    
    
    
    
    cls->defineFinalizeFunction(_SE(js_delete_spine_Skin_AttachmentMap_Entry));
    
    
    cls->install();
    JSBClassType::registerClass<spine::Skin::AttachmentMap::Entry>(cls);
    
    __jsb_spine_Skin_AttachmentMap_Entry_proto = cls->getProto();
    __jsb_spine_Skin_AttachmentMap_Entry_class = cls;
    se::ScriptEngine::getInstance()->clearException();
    return true;
}


se::Class* __jsb_spine_Skin_AttachmentMap_Entries_class = nullptr;
se::Object* __jsb_spine_Skin_AttachmentMap_Entries_proto = nullptr;
SE_DECLARE_FINALIZE_FUNC(js_delete_spine_Skin_AttachmentMap_Entries) 

static bool js_spine_Skin_AttachmentMap_Entries_hasNext(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Skin::AttachmentMap::Entries *arg1 = (spine::Skin::AttachmentMap::Entries *) NULL ;
    bool result;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Skin::AttachmentMap::Entries>(s);
    if (nullptr == arg1) return true;
    result = (bool)(arg1)->hasNext();
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Skin_AttachmentMap_Entries_hasNext) 

static bool js_spine_Skin_AttachmentMap_Entries_next(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Skin::AttachmentMap::Entries *arg1 = (spine::Skin::AttachmentMap::Entries *) NULL ;
    spine::Skin::AttachmentMap::Entry *result = 0 ;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Skin::AttachmentMap::Entries>(s);
    if (nullptr == arg1) return true;
    result = (spine::Skin::AttachmentMap::Entry *) &(arg1)->next();
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Skin_AttachmentMap_Entries_next) 

static bool js_delete_spine_Skin_AttachmentMap_Entries(se::State& s)
{
    return true;
}
SE_BIND_FINALIZE_FUNC(js_delete_spine_Skin_AttachmentMap_Entries) 

bool js_register_spine_Skin_AttachmentMap_Entries(se::Object* obj) {
    auto* cls = se::Class::create({"Skin", "AttachmentMap", "Entries"}, obj, nullptr, nullptr); 
    
    cls->defineStaticProperty("__isJSB", se::Value(true), se::PropertyAttribute::READ_ONLY | se::PropertyAttribute::DONT_ENUM | se::PropertyAttribute::DONT_DELETE);
    
    cls->defineFunction("hasNext", _SE(js_spine_Skin_AttachmentMap_Entries_hasNext)); 
    cls->defineFunction("next", _SE(js_spine_Skin_AttachmentMap_Entries_next)); 
    
    
    
    
    cls->defineFinalizeFunction(_SE(js_delete_spine_Skin_AttachmentMap_Entries));
    
    
    cls->install();
    JSBClassType::registerClass<spine::Skin::AttachmentMap::Entries>(cls);
    
    __jsb_spine_Skin_AttachmentMap_Entries_proto = cls->getProto();
    __jsb_spine_Skin_AttachmentMap_Entries_class = cls;
    se::ScriptEngine::getInstance()->clearException();
    return true;
}


static bool js_spine_Skin_AttachmentMap_put(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Skin::AttachmentMap *arg1 = (spine::Skin::AttachmentMap *) NULL ;
    size_t arg2 ;
    spine::String *arg3 = 0 ;
    spine::Attachment *arg4 = (spine::Attachment *) NULL ;
    spine::String temp3 ;
    
    if(argc != 3) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 3);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Skin::AttachmentMap>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    
    
    ok &= sevalue_to_native(args[1], &temp3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg3 = &temp3;
    
    
    ok &= sevalue_to_native(args[2], &arg4, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->put(arg2,(spine::String const &)*arg3,arg4);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Skin_AttachmentMap_put) 

static bool js_spine_Skin_AttachmentMap_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Skin::AttachmentMap *arg1 = (spine::Skin::AttachmentMap *) NULL ;
    size_t arg2 ;
    spine::String *arg3 = 0 ;
    spine::String temp3 ;
    spine::Attachment *result = 0 ;
    
    if(argc != 2) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 2);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Skin::AttachmentMap>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    
    
    ok &= sevalue_to_native(args[1], &temp3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg3 = &temp3;
    
    result = (spine::Attachment *)(arg1)->get(arg2,(spine::String const &)*arg3);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Skin_AttachmentMap_get) 

static bool js_spine_Skin_AttachmentMap_remove(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Skin::AttachmentMap *arg1 = (spine::Skin::AttachmentMap *) NULL ;
    size_t arg2 ;
    spine::String *arg3 = 0 ;
    spine::String temp3 ;
    
    if(argc != 2) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 2);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Skin::AttachmentMap>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    
    
    ok &= sevalue_to_native(args[1], &temp3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg3 = &temp3;
    
    (arg1)->remove(arg2,(spine::String const &)*arg3);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Skin_AttachmentMap_remove) 

static bool js_delete_spine_Skin_AttachmentMap(se::State& s)
{
    return true;
}
SE_BIND_FINALIZE_FUNC(js_delete_spine_Skin_AttachmentMap) 

bool js_register_spine_Skin_AttachmentMap(se::Object* obj) {
    auto* cls = se::Class::create({"Skin", "AttachmentMap"}, obj, nullptr, nullptr); 
    
    cls->defineStaticProperty("__isJSB", se::Value(true), se::PropertyAttribute::READ_ONLY | se::PropertyAttribute::DONT_ENUM | se::PropertyAttribute::DONT_DELETE);
    
    cls->defineFunction("put", _SE(js_spine_Skin_AttachmentMap_put)); 
    cls->defineFunction("get", _SE(js_spine_Skin_AttachmentMap_get)); 
    cls->defineFunction("remove", _SE(js_spine_Skin_AttachmentMap_remove)); 
    
    
    
    
    cls->defineFinalizeFunction(_SE(js_delete_spine_Skin_AttachmentMap));
    
    
    cls->install();
    JSBClassType::registerClass<spine::Skin::AttachmentMap>(cls);
    
    __jsb_spine_Skin_AttachmentMap_proto = cls->getProto();
    __jsb_spine_Skin_AttachmentMap_class = cls;
    se::ScriptEngine::getInstance()->clearException();
    return true;
}


static bool js_new_spine_Skin(se::State& s) // NOLINT(readability-identifier-naming)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    if (argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    
    spine::String *arg1 = 0 ;
    spine::String temp1 ;
    spine::Skin *result;
    
    ok &= sevalue_to_native(args[0], &temp1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg1 = &temp1;
    
    result = (spine::Skin *)new spine::Skin((spine::String const &)*arg1);
    
    
    auto *ptr = JSB_MAKE_PRIVATE_OBJECT_WITH_INSTANCE(result);
    s.thisObject()->setPrivateObject(ptr);
    return true;
}
SE_BIND_CTOR(js_new_spine_Skin, __jsb_spine_Skin_class, js_delete_spine_Skin)

static bool js_delete_spine_Skin(se::State& s)
{
    return true;
}
SE_BIND_FINALIZE_FUNC(js_delete_spine_Skin) 

static bool js_spine_Skin_setAttachment(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Skin *arg1 = (spine::Skin *) NULL ;
    size_t arg2 ;
    spine::String *arg3 = 0 ;
    spine::Attachment *arg4 = (spine::Attachment *) NULL ;
    spine::String temp3 ;
    
    if(argc != 3) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 3);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Skin>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    
    
    ok &= sevalue_to_native(args[1], &temp3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg3 = &temp3;
    
    
    ok &= sevalue_to_native(args[2], &arg4, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setAttachment(arg2,(spine::String const &)*arg3,arg4);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Skin_setAttachment) 

static bool js_spine_Skin_getAttachment(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Skin *arg1 = (spine::Skin *) NULL ;
    size_t arg2 ;
    spine::String *arg3 = 0 ;
    spine::String temp3 ;
    spine::Attachment *result = 0 ;
    
    if(argc != 2) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 2);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Skin>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    
    
    ok &= sevalue_to_native(args[1], &temp3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg3 = &temp3;
    
    result = (spine::Attachment *)(arg1)->getAttachment(arg2,(spine::String const &)*arg3);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Skin_getAttachment) 

static bool js_spine_Skin_removeAttachment(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Skin *arg1 = (spine::Skin *) NULL ;
    size_t arg2 ;
    spine::String *arg3 = 0 ;
    spine::String temp3 ;
    
    if(argc != 2) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 2);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Skin>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    
    
    ok &= sevalue_to_native(args[1], &temp3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg3 = &temp3;
    
    (arg1)->removeAttachment(arg2,(spine::String const &)*arg3);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Skin_removeAttachment) 

static bool js_spine_Skin_addSkin(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Skin *arg1 = (spine::Skin *) NULL ;
    spine::Skin *arg2 = (spine::Skin *) NULL ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Skin>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->addSkin(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Skin_addSkin) 

static bool js_spine_Skin_copySkin(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Skin *arg1 = (spine::Skin *) NULL ;
    spine::Skin *arg2 = (spine::Skin *) NULL ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Skin>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->copySkin(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Skin_copySkin) 

static bool js_spine_Skin_getColor(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Skin *arg1 = (spine::Skin *) NULL ;
    spine::Color *result = 0 ;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Skin>(s);
    if (nullptr == arg1) return true;
    result = (spine::Color *) &(arg1)->getColor();
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Skin_getColor) 

static bool js_spine_Skin_name_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::Skin *arg1 = (spine::Skin *) NULL ;
    spine::String *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::Skin>(s);
    if (nullptr == arg1) return true;
    result = (spine::String *) &spine_Skin_name_get(arg1);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_Skin_name_get) 

static bool js_spine_Skin_bones_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::Skin *arg1 = (spine::Skin *) NULL ;
    spine::Vector< spine::BoneData * > *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::Skin>(s);
    if (nullptr == arg1) return true;
    result = (spine::Vector< spine::BoneData * > *) &spine_Skin_bones_get(arg1);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_Skin_bones_get) 

static bool js_spine_Skin_constraints_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::Skin *arg1 = (spine::Skin *) NULL ;
    spine::Vector< spine::ConstraintData * > *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::Skin>(s);
    if (nullptr == arg1) return true;
    result = (spine::Vector< spine::ConstraintData * > *) &spine_Skin_constraints_get(arg1);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_Skin_constraints_get) 

bool js_register_spine_Skin(se::Object* obj) {
    auto* cls = se::Class::create("Skin", obj, nullptr, _SE(js_new_spine_Skin)); 
    
    cls->defineStaticProperty("__isJSB", se::Value(true), se::PropertyAttribute::READ_ONLY | se::PropertyAttribute::DONT_ENUM | se::PropertyAttribute::DONT_DELETE);
    cls->defineProperty("name", _SE(js_spine_Skin_name_get), nullptr); 
    cls->defineProperty("bones", _SE(js_spine_Skin_bones_get), nullptr); 
    cls->defineProperty("constraints", _SE(js_spine_Skin_constraints_get), nullptr); 
    
    cls->defineFunction("setAttachment", _SE(js_spine_Skin_setAttachment)); 
    cls->defineFunction("getAttachment", _SE(js_spine_Skin_getAttachment)); 
    cls->defineFunction("removeAttachment", _SE(js_spine_Skin_removeAttachment)); 
    cls->defineFunction("addSkin", _SE(js_spine_Skin_addSkin)); 
    cls->defineFunction("copySkin", _SE(js_spine_Skin_copySkin)); 
    cls->defineFunction("getColor", _SE(js_spine_Skin_getColor)); 
    
    
    
    
    cls->defineFinalizeFunction(_SE(js_delete_spine_Skin));
    
    
    cls->install();
    JSBClassType::registerClass<spine::Skin>(cls);
    
    __jsb_spine_Skin_proto = cls->getProto();
    __jsb_spine_Skin_class = cls;
    se::ScriptEngine::getInstance()->clearException();
    return true;
}


se::Class* __jsb_spine_SkeletonBounds_class = nullptr;
se::Object* __jsb_spine_SkeletonBounds_proto = nullptr;
SE_DECLARE_FINALIZE_FUNC(js_delete_spine_SkeletonBounds) 

static bool js_new_spine_SkeletonBounds(se::State& s) // NOLINT(readability-identifier-naming)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    spine::SkeletonBounds *result;
    result = (spine::SkeletonBounds *)new spine::SkeletonBounds();
    
    
    auto *ptr = JSB_MAKE_PRIVATE_OBJECT_WITH_INSTANCE(result);
    s.thisObject()->setPrivateObject(ptr);
    return true;
}
SE_BIND_CTOR(js_new_spine_SkeletonBounds, __jsb_spine_SkeletonBounds_class, js_delete_spine_SkeletonBounds)

static bool js_delete_spine_SkeletonBounds(se::State& s)
{
    return true;
}
SE_BIND_FINALIZE_FUNC(js_delete_spine_SkeletonBounds) 

static bool js_spine_SkeletonBounds_aabbcontainsPoint(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::SkeletonBounds *arg1 = (spine::SkeletonBounds *) NULL ;
    float arg2 ;
    float arg3 ;
    bool result;
    
    if(argc != 2) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 2);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::SkeletonBounds>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[1], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (bool)(arg1)->aabbcontainsPoint(arg2,arg3);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    
    
    return true;
}
SE_BIND_FUNC(js_spine_SkeletonBounds_aabbcontainsPoint) 

static bool js_spine_SkeletonBounds_aabbintersectsSegment(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::SkeletonBounds *arg1 = (spine::SkeletonBounds *) NULL ;
    float arg2 ;
    float arg3 ;
    float arg4 ;
    float arg5 ;
    bool result;
    
    if(argc != 4) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 4);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::SkeletonBounds>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[1], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[2], &arg4, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[3], &arg5, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (bool)(arg1)->aabbintersectsSegment(arg2,arg3,arg4,arg5);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    
    
    return true;
}
SE_BIND_FUNC(js_spine_SkeletonBounds_aabbintersectsSegment) 

static bool js_spine_SkeletonBounds_aabbIntersectsSkeleton(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::SkeletonBounds *arg1 = (spine::SkeletonBounds *) NULL ;
    spine::SkeletonBounds *arg2 = 0 ;
    spine::SkeletonBounds temp2 ;
    bool result;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::SkeletonBounds>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    result = (bool)(arg1)->aabbIntersectsSkeleton(*arg2);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    
    
    return true;
}
SE_BIND_FUNC(js_spine_SkeletonBounds_aabbIntersectsSkeleton) 

static bool js_spine_SkeletonBounds_containsPoint__SWIG_0(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    spine::SkeletonBounds *arg1 = (spine::SkeletonBounds *) NULL ;
    spine::Polygon *arg2 = (spine::Polygon *) NULL ;
    float arg3 ;
    float arg4 ;
    bool result;
    
    arg1 = SE_THIS_OBJECT<spine::SkeletonBounds>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[1], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[2], &arg4, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (bool)(arg1)->containsPoint(arg2,arg3,arg4);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    
    
    return true;
}

static bool js_spine_SkeletonBounds_containsPoint__SWIG_1(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    spine::SkeletonBounds *arg1 = (spine::SkeletonBounds *) NULL ;
    float arg2 ;
    float arg3 ;
    spine::BoundingBoxAttachment *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::SkeletonBounds>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[1], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (spine::BoundingBoxAttachment *)(arg1)->containsPoint(arg2,arg3);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}

static bool js_spine_SkeletonBounds_containsPoint(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    
    if (argc == 3) {
        ok = js_spine_SkeletonBounds_containsPoint__SWIG_0(s);
        if (ok) {
            return true; 
        }
    } 
    if (argc == 2) {
        ok = js_spine_SkeletonBounds_containsPoint__SWIG_1(s);
        if (ok) {
            return true; 
        }
    } 
    SE_REPORT_ERROR("wrong number of arguments: %d", (int)argc);
    return false;
}
SE_BIND_FUNC(js_spine_SkeletonBounds_containsPoint) 

static bool js_spine_SkeletonBounds_intersectsSegment__SWIG_0(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    spine::SkeletonBounds *arg1 = (spine::SkeletonBounds *) NULL ;
    float arg2 ;
    float arg3 ;
    float arg4 ;
    float arg5 ;
    spine::BoundingBoxAttachment *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::SkeletonBounds>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[1], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[2], &arg4, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[3], &arg5, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (spine::BoundingBoxAttachment *)(arg1)->intersectsSegment(arg2,arg3,arg4,arg5);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}

static bool js_spine_SkeletonBounds_intersectsSegment__SWIG_1(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    spine::SkeletonBounds *arg1 = (spine::SkeletonBounds *) NULL ;
    spine::Polygon *arg2 = (spine::Polygon *) NULL ;
    float arg3 ;
    float arg4 ;
    float arg5 ;
    float arg6 ;
    bool result;
    
    arg1 = SE_THIS_OBJECT<spine::SkeletonBounds>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[1], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[2], &arg4, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[3], &arg5, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[4], &arg6, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (bool)(arg1)->intersectsSegment(arg2,arg3,arg4,arg5,arg6);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    
    
    return true;
}

static bool js_spine_SkeletonBounds_intersectsSegment(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    
    if (argc == 4) {
        ok = js_spine_SkeletonBounds_intersectsSegment__SWIG_0(s);
        if (ok) {
            return true; 
        }
    } 
    if (argc == 5) {
        ok = js_spine_SkeletonBounds_intersectsSegment__SWIG_1(s);
        if (ok) {
            return true; 
        }
    } 
    SE_REPORT_ERROR("wrong number of arguments: %d", (int)argc);
    return false;
}
SE_BIND_FUNC(js_spine_SkeletonBounds_intersectsSegment) 

static bool js_spine_SkeletonBounds_getPolygon(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::SkeletonBounds *arg1 = (spine::SkeletonBounds *) NULL ;
    spine::BoundingBoxAttachment *arg2 = (spine::BoundingBoxAttachment *) NULL ;
    spine::Polygon *result = 0 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::SkeletonBounds>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (spine::Polygon *)(arg1)->getPolygon(arg2);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_SkeletonBounds_getPolygon) 

static bool js_spine_SkeletonBounds_getBoundingBox(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::SkeletonBounds *arg1 = (spine::SkeletonBounds *) NULL ;
    spine::Polygon *arg2 = (spine::Polygon *) NULL ;
    spine::BoundingBoxAttachment *result = 0 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::SkeletonBounds>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (spine::BoundingBoxAttachment *)(arg1)->getBoundingBox(arg2);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_SkeletonBounds_getBoundingBox) 

static bool js_spine_SkeletonBounds_getPolygons(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::SkeletonBounds *arg1 = (spine::SkeletonBounds *) NULL ;
    spine::Vector< spine::Polygon * > *result = 0 ;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::SkeletonBounds>(s);
    if (nullptr == arg1) return true;
    result = (spine::Vector< spine::Polygon * > *) &(arg1)->getPolygons();
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_SkeletonBounds_getPolygons) 

static bool js_spine_SkeletonBounds_getBoundingBoxes(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::SkeletonBounds *arg1 = (spine::SkeletonBounds *) NULL ;
    spine::Vector< spine::BoundingBoxAttachment * > *result = 0 ;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::SkeletonBounds>(s);
    if (nullptr == arg1) return true;
    result = (spine::Vector< spine::BoundingBoxAttachment * > *) &(arg1)->getBoundingBoxes();
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_SkeletonBounds_getBoundingBoxes) 

static bool js_spine_SkeletonBounds_getWidth(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::SkeletonBounds *arg1 = (spine::SkeletonBounds *) NULL ;
    float result;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::SkeletonBounds>(s);
    if (nullptr == arg1) return true;
    result = (float)(arg1)->getWidth();
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_SkeletonBounds_getWidth) 

static bool js_spine_SkeletonBounds_getHeight(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::SkeletonBounds *arg1 = (spine::SkeletonBounds *) NULL ;
    float result;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::SkeletonBounds>(s);
    if (nullptr == arg1) return true;
    result = (float)(arg1)->getHeight();
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_SkeletonBounds_getHeight) 

static bool js_spine_SkeletonBounds_update(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::SkeletonBounds *arg1 = (spine::SkeletonBounds *) NULL ;
    spine::Skeleton *arg2 = (spine::Skeleton *) NULL ;
    bool arg3 ;
    
    if(argc != 2) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 2);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::SkeletonBounds>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[1], &arg3);
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_SkeletonBounds_update(arg1,arg2,arg3);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_SkeletonBounds_update) 

bool js_register_spine_SkeletonBounds(se::Object* obj) {
    auto* cls = se::Class::create("SkeletonBounds", obj, nullptr, _SE(js_new_spine_SkeletonBounds)); 
    
    cls->defineStaticProperty("__isJSB", se::Value(true), se::PropertyAttribute::READ_ONLY | se::PropertyAttribute::DONT_ENUM | se::PropertyAttribute::DONT_DELETE);
    
    cls->defineFunction("aabbcontainsPoint", _SE(js_spine_SkeletonBounds_aabbcontainsPoint)); 
    cls->defineFunction("aabbintersectsSegment", _SE(js_spine_SkeletonBounds_aabbintersectsSegment)); 
    cls->defineFunction("aabbIntersectsSkeleton", _SE(js_spine_SkeletonBounds_aabbIntersectsSkeleton)); 
    cls->defineFunction("containsPoint", _SE(js_spine_SkeletonBounds_containsPoint)); 
    cls->defineFunction("intersectsSegment", _SE(js_spine_SkeletonBounds_intersectsSegment)); 
    cls->defineFunction("getPolygon", _SE(js_spine_SkeletonBounds_getPolygon)); 
    cls->defineFunction("getBoundingBox", _SE(js_spine_SkeletonBounds_getBoundingBox)); 
    cls->defineFunction("getPolygons", _SE(js_spine_SkeletonBounds_getPolygons)); 
    cls->defineFunction("getBoundingBoxes", _SE(js_spine_SkeletonBounds_getBoundingBoxes)); 
    cls->defineFunction("getWidth", _SE(js_spine_SkeletonBounds_getWidth)); 
    cls->defineFunction("getHeight", _SE(js_spine_SkeletonBounds_getHeight)); 
    cls->defineFunction("update", _SE(js_spine_SkeletonBounds_update)); 
    
    
    
    
    cls->defineFinalizeFunction(_SE(js_delete_spine_SkeletonBounds));
    
    
    cls->install();
    JSBClassType::registerClass<spine::SkeletonBounds>(cls);
    
    __jsb_spine_SkeletonBounds_proto = cls->getProto();
    __jsb_spine_SkeletonBounds_class = cls;
    se::ScriptEngine::getInstance()->clearException();
    return true;
}


se::Class* __jsb_spine_Polygon_class = nullptr;
se::Object* __jsb_spine_Polygon_proto = nullptr;
SE_DECLARE_FINALIZE_FUNC(js_delete_spine_Polygon) 

static bool js_spine_Polygon__count_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Polygon *arg1 = (spine::Polygon *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::Polygon>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg1->_count, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_Polygon__count_set) 

static bool js_spine_Polygon__count_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::Polygon *arg1 = (spine::Polygon *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::Polygon>(s);
    if (nullptr == arg1) return true;
    
    ok &= nativevalue_to_se(arg1->_count, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_Polygon__count_get) 

static bool js_delete_spine_Polygon(se::State& s)
{
    return true;
}
SE_BIND_FINALIZE_FUNC(js_delete_spine_Polygon) 

bool js_register_spine_Polygon(se::Object* obj) {
    auto* cls = se::Class::create("Polygon", obj, nullptr, nullptr); 
    
    cls->defineStaticProperty("__isJSB", se::Value(true), se::PropertyAttribute::READ_ONLY | se::PropertyAttribute::DONT_ENUM | se::PropertyAttribute::DONT_DELETE);
    cls->defineProperty("_count", _SE(js_spine_Polygon__count_get), _SE(js_spine_Polygon__count_set)); 
    
    
    
    
    
    cls->defineFinalizeFunction(_SE(js_delete_spine_Polygon));
    
    
    cls->install();
    JSBClassType::registerClass<spine::Polygon>(cls);
    
    __jsb_spine_Polygon_proto = cls->getProto();
    __jsb_spine_Polygon_class = cls;
    se::ScriptEngine::getInstance()->clearException();
    return true;
}


se::Class* __jsb_spine_SkeletonData_class = nullptr;
se::Object* __jsb_spine_SkeletonData_proto = nullptr;
SE_DECLARE_FINALIZE_FUNC(js_delete_spine_SkeletonData) 

static bool js_new_spine_SkeletonData(se::State& s) // NOLINT(readability-identifier-naming)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    spine::SkeletonData *result;
    result = (spine::SkeletonData *)new spine::SkeletonData();
    
    
    auto *ptr = JSB_MAKE_PRIVATE_OBJECT_WITH_INSTANCE(result);
    s.thisObject()->setPrivateObject(ptr);
    return true;
}
SE_BIND_CTOR(js_new_spine_SkeletonData, __jsb_spine_SkeletonData_class, js_delete_spine_SkeletonData)

static bool js_delete_spine_SkeletonData(se::State& s)
{
    return true;
}
SE_BIND_FINALIZE_FUNC(js_delete_spine_SkeletonData) 

static bool js_spine_SkeletonData_findBone(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::SkeletonData *arg1 = (spine::SkeletonData *) NULL ;
    spine::String *arg2 = 0 ;
    spine::String temp2 ;
    spine::BoneData *result = 0 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::SkeletonData>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    result = (spine::BoneData *)(arg1)->findBone((spine::String const &)*arg2);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_SkeletonData_findBone) 

static bool js_spine_SkeletonData_findSlot(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::SkeletonData *arg1 = (spine::SkeletonData *) NULL ;
    spine::String *arg2 = 0 ;
    spine::String temp2 ;
    spine::SlotData *result = 0 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::SkeletonData>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    result = (spine::SlotData *)(arg1)->findSlot((spine::String const &)*arg2);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_SkeletonData_findSlot) 

static bool js_spine_SkeletonData_findSkin(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::SkeletonData *arg1 = (spine::SkeletonData *) NULL ;
    spine::String *arg2 = 0 ;
    spine::String temp2 ;
    spine::Skin *result = 0 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::SkeletonData>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    result = (spine::Skin *)(arg1)->findSkin((spine::String const &)*arg2);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_SkeletonData_findSkin) 

static bool js_spine_SkeletonData_findEvent(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::SkeletonData *arg1 = (spine::SkeletonData *) NULL ;
    spine::String *arg2 = 0 ;
    spine::String temp2 ;
    spine::EventData *result = 0 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::SkeletonData>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    result = (spine::EventData *)(arg1)->findEvent((spine::String const &)*arg2);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_SkeletonData_findEvent) 

static bool js_spine_SkeletonData_findAnimation(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::SkeletonData *arg1 = (spine::SkeletonData *) NULL ;
    spine::String *arg2 = 0 ;
    spine::String temp2 ;
    spine::Animation *result = 0 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::SkeletonData>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    result = (spine::Animation *)(arg1)->findAnimation((spine::String const &)*arg2);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_SkeletonData_findAnimation) 

static bool js_spine_SkeletonData_findIkConstraint(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::SkeletonData *arg1 = (spine::SkeletonData *) NULL ;
    spine::String *arg2 = 0 ;
    spine::String temp2 ;
    spine::IkConstraintData *result = 0 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::SkeletonData>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    result = (spine::IkConstraintData *)(arg1)->findIkConstraint((spine::String const &)*arg2);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_SkeletonData_findIkConstraint) 

static bool js_spine_SkeletonData_findTransformConstraint(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::SkeletonData *arg1 = (spine::SkeletonData *) NULL ;
    spine::String *arg2 = 0 ;
    spine::String temp2 ;
    spine::TransformConstraintData *result = 0 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::SkeletonData>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    result = (spine::TransformConstraintData *)(arg1)->findTransformConstraint((spine::String const &)*arg2);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_SkeletonData_findTransformConstraint) 

static bool js_spine_SkeletonData_findPathConstraint(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::SkeletonData *arg1 = (spine::SkeletonData *) NULL ;
    spine::String *arg2 = 0 ;
    spine::String temp2 ;
    spine::PathConstraintData *result = 0 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::SkeletonData>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    result = (spine::PathConstraintData *)(arg1)->findPathConstraint((spine::String const &)*arg2);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_SkeletonData_findPathConstraint) 

static bool js_spine_SkeletonData_findPhysicsConstraint(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::SkeletonData *arg1 = (spine::SkeletonData *) NULL ;
    spine::String *arg2 = 0 ;
    spine::String temp2 ;
    spine::PhysicsConstraintData *result = 0 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::SkeletonData>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    result = (spine::PhysicsConstraintData *)(arg1)->findPhysicsConstraint((spine::String const &)*arg2);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_SkeletonData_findPhysicsConstraint) 

static bool js_spine_SkeletonData_getPhysicsConstraints(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::SkeletonData *arg1 = (spine::SkeletonData *) NULL ;
    spine::Vector< spine::PhysicsConstraintData * > *result = 0 ;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::SkeletonData>(s);
    if (nullptr == arg1) return true;
    result = (spine::Vector< spine::PhysicsConstraintData * > *) &(arg1)->getPhysicsConstraints();
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_SkeletonData_getPhysicsConstraints) 

static bool js_spine_SkeletonData_getReferenceScale(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::SkeletonData *arg1 = (spine::SkeletonData *) NULL ;
    float result;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::SkeletonData>(s);
    if (nullptr == arg1) return true;
    result = (float)(arg1)->getReferenceScale();
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_SkeletonData_getReferenceScale) 

static bool js_spine_SkeletonData_setReferenceScale(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::SkeletonData *arg1 = (spine::SkeletonData *) NULL ;
    float arg2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::SkeletonData>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setReferenceScale(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_SkeletonData_setReferenceScale) 

static bool js_spine_SkeletonData_name_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::SkeletonData *arg1 = (spine::SkeletonData *) NULL ;
    spine::String *arg2 = 0 ;
    spine::String temp2 ;
    
    arg1 = SE_THIS_OBJECT<spine::SkeletonData>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    spine_SkeletonData_name_set(arg1,*arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_SkeletonData_name_set) 

static bool js_spine_SkeletonData_name_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::SkeletonData *arg1 = (spine::SkeletonData *) NULL ;
    spine::String *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::SkeletonData>(s);
    if (nullptr == arg1) return true;
    result = (spine::String *) &spine_SkeletonData_name_get(arg1);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_SkeletonData_name_get) 

static bool js_spine_SkeletonData_bones_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::SkeletonData *arg1 = (spine::SkeletonData *) NULL ;
    spine::Vector< spine::BoneData * > *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::SkeletonData>(s);
    if (nullptr == arg1) return true;
    result = (spine::Vector< spine::BoneData * > *) &spine_SkeletonData_bones_get(arg1);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_SkeletonData_bones_get) 

static bool js_spine_SkeletonData_slots_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::SkeletonData *arg1 = (spine::SkeletonData *) NULL ;
    spine::Vector< spine::SlotData * > *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::SkeletonData>(s);
    if (nullptr == arg1) return true;
    result = (spine::Vector< spine::SlotData * > *) &spine_SkeletonData_slots_get(arg1);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_SkeletonData_slots_get) 

static bool js_spine_SkeletonData_skins_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::SkeletonData *arg1 = (spine::SkeletonData *) NULL ;
    spine::Vector< spine::Skin * > *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::SkeletonData>(s);
    if (nullptr == arg1) return true;
    result = (spine::Vector< spine::Skin * > *) &spine_SkeletonData_skins_get(arg1);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_SkeletonData_skins_get) 

static bool js_spine_SkeletonData_defaultSkin_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::SkeletonData *arg1 = (spine::SkeletonData *) NULL ;
    spine::Skin *arg2 = (spine::Skin *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::SkeletonData>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_SkeletonData_defaultSkin_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_SkeletonData_defaultSkin_set) 

static bool js_spine_SkeletonData_defaultSkin_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::SkeletonData *arg1 = (spine::SkeletonData *) NULL ;
    spine::Skin *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::SkeletonData>(s);
    if (nullptr == arg1) return true;
    result = (spine::Skin *)spine_SkeletonData_defaultSkin_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_SkeletonData_defaultSkin_get) 

static bool js_spine_SkeletonData_events_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::SkeletonData *arg1 = (spine::SkeletonData *) NULL ;
    spine::Vector< spine::EventData * > *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::SkeletonData>(s);
    if (nullptr == arg1) return true;
    result = (spine::Vector< spine::EventData * > *) &spine_SkeletonData_events_get(arg1);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_SkeletonData_events_get) 

static bool js_spine_SkeletonData_animations_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::SkeletonData *arg1 = (spine::SkeletonData *) NULL ;
    spine::Vector< spine::Animation * > *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::SkeletonData>(s);
    if (nullptr == arg1) return true;
    result = (spine::Vector< spine::Animation * > *) &spine_SkeletonData_animations_get(arg1);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_SkeletonData_animations_get) 

static bool js_spine_SkeletonData_ikConstraints_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::SkeletonData *arg1 = (spine::SkeletonData *) NULL ;
    spine::Vector< spine::IkConstraintData * > *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::SkeletonData>(s);
    if (nullptr == arg1) return true;
    result = (spine::Vector< spine::IkConstraintData * > *) &spine_SkeletonData_ikConstraints_get(arg1);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_SkeletonData_ikConstraints_get) 

static bool js_spine_SkeletonData_transformConstraints_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::SkeletonData *arg1 = (spine::SkeletonData *) NULL ;
    spine::Vector< spine::TransformConstraintData * > *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::SkeletonData>(s);
    if (nullptr == arg1) return true;
    result = (spine::Vector< spine::TransformConstraintData * > *) &spine_SkeletonData_transformConstraints_get(arg1);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_SkeletonData_transformConstraints_get) 

static bool js_spine_SkeletonData_pathConstraints_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::SkeletonData *arg1 = (spine::SkeletonData *) NULL ;
    spine::Vector< spine::PathConstraintData * > *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::SkeletonData>(s);
    if (nullptr == arg1) return true;
    result = (spine::Vector< spine::PathConstraintData * > *) &spine_SkeletonData_pathConstraints_get(arg1);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_SkeletonData_pathConstraints_get) 

static bool js_spine_SkeletonData_x_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::SkeletonData *arg1 = (spine::SkeletonData *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::SkeletonData>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_SkeletonData_x_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_SkeletonData_x_set) 

static bool js_spine_SkeletonData_x_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::SkeletonData *arg1 = (spine::SkeletonData *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::SkeletonData>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_SkeletonData_x_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_SkeletonData_x_get) 

static bool js_spine_SkeletonData_y_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::SkeletonData *arg1 = (spine::SkeletonData *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::SkeletonData>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_SkeletonData_y_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_SkeletonData_y_set) 

static bool js_spine_SkeletonData_y_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::SkeletonData *arg1 = (spine::SkeletonData *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::SkeletonData>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_SkeletonData_y_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_SkeletonData_y_get) 

static bool js_spine_SkeletonData_width_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::SkeletonData *arg1 = (spine::SkeletonData *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::SkeletonData>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_SkeletonData_width_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_SkeletonData_width_set) 

static bool js_spine_SkeletonData_width_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::SkeletonData *arg1 = (spine::SkeletonData *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::SkeletonData>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_SkeletonData_width_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_SkeletonData_width_get) 

static bool js_spine_SkeletonData_height_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::SkeletonData *arg1 = (spine::SkeletonData *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::SkeletonData>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_SkeletonData_height_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_SkeletonData_height_set) 

static bool js_spine_SkeletonData_height_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::SkeletonData *arg1 = (spine::SkeletonData *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::SkeletonData>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_SkeletonData_height_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_SkeletonData_height_get) 

static bool js_spine_SkeletonData_version_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::SkeletonData *arg1 = (spine::SkeletonData *) NULL ;
    spine::String *arg2 = 0 ;
    spine::String temp2 ;
    
    arg1 = SE_THIS_OBJECT<spine::SkeletonData>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    spine_SkeletonData_version_set(arg1,*arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_SkeletonData_version_set) 

static bool js_spine_SkeletonData_version_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::SkeletonData *arg1 = (spine::SkeletonData *) NULL ;
    spine::String *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::SkeletonData>(s);
    if (nullptr == arg1) return true;
    result = (spine::String *) &spine_SkeletonData_version_get(arg1);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_SkeletonData_version_get) 

static bool js_spine_SkeletonData_hash_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::SkeletonData *arg1 = (spine::SkeletonData *) NULL ;
    spine::String *arg2 = 0 ;
    spine::String temp2 ;
    
    arg1 = SE_THIS_OBJECT<spine::SkeletonData>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    spine_SkeletonData_hash_set(arg1,*arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_SkeletonData_hash_set) 

static bool js_spine_SkeletonData_hash_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::SkeletonData *arg1 = (spine::SkeletonData *) NULL ;
    spine::String *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::SkeletonData>(s);
    if (nullptr == arg1) return true;
    result = (spine::String *) &spine_SkeletonData_hash_get(arg1);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_SkeletonData_hash_get) 

static bool js_spine_SkeletonData_fps_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::SkeletonData *arg1 = (spine::SkeletonData *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::SkeletonData>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_SkeletonData_fps_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_SkeletonData_fps_set) 

static bool js_spine_SkeletonData_fps_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::SkeletonData *arg1 = (spine::SkeletonData *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::SkeletonData>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_SkeletonData_fps_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_SkeletonData_fps_get) 

static bool js_spine_SkeletonData_imagesPath_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::SkeletonData *arg1 = (spine::SkeletonData *) NULL ;
    spine::String *arg2 = 0 ;
    spine::String temp2 ;
    
    arg1 = SE_THIS_OBJECT<spine::SkeletonData>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    spine_SkeletonData_imagesPath_set(arg1,*arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_SkeletonData_imagesPath_set) 

static bool js_spine_SkeletonData_imagesPath_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::SkeletonData *arg1 = (spine::SkeletonData *) NULL ;
    spine::String *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::SkeletonData>(s);
    if (nullptr == arg1) return true;
    result = (spine::String *) &spine_SkeletonData_imagesPath_get(arg1);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_SkeletonData_imagesPath_get) 

static bool js_spine_SkeletonData_audioPath_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::SkeletonData *arg1 = (spine::SkeletonData *) NULL ;
    spine::String *arg2 = 0 ;
    spine::String temp2 ;
    
    arg1 = SE_THIS_OBJECT<spine::SkeletonData>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    spine_SkeletonData_audioPath_set(arg1,*arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_SkeletonData_audioPath_set) 

static bool js_spine_SkeletonData_audioPath_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::SkeletonData *arg1 = (spine::SkeletonData *) NULL ;
    spine::String *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::SkeletonData>(s);
    if (nullptr == arg1) return true;
    result = (spine::String *) &spine_SkeletonData_audioPath_get(arg1);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_SkeletonData_audioPath_get) 

bool js_register_spine_SkeletonData(se::Object* obj) {
    auto* cls = se::Class::create("SkeletonData", obj, nullptr, _SE(js_new_spine_SkeletonData)); 
    
    cls->defineStaticProperty("__isJSB", se::Value(true), se::PropertyAttribute::READ_ONLY | se::PropertyAttribute::DONT_ENUM | se::PropertyAttribute::DONT_DELETE);
    cls->defineProperty("name", _SE(js_spine_SkeletonData_name_get), _SE(js_spine_SkeletonData_name_set)); 
    cls->defineProperty("bones", _SE(js_spine_SkeletonData_bones_get), nullptr); 
    cls->defineProperty("slots", _SE(js_spine_SkeletonData_slots_get), nullptr); 
    cls->defineProperty("skins", _SE(js_spine_SkeletonData_skins_get), nullptr); 
    cls->defineProperty("defaultSkin", _SE(js_spine_SkeletonData_defaultSkin_get), _SE(js_spine_SkeletonData_defaultSkin_set)); 
    cls->defineProperty("events", _SE(js_spine_SkeletonData_events_get), nullptr); 
    cls->defineProperty("animations", _SE(js_spine_SkeletonData_animations_get), nullptr); 
    cls->defineProperty("ikConstraints", _SE(js_spine_SkeletonData_ikConstraints_get), nullptr); 
    cls->defineProperty("transformConstraints", _SE(js_spine_SkeletonData_transformConstraints_get), nullptr); 
    cls->defineProperty("pathConstraints", _SE(js_spine_SkeletonData_pathConstraints_get), nullptr); 
    cls->defineProperty("x", _SE(js_spine_SkeletonData_x_get), _SE(js_spine_SkeletonData_x_set)); 
    cls->defineProperty("y", _SE(js_spine_SkeletonData_y_get), _SE(js_spine_SkeletonData_y_set)); 
    cls->defineProperty("width", _SE(js_spine_SkeletonData_width_get), _SE(js_spine_SkeletonData_width_set)); 
    cls->defineProperty("height", _SE(js_spine_SkeletonData_height_get), _SE(js_spine_SkeletonData_height_set)); 
    cls->defineProperty("version", _SE(js_spine_SkeletonData_version_get), _SE(js_spine_SkeletonData_version_set)); 
    cls->defineProperty("hash", _SE(js_spine_SkeletonData_hash_get), _SE(js_spine_SkeletonData_hash_set)); 
    cls->defineProperty("fps", _SE(js_spine_SkeletonData_fps_get), _SE(js_spine_SkeletonData_fps_set)); 
    cls->defineProperty("imagesPath", _SE(js_spine_SkeletonData_imagesPath_get), _SE(js_spine_SkeletonData_imagesPath_set)); 
    cls->defineProperty("audioPath", _SE(js_spine_SkeletonData_audioPath_get), _SE(js_spine_SkeletonData_audioPath_set)); 
    
    cls->defineFunction("findBone", _SE(js_spine_SkeletonData_findBone)); 
    cls->defineFunction("findSlot", _SE(js_spine_SkeletonData_findSlot)); 
    cls->defineFunction("findSkin", _SE(js_spine_SkeletonData_findSkin)); 
    cls->defineFunction("findEvent", _SE(js_spine_SkeletonData_findEvent)); 
    cls->defineFunction("findAnimation", _SE(js_spine_SkeletonData_findAnimation)); 
    cls->defineFunction("findIkConstraint", _SE(js_spine_SkeletonData_findIkConstraint)); 
    cls->defineFunction("findTransformConstraint", _SE(js_spine_SkeletonData_findTransformConstraint)); 
    cls->defineFunction("findPathConstraint", _SE(js_spine_SkeletonData_findPathConstraint)); 
    cls->defineFunction("findPhysicsConstraint", _SE(js_spine_SkeletonData_findPhysicsConstraint)); 
    cls->defineFunction("getPhysicsConstraints", _SE(js_spine_SkeletonData_getPhysicsConstraints)); 
    cls->defineFunction("getReferenceScale", _SE(js_spine_SkeletonData_getReferenceScale)); 
    cls->defineFunction("setReferenceScale", _SE(js_spine_SkeletonData_setReferenceScale)); 
    
    
    
    
    cls->defineFinalizeFunction(_SE(js_delete_spine_SkeletonData));
    
    
    cls->install();
    JSBClassType::registerClass<spine::SkeletonData>(cls);
    
    __jsb_spine_SkeletonData_proto = cls->getProto();
    __jsb_spine_SkeletonData_class = cls;
    se::ScriptEngine::getInstance()->clearException();
    return true;
}


se::Class* __jsb_spine_SlotData_class = nullptr;
se::Object* __jsb_spine_SlotData_proto = nullptr;
SE_DECLARE_FINALIZE_FUNC(js_delete_spine_SlotData) 

static bool js_spine_SlotData_hasDarkColor(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::SlotData *arg1 = (spine::SlotData *) NULL ;
    bool result;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::SlotData>(s);
    if (nullptr == arg1) return true;
    result = (bool)(arg1)->hasDarkColor();
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    
    
    return true;
}
SE_BIND_FUNC(js_spine_SlotData_hasDarkColor) 

static bool js_spine_SlotData_setHasDarkColor(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::SlotData *arg1 = (spine::SlotData *) NULL ;
    bool arg2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::SlotData>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2);
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setHasDarkColor(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_SlotData_setHasDarkColor) 

static bool js_spine_SlotData_isVisible(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::SlotData *arg1 = (spine::SlotData *) NULL ;
    bool result;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::SlotData>(s);
    if (nullptr == arg1) return true;
    result = (bool)(arg1)->isVisible();
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    
    
    return true;
}
SE_BIND_FUNC(js_spine_SlotData_isVisible) 

static bool js_spine_SlotData_setVisible(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::SlotData *arg1 = (spine::SlotData *) NULL ;
    bool arg2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::SlotData>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2);
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setVisible(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_SlotData_setVisible) 

static bool js_spine_SlotData_index_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::SlotData *arg1 = (spine::SlotData *) NULL ;
    int result;
    
    arg1 = SE_THIS_OBJECT<spine::SlotData>(s);
    if (nullptr == arg1) return true;
    result = (int)spine_SlotData_index_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_SlotData_index_get) 

static bool js_spine_SlotData_name_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::SlotData *arg1 = (spine::SlotData *) NULL ;
    spine::String *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::SlotData>(s);
    if (nullptr == arg1) return true;
    result = (spine::String *) &spine_SlotData_name_get(arg1);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_SlotData_name_get) 

static bool js_spine_SlotData_boneData_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::SlotData *arg1 = (spine::SlotData *) NULL ;
    spine::BoneData *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::SlotData>(s);
    if (nullptr == arg1) return true;
    result = (spine::BoneData *) &spine_SlotData_boneData_get(arg1);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_SlotData_boneData_get) 

static bool js_spine_SlotData_color_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::SlotData *arg1 = (spine::SlotData *) NULL ;
    spine::Color *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::SlotData>(s);
    if (nullptr == arg1) return true;
    result = (spine::Color *) &spine_SlotData_color_get(arg1);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_SlotData_color_get) 

static bool js_spine_SlotData_darkColor_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::SlotData *arg1 = (spine::SlotData *) NULL ;
    spine::Color *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::SlotData>(s);
    if (nullptr == arg1) return true;
    result = (spine::Color *) &spine_SlotData_darkColor_get(arg1);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_SlotData_darkColor_get) 

static bool js_spine_SlotData_attachmentName_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::SlotData *arg1 = (spine::SlotData *) NULL ;
    spine::String *arg2 = 0 ;
    spine::String temp2 ;
    
    arg1 = SE_THIS_OBJECT<spine::SlotData>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    spine_SlotData_attachmentName_set(arg1,*arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_SlotData_attachmentName_set) 

static bool js_spine_SlotData_attachmentName_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::SlotData *arg1 = (spine::SlotData *) NULL ;
    spine::String *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::SlotData>(s);
    if (nullptr == arg1) return true;
    result = (spine::String *) &spine_SlotData_attachmentName_get(arg1);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_SlotData_attachmentName_get) 

static bool js_spine_SlotData_blendMode_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::SlotData *arg1 = (spine::SlotData *) NULL ;
    spine::BlendMode arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::SlotData>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    spine_SlotData_blendMode_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_SlotData_blendMode_set) 

static bool js_spine_SlotData_blendMode_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::SlotData *arg1 = (spine::SlotData *) NULL ;
    spine::BlendMode result;
    
    arg1 = SE_THIS_OBJECT<spine::SlotData>(s);
    if (nullptr == arg1) return true;
    result = (spine::BlendMode)spine_SlotData_blendMode_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject() /*ctx*/);
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval());
    
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_SlotData_blendMode_get) 

static bool js_new_spine_SlotData(se::State& s) // NOLINT(readability-identifier-naming)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    if (argc != 3) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 3);
        return false;
    }
    
    int arg1 ;
    ccstd::string *arg2 = (ccstd::string *) NULL ;
    spine::BoneData *arg3 = (spine::BoneData *) NULL ;
    spine::SlotData *result;
    
    ok &= sevalue_to_native(args[0], &arg1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[1], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[2], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (spine::SlotData *)new_spine_SlotData(arg1,(ccstd::string const *)arg2,arg3);
    
    
    auto *ptr = JSB_MAKE_PRIVATE_OBJECT_WITH_INSTANCE(result);
    s.thisObject()->setPrivateObject(ptr);
    return true;
}
SE_BIND_CTOR(js_new_spine_SlotData, __jsb_spine_SlotData_class, js_delete_spine_SlotData)

static bool js_delete_spine_SlotData(se::State& s)
{
    return true;
}
SE_BIND_FINALIZE_FUNC(js_delete_spine_SlotData) 

bool js_register_spine_SlotData(se::Object* obj) {
    auto* cls = se::Class::create("SlotData", obj, nullptr, _SE(js_new_spine_SlotData)); 
    
    cls->defineStaticProperty("__isJSB", se::Value(true), se::PropertyAttribute::READ_ONLY | se::PropertyAttribute::DONT_ENUM | se::PropertyAttribute::DONT_DELETE);
    cls->defineProperty("index", _SE(js_spine_SlotData_index_get), nullptr); 
    cls->defineProperty("name", _SE(js_spine_SlotData_name_get), nullptr); 
    cls->defineProperty("boneData", _SE(js_spine_SlotData_boneData_get), nullptr); 
    cls->defineProperty("color", _SE(js_spine_SlotData_color_get), nullptr); 
    cls->defineProperty("darkColor", _SE(js_spine_SlotData_darkColor_get), nullptr); 
    cls->defineProperty("attachmentName", _SE(js_spine_SlotData_attachmentName_get), _SE(js_spine_SlotData_attachmentName_set)); 
    cls->defineProperty("blendMode", _SE(js_spine_SlotData_blendMode_get), _SE(js_spine_SlotData_blendMode_set)); 
    
    cls->defineFunction("hasDarkColor", _SE(js_spine_SlotData_hasDarkColor)); 
    cls->defineFunction("setHasDarkColor", _SE(js_spine_SlotData_setHasDarkColor)); 
    cls->defineFunction("isVisible", _SE(js_spine_SlotData_isVisible)); 
    cls->defineFunction("setVisible", _SE(js_spine_SlotData_setVisible)); 
    
    
    
    
    cls->defineFinalizeFunction(_SE(js_delete_spine_SlotData));
    
    
    cls->install();
    JSBClassType::registerClass<spine::SlotData>(cls);
    
    __jsb_spine_SlotData_proto = cls->getProto();
    __jsb_spine_SlotData_class = cls;
    se::ScriptEngine::getInstance()->clearException();
    return true;
}


se::Class* __jsb_spine_Sequence_class = nullptr;
se::Object* __jsb_spine_Sequence_proto = nullptr;
SE_DECLARE_FINALIZE_FUNC(js_delete_spine_Sequence) 

static bool js_new_spine_Sequence(se::State& s) // NOLINT(readability-identifier-naming)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    if (argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    
    int arg1 ;
    spine::Sequence *result;
    
    ok &= sevalue_to_native(args[0], &arg1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (spine::Sequence *)new spine::Sequence(arg1);
    
    
    auto *ptr = JSB_MAKE_PRIVATE_OBJECT_WITH_INSTANCE(result);
    s.thisObject()->setPrivateObject(ptr);
    return true;
}
SE_BIND_CTOR(js_new_spine_Sequence, __jsb_spine_Sequence_class, js_delete_spine_Sequence)

static bool js_delete_spine_Sequence(se::State& s)
{
    return true;
}
SE_BIND_FINALIZE_FUNC(js_delete_spine_Sequence) 

static bool js_spine_Sequence_copy(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Sequence *arg1 = (spine::Sequence *) NULL ;
    spine::Sequence *result = 0 ;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Sequence>(s);
    if (nullptr == arg1) return true;
    result = (spine::Sequence *)(arg1)->copy();
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Sequence_copy) 

static bool js_spine_Sequence_apply(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Sequence *arg1 = (spine::Sequence *) NULL ;
    spine::Slot *arg2 = (spine::Slot *) NULL ;
    spine::Attachment *arg3 = (spine::Attachment *) NULL ;
    
    if(argc != 2) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 2);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Sequence>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[1], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->apply(arg2,arg3);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Sequence_apply) 

static bool js_spine_Sequence_getPath(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Sequence *arg1 = (spine::Sequence *) NULL ;
    spine::String *arg2 = 0 ;
    int arg3 ;
    spine::String temp2 ;
    spine::String result;
    
    if(argc != 2) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 2);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Sequence>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    
    ok &= sevalue_to_native(args[1], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (arg1)->getPath((spine::String const &)*arg2,arg3);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject() /*ctx*/);
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval());
    
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Sequence_getPath) 

static bool js_spine_Sequence_getId(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Sequence *arg1 = (spine::Sequence *) NULL ;
    int result;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Sequence>(s);
    if (nullptr == arg1) return true;
    result = (int)(arg1)->getId();
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Sequence_getId) 

static bool js_spine_Sequence_setId(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Sequence *arg1 = (spine::Sequence *) NULL ;
    int arg2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Sequence>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setId(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Sequence_setId) 

static bool js_spine_Sequence_getStart(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Sequence *arg1 = (spine::Sequence *) NULL ;
    int result;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Sequence>(s);
    if (nullptr == arg1) return true;
    result = (int)(arg1)->getStart();
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Sequence_getStart) 

static bool js_spine_Sequence_setStart(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Sequence *arg1 = (spine::Sequence *) NULL ;
    int arg2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Sequence>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setStart(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Sequence_setStart) 

static bool js_spine_Sequence_getDigits(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Sequence *arg1 = (spine::Sequence *) NULL ;
    int result;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Sequence>(s);
    if (nullptr == arg1) return true;
    result = (int)(arg1)->getDigits();
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Sequence_getDigits) 

static bool js_spine_Sequence_setDigits(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Sequence *arg1 = (spine::Sequence *) NULL ;
    int arg2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Sequence>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setDigits(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Sequence_setDigits) 

static bool js_spine_Sequence_getSetupIndex(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Sequence *arg1 = (spine::Sequence *) NULL ;
    int result;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Sequence>(s);
    if (nullptr == arg1) return true;
    result = (int)(arg1)->getSetupIndex();
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Sequence_getSetupIndex) 

static bool js_spine_Sequence_setSetupIndex(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Sequence *arg1 = (spine::Sequence *) NULL ;
    int arg2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Sequence>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setSetupIndex(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Sequence_setSetupIndex) 

static bool js_spine_Sequence_getRegions(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Sequence *arg1 = (spine::Sequence *) NULL ;
    spine::Vector< TextureRegion * > *result = 0 ;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Sequence>(s);
    if (nullptr == arg1) return true;
    result = (spine::Vector< TextureRegion * > *) &(arg1)->getRegions();
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_Sequence_getRegions) 

bool js_register_spine_Sequence(se::Object* obj) {
    auto* cls = se::Class::create("Sequence", obj, nullptr, _SE(js_new_spine_Sequence)); 
    
    cls->defineStaticProperty("__isJSB", se::Value(true), se::PropertyAttribute::READ_ONLY | se::PropertyAttribute::DONT_ENUM | se::PropertyAttribute::DONT_DELETE);
    
    cls->defineFunction("copy", _SE(js_spine_Sequence_copy)); 
    cls->defineFunction("apply", _SE(js_spine_Sequence_apply)); 
    cls->defineFunction("getPath", _SE(js_spine_Sequence_getPath)); 
    cls->defineFunction("getId", _SE(js_spine_Sequence_getId)); 
    cls->defineFunction("setId", _SE(js_spine_Sequence_setId)); 
    cls->defineFunction("getStart", _SE(js_spine_Sequence_getStart)); 
    cls->defineFunction("setStart", _SE(js_spine_Sequence_setStart)); 
    cls->defineFunction("getDigits", _SE(js_spine_Sequence_getDigits)); 
    cls->defineFunction("setDigits", _SE(js_spine_Sequence_setDigits)); 
    cls->defineFunction("getSetupIndex", _SE(js_spine_Sequence_getSetupIndex)); 
    cls->defineFunction("setSetupIndex", _SE(js_spine_Sequence_setSetupIndex)); 
    cls->defineFunction("getRegions", _SE(js_spine_Sequence_getRegions)); 
    
    
    
    
    cls->defineFinalizeFunction(_SE(js_delete_spine_Sequence));
    
    
    cls->install();
    JSBClassType::registerClass<spine::Sequence>(cls);
    
    __jsb_spine_Sequence_proto = cls->getProto();
    __jsb_spine_Sequence_class = cls;
    se::ScriptEngine::getInstance()->clearException();
    return true;
}


se::Class* __jsb_spine_AtlasPage_class = nullptr;
se::Object* __jsb_spine_AtlasPage_proto = nullptr;
SE_DECLARE_FINALIZE_FUNC(js_delete_spine_AtlasPage) 

static bool js_spine_TextureAtlasPage_name_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::AtlasPage *arg1 = (spine::AtlasPage *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::AtlasPage>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg1->name, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_TextureAtlasPage_name_set) 

static bool js_spine_TextureAtlasPage_name_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::AtlasPage *arg1 = (spine::AtlasPage *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::AtlasPage>(s);
    if (nullptr == arg1) return true;
    
    ok &= nativevalue_to_se(arg1->name, s.rval(), s.thisObject() /*ctx*/);
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(arg1->name, s.thisObject(), s.rval());
    
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_TextureAtlasPage_name_get) 

static bool js_spine_TextureAtlasPage_texturePath_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::AtlasPage *arg1 = (spine::AtlasPage *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::AtlasPage>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg1->texturePath, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_TextureAtlasPage_texturePath_set) 

static bool js_spine_TextureAtlasPage_texturePath_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::AtlasPage *arg1 = (spine::AtlasPage *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::AtlasPage>(s);
    if (nullptr == arg1) return true;
    
    ok &= nativevalue_to_se(arg1->texturePath, s.rval(), s.thisObject() /*ctx*/);
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(arg1->texturePath, s.thisObject(), s.rval());
    
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_TextureAtlasPage_texturePath_get) 

static bool js_spine_TextureAtlasPage_format_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::AtlasPage *arg1 = (spine::AtlasPage *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::AtlasPage>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg1->format, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_TextureAtlasPage_format_set) 

static bool js_spine_TextureAtlasPage_format_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::AtlasPage *arg1 = (spine::AtlasPage *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::AtlasPage>(s);
    if (nullptr == arg1) return true;
    
    ok &= nativevalue_to_se(arg1->format, s.rval(), s.thisObject() /*ctx*/);
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(arg1->format, s.thisObject(), s.rval());
    
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_TextureAtlasPage_format_get) 

static bool js_spine_TextureAtlasPage_minFilter_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::AtlasPage *arg1 = (spine::AtlasPage *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::AtlasPage>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg1->minFilter, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_TextureAtlasPage_minFilter_set) 

static bool js_spine_TextureAtlasPage_minFilter_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::AtlasPage *arg1 = (spine::AtlasPage *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::AtlasPage>(s);
    if (nullptr == arg1) return true;
    
    ok &= nativevalue_to_se(arg1->minFilter, s.rval(), s.thisObject() /*ctx*/);
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(arg1->minFilter, s.thisObject(), s.rval());
    
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_TextureAtlasPage_minFilter_get) 

static bool js_spine_TextureAtlasPage_magFilter_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::AtlasPage *arg1 = (spine::AtlasPage *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::AtlasPage>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg1->magFilter, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_TextureAtlasPage_magFilter_set) 

static bool js_spine_TextureAtlasPage_magFilter_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::AtlasPage *arg1 = (spine::AtlasPage *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::AtlasPage>(s);
    if (nullptr == arg1) return true;
    
    ok &= nativevalue_to_se(arg1->magFilter, s.rval(), s.thisObject() /*ctx*/);
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(arg1->magFilter, s.thisObject(), s.rval());
    
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_TextureAtlasPage_magFilter_get) 

static bool js_spine_TextureAtlasPage_uWrap_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::AtlasPage *arg1 = (spine::AtlasPage *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::AtlasPage>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg1->uWrap, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_TextureAtlasPage_uWrap_set) 

static bool js_spine_TextureAtlasPage_uWrap_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::AtlasPage *arg1 = (spine::AtlasPage *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::AtlasPage>(s);
    if (nullptr == arg1) return true;
    
    ok &= nativevalue_to_se(arg1->uWrap, s.rval(), s.thisObject() /*ctx*/);
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(arg1->uWrap, s.thisObject(), s.rval());
    
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_TextureAtlasPage_uWrap_get) 

static bool js_spine_TextureAtlasPage_vWrap_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::AtlasPage *arg1 = (spine::AtlasPage *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::AtlasPage>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg1->vWrap, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_TextureAtlasPage_vWrap_set) 

static bool js_spine_TextureAtlasPage_vWrap_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::AtlasPage *arg1 = (spine::AtlasPage *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::AtlasPage>(s);
    if (nullptr == arg1) return true;
    
    ok &= nativevalue_to_se(arg1->vWrap, s.rval(), s.thisObject() /*ctx*/);
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(arg1->vWrap, s.thisObject(), s.rval());
    
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_TextureAtlasPage_vWrap_get) 

static bool js_spine_TextureAtlasPage_width_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::AtlasPage *arg1 = (spine::AtlasPage *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::AtlasPage>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg1->width, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_TextureAtlasPage_width_set) 

static bool js_spine_TextureAtlasPage_width_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::AtlasPage *arg1 = (spine::AtlasPage *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::AtlasPage>(s);
    if (nullptr == arg1) return true;
    
    ok &= nativevalue_to_se(arg1->width, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_TextureAtlasPage_width_get) 

static bool js_spine_TextureAtlasPage_height_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::AtlasPage *arg1 = (spine::AtlasPage *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::AtlasPage>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg1->height, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_TextureAtlasPage_height_set) 

static bool js_spine_TextureAtlasPage_height_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::AtlasPage *arg1 = (spine::AtlasPage *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::AtlasPage>(s);
    if (nullptr == arg1) return true;
    
    ok &= nativevalue_to_se(arg1->height, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_TextureAtlasPage_height_get) 

static bool js_spine_TextureAtlasPage_pma_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::AtlasPage *arg1 = (spine::AtlasPage *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::AtlasPage>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg1->pma);
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_TextureAtlasPage_pma_set) 

static bool js_spine_TextureAtlasPage_pma_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::AtlasPage *arg1 = (spine::AtlasPage *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::AtlasPage>(s);
    if (nullptr == arg1) return true;
    
    ok &= nativevalue_to_se(arg1->pma, s.rval(), s.thisObject());
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_TextureAtlasPage_pma_get) 

static bool js_spine_TextureAtlasPage_index_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::AtlasPage *arg1 = (spine::AtlasPage *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::AtlasPage>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg1->index, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_TextureAtlasPage_index_set) 

static bool js_spine_TextureAtlasPage_index_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::AtlasPage *arg1 = (spine::AtlasPage *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::AtlasPage>(s);
    if (nullptr == arg1) return true;
    
    ok &= nativevalue_to_se(arg1->index, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_TextureAtlasPage_index_get) 

static bool js_spine_TextureAtlasPage_texture_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::AtlasPage *arg1 = (spine::AtlasPage *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::AtlasPage>(s);
    if (nullptr == arg1) return true;
    ok &= sevalue_to_native(args[0], &arg1->texture);
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_TextureAtlasPage_texture_set) 

static bool js_spine_TextureAtlasPage_texture_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::AtlasPage *arg1 = (spine::AtlasPage *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::AtlasPage>(s);
    if (nullptr == arg1) return true;
    
    ok &= nativevalue_to_se(arg1->texture, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(arg1->texture, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_TextureAtlasPage_texture_get) 

static bool js_new_spine_AtlasPage(se::State& s) // NOLINT(readability-identifier-naming)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    if (argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    
    spine::String *arg1 = 0 ;
    spine::String temp1 ;
    spine::AtlasPage *result;
    
    ok &= sevalue_to_native(args[0], &temp1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg1 = &temp1;
    
    result = (spine::AtlasPage *)new spine::AtlasPage((spine::String const &)*arg1);
    
    
    auto *ptr = JSB_MAKE_PRIVATE_OBJECT_WITH_INSTANCE(result);
    s.thisObject()->setPrivateObject(ptr);
    return true;
}
SE_BIND_CTOR(js_new_spine_AtlasPage, __jsb_spine_AtlasPage_class, js_delete_spine_AtlasPage)

static bool js_delete_spine_AtlasPage(se::State& s)
{
    return true;
}
SE_BIND_FINALIZE_FUNC(js_delete_spine_AtlasPage) 

bool js_register_spine_AtlasPage(se::Object* obj) {
    auto* cls = se::Class::create("TextureAtlasPage", obj, nullptr, _SE(js_new_spine_AtlasPage)); 
    
    cls->defineStaticProperty("__isJSB", se::Value(true), se::PropertyAttribute::READ_ONLY | se::PropertyAttribute::DONT_ENUM | se::PropertyAttribute::DONT_DELETE);
    cls->defineProperty("name", _SE(js_spine_TextureAtlasPage_name_get), _SE(js_spine_TextureAtlasPage_name_set)); 
    cls->defineProperty("texturePath", _SE(js_spine_TextureAtlasPage_texturePath_get), _SE(js_spine_TextureAtlasPage_texturePath_set)); 
    cls->defineProperty("format", _SE(js_spine_TextureAtlasPage_format_get), _SE(js_spine_TextureAtlasPage_format_set)); 
    cls->defineProperty("minFilter", _SE(js_spine_TextureAtlasPage_minFilter_get), _SE(js_spine_TextureAtlasPage_minFilter_set)); 
    cls->defineProperty("magFilter", _SE(js_spine_TextureAtlasPage_magFilter_get), _SE(js_spine_TextureAtlasPage_magFilter_set)); 
    cls->defineProperty("uWrap", _SE(js_spine_TextureAtlasPage_uWrap_get), _SE(js_spine_TextureAtlasPage_uWrap_set)); 
    cls->defineProperty("vWrap", _SE(js_spine_TextureAtlasPage_vWrap_get), _SE(js_spine_TextureAtlasPage_vWrap_set)); 
    cls->defineProperty("width", _SE(js_spine_TextureAtlasPage_width_get), _SE(js_spine_TextureAtlasPage_width_set)); 
    cls->defineProperty("height", _SE(js_spine_TextureAtlasPage_height_get), _SE(js_spine_TextureAtlasPage_height_set)); 
    cls->defineProperty("pma", _SE(js_spine_TextureAtlasPage_pma_get), _SE(js_spine_TextureAtlasPage_pma_set)); 
    cls->defineProperty("index", _SE(js_spine_TextureAtlasPage_index_get), _SE(js_spine_TextureAtlasPage_index_set)); 
    cls->defineProperty("texture", _SE(js_spine_TextureAtlasPage_texture_get), _SE(js_spine_TextureAtlasPage_texture_set)); 
    
    
    
    
    
    cls->defineFinalizeFunction(_SE(js_delete_spine_AtlasPage));
    
    
    cls->install();
    JSBClassType::registerClass<spine::AtlasPage>(cls);
    
    __jsb_spine_AtlasPage_proto = cls->getProto();
    __jsb_spine_AtlasPage_class = cls;
    se::ScriptEngine::getInstance()->clearException();
    return true;
}


se::Class* __jsb_spine_AtlasRegion_class = nullptr;
se::Object* __jsb_spine_AtlasRegion_proto = nullptr;
SE_DECLARE_FINALIZE_FUNC(js_delete_spine_AtlasRegion) 

static bool js_spine_TextureAtlasRegion_page_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::AtlasRegion *arg1 = (spine::AtlasRegion *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::AtlasRegion>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg1->page, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_TextureAtlasRegion_page_set) 

static bool js_spine_TextureAtlasRegion_page_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::AtlasRegion *arg1 = (spine::AtlasRegion *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::AtlasRegion>(s);
    if (nullptr == arg1) return true;
    
    ok &= nativevalue_to_se(arg1->page, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(arg1->page, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_TextureAtlasRegion_page_get) 

static bool js_spine_TextureAtlasRegion_name_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::AtlasRegion *arg1 = (spine::AtlasRegion *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::AtlasRegion>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg1->name, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_TextureAtlasRegion_name_set) 

static bool js_spine_TextureAtlasRegion_name_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::AtlasRegion *arg1 = (spine::AtlasRegion *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::AtlasRegion>(s);
    if (nullptr == arg1) return true;
    
    ok &= nativevalue_to_se(arg1->name, s.rval(), s.thisObject() /*ctx*/);
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(arg1->name, s.thisObject(), s.rval());
    
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_TextureAtlasRegion_name_get) 

static bool js_spine_TextureAtlasRegion_index_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::AtlasRegion *arg1 = (spine::AtlasRegion *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::AtlasRegion>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg1->index, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_TextureAtlasRegion_index_set) 

static bool js_spine_TextureAtlasRegion_index_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::AtlasRegion *arg1 = (spine::AtlasRegion *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::AtlasRegion>(s);
    if (nullptr == arg1) return true;
    
    ok &= nativevalue_to_se(arg1->index, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_TextureAtlasRegion_index_get) 

static bool js_spine_TextureAtlasRegion_x_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::AtlasRegion *arg1 = (spine::AtlasRegion *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::AtlasRegion>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg1->x, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_TextureAtlasRegion_x_set) 

static bool js_spine_TextureAtlasRegion_x_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::AtlasRegion *arg1 = (spine::AtlasRegion *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::AtlasRegion>(s);
    if (nullptr == arg1) return true;
    
    ok &= nativevalue_to_se(arg1->x, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_TextureAtlasRegion_x_get) 

static bool js_spine_TextureAtlasRegion_y_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::AtlasRegion *arg1 = (spine::AtlasRegion *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::AtlasRegion>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg1->y, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_TextureAtlasRegion_y_set) 

static bool js_spine_TextureAtlasRegion_y_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::AtlasRegion *arg1 = (spine::AtlasRegion *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::AtlasRegion>(s);
    if (nullptr == arg1) return true;
    
    ok &= nativevalue_to_se(arg1->y, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_TextureAtlasRegion_y_get) 

static bool js_spine_TextureAtlasRegion_splits_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::AtlasRegion *arg1 = (spine::AtlasRegion *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::AtlasRegion>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg1->splits, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_TextureAtlasRegion_splits_set) 

static bool js_spine_TextureAtlasRegion_splits_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::AtlasRegion *arg1 = (spine::AtlasRegion *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::AtlasRegion>(s);
    if (nullptr == arg1) return true;
    
    ok &= nativevalue_to_se(arg1->splits, s.rval(), s.thisObject() /*ctx*/);
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(arg1->splits, s.thisObject(), s.rval());
    
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_TextureAtlasRegion_splits_get) 

static bool js_spine_TextureAtlasRegion_pads_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::AtlasRegion *arg1 = (spine::AtlasRegion *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::AtlasRegion>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg1->pads, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_TextureAtlasRegion_pads_set) 

static bool js_spine_TextureAtlasRegion_pads_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::AtlasRegion *arg1 = (spine::AtlasRegion *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::AtlasRegion>(s);
    if (nullptr == arg1) return true;
    
    ok &= nativevalue_to_se(arg1->pads, s.rval(), s.thisObject() /*ctx*/);
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(arg1->pads, s.thisObject(), s.rval());
    
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_TextureAtlasRegion_pads_get) 

static bool js_spine_TextureAtlasRegion_names_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::AtlasRegion *arg1 = (spine::AtlasRegion *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::AtlasRegion>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg1->names, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_TextureAtlasRegion_names_set) 

static bool js_spine_TextureAtlasRegion_names_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::AtlasRegion *arg1 = (spine::AtlasRegion *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::AtlasRegion>(s);
    if (nullptr == arg1) return true;
    
    ok &= nativevalue_to_se(arg1->names, s.rval(), s.thisObject() /*ctx*/);
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(arg1->names, s.thisObject(), s.rval());
    
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_TextureAtlasRegion_names_get) 

static bool js_spine_TextureAtlasRegion_values_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::AtlasRegion *arg1 = (spine::AtlasRegion *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::AtlasRegion>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg1->values, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_TextureAtlasRegion_values_set) 

static bool js_spine_TextureAtlasRegion_values_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::AtlasRegion *arg1 = (spine::AtlasRegion *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::AtlasRegion>(s);
    if (nullptr == arg1) return true;
    
    ok &= nativevalue_to_se(arg1->values, s.rval(), s.thisObject() /*ctx*/);
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(arg1->values, s.thisObject(), s.rval());
    
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_TextureAtlasRegion_values_get) 

static bool js_new_spine_AtlasRegion(se::State& s) // NOLINT(readability-identifier-naming)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    spine::AtlasRegion *result;
    result = (spine::AtlasRegion *)new spine::AtlasRegion();
    
    
    auto *ptr = JSB_MAKE_PRIVATE_OBJECT_WITH_INSTANCE(result);
    s.thisObject()->setPrivateObject(ptr);
    return true;
}
SE_BIND_CTOR(js_new_spine_AtlasRegion, __jsb_spine_AtlasRegion_class, js_delete_spine_AtlasRegion)

static bool js_delete_spine_AtlasRegion(se::State& s)
{
    return true;
}
SE_BIND_FINALIZE_FUNC(js_delete_spine_AtlasRegion) 

bool js_register_spine_AtlasRegion(se::Object* obj) {
    auto* cls = se::Class::create("TextureAtlasRegion", obj, nullptr, _SE(js_new_spine_AtlasRegion)); 
    
    cls->defineStaticProperty("__isJSB", se::Value(true), se::PropertyAttribute::READ_ONLY | se::PropertyAttribute::DONT_ENUM | se::PropertyAttribute::DONT_DELETE);
    cls->defineProperty("page", _SE(js_spine_TextureAtlasRegion_page_get), _SE(js_spine_TextureAtlasRegion_page_set)); 
    cls->defineProperty("name", _SE(js_spine_TextureAtlasRegion_name_get), _SE(js_spine_TextureAtlasRegion_name_set)); 
    cls->defineProperty("index", _SE(js_spine_TextureAtlasRegion_index_get), _SE(js_spine_TextureAtlasRegion_index_set)); 
    cls->defineProperty("x", _SE(js_spine_TextureAtlasRegion_x_get), _SE(js_spine_TextureAtlasRegion_x_set)); 
    cls->defineProperty("y", _SE(js_spine_TextureAtlasRegion_y_get), _SE(js_spine_TextureAtlasRegion_y_set)); 
    cls->defineProperty("splits", _SE(js_spine_TextureAtlasRegion_splits_get), _SE(js_spine_TextureAtlasRegion_splits_set)); 
    cls->defineProperty("pads", _SE(js_spine_TextureAtlasRegion_pads_get), _SE(js_spine_TextureAtlasRegion_pads_set)); 
    cls->defineProperty("names", _SE(js_spine_TextureAtlasRegion_names_get), _SE(js_spine_TextureAtlasRegion_names_set)); 
    cls->defineProperty("values", _SE(js_spine_TextureAtlasRegion_values_get), _SE(js_spine_TextureAtlasRegion_values_set)); 
    
    
    
    
    
    cls->defineFinalizeFunction(_SE(js_delete_spine_AtlasRegion));
    
    
    cls->install();
    JSBClassType::registerClass<spine::AtlasRegion>(cls);
    
    __jsb_spine_AtlasRegion_proto = cls->getProto();
    __jsb_spine_AtlasRegion_class = cls;
    se::ScriptEngine::getInstance()->clearException();
    return true;
}


se::Class* __jsb_spine_Atlas_class = nullptr;
se::Object* __jsb_spine_Atlas_proto = nullptr;
SE_DECLARE_FINALIZE_FUNC(js_delete_spine_Atlas) 

static bool js_new_spine_Atlas__SWIG_0(se::State& s) // NOLINT(readability-identifier-naming)
{
    const auto& args = s.args();
    CC_UNUSED bool ok = true;
    spine::String *arg1 = 0 ;
    spine::TextureLoader *arg2 = (spine::TextureLoader *) NULL ;
    bool arg3 ;
    spine::String temp1 ;
    spine::Atlas *result;
    
    ok &= sevalue_to_native(args[0], &temp1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg1 = &temp1;
    
    
    ok &= sevalue_to_native(args[1], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[2], &arg3);
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (spine::Atlas *)new spine::Atlas((spine::String const &)*arg1,arg2,arg3);
    
    
    auto *ptr = JSB_MAKE_PRIVATE_OBJECT_WITH_INSTANCE(result);
    s.thisObject()->setPrivateObject(ptr);
    return true;
}


static bool js_new_spine_Atlas__SWIG_1(se::State& s) // NOLINT(readability-identifier-naming)
{
    const auto& args = s.args();
    CC_UNUSED bool ok = true;
    spine::String *arg1 = 0 ;
    spine::TextureLoader *arg2 = (spine::TextureLoader *) NULL ;
    spine::String temp1 ;
    spine::Atlas *result;
    
    ok &= sevalue_to_native(args[0], &temp1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg1 = &temp1;
    
    
    ok &= sevalue_to_native(args[1], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (spine::Atlas *)new spine::Atlas((spine::String const &)*arg1,arg2);
    
    
    auto *ptr = JSB_MAKE_PRIVATE_OBJECT_WITH_INSTANCE(result);
    s.thisObject()->setPrivateObject(ptr);
    return true;
}


static bool js_new_spine_Atlas__SWIG_2(se::State& s) // NOLINT(readability-identifier-naming)
{
    const auto& args = s.args();
    CC_UNUSED bool ok = true;
    char *arg1 = (char *) NULL ;
    int arg2 ;
    char *arg3 = (char *) NULL ;
    spine::TextureLoader *arg4 = (spine::TextureLoader *) NULL ;
    bool arg5 ;
    ccstd::string temp1 ;
    ccstd::string temp3 ;
    spine::Atlas *result;
    
    ok &= sevalue_to_native(args[0], &temp1);
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg1 = (char *) temp1.c_str(); 
    
    ok &= sevalue_to_native(args[1], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[2], &temp3);
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg3 = (char *) temp3.c_str(); 
    
    ok &= sevalue_to_native(args[3], &arg4, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[4], &arg5);
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (spine::Atlas *)new spine::Atlas((char const *)arg1,arg2,(char const *)arg3,arg4,arg5);
    
    
    auto *ptr = JSB_MAKE_PRIVATE_OBJECT_WITH_INSTANCE(result);
    s.thisObject()->setPrivateObject(ptr);
    return true;
}


static bool js_new_spine_Atlas__SWIG_3(se::State& s) // NOLINT(readability-identifier-naming)
{
    const auto& args = s.args();
    CC_UNUSED bool ok = true;
    char *arg1 = (char *) NULL ;
    int arg2 ;
    char *arg3 = (char *) NULL ;
    spine::TextureLoader *arg4 = (spine::TextureLoader *) NULL ;
    ccstd::string temp1 ;
    ccstd::string temp3 ;
    spine::Atlas *result;
    
    ok &= sevalue_to_native(args[0], &temp1);
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg1 = (char *) temp1.c_str(); 
    
    ok &= sevalue_to_native(args[1], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[2], &temp3);
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg3 = (char *) temp3.c_str(); 
    
    ok &= sevalue_to_native(args[3], &arg4, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (spine::Atlas *)new spine::Atlas((char const *)arg1,arg2,(char const *)arg3,arg4);
    
    
    auto *ptr = JSB_MAKE_PRIVATE_OBJECT_WITH_INSTANCE(result);
    s.thisObject()->setPrivateObject(ptr);
    return true;
}


static bool js_new_spine_Atlas(se::State& s) // NOLINT(readability-identifier-naming)
{
    size_t argc = s.args().size();
    bool ret = false;
    
    if(argc == 3) {
        ret = js_new_spine_Atlas__SWIG_0(s);
        if (ret) {
            return ret; 
        } /* reset exception and return */
    }
    
    if(argc == 2) {
        ret = js_new_spine_Atlas__SWIG_1(s);
        if (ret) {
            return ret; 
        } /* reset exception and return */
    }
    
    if(argc == 5) {
        ret = js_new_spine_Atlas__SWIG_2(s);
        if (ret) {
            return ret; 
        } /* reset exception and return */
    }
    
    if(argc == 4) {
        ret = js_new_spine_Atlas__SWIG_3(s);
        if (ret) {
            return ret; 
        } /* reset exception and return */
    }
    
    SE_REPORT_ERROR("Illegal arguments for construction of TextureAtlas");
    return false;
}
SE_BIND_CTOR(js_new_spine_Atlas, __jsb_spine_Atlas_class, js_delete_spine_Atlas)

static bool js_delete_spine_Atlas(se::State& s)
{
    return true;
}
SE_BIND_FINALIZE_FUNC(js_delete_spine_Atlas) 

static bool js_spine_TextureAtlas_flipV(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Atlas *arg1 = (spine::Atlas *) NULL ;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Atlas>(s);
    if (nullptr == arg1) return true;
    (arg1)->flipV();
    
    
    return true;
}
SE_BIND_FUNC(js_spine_TextureAtlas_flipV) 

static bool js_spine_TextureAtlas_findRegion(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Atlas *arg1 = (spine::Atlas *) NULL ;
    spine::String *arg2 = 0 ;
    spine::String temp2 ;
    spine::AtlasRegion *result = 0 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Atlas>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    result = (spine::AtlasRegion *)(arg1)->findRegion((spine::String const &)*arg2);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_TextureAtlas_findRegion) 

static bool js_spine_TextureAtlas_getPages(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Atlas *arg1 = (spine::Atlas *) NULL ;
    spine::Vector< spine::AtlasPage * > *result = 0 ;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Atlas>(s);
    if (nullptr == arg1) return true;
    result = (spine::Vector< spine::AtlasPage * > *) &(arg1)->getPages();
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_TextureAtlas_getPages) 

static bool js_spine_TextureAtlas_getRegions(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::Atlas *arg1 = (spine::Atlas *) NULL ;
    spine::Vector< spine::AtlasRegion * > *result = 0 ;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::Atlas>(s);
    if (nullptr == arg1) return true;
    result = (spine::Vector< spine::AtlasRegion * > *) &(arg1)->getRegions();
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_TextureAtlas_getRegions) 

bool js_register_spine_Atlas(se::Object* obj) {
    auto* cls = se::Class::create("TextureAtlas", obj, nullptr, _SE(js_new_spine_Atlas)); 
    
    cls->defineStaticProperty("__isJSB", se::Value(true), se::PropertyAttribute::READ_ONLY | se::PropertyAttribute::DONT_ENUM | se::PropertyAttribute::DONT_DELETE);
    
    cls->defineFunction("flipV", _SE(js_spine_TextureAtlas_flipV)); 
    cls->defineFunction("findRegion", _SE(js_spine_TextureAtlas_findRegion)); 
    cls->defineFunction("getPages", _SE(js_spine_TextureAtlas_getPages)); 
    cls->defineFunction("getRegions", _SE(js_spine_TextureAtlas_getRegions)); 
    
    
    
    
    cls->defineFinalizeFunction(_SE(js_delete_spine_Atlas));
    
    
    cls->install();
    JSBClassType::registerClass<spine::Atlas>(cls);
    
    __jsb_spine_Atlas_proto = cls->getProto();
    __jsb_spine_Atlas_class = cls;
    se::ScriptEngine::getInstance()->clearException();
    return true;
}


se::Class* __jsb_spine_TextureLoader_class = nullptr;
se::Object* __jsb_spine_TextureLoader_proto = nullptr;
SE_DECLARE_FINALIZE_FUNC(js_delete_spine_TextureLoader) 

static bool js_delete_spine_TextureLoader(se::State& s)
{
    return true;
}
SE_BIND_FINALIZE_FUNC(js_delete_spine_TextureLoader) 

static bool js_spine_TextureLoader_unload(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::TextureLoader *arg1 = (spine::TextureLoader *) NULL ;
    void *arg2 = (void *) NULL ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::TextureLoader>(s);
    if (nullptr == arg1) return true;
    ok &= sevalue_to_native(args[0], &arg2);
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    (arg1)->unload(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_TextureLoader_unload) 

static bool js_spine_TextureLoader_load(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::TextureLoader *arg1 = (spine::TextureLoader *) NULL ;
    spine::AtlasPage *arg2 = (spine::AtlasPage *) NULL ;
    spine::String *arg3 = 0 ;
    spine::String temp3 ;
    
    if(argc != 2) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 2);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::TextureLoader>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[1], &temp3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg3 = &temp3;
    
    spine_TextureLoader_load(arg1,arg2,(spine::String const &)*arg3);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_TextureLoader_load) 

bool js_register_spine_TextureLoader(se::Object* obj) {
    auto* cls = se::Class::create("TextureLoader", obj, nullptr, nullptr); 
    
    cls->defineStaticProperty("__isJSB", se::Value(true), se::PropertyAttribute::READ_ONLY | se::PropertyAttribute::DONT_ENUM | se::PropertyAttribute::DONT_DELETE);
    
    cls->defineFunction("unload", _SE(js_spine_TextureLoader_unload)); 
    cls->defineFunction("load", _SE(js_spine_TextureLoader_load)); 
    
    
    
    
    cls->defineFinalizeFunction(_SE(js_delete_spine_TextureLoader));
    
    
    cls->install();
    JSBClassType::registerClass<spine::TextureLoader>(cls);
    
    __jsb_spine_TextureLoader_proto = cls->getProto();
    __jsb_spine_TextureLoader_class = cls;
    se::ScriptEngine::getInstance()->clearException();
    return true;
}


se::Class* __jsb_spine_TextureRegion_class = nullptr;
se::Object* __jsb_spine_TextureRegion_proto = nullptr;
SE_DECLARE_FINALIZE_FUNC(js_delete_spine_TextureRegion) 

static bool js_spine_TextureRegion_rendererObject_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::TextureRegion *arg1 = (spine::TextureRegion *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::TextureRegion>(s);
    if (nullptr == arg1) return true;
    ok &= sevalue_to_native(args[0], &arg1->rendererObject);
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_TextureRegion_rendererObject_set) 

static bool js_spine_TextureRegion_rendererObject_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::TextureRegion *arg1 = (spine::TextureRegion *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::TextureRegion>(s);
    if (nullptr == arg1) return true;
    
    ok &= nativevalue_to_se(arg1->rendererObject, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(arg1->rendererObject, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_TextureRegion_rendererObject_get) 

static bool js_spine_TextureRegion_u_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::TextureRegion *arg1 = (spine::TextureRegion *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::TextureRegion>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg1->u, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_TextureRegion_u_set) 

static bool js_spine_TextureRegion_u_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::TextureRegion *arg1 = (spine::TextureRegion *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::TextureRegion>(s);
    if (nullptr == arg1) return true;
    
    ok &= nativevalue_to_se(arg1->u, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_TextureRegion_u_get) 

static bool js_spine_TextureRegion_v_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::TextureRegion *arg1 = (spine::TextureRegion *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::TextureRegion>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg1->v, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_TextureRegion_v_set) 

static bool js_spine_TextureRegion_v_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::TextureRegion *arg1 = (spine::TextureRegion *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::TextureRegion>(s);
    if (nullptr == arg1) return true;
    
    ok &= nativevalue_to_se(arg1->v, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_TextureRegion_v_get) 

static bool js_spine_TextureRegion_u2_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::TextureRegion *arg1 = (spine::TextureRegion *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::TextureRegion>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg1->u2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_TextureRegion_u2_set) 

static bool js_spine_TextureRegion_u2_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::TextureRegion *arg1 = (spine::TextureRegion *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::TextureRegion>(s);
    if (nullptr == arg1) return true;
    
    ok &= nativevalue_to_se(arg1->u2, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_TextureRegion_u2_get) 

static bool js_spine_TextureRegion_v2_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::TextureRegion *arg1 = (spine::TextureRegion *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::TextureRegion>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg1->v2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_TextureRegion_v2_set) 

static bool js_spine_TextureRegion_v2_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::TextureRegion *arg1 = (spine::TextureRegion *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::TextureRegion>(s);
    if (nullptr == arg1) return true;
    
    ok &= nativevalue_to_se(arg1->v2, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_TextureRegion_v2_get) 

static bool js_spine_TextureRegion_degrees_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::TextureRegion *arg1 = (spine::TextureRegion *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::TextureRegion>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg1->degrees, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_TextureRegion_degrees_set) 

static bool js_spine_TextureRegion_degrees_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::TextureRegion *arg1 = (spine::TextureRegion *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::TextureRegion>(s);
    if (nullptr == arg1) return true;
    
    ok &= nativevalue_to_se(arg1->degrees, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_TextureRegion_degrees_get) 

static bool js_spine_TextureRegion_offsetX_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::TextureRegion *arg1 = (spine::TextureRegion *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::TextureRegion>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg1->offsetX, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_TextureRegion_offsetX_set) 

static bool js_spine_TextureRegion_offsetX_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::TextureRegion *arg1 = (spine::TextureRegion *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::TextureRegion>(s);
    if (nullptr == arg1) return true;
    
    ok &= nativevalue_to_se(arg1->offsetX, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_TextureRegion_offsetX_get) 

static bool js_spine_TextureRegion_offsetY_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::TextureRegion *arg1 = (spine::TextureRegion *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::TextureRegion>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg1->offsetY, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_TextureRegion_offsetY_set) 

static bool js_spine_TextureRegion_offsetY_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::TextureRegion *arg1 = (spine::TextureRegion *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::TextureRegion>(s);
    if (nullptr == arg1) return true;
    
    ok &= nativevalue_to_se(arg1->offsetY, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_TextureRegion_offsetY_get) 

static bool js_spine_TextureRegion_width_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::TextureRegion *arg1 = (spine::TextureRegion *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::TextureRegion>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg1->width, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_TextureRegion_width_set) 

static bool js_spine_TextureRegion_width_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::TextureRegion *arg1 = (spine::TextureRegion *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::TextureRegion>(s);
    if (nullptr == arg1) return true;
    
    ok &= nativevalue_to_se(arg1->width, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_TextureRegion_width_get) 

static bool js_spine_TextureRegion_height_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::TextureRegion *arg1 = (spine::TextureRegion *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::TextureRegion>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg1->height, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_TextureRegion_height_set) 

static bool js_spine_TextureRegion_height_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::TextureRegion *arg1 = (spine::TextureRegion *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::TextureRegion>(s);
    if (nullptr == arg1) return true;
    
    ok &= nativevalue_to_se(arg1->height, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_TextureRegion_height_get) 

static bool js_spine_TextureRegion_originalWidth_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::TextureRegion *arg1 = (spine::TextureRegion *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::TextureRegion>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg1->originalWidth, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_TextureRegion_originalWidth_set) 

static bool js_spine_TextureRegion_originalWidth_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::TextureRegion *arg1 = (spine::TextureRegion *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::TextureRegion>(s);
    if (nullptr == arg1) return true;
    
    ok &= nativevalue_to_se(arg1->originalWidth, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_TextureRegion_originalWidth_get) 

static bool js_spine_TextureRegion_originalHeight_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::TextureRegion *arg1 = (spine::TextureRegion *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::TextureRegion>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg1->originalHeight, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_TextureRegion_originalHeight_set) 

static bool js_spine_TextureRegion_originalHeight_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::TextureRegion *arg1 = (spine::TextureRegion *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::TextureRegion>(s);
    if (nullptr == arg1) return true;
    
    ok &= nativevalue_to_se(arg1->originalHeight, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_TextureRegion_originalHeight_get) 

static bool js_new_spine_TextureRegion(se::State& s) // NOLINT(readability-identifier-naming)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    spine::TextureRegion *result;
    result = (spine::TextureRegion *)new spine::TextureRegion();
    
    
    auto *ptr = JSB_MAKE_PRIVATE_OBJECT_WITH_INSTANCE(result);
    s.thisObject()->setPrivateObject(ptr);
    return true;
}
SE_BIND_CTOR(js_new_spine_TextureRegion, __jsb_spine_TextureRegion_class, js_delete_spine_TextureRegion)

static bool js_delete_spine_TextureRegion(se::State& s)
{
    return true;
}
SE_BIND_FINALIZE_FUNC(js_delete_spine_TextureRegion) 

bool js_register_spine_TextureRegion(se::Object* obj) {
    auto* cls = se::Class::create("TextureRegion", obj, nullptr, _SE(js_new_spine_TextureRegion)); 
    
    cls->defineStaticProperty("__isJSB", se::Value(true), se::PropertyAttribute::READ_ONLY | se::PropertyAttribute::DONT_ENUM | se::PropertyAttribute::DONT_DELETE);
    cls->defineProperty("rendererObject", _SE(js_spine_TextureRegion_rendererObject_get), _SE(js_spine_TextureRegion_rendererObject_set)); 
    cls->defineProperty("u", _SE(js_spine_TextureRegion_u_get), _SE(js_spine_TextureRegion_u_set)); 
    cls->defineProperty("v", _SE(js_spine_TextureRegion_v_get), _SE(js_spine_TextureRegion_v_set)); 
    cls->defineProperty("u2", _SE(js_spine_TextureRegion_u2_get), _SE(js_spine_TextureRegion_u2_set)); 
    cls->defineProperty("v2", _SE(js_spine_TextureRegion_v2_get), _SE(js_spine_TextureRegion_v2_set)); 
    cls->defineProperty("degrees", _SE(js_spine_TextureRegion_degrees_get), _SE(js_spine_TextureRegion_degrees_set)); 
    cls->defineProperty("offsetX", _SE(js_spine_TextureRegion_offsetX_get), _SE(js_spine_TextureRegion_offsetX_set)); 
    cls->defineProperty("offsetY", _SE(js_spine_TextureRegion_offsetY_get), _SE(js_spine_TextureRegion_offsetY_set)); 
    cls->defineProperty("width", _SE(js_spine_TextureRegion_width_get), _SE(js_spine_TextureRegion_width_set)); 
    cls->defineProperty("height", _SE(js_spine_TextureRegion_height_get), _SE(js_spine_TextureRegion_height_set)); 
    cls->defineProperty("originalWidth", _SE(js_spine_TextureRegion_originalWidth_get), _SE(js_spine_TextureRegion_originalWidth_set)); 
    cls->defineProperty("originalHeight", _SE(js_spine_TextureRegion_originalHeight_get), _SE(js_spine_TextureRegion_originalHeight_set)); 
    
    
    
    
    
    cls->defineFinalizeFunction(_SE(js_delete_spine_TextureRegion));
    
    
    cls->install();
    JSBClassType::registerClass<spine::TextureRegion>(cls);
    
    __jsb_spine_TextureRegion_proto = cls->getProto();
    __jsb_spine_TextureRegion_class = cls;
    se::ScriptEngine::getInstance()->clearException();
    return true;
}


se::Class* __jsb_spine_TransformConstraint_class = nullptr;
se::Object* __jsb_spine_TransformConstraint_proto = nullptr;
SE_DECLARE_FINALIZE_FUNC(js_delete_spine_TransformConstraint) 

static bool js_spine_TransformConstraint_update(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::TransformConstraint *arg1 = (spine::TransformConstraint *) NULL ;
    Physics arg2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::TransformConstraint>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    (arg1)->update(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_TransformConstraint_update) 

static bool js_spine_TransformConstraint_getOrder(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::TransformConstraint *arg1 = (spine::TransformConstraint *) NULL ;
    int result;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::TransformConstraint>(s);
    if (nullptr == arg1) return true;
    result = (int)(arg1)->getOrder();
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_TransformConstraint_getOrder) 

static bool js_spine_TransformConstraint_setToSetupPose(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::TransformConstraint *arg1 = (spine::TransformConstraint *) NULL ;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::TransformConstraint>(s);
    if (nullptr == arg1) return true;
    (arg1)->setToSetupPose();
    
    
    return true;
}
SE_BIND_FUNC(js_spine_TransformConstraint_setToSetupPose) 

static bool js_spine_TransformConstraint_data_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::TransformConstraint *arg1 = (spine::TransformConstraint *) NULL ;
    spine::TransformConstraintData *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::TransformConstraint>(s);
    if (nullptr == arg1) return true;
    result = (spine::TransformConstraintData *) &spine_TransformConstraint_data_get(arg1);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_TransformConstraint_data_get) 

static bool js_spine_TransformConstraint_bones_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::TransformConstraint *arg1 = (spine::TransformConstraint *) NULL ;
    spine::Vector< spine::Bone * > *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::TransformConstraint>(s);
    if (nullptr == arg1) return true;
    result = (spine::Vector< spine::Bone * > *) &spine_TransformConstraint_bones_get(arg1);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_TransformConstraint_bones_get) 

static bool js_spine_TransformConstraint_target_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::TransformConstraint *arg1 = (spine::TransformConstraint *) NULL ;
    spine::Bone *arg2 = (spine::Bone *) NULL ;
    
    arg1 = SE_THIS_OBJECT<spine::TransformConstraint>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_TransformConstraint_target_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_TransformConstraint_target_set) 

static bool js_spine_TransformConstraint_target_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::TransformConstraint *arg1 = (spine::TransformConstraint *) NULL ;
    spine::Bone *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::TransformConstraint>(s);
    if (nullptr == arg1) return true;
    result = (spine::Bone *)spine_TransformConstraint_target_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_TransformConstraint_target_get) 

static bool js_spine_TransformConstraint_mixRotate_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::TransformConstraint *arg1 = (spine::TransformConstraint *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::TransformConstraint>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_TransformConstraint_mixRotate_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_TransformConstraint_mixRotate_set) 

static bool js_spine_TransformConstraint_mixRotate_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::TransformConstraint *arg1 = (spine::TransformConstraint *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::TransformConstraint>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_TransformConstraint_mixRotate_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_TransformConstraint_mixRotate_get) 

static bool js_spine_TransformConstraint_mixX_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::TransformConstraint *arg1 = (spine::TransformConstraint *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::TransformConstraint>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_TransformConstraint_mixX_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_TransformConstraint_mixX_set) 

static bool js_spine_TransformConstraint_mixX_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::TransformConstraint *arg1 = (spine::TransformConstraint *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::TransformConstraint>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_TransformConstraint_mixX_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_TransformConstraint_mixX_get) 

static bool js_spine_TransformConstraint_mixY_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::TransformConstraint *arg1 = (spine::TransformConstraint *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::TransformConstraint>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_TransformConstraint_mixY_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_TransformConstraint_mixY_set) 

static bool js_spine_TransformConstraint_mixY_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::TransformConstraint *arg1 = (spine::TransformConstraint *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::TransformConstraint>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_TransformConstraint_mixY_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_TransformConstraint_mixY_get) 

static bool js_spine_TransformConstraint_mixScaleX_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::TransformConstraint *arg1 = (spine::TransformConstraint *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::TransformConstraint>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_TransformConstraint_mixScaleX_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_TransformConstraint_mixScaleX_set) 

static bool js_spine_TransformConstraint_mixScaleX_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::TransformConstraint *arg1 = (spine::TransformConstraint *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::TransformConstraint>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_TransformConstraint_mixScaleX_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_TransformConstraint_mixScaleX_get) 

static bool js_spine_TransformConstraint_mixScaleY_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::TransformConstraint *arg1 = (spine::TransformConstraint *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::TransformConstraint>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_TransformConstraint_mixScaleY_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_TransformConstraint_mixScaleY_set) 

static bool js_spine_TransformConstraint_mixScaleY_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::TransformConstraint *arg1 = (spine::TransformConstraint *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::TransformConstraint>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_TransformConstraint_mixScaleY_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_TransformConstraint_mixScaleY_get) 

static bool js_spine_TransformConstraint_mixShearY_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::TransformConstraint *arg1 = (spine::TransformConstraint *) NULL ;
    float arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::TransformConstraint>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_TransformConstraint_mixShearY_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_TransformConstraint_mixShearY_set) 

static bool js_spine_TransformConstraint_mixShearY_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::TransformConstraint *arg1 = (spine::TransformConstraint *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::TransformConstraint>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_TransformConstraint_mixShearY_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_TransformConstraint_mixShearY_get) 

static bool js_spine_TransformConstraint_active_set(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::TransformConstraint *arg1 = (spine::TransformConstraint *) NULL ;
    bool arg2 ;
    
    arg1 = SE_THIS_OBJECT<spine::TransformConstraint>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2);
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    spine_TransformConstraint_active_set(arg1,arg2);
    
    
    return true;
}
SE_BIND_PROP_SET(js_spine_TransformConstraint_active_set) 

static bool js_spine_TransformConstraint_active_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::TransformConstraint *arg1 = (spine::TransformConstraint *) NULL ;
    bool result;
    
    arg1 = SE_THIS_OBJECT<spine::TransformConstraint>(s);
    if (nullptr == arg1) return true;
    result = (bool)spine_TransformConstraint_active_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_TransformConstraint_active_get) 

static bool js_new_spine_TransformConstraint(se::State& s) // NOLINT(readability-identifier-naming)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    if (argc != 2) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 2);
        return false;
    }
    
    spine::TransformConstraintData *arg1 = (spine::TransformConstraintData *) NULL ;
    spine::Skeleton *arg2 = (spine::Skeleton *) NULL ;
    spine::TransformConstraint *result;
    
    ok &= sevalue_to_native(args[0], &arg1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[1], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (spine::TransformConstraint *)new_spine_TransformConstraint(arg1,arg2);
    
    
    auto *ptr = JSB_MAKE_PRIVATE_OBJECT_WITH_INSTANCE(result);
    s.thisObject()->setPrivateObject(ptr);
    return true;
}
SE_BIND_CTOR(js_new_spine_TransformConstraint, __jsb_spine_TransformConstraint_class, js_delete_spine_TransformConstraint)

static bool js_delete_spine_TransformConstraint(se::State& s)
{
    return true;
}
SE_BIND_FINALIZE_FUNC(js_delete_spine_TransformConstraint) 

bool js_register_spine_TransformConstraint(se::Object* obj) {
    auto* cls = se::Class::create("TransformConstraint", obj, nullptr, _SE(js_new_spine_TransformConstraint)); 
    
    cls->defineStaticProperty("__isJSB", se::Value(true), se::PropertyAttribute::READ_ONLY | se::PropertyAttribute::DONT_ENUM | se::PropertyAttribute::DONT_DELETE);
    cls->defineProperty("data", _SE(js_spine_TransformConstraint_data_get), nullptr); 
    cls->defineProperty("bones", _SE(js_spine_TransformConstraint_bones_get), nullptr); 
    cls->defineProperty("target", _SE(js_spine_TransformConstraint_target_get), _SE(js_spine_TransformConstraint_target_set)); 
    cls->defineProperty("mixRotate", _SE(js_spine_TransformConstraint_mixRotate_get), _SE(js_spine_TransformConstraint_mixRotate_set)); 
    cls->defineProperty("mixX", _SE(js_spine_TransformConstraint_mixX_get), _SE(js_spine_TransformConstraint_mixX_set)); 
    cls->defineProperty("mixY", _SE(js_spine_TransformConstraint_mixY_get), _SE(js_spine_TransformConstraint_mixY_set)); 
    cls->defineProperty("mixScaleX", _SE(js_spine_TransformConstraint_mixScaleX_get), _SE(js_spine_TransformConstraint_mixScaleX_set)); 
    cls->defineProperty("mixScaleY", _SE(js_spine_TransformConstraint_mixScaleY_get), _SE(js_spine_TransformConstraint_mixScaleY_set)); 
    cls->defineProperty("mixShearY", _SE(js_spine_TransformConstraint_mixShearY_get), _SE(js_spine_TransformConstraint_mixShearY_set)); 
    cls->defineProperty("active", _SE(js_spine_TransformConstraint_active_get), _SE(js_spine_TransformConstraint_active_set)); 
    
    cls->defineFunction("update", _SE(js_spine_TransformConstraint_update)); 
    cls->defineFunction("getOrder", _SE(js_spine_TransformConstraint_getOrder)); 
    cls->defineFunction("setToSetupPose", _SE(js_spine_TransformConstraint_setToSetupPose)); 
    
    
    
    
    cls->defineFinalizeFunction(_SE(js_delete_spine_TransformConstraint));
    
    
    cls->install();
    JSBClassType::registerClass<spine::TransformConstraint>(cls);
    
    __jsb_spine_TransformConstraint_proto = cls->getProto();
    __jsb_spine_TransformConstraint_class = cls;
    se::ScriptEngine::getInstance()->clearException();
    return true;
}


se::Class* __jsb_spine_TransformConstraintData_class = nullptr;
se::Object* __jsb_spine_TransformConstraintData_proto = nullptr;
SE_DECLARE_FINALIZE_FUNC(js_delete_spine_TransformConstraintData) 

static bool js_new_spine_TransformConstraintData(se::State& s) // NOLINT(readability-identifier-naming)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    if (argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    
    spine::String *arg1 = 0 ;
    spine::String temp1 ;
    spine::TransformConstraintData *result;
    
    ok &= sevalue_to_native(args[0], &temp1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg1 = &temp1;
    
    result = (spine::TransformConstraintData *)new spine::TransformConstraintData((spine::String const &)*arg1);
    
    
    auto *ptr = JSB_MAKE_PRIVATE_OBJECT_WITH_INSTANCE(result);
    s.thisObject()->setPrivateObject(ptr);
    return true;
}
SE_BIND_CTOR(js_new_spine_TransformConstraintData, __jsb_spine_TransformConstraintData_class, js_delete_spine_TransformConstraintData)

static bool js_spine_TransformConstraintData_setTarget(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::TransformConstraintData *arg1 = (spine::TransformConstraintData *) NULL ;
    spine::BoneData *arg2 = (spine::BoneData *) NULL ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::TransformConstraintData>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setTarget(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_TransformConstraintData_setTarget) 

static bool js_spine_TransformConstraintData_setMixRotate(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::TransformConstraintData *arg1 = (spine::TransformConstraintData *) NULL ;
    float arg2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::TransformConstraintData>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setMixRotate(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_TransformConstraintData_setMixRotate) 

static bool js_spine_TransformConstraintData_setMixX(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::TransformConstraintData *arg1 = (spine::TransformConstraintData *) NULL ;
    float arg2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::TransformConstraintData>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setMixX(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_TransformConstraintData_setMixX) 

static bool js_spine_TransformConstraintData_setMixY(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::TransformConstraintData *arg1 = (spine::TransformConstraintData *) NULL ;
    float arg2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::TransformConstraintData>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setMixY(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_TransformConstraintData_setMixY) 

static bool js_spine_TransformConstraintData_setMixScaleX(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::TransformConstraintData *arg1 = (spine::TransformConstraintData *) NULL ;
    float arg2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::TransformConstraintData>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setMixScaleX(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_TransformConstraintData_setMixScaleX) 

static bool js_spine_TransformConstraintData_setMixScaleY(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::TransformConstraintData *arg1 = (spine::TransformConstraintData *) NULL ;
    float arg2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::TransformConstraintData>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setMixScaleY(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_TransformConstraintData_setMixScaleY) 

static bool js_spine_TransformConstraintData_setMixShearY(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::TransformConstraintData *arg1 = (spine::TransformConstraintData *) NULL ;
    float arg2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::TransformConstraintData>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setMixShearY(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_TransformConstraintData_setMixShearY) 

static bool js_spine_TransformConstraintData_setOffsetRotation(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::TransformConstraintData *arg1 = (spine::TransformConstraintData *) NULL ;
    float arg2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::TransformConstraintData>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setOffsetRotation(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_TransformConstraintData_setOffsetRotation) 

static bool js_spine_TransformConstraintData_setOffsetX(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::TransformConstraintData *arg1 = (spine::TransformConstraintData *) NULL ;
    float arg2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::TransformConstraintData>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setOffsetX(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_TransformConstraintData_setOffsetX) 

static bool js_spine_TransformConstraintData_setOffsetY(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::TransformConstraintData *arg1 = (spine::TransformConstraintData *) NULL ;
    float arg2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::TransformConstraintData>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setOffsetY(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_TransformConstraintData_setOffsetY) 

static bool js_spine_TransformConstraintData_setOffsetScaleX(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::TransformConstraintData *arg1 = (spine::TransformConstraintData *) NULL ;
    float arg2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::TransformConstraintData>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setOffsetScaleX(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_TransformConstraintData_setOffsetScaleX) 

static bool js_spine_TransformConstraintData_setOffsetScaleY(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::TransformConstraintData *arg1 = (spine::TransformConstraintData *) NULL ;
    float arg2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::TransformConstraintData>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setOffsetScaleY(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_TransformConstraintData_setOffsetScaleY) 

static bool js_spine_TransformConstraintData_setOffsetShearY(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::TransformConstraintData *arg1 = (spine::TransformConstraintData *) NULL ;
    float arg2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::TransformConstraintData>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setOffsetShearY(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_TransformConstraintData_setOffsetShearY) 

static bool js_spine_TransformConstraintData_setRelative(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::TransformConstraintData *arg1 = (spine::TransformConstraintData *) NULL ;
    bool arg2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::TransformConstraintData>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2);
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setRelative(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_TransformConstraintData_setRelative) 

static bool js_spine_TransformConstraintData_setLocal(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::TransformConstraintData *arg1 = (spine::TransformConstraintData *) NULL ;
    bool arg2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::TransformConstraintData>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2);
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setLocal(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_TransformConstraintData_setLocal) 

static bool js_spine_TransformConstraintData_bones_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::TransformConstraintData *arg1 = (spine::TransformConstraintData *) NULL ;
    spine::Vector< spine::BoneData * > *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::TransformConstraintData>(s);
    if (nullptr == arg1) return true;
    result = (spine::Vector< spine::BoneData * > *) &spine_TransformConstraintData_bones_get(arg1);
    
    ok &= nativevalue_to_se(*result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(*result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_TransformConstraintData_bones_get) 

static bool js_spine_TransformConstraintData_target_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::TransformConstraintData *arg1 = (spine::TransformConstraintData *) NULL ;
    spine::BoneData *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<spine::TransformConstraintData>(s);
    if (nullptr == arg1) return true;
    result = (spine::BoneData *)spine_TransformConstraintData_target_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_TransformConstraintData_target_get) 

static bool js_spine_TransformConstraintData_mixX_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::TransformConstraintData *arg1 = (spine::TransformConstraintData *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::TransformConstraintData>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_TransformConstraintData_mixX_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_TransformConstraintData_mixX_get) 

static bool js_spine_TransformConstraintData_mixY_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::TransformConstraintData *arg1 = (spine::TransformConstraintData *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::TransformConstraintData>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_TransformConstraintData_mixY_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_TransformConstraintData_mixY_get) 

static bool js_spine_TransformConstraintData_mixRotate_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::TransformConstraintData *arg1 = (spine::TransformConstraintData *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::TransformConstraintData>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_TransformConstraintData_mixRotate_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_TransformConstraintData_mixRotate_get) 

static bool js_spine_TransformConstraintData_mixScaleX_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::TransformConstraintData *arg1 = (spine::TransformConstraintData *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::TransformConstraintData>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_TransformConstraintData_mixScaleX_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_TransformConstraintData_mixScaleX_get) 

static bool js_spine_TransformConstraintData_mixScaleY_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::TransformConstraintData *arg1 = (spine::TransformConstraintData *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::TransformConstraintData>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_TransformConstraintData_mixScaleY_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_TransformConstraintData_mixScaleY_get) 

static bool js_spine_TransformConstraintData_mixShearY_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::TransformConstraintData *arg1 = (spine::TransformConstraintData *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::TransformConstraintData>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_TransformConstraintData_mixShearY_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_TransformConstraintData_mixShearY_get) 

static bool js_spine_TransformConstraintData_offsetRotation_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::TransformConstraintData *arg1 = (spine::TransformConstraintData *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::TransformConstraintData>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_TransformConstraintData_offsetRotation_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_TransformConstraintData_offsetRotation_get) 

static bool js_spine_TransformConstraintData_offsetX_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::TransformConstraintData *arg1 = (spine::TransformConstraintData *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::TransformConstraintData>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_TransformConstraintData_offsetX_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_TransformConstraintData_offsetX_get) 

static bool js_spine_TransformConstraintData_offsetY_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::TransformConstraintData *arg1 = (spine::TransformConstraintData *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::TransformConstraintData>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_TransformConstraintData_offsetY_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_TransformConstraintData_offsetY_get) 

static bool js_spine_TransformConstraintData_offsetScaleX_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::TransformConstraintData *arg1 = (spine::TransformConstraintData *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::TransformConstraintData>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_TransformConstraintData_offsetScaleX_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_TransformConstraintData_offsetScaleX_get) 

static bool js_spine_TransformConstraintData_offsetScaleY_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::TransformConstraintData *arg1 = (spine::TransformConstraintData *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::TransformConstraintData>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_TransformConstraintData_offsetScaleY_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_TransformConstraintData_offsetScaleY_get) 

static bool js_spine_TransformConstraintData_offsetShearY_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::TransformConstraintData *arg1 = (spine::TransformConstraintData *) NULL ;
    float result;
    
    arg1 = SE_THIS_OBJECT<spine::TransformConstraintData>(s);
    if (nullptr == arg1) return true;
    result = (float)spine_TransformConstraintData_offsetShearY_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_TransformConstraintData_offsetShearY_get) 

static bool js_spine_TransformConstraintData_relative_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::TransformConstraintData *arg1 = (spine::TransformConstraintData *) NULL ;
    bool result;
    
    arg1 = SE_THIS_OBJECT<spine::TransformConstraintData>(s);
    if (nullptr == arg1) return true;
    result = (bool)spine_TransformConstraintData_relative_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_TransformConstraintData_relative_get) 

static bool js_spine_TransformConstraintData_local_get(se::State& s)
{
    CC_UNUSED bool ok = true;
    spine::TransformConstraintData *arg1 = (spine::TransformConstraintData *) NULL ;
    bool result;
    
    arg1 = SE_THIS_OBJECT<spine::TransformConstraintData>(s);
    if (nullptr == arg1) return true;
    result = (bool)spine_TransformConstraintData_local_get(arg1);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    
    
    return true;
}
SE_BIND_PROP_GET(js_spine_TransformConstraintData_local_get) 

static bool js_delete_spine_TransformConstraintData(se::State& s)
{
    return true;
}
SE_BIND_FINALIZE_FUNC(js_delete_spine_TransformConstraintData) 

bool js_register_spine_TransformConstraintData(se::Object* obj) {
    auto* cls = se::Class::create("TransformConstraintData", obj, __jsb_spine_ConstraintData_proto, _SE(js_new_spine_TransformConstraintData)); 
    
    cls->defineStaticProperty("__isJSB", se::Value(true), se::PropertyAttribute::READ_ONLY | se::PropertyAttribute::DONT_ENUM | se::PropertyAttribute::DONT_DELETE);
    cls->defineProperty("bones", _SE(js_spine_TransformConstraintData_bones_get), nullptr); 
    cls->defineProperty("target", _SE(js_spine_TransformConstraintData_target_get), nullptr); 
    cls->defineProperty("mixX", _SE(js_spine_TransformConstraintData_mixX_get), nullptr); 
    cls->defineProperty("mixY", _SE(js_spine_TransformConstraintData_mixY_get), nullptr); 
    cls->defineProperty("mixRotate", _SE(js_spine_TransformConstraintData_mixRotate_get), nullptr); 
    cls->defineProperty("mixScaleX", _SE(js_spine_TransformConstraintData_mixScaleX_get), nullptr); 
    cls->defineProperty("mixScaleY", _SE(js_spine_TransformConstraintData_mixScaleY_get), nullptr); 
    cls->defineProperty("mixShearY", _SE(js_spine_TransformConstraintData_mixShearY_get), nullptr); 
    cls->defineProperty("offsetRotation", _SE(js_spine_TransformConstraintData_offsetRotation_get), nullptr); 
    cls->defineProperty("offsetX", _SE(js_spine_TransformConstraintData_offsetX_get), nullptr); 
    cls->defineProperty("offsetY", _SE(js_spine_TransformConstraintData_offsetY_get), nullptr); 
    cls->defineProperty("offsetScaleX", _SE(js_spine_TransformConstraintData_offsetScaleX_get), nullptr); 
    cls->defineProperty("offsetScaleY", _SE(js_spine_TransformConstraintData_offsetScaleY_get), nullptr); 
    cls->defineProperty("offsetShearY", _SE(js_spine_TransformConstraintData_offsetShearY_get), nullptr); 
    cls->defineProperty("relative", _SE(js_spine_TransformConstraintData_relative_get), nullptr); 
    cls->defineProperty("local", _SE(js_spine_TransformConstraintData_local_get), nullptr); 
    
    cls->defineFunction("setTarget", _SE(js_spine_TransformConstraintData_setTarget)); 
    cls->defineFunction("setMixRotate", _SE(js_spine_TransformConstraintData_setMixRotate)); 
    cls->defineFunction("setMixX", _SE(js_spine_TransformConstraintData_setMixX)); 
    cls->defineFunction("setMixY", _SE(js_spine_TransformConstraintData_setMixY)); 
    cls->defineFunction("setMixScaleX", _SE(js_spine_TransformConstraintData_setMixScaleX)); 
    cls->defineFunction("setMixScaleY", _SE(js_spine_TransformConstraintData_setMixScaleY)); 
    cls->defineFunction("setMixShearY", _SE(js_spine_TransformConstraintData_setMixShearY)); 
    cls->defineFunction("setOffsetRotation", _SE(js_spine_TransformConstraintData_setOffsetRotation)); 
    cls->defineFunction("setOffsetX", _SE(js_spine_TransformConstraintData_setOffsetX)); 
    cls->defineFunction("setOffsetY", _SE(js_spine_TransformConstraintData_setOffsetY)); 
    cls->defineFunction("setOffsetScaleX", _SE(js_spine_TransformConstraintData_setOffsetScaleX)); 
    cls->defineFunction("setOffsetScaleY", _SE(js_spine_TransformConstraintData_setOffsetScaleY)); 
    cls->defineFunction("setOffsetShearY", _SE(js_spine_TransformConstraintData_setOffsetShearY)); 
    cls->defineFunction("setRelative", _SE(js_spine_TransformConstraintData_setRelative)); 
    cls->defineFunction("setLocal", _SE(js_spine_TransformConstraintData_setLocal)); 
    
    
    
    
    cls->defineFinalizeFunction(_SE(js_delete_spine_TransformConstraintData));
    
    
    cls->install();
    JSBClassType::registerClass<spine::TransformConstraintData>(cls);
    
    __jsb_spine_TransformConstraintData_proto = cls->getProto();
    __jsb_spine_TransformConstraintData_class = cls;
    se::ScriptEngine::getInstance()->clearException();
    return true;
}


se::Class* __jsb_spine_TransformConstraintTimeline_class = nullptr;
se::Object* __jsb_spine_TransformConstraintTimeline_proto = nullptr;
SE_DECLARE_FINALIZE_FUNC(js_delete_spine_TransformConstraintTimeline) 

static bool js_new_spine_TransformConstraintTimeline(se::State& s) // NOLINT(readability-identifier-naming)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    if (argc != 3) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 3);
        return false;
    }
    
    size_t arg1 ;
    size_t arg2 ;
    int arg3 ;
    spine::TransformConstraintTimeline *result;
    
    ok &= sevalue_to_native(args[0], &arg1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    
    
    ok &= sevalue_to_native(args[1], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    
    
    ok &= sevalue_to_native(args[2], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (spine::TransformConstraintTimeline *)new spine::TransformConstraintTimeline(arg1,arg2,arg3);
    
    
    auto *ptr = JSB_MAKE_PRIVATE_OBJECT_WITH_INSTANCE(result);
    s.thisObject()->setPrivateObject(ptr);
    return true;
}
SE_BIND_CTOR(js_new_spine_TransformConstraintTimeline, __jsb_spine_TransformConstraintTimeline_class, js_delete_spine_TransformConstraintTimeline)

static bool js_spine_TransformConstraintTimeline_setFrame(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::TransformConstraintTimeline *arg1 = (spine::TransformConstraintTimeline *) NULL ;
    size_t arg2 ;
    float arg3 ;
    float arg4 ;
    float arg5 ;
    float arg6 ;
    float arg7 ;
    float arg8 ;
    float arg9 ;
    
    if(argc != 8) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 8);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::TransformConstraintTimeline>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    
    
    ok &= sevalue_to_native(args[1], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[2], &arg4, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[3], &arg5, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[4], &arg6, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[5], &arg7, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[6], &arg8, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[7], &arg9, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setFrame(arg2,arg3,arg4,arg5,arg6,arg7,arg8,arg9);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_TransformConstraintTimeline_setFrame) 

static bool js_spine_TransformConstraintTimeline_getTransformConstraintIndex(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::TransformConstraintTimeline *arg1 = (spine::TransformConstraintTimeline *) NULL ;
    int result;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::TransformConstraintTimeline>(s);
    if (nullptr == arg1) return true;
    result = (int)(arg1)->getTransformConstraintIndex();
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_FUNC(js_spine_TransformConstraintTimeline_getTransformConstraintIndex) 

static bool js_spine_TransformConstraintTimeline_setTransformConstraintIndex(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    spine::TransformConstraintTimeline *arg1 = (spine::TransformConstraintTimeline *) NULL ;
    int arg2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<spine::TransformConstraintTimeline>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setTransformConstraintIndex(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_spine_TransformConstraintTimeline_setTransformConstraintIndex) 

static bool js_delete_spine_TransformConstraintTimeline(se::State& s)
{
    return true;
}
SE_BIND_FINALIZE_FUNC(js_delete_spine_TransformConstraintTimeline) 

bool js_register_spine_TransformConstraintTimeline(se::Object* obj) {
    auto* cls = se::Class::create("TransformConstraintTimeline", obj, __jsb_spine_CurveTimeline_proto, _SE(js_new_spine_TransformConstraintTimeline)); 
    
    cls->defineStaticProperty("__isJSB", se::Value(true), se::PropertyAttribute::READ_ONLY | se::PropertyAttribute::DONT_ENUM | se::PropertyAttribute::DONT_DELETE);
    
    cls->defineFunction("setFrame", _SE(js_spine_TransformConstraintTimeline_setFrame)); 
    cls->defineFunction("getTransformConstraintIndex", _SE(js_spine_TransformConstraintTimeline_getTransformConstraintIndex)); 
    cls->defineFunction("setTransformConstraintIndex", _SE(js_spine_TransformConstraintTimeline_setTransformConstraintIndex)); 
    
    
    
    
    cls->defineFinalizeFunction(_SE(js_delete_spine_TransformConstraintTimeline));
    
    
    cls->install();
    JSBClassType::registerClass<spine::TransformConstraintTimeline>(cls);
    
    __jsb_spine_TransformConstraintTimeline_proto = cls->getProto();
    __jsb_spine_TransformConstraintTimeline_class = cls;
    se::ScriptEngine::getInstance()->clearException();
    return true;
}


se::Class* __jsb_cc_SkeletonRenderer_class = nullptr;
se::Object* __jsb_cc_SkeletonRenderer_proto = nullptr;
SE_DECLARE_FINALIZE_FUNC(js_delete_cc_SkeletonRenderer) 

static bool js_cc_SkeletonRenderer_create_static__SWIG_0(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    std::string *arg1 = 0 ;
    std::string *arg2 = 0 ;
    float arg3 ;
    std::string temp1 ;
    std::string temp2 ;
    cc::SkeletonRenderer *result = 0 ;
    
    
    ok &= sevalue_to_native(args[0], &temp1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg1 = &temp1;
    
    
    ok &= sevalue_to_native(args[1], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    
    ok &= sevalue_to_native(args[2], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (cc::SkeletonRenderer *)cc::SkeletonRenderer::createWithFile((std::string const &)*arg1,(std::string const &)*arg2,arg3);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}

static bool js_cc_SkeletonRenderer_create_static__SWIG_1(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    std::string *arg1 = 0 ;
    std::string *arg2 = 0 ;
    std::string temp1 ;
    std::string temp2 ;
    cc::SkeletonRenderer *result = 0 ;
    
    
    ok &= sevalue_to_native(args[0], &temp1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg1 = &temp1;
    
    
    ok &= sevalue_to_native(args[1], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    result = (cc::SkeletonRenderer *)cc::SkeletonRenderer::createWithFile((std::string const &)*arg1,(std::string const &)*arg2);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}

static bool js_cc_SkeletonRenderer_create_static(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    
    if (argc == 3) {
        ok = js_cc_SkeletonRenderer_create_static__SWIG_0(s);
        if (ok) {
            return true; 
        }
    } 
    if (argc == 2) {
        ok = js_cc_SkeletonRenderer_create_static__SWIG_1(s);
        if (ok) {
            return true; 
        }
    } 
    SE_REPORT_ERROR("wrong number of arguments: %d", (int)argc);
    return false;
}
SE_BIND_FUNC(js_cc_SkeletonRenderer_create_static) 

static bool js_cc_SkeletonRenderer_update(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonRenderer *arg1 = (cc::SkeletonRenderer *) NULL ;
    float arg2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonRenderer>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->update(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonRenderer_update) 

static bool js_cc_SkeletonRenderer_render(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonRenderer *arg1 = (cc::SkeletonRenderer *) NULL ;
    float arg2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonRenderer>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->render(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonRenderer_render) 

static bool js_cc_SkeletonRenderer_getBoundingBox(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonRenderer *arg1 = (cc::SkeletonRenderer *) NULL ;
    cc::Rect result;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonRenderer>(s);
    if (nullptr == arg1) return true;
    result = ((cc::SkeletonRenderer const *)arg1)->getBoundingBox();
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject() /*ctx*/);
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval());
    
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonRenderer_getBoundingBox) 

static bool js_cc_SkeletonRenderer_getSkeleton(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonRenderer *arg1 = (cc::SkeletonRenderer *) NULL ;
    spine::Skeleton *result = 0 ;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonRenderer>(s);
    if (nullptr == arg1) return true;
    result = (spine::Skeleton *)((cc::SkeletonRenderer const *)arg1)->getSkeleton();
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonRenderer_getSkeleton) 

static bool js_cc_SkeletonRenderer_setTimeScale(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonRenderer *arg1 = (cc::SkeletonRenderer *) NULL ;
    float arg2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonRenderer>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setTimeScale(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonRenderer_setTimeScale) 

static bool js_cc_SkeletonRenderer_getTimeScale(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonRenderer *arg1 = (cc::SkeletonRenderer *) NULL ;
    float result;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonRenderer>(s);
    if (nullptr == arg1) return true;
    result = (float)((cc::SkeletonRenderer const *)arg1)->getTimeScale();
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonRenderer_getTimeScale) 

static bool js_cc_SkeletonRenderer_updateWorldTransform(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonRenderer *arg1 = (cc::SkeletonRenderer *) NULL ;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonRenderer>(s);
    if (nullptr == arg1) return true;
    (arg1)->updateWorldTransform();
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonRenderer_updateWorldTransform) 

static bool js_cc_SkeletonRenderer_setToSetupPose(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonRenderer *arg1 = (cc::SkeletonRenderer *) NULL ;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonRenderer>(s);
    if (nullptr == arg1) return true;
    (arg1)->setToSetupPose();
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonRenderer_setToSetupPose) 

static bool js_cc_SkeletonRenderer_setBonesToSetupPose(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonRenderer *arg1 = (cc::SkeletonRenderer *) NULL ;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonRenderer>(s);
    if (nullptr == arg1) return true;
    (arg1)->setBonesToSetupPose();
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonRenderer_setBonesToSetupPose) 

static bool js_cc_SkeletonRenderer_setSlotsToSetupPose(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonRenderer *arg1 = (cc::SkeletonRenderer *) NULL ;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonRenderer>(s);
    if (nullptr == arg1) return true;
    (arg1)->setSlotsToSetupPose();
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonRenderer_setSlotsToSetupPose) 

static bool js_cc_SkeletonRenderer_paused(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonRenderer *arg1 = (cc::SkeletonRenderer *) NULL ;
    bool arg2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonRenderer>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2);
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->paused(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonRenderer_paused) 

static bool js_cc_SkeletonRenderer_findBone(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonRenderer *arg1 = (cc::SkeletonRenderer *) NULL ;
    std::string *arg2 = 0 ;
    std::string temp2 ;
    spine::Bone *result = 0 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonRenderer>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    result = (spine::Bone *)((cc::SkeletonRenderer const *)arg1)->findBone((std::string const &)*arg2);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonRenderer_findBone) 

static bool js_cc_SkeletonRenderer_findSlot(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonRenderer *arg1 = (cc::SkeletonRenderer *) NULL ;
    std::string *arg2 = 0 ;
    std::string temp2 ;
    spine::Slot *result = 0 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonRenderer>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    result = (spine::Slot *)((cc::SkeletonRenderer const *)arg1)->findSlot((std::string const &)*arg2);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonRenderer_findSlot) 

static bool js_cc_SkeletonRenderer_setSkin__SWIG_0(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    cc::SkeletonRenderer *arg1 = (cc::SkeletonRenderer *) NULL ;
    std::string *arg2 = 0 ;
    std::string temp2 ;
    
    arg1 = SE_THIS_OBJECT<cc::SkeletonRenderer>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    (arg1)->setSkin((std::string const &)*arg2);
    
    
    return true;
}

static bool js_cc_SkeletonRenderer_setSkin__SWIG_1(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    cc::SkeletonRenderer *arg1 = (cc::SkeletonRenderer *) NULL ;
    char *arg2 = (char *) NULL ;
    ccstd::string temp2 ;
    
    arg1 = SE_THIS_OBJECT<cc::SkeletonRenderer>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &temp2);
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = (char *) temp2.c_str(); 
    (arg1)->setSkin((char const *)arg2);
    
    
    return true;
}

static bool js_cc_SkeletonRenderer_setSkin(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    
    if (argc == 1) {
        ok = js_cc_SkeletonRenderer_setSkin__SWIG_0(s);
        if (ok) {
            return true; 
        }
    } 
    if (argc == 1) {
        ok = js_cc_SkeletonRenderer_setSkin__SWIG_1(s);
        if (ok) {
            return true; 
        }
    } 
    SE_REPORT_ERROR("wrong number of arguments: %d", (int)argc);
    return false;
}
SE_BIND_FUNC(js_cc_SkeletonRenderer_setSkin) 

static bool js_cc_SkeletonRenderer_getAttachment(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonRenderer *arg1 = (cc::SkeletonRenderer *) NULL ;
    std::string *arg2 = 0 ;
    std::string *arg3 = 0 ;
    std::string temp2 ;
    std::string temp3 ;
    spine::Attachment *result = 0 ;
    
    if(argc != 2) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 2);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonRenderer>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    
    ok &= sevalue_to_native(args[1], &temp3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg3 = &temp3;
    
    result = (spine::Attachment *)((cc::SkeletonRenderer const *)arg1)->getAttachment((std::string const &)*arg2,(std::string const &)*arg3);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonRenderer_getAttachment) 

static bool js_cc_SkeletonRenderer_setAttachment__SWIG_0(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    cc::SkeletonRenderer *arg1 = (cc::SkeletonRenderer *) NULL ;
    std::string *arg2 = 0 ;
    std::string *arg3 = 0 ;
    std::string temp2 ;
    std::string temp3 ;
    bool result;
    
    arg1 = SE_THIS_OBJECT<cc::SkeletonRenderer>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    
    ok &= sevalue_to_native(args[1], &temp3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg3 = &temp3;
    
    result = (bool)(arg1)->setAttachment((std::string const &)*arg2,(std::string const &)*arg3);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    
    
    return true;
}

static bool js_cc_SkeletonRenderer_setAttachment__SWIG_1(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    cc::SkeletonRenderer *arg1 = (cc::SkeletonRenderer *) NULL ;
    std::string *arg2 = 0 ;
    char *arg3 = (char *) NULL ;
    std::string temp2 ;
    ccstd::string temp3 ;
    bool result;
    
    arg1 = SE_THIS_OBJECT<cc::SkeletonRenderer>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    
    ok &= sevalue_to_native(args[1], &temp3);
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg3 = (char *) temp3.c_str(); 
    result = (bool)(arg1)->setAttachment((std::string const &)*arg2,(char const *)arg3);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    
    
    return true;
}

static bool js_cc_SkeletonRenderer_setAttachment(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    
    if (argc == 2) {
        ok = js_cc_SkeletonRenderer_setAttachment__SWIG_0(s);
        if (ok) {
            return true; 
        }
    } 
    if (argc == 2) {
        ok = js_cc_SkeletonRenderer_setAttachment__SWIG_1(s);
        if (ok) {
            return true; 
        }
    } 
    SE_REPORT_ERROR("wrong number of arguments: %d", (int)argc);
    return false;
}
SE_BIND_FUNC(js_cc_SkeletonRenderer_setAttachment) 

static bool js_cc_SkeletonRenderer_setUseTint(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonRenderer *arg1 = (cc::SkeletonRenderer *) NULL ;
    bool arg2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonRenderer>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2);
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setUseTint(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonRenderer_setUseTint) 

static bool js_cc_SkeletonRenderer_setSlotsRange(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonRenderer *arg1 = (cc::SkeletonRenderer *) NULL ;
    int arg2 ;
    int arg3 ;
    
    if(argc != 2) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 2);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonRenderer>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[1], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setSlotsRange(arg2,arg3);
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonRenderer_setSlotsRange) 

static bool js_cc_SkeletonRenderer_getDebugData(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonRenderer *arg1 = (cc::SkeletonRenderer *) NULL ;
    se_object_ptr result;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonRenderer>(s);
    if (nullptr == arg1) return true;
    result = ((cc::SkeletonRenderer const *)arg1)->getDebugData();
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject() /*ctx*/);
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval());
    
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonRenderer_getDebugData) 

static bool js_cc_SkeletonRenderer_getSharedBufferOffset(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonRenderer *arg1 = (cc::SkeletonRenderer *) NULL ;
    se_object_ptr result;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonRenderer>(s);
    if (nullptr == arg1) return true;
    result = ((cc::SkeletonRenderer const *)arg1)->getSharedBufferOffset();
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject() /*ctx*/);
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval());
    
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonRenderer_getSharedBufferOffset) 

static bool js_cc_SkeletonRenderer_setColor(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonRenderer *arg1 = (cc::SkeletonRenderer *) NULL ;
    float arg2 ;
    float arg3 ;
    float arg4 ;
    float arg5 ;
    
    if(argc != 4) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 4);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonRenderer>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[1], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[2], &arg4, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[3], &arg5, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setColor(arg2,arg3,arg4,arg5);
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonRenderer_setColor) 

static bool js_cc_SkeletonRenderer_setBatchEnabled(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonRenderer *arg1 = (cc::SkeletonRenderer *) NULL ;
    bool arg2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonRenderer>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2);
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setBatchEnabled(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonRenderer_setBatchEnabled) 

static bool js_cc_SkeletonRenderer_setDebugBonesEnabled(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonRenderer *arg1 = (cc::SkeletonRenderer *) NULL ;
    bool arg2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonRenderer>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2);
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setDebugBonesEnabled(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonRenderer_setDebugBonesEnabled) 

static bool js_cc_SkeletonRenderer_setDebugSlotsEnabled(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonRenderer *arg1 = (cc::SkeletonRenderer *) NULL ;
    bool arg2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonRenderer>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2);
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setDebugSlotsEnabled(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonRenderer_setDebugSlotsEnabled) 

static bool js_cc_SkeletonRenderer_setDebugMeshEnabled(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonRenderer *arg1 = (cc::SkeletonRenderer *) NULL ;
    bool arg2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonRenderer>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2);
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setDebugMeshEnabled(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonRenderer_setDebugMeshEnabled) 

static bool js_cc_SkeletonRenderer_setAttachEnabled(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonRenderer *arg1 = (cc::SkeletonRenderer *) NULL ;
    bool arg2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonRenderer>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2);
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setAttachEnabled(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonRenderer_setAttachEnabled) 

static bool js_cc_SkeletonRenderer_setOpacityModifyRGB(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonRenderer *arg1 = (cc::SkeletonRenderer *) NULL ;
    bool arg2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonRenderer>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2);
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setOpacityModifyRGB(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonRenderer_setOpacityModifyRGB) 

static bool js_cc_SkeletonRenderer_isOpacityModifyRGB(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonRenderer *arg1 = (cc::SkeletonRenderer *) NULL ;
    bool result;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonRenderer>(s);
    if (nullptr == arg1) return true;
    result = (bool)((cc::SkeletonRenderer const *)arg1)->isOpacityModifyRGB();
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonRenderer_isOpacityModifyRGB) 

static bool js_cc_SkeletonRenderer_beginSchedule(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonRenderer *arg1 = (cc::SkeletonRenderer *) NULL ;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonRenderer>(s);
    if (nullptr == arg1) return true;
    (arg1)->beginSchedule();
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonRenderer_beginSchedule) 

static bool js_cc_SkeletonRenderer_stopSchedule(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonRenderer *arg1 = (cc::SkeletonRenderer *) NULL ;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonRenderer>(s);
    if (nullptr == arg1) return true;
    (arg1)->stopSchedule();
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonRenderer_stopSchedule) 

static bool js_cc_SkeletonRenderer_onEnable(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonRenderer *arg1 = (cc::SkeletonRenderer *) NULL ;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonRenderer>(s);
    if (nullptr == arg1) return true;
    (arg1)->onEnable();
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonRenderer_onEnable) 

static bool js_cc_SkeletonRenderer_onDisable(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonRenderer *arg1 = (cc::SkeletonRenderer *) NULL ;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonRenderer>(s);
    if (nullptr == arg1) return true;
    (arg1)->onDisable();
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonRenderer_onDisable) 

static bool js_new_cc_SkeletonRenderer__SWIG_0(se::State& s) // NOLINT(readability-identifier-naming)
{
    const auto& args = s.args();
    CC_UNUSED bool ok = true;
    cc::SkeletonRenderer *result;
    result = (cc::SkeletonRenderer *)new cc::SkeletonRenderer();
    
    
    auto *ptr = JSB_MAKE_PRIVATE_OBJECT_WITH_INSTANCE(result);
    s.thisObject()->setPrivateObject(ptr);
    return true;
}


static bool js_new_cc_SkeletonRenderer__SWIG_1(se::State& s) // NOLINT(readability-identifier-naming)
{
    const auto& args = s.args();
    CC_UNUSED bool ok = true;
    spine::Skeleton *arg1 = (spine::Skeleton *) NULL ;
    bool arg2 ;
    bool arg3 ;
    bool arg4 ;
    cc::SkeletonRenderer *result;
    
    ok &= sevalue_to_native(args[0], &arg1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[1], &arg2);
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[2], &arg3);
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[3], &arg4);
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (cc::SkeletonRenderer *)new cc::SkeletonRenderer(arg1,arg2,arg3,arg4);
    
    
    auto *ptr = JSB_MAKE_PRIVATE_OBJECT_WITH_INSTANCE(result);
    s.thisObject()->setPrivateObject(ptr);
    return true;
}


static bool js_new_cc_SkeletonRenderer__SWIG_2(se::State& s) // NOLINT(readability-identifier-naming)
{
    const auto& args = s.args();
    CC_UNUSED bool ok = true;
    spine::Skeleton *arg1 = (spine::Skeleton *) NULL ;
    bool arg2 ;
    bool arg3 ;
    cc::SkeletonRenderer *result;
    
    ok &= sevalue_to_native(args[0], &arg1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[1], &arg2);
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[2], &arg3);
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (cc::SkeletonRenderer *)new cc::SkeletonRenderer(arg1,arg2,arg3);
    
    
    auto *ptr = JSB_MAKE_PRIVATE_OBJECT_WITH_INSTANCE(result);
    s.thisObject()->setPrivateObject(ptr);
    return true;
}


static bool js_new_cc_SkeletonRenderer__SWIG_3(se::State& s) // NOLINT(readability-identifier-naming)
{
    const auto& args = s.args();
    CC_UNUSED bool ok = true;
    spine::Skeleton *arg1 = (spine::Skeleton *) NULL ;
    bool arg2 ;
    cc::SkeletonRenderer *result;
    
    ok &= sevalue_to_native(args[0], &arg1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[1], &arg2);
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (cc::SkeletonRenderer *)new cc::SkeletonRenderer(arg1,arg2);
    
    
    auto *ptr = JSB_MAKE_PRIVATE_OBJECT_WITH_INSTANCE(result);
    s.thisObject()->setPrivateObject(ptr);
    return true;
}


static bool js_new_cc_SkeletonRenderer__SWIG_4(se::State& s) // NOLINT(readability-identifier-naming)
{
    const auto& args = s.args();
    CC_UNUSED bool ok = true;
    spine::Skeleton *arg1 = (spine::Skeleton *) NULL ;
    cc::SkeletonRenderer *result;
    
    ok &= sevalue_to_native(args[0], &arg1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (cc::SkeletonRenderer *)new cc::SkeletonRenderer(arg1);
    
    
    auto *ptr = JSB_MAKE_PRIVATE_OBJECT_WITH_INSTANCE(result);
    s.thisObject()->setPrivateObject(ptr);
    return true;
}


static bool js_new_cc_SkeletonRenderer__SWIG_5(se::State& s) // NOLINT(readability-identifier-naming)
{
    const auto& args = s.args();
    CC_UNUSED bool ok = true;
    spine::SkeletonData *arg1 = (spine::SkeletonData *) NULL ;
    bool arg2 ;
    cc::SkeletonRenderer *result;
    
    ok &= sevalue_to_native(args[0], &arg1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[1], &arg2);
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (cc::SkeletonRenderer *)new cc::SkeletonRenderer(arg1,arg2);
    
    
    auto *ptr = JSB_MAKE_PRIVATE_OBJECT_WITH_INSTANCE(result);
    s.thisObject()->setPrivateObject(ptr);
    return true;
}


static bool js_new_cc_SkeletonRenderer__SWIG_6(se::State& s) // NOLINT(readability-identifier-naming)
{
    const auto& args = s.args();
    CC_UNUSED bool ok = true;
    spine::SkeletonData *arg1 = (spine::SkeletonData *) NULL ;
    cc::SkeletonRenderer *result;
    
    ok &= sevalue_to_native(args[0], &arg1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (cc::SkeletonRenderer *)new cc::SkeletonRenderer(arg1);
    
    
    auto *ptr = JSB_MAKE_PRIVATE_OBJECT_WITH_INSTANCE(result);
    s.thisObject()->setPrivateObject(ptr);
    return true;
}


static bool js_new_cc_SkeletonRenderer__SWIG_7(se::State& s) // NOLINT(readability-identifier-naming)
{
    const auto& args = s.args();
    CC_UNUSED bool ok = true;
    std::string *arg1 = 0 ;
    std::string *arg2 = 0 ;
    float arg3 ;
    std::string temp1 ;
    std::string temp2 ;
    cc::SkeletonRenderer *result;
    
    ok &= sevalue_to_native(args[0], &temp1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg1 = &temp1;
    
    
    ok &= sevalue_to_native(args[1], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    
    ok &= sevalue_to_native(args[2], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (cc::SkeletonRenderer *)new cc::SkeletonRenderer((std::string const &)*arg1,(std::string const &)*arg2,arg3);
    
    
    auto *ptr = JSB_MAKE_PRIVATE_OBJECT_WITH_INSTANCE(result);
    s.thisObject()->setPrivateObject(ptr);
    return true;
}


static bool js_new_cc_SkeletonRenderer__SWIG_8(se::State& s) // NOLINT(readability-identifier-naming)
{
    const auto& args = s.args();
    CC_UNUSED bool ok = true;
    std::string *arg1 = 0 ;
    std::string *arg2 = 0 ;
    std::string temp1 ;
    std::string temp2 ;
    cc::SkeletonRenderer *result;
    
    ok &= sevalue_to_native(args[0], &temp1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg1 = &temp1;
    
    
    ok &= sevalue_to_native(args[1], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    result = (cc::SkeletonRenderer *)new cc::SkeletonRenderer((std::string const &)*arg1,(std::string const &)*arg2);
    
    
    auto *ptr = JSB_MAKE_PRIVATE_OBJECT_WITH_INSTANCE(result);
    s.thisObject()->setPrivateObject(ptr);
    return true;
}


static bool js_new_cc_SkeletonRenderer(se::State& s) // NOLINT(readability-identifier-naming)
{
    size_t argc = s.args().size();
    bool ret = false;
    
    if(argc == 0) {
        ret = js_new_cc_SkeletonRenderer__SWIG_0(s);
        if (ret) {
            return ret; 
        } /* reset exception and return */
    }
    
    if(argc == 4) {
        ret = js_new_cc_SkeletonRenderer__SWIG_1(s);
        if (ret) {
            return ret; 
        } /* reset exception and return */
    }
    
    if(argc == 3) {
        ret = js_new_cc_SkeletonRenderer__SWIG_2(s);
        if (ret) {
            return ret; 
        } /* reset exception and return */
    }
    
    if(argc == 2) {
        ret = js_new_cc_SkeletonRenderer__SWIG_3(s);
        if (ret) {
            return ret; 
        } /* reset exception and return */
    }
    
    if(argc == 1) {
        ret = js_new_cc_SkeletonRenderer__SWIG_4(s);
        if (ret) {
            return ret; 
        } /* reset exception and return */
    }
    
    if(argc == 2) {
        ret = js_new_cc_SkeletonRenderer__SWIG_5(s);
        if (ret) {
            return ret; 
        } /* reset exception and return */
    }
    
    if(argc == 1) {
        ret = js_new_cc_SkeletonRenderer__SWIG_6(s);
        if (ret) {
            return ret; 
        } /* reset exception and return */
    }
    
    if(argc == 3) {
        ret = js_new_cc_SkeletonRenderer__SWIG_7(s);
        if (ret) {
            return ret; 
        } /* reset exception and return */
    }
    
    if(argc == 2) {
        ret = js_new_cc_SkeletonRenderer__SWIG_8(s);
        if (ret) {
            return ret; 
        } /* reset exception and return */
    }
    
    SE_REPORT_ERROR("Illegal arguments for construction of SkeletonRenderer");
    return false;
}
SE_BIND_CTOR(js_new_cc_SkeletonRenderer, __jsb_cc_SkeletonRenderer_class, js_delete_cc_SkeletonRenderer)

static bool js_delete_cc_SkeletonRenderer(se::State& s)
{
    return true;
}
SE_BIND_FINALIZE_FUNC(js_delete_cc_SkeletonRenderer) 

static bool js_cc_SkeletonRenderer_initWithUUID(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonRenderer *arg1 = (cc::SkeletonRenderer *) NULL ;
    std::string *arg2 = 0 ;
    std::string temp2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonRenderer>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    (arg1)->initWithUUID((std::string const &)*arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonRenderer_initWithUUID) 

static bool js_cc_SkeletonRenderer_initWithSkeleton__SWIG_0(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    cc::SkeletonRenderer *arg1 = (cc::SkeletonRenderer *) NULL ;
    spine::Skeleton *arg2 = (spine::Skeleton *) NULL ;
    bool arg3 ;
    bool arg4 ;
    bool arg5 ;
    
    arg1 = SE_THIS_OBJECT<cc::SkeletonRenderer>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[1], &arg3);
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[2], &arg4);
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[3], &arg5);
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->initWithSkeleton(arg2,arg3,arg4,arg5);
    
    
    return true;
}

static bool js_cc_SkeletonRenderer_initWithSkeleton__SWIG_1(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    cc::SkeletonRenderer *arg1 = (cc::SkeletonRenderer *) NULL ;
    spine::Skeleton *arg2 = (spine::Skeleton *) NULL ;
    bool arg3 ;
    bool arg4 ;
    
    arg1 = SE_THIS_OBJECT<cc::SkeletonRenderer>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[1], &arg3);
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[2], &arg4);
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->initWithSkeleton(arg2,arg3,arg4);
    
    
    return true;
}

static bool js_cc_SkeletonRenderer_initWithSkeleton__SWIG_2(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    cc::SkeletonRenderer *arg1 = (cc::SkeletonRenderer *) NULL ;
    spine::Skeleton *arg2 = (spine::Skeleton *) NULL ;
    bool arg3 ;
    
    arg1 = SE_THIS_OBJECT<cc::SkeletonRenderer>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[1], &arg3);
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->initWithSkeleton(arg2,arg3);
    
    
    return true;
}

static bool js_cc_SkeletonRenderer_initWithSkeleton__SWIG_3(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    cc::SkeletonRenderer *arg1 = (cc::SkeletonRenderer *) NULL ;
    spine::Skeleton *arg2 = (spine::Skeleton *) NULL ;
    
    arg1 = SE_THIS_OBJECT<cc::SkeletonRenderer>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->initWithSkeleton(arg2);
    
    
    return true;
}

static bool js_cc_SkeletonRenderer_initWithSkeleton(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    
    if (argc == 4) {
        ok = js_cc_SkeletonRenderer_initWithSkeleton__SWIG_0(s);
        if (ok) {
            return true; 
        }
    } 
    if (argc == 3) {
        ok = js_cc_SkeletonRenderer_initWithSkeleton__SWIG_1(s);
        if (ok) {
            return true; 
        }
    } 
    if (argc == 2) {
        ok = js_cc_SkeletonRenderer_initWithSkeleton__SWIG_2(s);
        if (ok) {
            return true; 
        }
    } 
    if (argc == 1) {
        ok = js_cc_SkeletonRenderer_initWithSkeleton__SWIG_3(s);
        if (ok) {
            return true; 
        }
    } 
    SE_REPORT_ERROR("wrong number of arguments: %d", (int)argc);
    return false;
}
SE_BIND_FUNC(js_cc_SkeletonRenderer_initWithSkeleton) 

static bool js_cc_SkeletonRenderer_initialize(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonRenderer *arg1 = (cc::SkeletonRenderer *) NULL ;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonRenderer>(s);
    if (nullptr == arg1) return true;
    (arg1)->initialize();
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonRenderer_initialize) 

static bool js_cc_SkeletonRenderer_setMaterial(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonRenderer *arg1 = (cc::SkeletonRenderer *) NULL ;
    cc::Material *arg2 = (cc::Material *) NULL ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonRenderer>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setMaterial(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonRenderer_setMaterial) 

static bool js_cc_SkeletonRenderer_setRenderEntity(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonRenderer *arg1 = (cc::SkeletonRenderer *) NULL ;
    cc::RenderEntity *arg2 = (cc::RenderEntity *) NULL ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonRenderer>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setRenderEntity(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonRenderer_setRenderEntity) 

static bool js_cc_SkeletonRenderer_setSlotTexture(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonRenderer *arg1 = (cc::SkeletonRenderer *) NULL ;
    std::string *arg2 = 0 ;
    cc::Texture2D *arg3 = (cc::Texture2D *) NULL ;
    bool arg4 ;
    std::string temp2 ;
    
    if(argc != 3) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 3);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonRenderer>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    
    ok &= sevalue_to_native(args[1], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[2], &arg4);
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setSlotTexture((std::string const &)*arg2,arg3,arg4);
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonRenderer_setSlotTexture) 

bool js_register_cc_SkeletonRenderer(se::Object* obj) {
    auto* cls = se::Class::create("SkeletonRenderer", obj, nullptr, _SE(js_new_cc_SkeletonRenderer)); 
    
    cls->defineStaticProperty("__isJSB", se::Value(true), se::PropertyAttribute::READ_ONLY | se::PropertyAttribute::DONT_ENUM | se::PropertyAttribute::DONT_DELETE);
    
    cls->defineFunction("update", _SE(js_cc_SkeletonRenderer_update)); 
    cls->defineFunction("render", _SE(js_cc_SkeletonRenderer_render)); 
    cls->defineFunction("getBoundingBox", _SE(js_cc_SkeletonRenderer_getBoundingBox)); 
    cls->defineFunction("getSkeleton", _SE(js_cc_SkeletonRenderer_getSkeleton)); 
    cls->defineFunction("setTimeScale", _SE(js_cc_SkeletonRenderer_setTimeScale)); 
    cls->defineFunction("getTimeScale", _SE(js_cc_SkeletonRenderer_getTimeScale)); 
    cls->defineFunction("updateWorldTransform", _SE(js_cc_SkeletonRenderer_updateWorldTransform)); 
    cls->defineFunction("setToSetupPose", _SE(js_cc_SkeletonRenderer_setToSetupPose)); 
    cls->defineFunction("setBonesToSetupPose", _SE(js_cc_SkeletonRenderer_setBonesToSetupPose)); 
    cls->defineFunction("setSlotsToSetupPose", _SE(js_cc_SkeletonRenderer_setSlotsToSetupPose)); 
    cls->defineFunction("paused", _SE(js_cc_SkeletonRenderer_paused)); 
    cls->defineFunction("findBone", _SE(js_cc_SkeletonRenderer_findBone)); 
    cls->defineFunction("findSlot", _SE(js_cc_SkeletonRenderer_findSlot)); 
    cls->defineFunction("setSkin", _SE(js_cc_SkeletonRenderer_setSkin)); 
    cls->defineFunction("getAttachment", _SE(js_cc_SkeletonRenderer_getAttachment)); 
    cls->defineFunction("setAttachment", _SE(js_cc_SkeletonRenderer_setAttachment)); 
    cls->defineFunction("setUseTint", _SE(js_cc_SkeletonRenderer_setUseTint)); 
    cls->defineFunction("setSlotsRange", _SE(js_cc_SkeletonRenderer_setSlotsRange)); 
    cls->defineFunction("getDebugData", _SE(js_cc_SkeletonRenderer_getDebugData)); 
    cls->defineFunction("getSharedBufferOffset", _SE(js_cc_SkeletonRenderer_getSharedBufferOffset)); 
    cls->defineFunction("setColor", _SE(js_cc_SkeletonRenderer_setColor)); 
    cls->defineFunction("setBatchEnabled", _SE(js_cc_SkeletonRenderer_setBatchEnabled)); 
    cls->defineFunction("setDebugBonesEnabled", _SE(js_cc_SkeletonRenderer_setDebugBonesEnabled)); 
    cls->defineFunction("setDebugSlotsEnabled", _SE(js_cc_SkeletonRenderer_setDebugSlotsEnabled)); 
    cls->defineFunction("setDebugMeshEnabled", _SE(js_cc_SkeletonRenderer_setDebugMeshEnabled)); 
    cls->defineFunction("setAttachEnabled", _SE(js_cc_SkeletonRenderer_setAttachEnabled)); 
    cls->defineFunction("setOpacityModifyRGB", _SE(js_cc_SkeletonRenderer_setOpacityModifyRGB)); 
    cls->defineFunction("isOpacityModifyRGB", _SE(js_cc_SkeletonRenderer_isOpacityModifyRGB)); 
    cls->defineFunction("beginSchedule", _SE(js_cc_SkeletonRenderer_beginSchedule)); 
    cls->defineFunction("stopSchedule", _SE(js_cc_SkeletonRenderer_stopSchedule)); 
    cls->defineFunction("onEnable", _SE(js_cc_SkeletonRenderer_onEnable)); 
    cls->defineFunction("onDisable", _SE(js_cc_SkeletonRenderer_onDisable)); 
    cls->defineFunction("initWithUUID", _SE(js_cc_SkeletonRenderer_initWithUUID)); 
    cls->defineFunction("initWithSkeleton", _SE(js_cc_SkeletonRenderer_initWithSkeleton)); 
    cls->defineFunction("initialize", _SE(js_cc_SkeletonRenderer_initialize)); 
    cls->defineFunction("setMaterial", _SE(js_cc_SkeletonRenderer_setMaterial)); 
    cls->defineFunction("setRenderEntity", _SE(js_cc_SkeletonRenderer_setRenderEntity)); 
    cls->defineFunction("setSlotTexture", _SE(js_cc_SkeletonRenderer_setSlotTexture)); 
    
    
    cls->defineStaticFunction("create", _SE(js_cc_SkeletonRenderer_create_static)); 
    
    
    cls->defineFinalizeFunction(_SE(js_delete_cc_SkeletonRenderer));
    
    
    cls->install();
    JSBClassType::registerClass<cc::SkeletonRenderer>(cls);
    
    __jsb_cc_SkeletonRenderer_proto = cls->getProto();
    __jsb_cc_SkeletonRenderer_class = cls;
    se::ScriptEngine::getInstance()->clearException();
    return true;
}


se::Class* __jsb_cc_SkeletonAnimation_class = nullptr;
se::Object* __jsb_cc_SkeletonAnimation_proto = nullptr;
SE_DECLARE_FINALIZE_FUNC(js_delete_cc_SkeletonAnimation) 

static bool js_cc_SkeletonAnimation_createWithJsonFile_static__SWIG_0(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    std::string *arg1 = 0 ;
    std::string *arg2 = 0 ;
    float arg3 ;
    std::string temp1 ;
    std::string temp2 ;
    cc::SkeletonAnimation *result = 0 ;
    
    
    ok &= sevalue_to_native(args[0], &temp1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg1 = &temp1;
    
    
    ok &= sevalue_to_native(args[1], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    
    ok &= sevalue_to_native(args[2], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (cc::SkeletonAnimation *)cc::SkeletonAnimation::createWithJsonFile((std::string const &)*arg1,(std::string const &)*arg2,arg3);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}

static bool js_cc_SkeletonAnimation_createWithJsonFile_static__SWIG_1(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    std::string *arg1 = 0 ;
    std::string *arg2 = 0 ;
    std::string temp1 ;
    std::string temp2 ;
    cc::SkeletonAnimation *result = 0 ;
    
    
    ok &= sevalue_to_native(args[0], &temp1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg1 = &temp1;
    
    
    ok &= sevalue_to_native(args[1], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    result = (cc::SkeletonAnimation *)cc::SkeletonAnimation::createWithJsonFile((std::string const &)*arg1,(std::string const &)*arg2);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}

static bool js_cc_SkeletonAnimation_createWithJsonFile_static(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    
    if (argc == 3) {
        ok = js_cc_SkeletonAnimation_createWithJsonFile_static__SWIG_0(s);
        if (ok) {
            return true; 
        }
    } 
    if (argc == 2) {
        ok = js_cc_SkeletonAnimation_createWithJsonFile_static__SWIG_1(s);
        if (ok) {
            return true; 
        }
    } 
    SE_REPORT_ERROR("wrong number of arguments: %d", (int)argc);
    return false;
}
SE_BIND_FUNC(js_cc_SkeletonAnimation_createWithJsonFile_static) 

static bool js_cc_SkeletonAnimation_createWithBinaryFile_static__SWIG_0(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    std::string *arg1 = 0 ;
    std::string *arg2 = 0 ;
    float arg3 ;
    std::string temp1 ;
    std::string temp2 ;
    cc::SkeletonAnimation *result = 0 ;
    
    
    ok &= sevalue_to_native(args[0], &temp1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg1 = &temp1;
    
    
    ok &= sevalue_to_native(args[1], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    
    ok &= sevalue_to_native(args[2], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (cc::SkeletonAnimation *)cc::SkeletonAnimation::createWithBinaryFile((std::string const &)*arg1,(std::string const &)*arg2,arg3);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}

static bool js_cc_SkeletonAnimation_createWithBinaryFile_static__SWIG_1(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    std::string *arg1 = 0 ;
    std::string *arg2 = 0 ;
    std::string temp1 ;
    std::string temp2 ;
    cc::SkeletonAnimation *result = 0 ;
    
    
    ok &= sevalue_to_native(args[0], &temp1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg1 = &temp1;
    
    
    ok &= sevalue_to_native(args[1], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    result = (cc::SkeletonAnimation *)cc::SkeletonAnimation::createWithBinaryFile((std::string const &)*arg1,(std::string const &)*arg2);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}

static bool js_cc_SkeletonAnimation_createWithBinaryFile_static(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    
    if (argc == 3) {
        ok = js_cc_SkeletonAnimation_createWithBinaryFile_static__SWIG_0(s);
        if (ok) {
            return true; 
        }
    } 
    if (argc == 2) {
        ok = js_cc_SkeletonAnimation_createWithBinaryFile_static__SWIG_1(s);
        if (ok) {
            return true; 
        }
    } 
    SE_REPORT_ERROR("wrong number of arguments: %d", (int)argc);
    return false;
}
SE_BIND_FUNC(js_cc_SkeletonAnimation_createWithBinaryFile_static) 

static bool js_cc_SkeletonAnimation_setGlobalTimeScale_static(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    float arg1 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    
    ok &= sevalue_to_native(args[0], &arg1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    cc::SkeletonAnimation::setGlobalTimeScale(arg1);
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonAnimation_setGlobalTimeScale_static) 

static bool js_cc_SkeletonAnimation_update(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonAnimation *arg1 = (cc::SkeletonAnimation *) NULL ;
    float arg2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonAnimation>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->update(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonAnimation_update) 

static bool js_cc_SkeletonAnimation_setAnimationStateData(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonAnimation *arg1 = (cc::SkeletonAnimation *) NULL ;
    spine::AnimationStateData *arg2 = (spine::AnimationStateData *) NULL ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonAnimation>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setAnimationStateData(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonAnimation_setAnimationStateData) 

static bool js_cc_SkeletonAnimation_setMix(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonAnimation *arg1 = (cc::SkeletonAnimation *) NULL ;
    std::string *arg2 = 0 ;
    std::string *arg3 = 0 ;
    float arg4 ;
    std::string temp2 ;
    std::string temp3 ;
    
    if(argc != 3) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 3);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonAnimation>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    
    ok &= sevalue_to_native(args[1], &temp3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg3 = &temp3;
    
    
    ok &= sevalue_to_native(args[2], &arg4, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setMix((std::string const &)*arg2,(std::string const &)*arg3,arg4);
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonAnimation_setMix) 

static bool js_cc_SkeletonAnimation_setAnimation(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonAnimation *arg1 = (cc::SkeletonAnimation *) NULL ;
    int arg2 ;
    std::string *arg3 = 0 ;
    bool arg4 ;
    std::string temp3 ;
    spine::TrackEntry *result = 0 ;
    
    if(argc != 3) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 3);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonAnimation>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[1], &temp3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg3 = &temp3;
    
    
    ok &= sevalue_to_native(args[2], &arg4);
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (spine::TrackEntry *)(arg1)->setAnimation(arg2,(std::string const &)*arg3,arg4);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonAnimation_setAnimation) 

static bool js_cc_SkeletonAnimation_addAnimation__SWIG_0(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    cc::SkeletonAnimation *arg1 = (cc::SkeletonAnimation *) NULL ;
    int arg2 ;
    std::string *arg3 = 0 ;
    bool arg4 ;
    float arg5 ;
    std::string temp3 ;
    spine::TrackEntry *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<cc::SkeletonAnimation>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[1], &temp3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg3 = &temp3;
    
    
    ok &= sevalue_to_native(args[2], &arg4);
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[3], &arg5, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (spine::TrackEntry *)(arg1)->addAnimation(arg2,(std::string const &)*arg3,arg4,arg5);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}

static bool js_cc_SkeletonAnimation_addAnimation__SWIG_1(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    cc::SkeletonAnimation *arg1 = (cc::SkeletonAnimation *) NULL ;
    int arg2 ;
    std::string *arg3 = 0 ;
    bool arg4 ;
    std::string temp3 ;
    spine::TrackEntry *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<cc::SkeletonAnimation>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[1], &temp3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg3 = &temp3;
    
    
    ok &= sevalue_to_native(args[2], &arg4);
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (spine::TrackEntry *)(arg1)->addAnimation(arg2,(std::string const &)*arg3,arg4);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}

static bool js_cc_SkeletonAnimation_addAnimation(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    
    if (argc == 4) {
        ok = js_cc_SkeletonAnimation_addAnimation__SWIG_0(s);
        if (ok) {
            return true; 
        }
    } 
    if (argc == 3) {
        ok = js_cc_SkeletonAnimation_addAnimation__SWIG_1(s);
        if (ok) {
            return true; 
        }
    } 
    SE_REPORT_ERROR("wrong number of arguments: %d", (int)argc);
    return false;
}
SE_BIND_FUNC(js_cc_SkeletonAnimation_addAnimation) 

static bool js_cc_SkeletonAnimation_setEmptyAnimation(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonAnimation *arg1 = (cc::SkeletonAnimation *) NULL ;
    int arg2 ;
    float arg3 ;
    spine::TrackEntry *result = 0 ;
    
    if(argc != 2) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 2);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonAnimation>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[1], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (spine::TrackEntry *)(arg1)->setEmptyAnimation(arg2,arg3);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonAnimation_setEmptyAnimation) 

static bool js_cc_SkeletonAnimation_setEmptyAnimations(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonAnimation *arg1 = (cc::SkeletonAnimation *) NULL ;
    float arg2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonAnimation>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setEmptyAnimations(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonAnimation_setEmptyAnimations) 

static bool js_cc_SkeletonAnimation_addEmptyAnimation__SWIG_0(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    cc::SkeletonAnimation *arg1 = (cc::SkeletonAnimation *) NULL ;
    int arg2 ;
    float arg3 ;
    float arg4 ;
    spine::TrackEntry *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<cc::SkeletonAnimation>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[1], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[2], &arg4, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (spine::TrackEntry *)(arg1)->addEmptyAnimation(arg2,arg3,arg4);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}

static bool js_cc_SkeletonAnimation_addEmptyAnimation__SWIG_1(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    cc::SkeletonAnimation *arg1 = (cc::SkeletonAnimation *) NULL ;
    int arg2 ;
    float arg3 ;
    spine::TrackEntry *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<cc::SkeletonAnimation>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[1], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (spine::TrackEntry *)(arg1)->addEmptyAnimation(arg2,arg3);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}

static bool js_cc_SkeletonAnimation_addEmptyAnimation(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    
    if (argc == 3) {
        ok = js_cc_SkeletonAnimation_addEmptyAnimation__SWIG_0(s);
        if (ok) {
            return true; 
        }
    } 
    if (argc == 2) {
        ok = js_cc_SkeletonAnimation_addEmptyAnimation__SWIG_1(s);
        if (ok) {
            return true; 
        }
    } 
    SE_REPORT_ERROR("wrong number of arguments: %d", (int)argc);
    return false;
}
SE_BIND_FUNC(js_cc_SkeletonAnimation_addEmptyAnimation) 

static bool js_cc_SkeletonAnimation_findAnimation(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonAnimation *arg1 = (cc::SkeletonAnimation *) NULL ;
    std::string *arg2 = 0 ;
    std::string temp2 ;
    spine::Animation *result = 0 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonAnimation>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    result = (spine::Animation *)((cc::SkeletonAnimation const *)arg1)->findAnimation((std::string const &)*arg2);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonAnimation_findAnimation) 

static bool js_cc_SkeletonAnimation_getCurrent__SWIG_0(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    cc::SkeletonAnimation *arg1 = (cc::SkeletonAnimation *) NULL ;
    int arg2 ;
    spine::TrackEntry *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<cc::SkeletonAnimation>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (spine::TrackEntry *)(arg1)->getCurrent(arg2);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}

static bool js_cc_SkeletonAnimation_getCurrent__SWIG_1(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    cc::SkeletonAnimation *arg1 = (cc::SkeletonAnimation *) NULL ;
    spine::TrackEntry *result = 0 ;
    
    arg1 = SE_THIS_OBJECT<cc::SkeletonAnimation>(s);
    if (nullptr == arg1) return true;
    result = (spine::TrackEntry *)(arg1)->getCurrent();
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}

static bool js_cc_SkeletonAnimation_getCurrent(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    
    if (argc == 1) {
        ok = js_cc_SkeletonAnimation_getCurrent__SWIG_0(s);
        if (ok) {
            return true; 
        }
    } 
    if (argc == 0) {
        ok = js_cc_SkeletonAnimation_getCurrent__SWIG_1(s);
        if (ok) {
            return true; 
        }
    } 
    SE_REPORT_ERROR("wrong number of arguments: %d", (int)argc);
    return false;
}
SE_BIND_FUNC(js_cc_SkeletonAnimation_getCurrent) 

static bool js_cc_SkeletonAnimation_clearTracks(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonAnimation *arg1 = (cc::SkeletonAnimation *) NULL ;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonAnimation>(s);
    if (nullptr == arg1) return true;
    (arg1)->clearTracks();
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonAnimation_clearTracks) 

static bool js_cc_SkeletonAnimation_clearTrack__SWIG_0(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    cc::SkeletonAnimation *arg1 = (cc::SkeletonAnimation *) NULL ;
    int arg2 ;
    
    arg1 = SE_THIS_OBJECT<cc::SkeletonAnimation>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->clearTrack(arg2);
    
    
    return true;
}

static bool js_cc_SkeletonAnimation_clearTrack__SWIG_1(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    cc::SkeletonAnimation *arg1 = (cc::SkeletonAnimation *) NULL ;
    
    arg1 = SE_THIS_OBJECT<cc::SkeletonAnimation>(s);
    if (nullptr == arg1) return true;
    (arg1)->clearTrack();
    
    
    return true;
}

static bool js_cc_SkeletonAnimation_clearTrack(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    
    if (argc == 1) {
        ok = js_cc_SkeletonAnimation_clearTrack__SWIG_0(s);
        if (ok) {
            return true; 
        }
    } 
    if (argc == 0) {
        ok = js_cc_SkeletonAnimation_clearTrack__SWIG_1(s);
        if (ok) {
            return true; 
        }
    } 
    SE_REPORT_ERROR("wrong number of arguments: %d", (int)argc);
    return false;
}
SE_BIND_FUNC(js_cc_SkeletonAnimation_clearTrack) 

static bool js_cc_SkeletonAnimation_setStartListener(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonAnimation *arg1 = (cc::SkeletonAnimation *) NULL ;
    cc::StartListener *arg2 = 0 ;
    cc::StartListener temp2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonAnimation>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    (arg1)->setStartListener((cc::StartListener const &)*arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonAnimation_setStartListener) 

static bool js_cc_SkeletonAnimation_setInterruptListener(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonAnimation *arg1 = (cc::SkeletonAnimation *) NULL ;
    cc::InterruptListener *arg2 = 0 ;
    cc::InterruptListener temp2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonAnimation>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    (arg1)->setInterruptListener((cc::InterruptListener const &)*arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonAnimation_setInterruptListener) 

static bool js_cc_SkeletonAnimation_setEndListener(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonAnimation *arg1 = (cc::SkeletonAnimation *) NULL ;
    cc::EndListener *arg2 = 0 ;
    cc::EndListener temp2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonAnimation>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    (arg1)->setEndListener((cc::EndListener const &)*arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonAnimation_setEndListener) 

static bool js_cc_SkeletonAnimation_setDisposeListener(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonAnimation *arg1 = (cc::SkeletonAnimation *) NULL ;
    cc::DisposeListener *arg2 = 0 ;
    cc::DisposeListener temp2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonAnimation>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    (arg1)->setDisposeListener((cc::DisposeListener const &)*arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonAnimation_setDisposeListener) 

static bool js_cc_SkeletonAnimation_setCompleteListenerNative(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonAnimation *arg1 = (cc::SkeletonAnimation *) NULL ;
    cc::CompleteListener *arg2 = 0 ;
    cc::CompleteListener temp2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonAnimation>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    (arg1)->setCompleteListener((cc::CompleteListener const &)*arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonAnimation_setCompleteListenerNative) 

static bool js_cc_SkeletonAnimation_setEventListener(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonAnimation *arg1 = (cc::SkeletonAnimation *) NULL ;
    cc::EventListener *arg2 = 0 ;
    cc::EventListener temp2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonAnimation>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    (arg1)->setEventListener((cc::EventListener const &)*arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonAnimation_setEventListener) 

static bool js_cc_SkeletonAnimation_setTrackStartListener(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonAnimation *arg1 = (cc::SkeletonAnimation *) NULL ;
    spine::TrackEntry *arg2 = (spine::TrackEntry *) NULL ;
    cc::StartListener *arg3 = 0 ;
    cc::StartListener temp3 ;
    
    if(argc != 2) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 2);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonAnimation>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[1], &temp3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg3 = &temp3;
    
    (arg1)->setTrackStartListener(arg2,(cc::StartListener const &)*arg3);
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonAnimation_setTrackStartListener) 

static bool js_cc_SkeletonAnimation_setTrackInterruptListener(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonAnimation *arg1 = (cc::SkeletonAnimation *) NULL ;
    spine::TrackEntry *arg2 = (spine::TrackEntry *) NULL ;
    cc::InterruptListener *arg3 = 0 ;
    cc::InterruptListener temp3 ;
    
    if(argc != 2) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 2);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonAnimation>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[1], &temp3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg3 = &temp3;
    
    (arg1)->setTrackInterruptListener(arg2,(cc::InterruptListener const &)*arg3);
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonAnimation_setTrackInterruptListener) 

static bool js_cc_SkeletonAnimation_setTrackEndListener(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonAnimation *arg1 = (cc::SkeletonAnimation *) NULL ;
    spine::TrackEntry *arg2 = (spine::TrackEntry *) NULL ;
    cc::EndListener *arg3 = 0 ;
    cc::EndListener temp3 ;
    
    if(argc != 2) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 2);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonAnimation>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[1], &temp3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg3 = &temp3;
    
    (arg1)->setTrackEndListener(arg2,(cc::EndListener const &)*arg3);
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonAnimation_setTrackEndListener) 

static bool js_cc_SkeletonAnimation_setTrackDisposeListener(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonAnimation *arg1 = (cc::SkeletonAnimation *) NULL ;
    spine::TrackEntry *arg2 = (spine::TrackEntry *) NULL ;
    cc::DisposeListener *arg3 = 0 ;
    cc::DisposeListener temp3 ;
    
    if(argc != 2) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 2);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonAnimation>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[1], &temp3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg3 = &temp3;
    
    (arg1)->setTrackDisposeListener(arg2,(cc::DisposeListener const &)*arg3);
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonAnimation_setTrackDisposeListener) 

static bool js_cc_SkeletonAnimation_setTrackCompleteListenerNative(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonAnimation *arg1 = (cc::SkeletonAnimation *) NULL ;
    spine::TrackEntry *arg2 = (spine::TrackEntry *) NULL ;
    cc::CompleteListener *arg3 = 0 ;
    cc::CompleteListener temp3 ;
    
    if(argc != 2) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 2);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonAnimation>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[1], &temp3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg3 = &temp3;
    
    (arg1)->setTrackCompleteListener(arg2,(cc::CompleteListener const &)*arg3);
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonAnimation_setTrackCompleteListenerNative) 

static bool js_cc_SkeletonAnimation_setTrackEventListener(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonAnimation *arg1 = (cc::SkeletonAnimation *) NULL ;
    spine::TrackEntry *arg2 = (spine::TrackEntry *) NULL ;
    cc::EventListener *arg3 = 0 ;
    cc::EventListener temp3 ;
    
    if(argc != 2) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 2);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonAnimation>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[1], &temp3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg3 = &temp3;
    
    (arg1)->setTrackEventListener(arg2,(cc::EventListener const &)*arg3);
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonAnimation_setTrackEventListener) 

static bool js_cc_SkeletonAnimation_getState(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonAnimation *arg1 = (cc::SkeletonAnimation *) NULL ;
    spine::AnimationState *result = 0 ;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonAnimation>(s);
    if (nullptr == arg1) return true;
    result = (spine::AnimationState *)((cc::SkeletonAnimation const *)arg1)->getState();
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonAnimation_getState) 

static bool js_new_cc_SkeletonAnimation(se::State& s) // NOLINT(readability-identifier-naming)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    cc::SkeletonAnimation *result;
    result = (cc::SkeletonAnimation *)new cc::SkeletonAnimation();
    
    
    auto *ptr = JSB_MAKE_PRIVATE_OBJECT_WITH_INSTANCE(result);
    s.thisObject()->setPrivateObject(ptr);
    return true;
}
SE_BIND_CTOR(js_new_cc_SkeletonAnimation, __jsb_cc_SkeletonAnimation_class, js_delete_cc_SkeletonAnimation)

static bool js_delete_cc_SkeletonAnimation(se::State& s)
{
    return true;
}
SE_BIND_FINALIZE_FUNC(js_delete_cc_SkeletonAnimation) 

bool js_register_cc_SkeletonAnimation(se::Object* obj) {
    auto* cls = se::Class::create("SkeletonAnimation", obj, __jsb_cc_SkeletonRenderer_proto, _SE(js_new_cc_SkeletonAnimation)); 
    
    cls->defineStaticProperty("__isJSB", se::Value(true), se::PropertyAttribute::READ_ONLY | se::PropertyAttribute::DONT_ENUM | se::PropertyAttribute::DONT_DELETE);
    
    cls->defineFunction("update", _SE(js_cc_SkeletonAnimation_update)); 
    cls->defineFunction("setAnimationStateData", _SE(js_cc_SkeletonAnimation_setAnimationStateData)); 
    cls->defineFunction("setMix", _SE(js_cc_SkeletonAnimation_setMix)); 
    cls->defineFunction("setAnimation", _SE(js_cc_SkeletonAnimation_setAnimation)); 
    cls->defineFunction("addAnimation", _SE(js_cc_SkeletonAnimation_addAnimation)); 
    cls->defineFunction("setEmptyAnimation", _SE(js_cc_SkeletonAnimation_setEmptyAnimation)); 
    cls->defineFunction("setEmptyAnimations", _SE(js_cc_SkeletonAnimation_setEmptyAnimations)); 
    cls->defineFunction("addEmptyAnimation", _SE(js_cc_SkeletonAnimation_addEmptyAnimation)); 
    cls->defineFunction("findAnimation", _SE(js_cc_SkeletonAnimation_findAnimation)); 
    cls->defineFunction("getCurrent", _SE(js_cc_SkeletonAnimation_getCurrent)); 
    cls->defineFunction("clearTracks", _SE(js_cc_SkeletonAnimation_clearTracks)); 
    cls->defineFunction("clearTrack", _SE(js_cc_SkeletonAnimation_clearTrack)); 
    cls->defineFunction("setStartListener", _SE(js_cc_SkeletonAnimation_setStartListener)); 
    cls->defineFunction("setInterruptListener", _SE(js_cc_SkeletonAnimation_setInterruptListener)); 
    cls->defineFunction("setEndListener", _SE(js_cc_SkeletonAnimation_setEndListener)); 
    cls->defineFunction("setDisposeListener", _SE(js_cc_SkeletonAnimation_setDisposeListener)); 
    cls->defineFunction("setCompleteListenerNative", _SE(js_cc_SkeletonAnimation_setCompleteListenerNative)); 
    cls->defineFunction("setEventListener", _SE(js_cc_SkeletonAnimation_setEventListener)); 
    cls->defineFunction("setTrackStartListener", _SE(js_cc_SkeletonAnimation_setTrackStartListener)); 
    cls->defineFunction("setTrackInterruptListener", _SE(js_cc_SkeletonAnimation_setTrackInterruptListener)); 
    cls->defineFunction("setTrackEndListener", _SE(js_cc_SkeletonAnimation_setTrackEndListener)); 
    cls->defineFunction("setTrackDisposeListener", _SE(js_cc_SkeletonAnimation_setTrackDisposeListener)); 
    cls->defineFunction("setTrackCompleteListenerNative", _SE(js_cc_SkeletonAnimation_setTrackCompleteListenerNative)); 
    cls->defineFunction("setTrackEventListener", _SE(js_cc_SkeletonAnimation_setTrackEventListener)); 
    cls->defineFunction("getState", _SE(js_cc_SkeletonAnimation_getState)); 
    
    
    cls->defineStaticFunction("createWithJsonFile", _SE(js_cc_SkeletonAnimation_createWithJsonFile_static)); 
    cls->defineStaticFunction("createWithBinaryFile", _SE(js_cc_SkeletonAnimation_createWithBinaryFile_static)); 
    cls->defineStaticFunction("setGlobalTimeScale", _SE(js_cc_SkeletonAnimation_setGlobalTimeScale_static)); 
    
    
    cls->defineFinalizeFunction(_SE(js_delete_cc_SkeletonAnimation));
    
    
    cls->install();
    JSBClassType::registerClass<cc::SkeletonAnimation>(cls);
    
    __jsb_cc_SkeletonAnimation_proto = cls->getProto();
    __jsb_cc_SkeletonAnimation_class = cls;
    se::ScriptEngine::getInstance()->clearException();
    return true;
}


se::Class* __jsb_cc_SkeletonDataMgr_class = nullptr;
se::Object* __jsb_cc_SkeletonDataMgr_proto = nullptr;
SE_DECLARE_FINALIZE_FUNC(js_delete_cc_SkeletonDataMgr) 

static bool js_cc_SkeletonDataMgr_getInstance_static(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonDataMgr *result = 0 ;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    result = (cc::SkeletonDataMgr *)cc::SkeletonDataMgr::getInstance();
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonDataMgr_getInstance_static) 

static bool js_new_cc_SkeletonDataMgr(se::State& s) // NOLINT(readability-identifier-naming)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    cc::SkeletonDataMgr *result;
    result = (cc::SkeletonDataMgr *)new cc::SkeletonDataMgr();
    
    
    auto *ptr = JSB_MAKE_PRIVATE_OBJECT_WITH_INSTANCE(result);
    s.thisObject()->setPrivateObject(ptr);
    return true;
}
SE_BIND_CTOR(js_new_cc_SkeletonDataMgr, __jsb_cc_SkeletonDataMgr_class, js_delete_cc_SkeletonDataMgr)

static bool js_delete_cc_SkeletonDataMgr(se::State& s)
{
    return true;
}
SE_BIND_FINALIZE_FUNC(js_delete_cc_SkeletonDataMgr) 

static bool js_cc_SkeletonDataMgr_setDestroyCallback(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonDataMgr *arg1 = (cc::SkeletonDataMgr *) NULL ;
    cc::SkeletonDataMgr::destroyCallback arg2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonDataMgr>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    (arg1)->setDestroyCallback(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonDataMgr_setDestroyCallback) 

bool js_register_cc_SkeletonDataMgr(se::Object* obj) {
    auto* cls = se::Class::create("SkeletonDataMgr", obj, nullptr, _SE(js_new_cc_SkeletonDataMgr)); 
    
    cls->defineStaticProperty("__isJSB", se::Value(true), se::PropertyAttribute::READ_ONLY | se::PropertyAttribute::DONT_ENUM | se::PropertyAttribute::DONT_DELETE);
    
    cls->defineFunction("setDestroyCallback", _SE(js_cc_SkeletonDataMgr_setDestroyCallback)); 
    
    
    cls->defineStaticFunction("getInstance", _SE(js_cc_SkeletonDataMgr_getInstance_static)); 
    
    
    cls->defineFinalizeFunction(_SE(js_delete_cc_SkeletonDataMgr));
    
    
    cls->install();
    JSBClassType::registerClass<cc::SkeletonDataMgr>(cls);
    
    __jsb_cc_SkeletonDataMgr_proto = cls->getProto();
    __jsb_cc_SkeletonDataMgr_class = cls;
    se::ScriptEngine::getInstance()->clearException();
    return true;
}


se::Class* __jsb_cc_SkeletonCacheAnimation_class = nullptr;
se::Object* __jsb_cc_SkeletonCacheAnimation_proto = nullptr;
SE_DECLARE_FINALIZE_FUNC(js_delete_cc_SkeletonCacheAnimation) 

static bool js_new_cc_SkeletonCacheAnimation(se::State& s) // NOLINT(readability-identifier-naming)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    if (argc != 2) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 2);
        return false;
    }
    
    std::string *arg1 = 0 ;
    bool arg2 ;
    std::string temp1 ;
    cc::SkeletonCacheAnimation *result;
    
    ok &= sevalue_to_native(args[0], &temp1, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg1 = &temp1;
    
    
    ok &= sevalue_to_native(args[1], &arg2);
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    result = (cc::SkeletonCacheAnimation *)new cc::SkeletonCacheAnimation((std::string const &)*arg1,arg2);
    
    
    auto *ptr = JSB_MAKE_PRIVATE_OBJECT_WITH_INSTANCE(result);
    s.thisObject()->setPrivateObject(ptr);
    return true;
}
SE_BIND_CTOR(js_new_cc_SkeletonCacheAnimation, __jsb_cc_SkeletonCacheAnimation_class, js_delete_cc_SkeletonCacheAnimation)

static bool js_delete_cc_SkeletonCacheAnimation(se::State& s)
{
    return true;
}
SE_BIND_FINALIZE_FUNC(js_delete_cc_SkeletonCacheAnimation) 

static bool js_cc_SkeletonCacheAnimation_update(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonCacheAnimation *arg1 = (cc::SkeletonCacheAnimation *) NULL ;
    float arg2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonCacheAnimation>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->update(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonCacheAnimation_update) 

static bool js_cc_SkeletonCacheAnimation_getSkeleton(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonCacheAnimation *arg1 = (cc::SkeletonCacheAnimation *) NULL ;
    spine::Skeleton *result = 0 ;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonCacheAnimation>(s);
    if (nullptr == arg1) return true;
    result = (spine::Skeleton *)((cc::SkeletonCacheAnimation const *)arg1)->getSkeleton();
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonCacheAnimation_getSkeleton) 

static bool js_cc_SkeletonCacheAnimation_setTimeScale(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonCacheAnimation *arg1 = (cc::SkeletonCacheAnimation *) NULL ;
    float arg2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonCacheAnimation>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setTimeScale(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonCacheAnimation_setTimeScale) 

static bool js_cc_SkeletonCacheAnimation_getTimeScale(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonCacheAnimation *arg1 = (cc::SkeletonCacheAnimation *) NULL ;
    float result;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonCacheAnimation>(s);
    if (nullptr == arg1) return true;
    result = (float)((cc::SkeletonCacheAnimation const *)arg1)->getTimeScale();
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject()); 
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonCacheAnimation_getTimeScale) 

static bool js_cc_SkeletonCacheAnimation_paused(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonCacheAnimation *arg1 = (cc::SkeletonCacheAnimation *) NULL ;
    bool arg2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonCacheAnimation>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2);
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->paused(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonCacheAnimation_paused) 

static bool js_cc_SkeletonCacheAnimation_findBone(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonCacheAnimation *arg1 = (cc::SkeletonCacheAnimation *) NULL ;
    std::string *arg2 = 0 ;
    std::string temp2 ;
    spine::Bone *result = 0 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonCacheAnimation>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    result = (spine::Bone *)((cc::SkeletonCacheAnimation const *)arg1)->findBone((std::string const &)*arg2);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonCacheAnimation_findBone) 

static bool js_cc_SkeletonCacheAnimation_findSlot(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonCacheAnimation *arg1 = (cc::SkeletonCacheAnimation *) NULL ;
    std::string *arg2 = 0 ;
    std::string temp2 ;
    spine::Slot *result = 0 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonCacheAnimation>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    result = (spine::Slot *)((cc::SkeletonCacheAnimation const *)arg1)->findSlot((std::string const &)*arg2);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonCacheAnimation_findSlot) 

static bool js_cc_SkeletonCacheAnimation_setSkin__SWIG_0(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    cc::SkeletonCacheAnimation *arg1 = (cc::SkeletonCacheAnimation *) NULL ;
    std::string *arg2 = 0 ;
    std::string temp2 ;
    
    arg1 = SE_THIS_OBJECT<cc::SkeletonCacheAnimation>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    (arg1)->setSkin((std::string const &)*arg2);
    
    
    return true;
}

static bool js_cc_SkeletonCacheAnimation_setSkin__SWIG_1(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    cc::SkeletonCacheAnimation *arg1 = (cc::SkeletonCacheAnimation *) NULL ;
    char *arg2 = (char *) NULL ;
    ccstd::string temp2 ;
    
    arg1 = SE_THIS_OBJECT<cc::SkeletonCacheAnimation>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &temp2);
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = (char *) temp2.c_str(); 
    (arg1)->setSkin((char const *)arg2);
    
    
    return true;
}

static bool js_cc_SkeletonCacheAnimation_setSkin(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    
    if (argc == 1) {
        ok = js_cc_SkeletonCacheAnimation_setSkin__SWIG_0(s);
        if (ok) {
            return true; 
        }
    } 
    if (argc == 1) {
        ok = js_cc_SkeletonCacheAnimation_setSkin__SWIG_1(s);
        if (ok) {
            return true; 
        }
    } 
    SE_REPORT_ERROR("wrong number of arguments: %d", (int)argc);
    return false;
}
SE_BIND_FUNC(js_cc_SkeletonCacheAnimation_setSkin) 

static bool js_cc_SkeletonCacheAnimation_getAttachment(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonCacheAnimation *arg1 = (cc::SkeletonCacheAnimation *) NULL ;
    std::string *arg2 = 0 ;
    std::string *arg3 = 0 ;
    std::string temp2 ;
    std::string temp3 ;
    spine::Attachment *result = 0 ;
    
    if(argc != 2) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 2);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonCacheAnimation>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    
    ok &= sevalue_to_native(args[1], &temp3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg3 = &temp3;
    
    result = (spine::Attachment *)((cc::SkeletonCacheAnimation const *)arg1)->getAttachment((std::string const &)*arg2,(std::string const &)*arg3);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonCacheAnimation_getAttachment) 

static bool js_cc_SkeletonCacheAnimation_setAttachment__SWIG_0(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    cc::SkeletonCacheAnimation *arg1 = (cc::SkeletonCacheAnimation *) NULL ;
    std::string *arg2 = 0 ;
    std::string *arg3 = 0 ;
    std::string temp2 ;
    std::string temp3 ;
    bool result;
    
    arg1 = SE_THIS_OBJECT<cc::SkeletonCacheAnimation>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    
    ok &= sevalue_to_native(args[1], &temp3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg3 = &temp3;
    
    result = (bool)(arg1)->setAttachment((std::string const &)*arg2,(std::string const &)*arg3);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    
    
    return true;
}

static bool js_cc_SkeletonCacheAnimation_setAttachment__SWIG_1(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    cc::SkeletonCacheAnimation *arg1 = (cc::SkeletonCacheAnimation *) NULL ;
    std::string *arg2 = 0 ;
    char *arg3 = (char *) NULL ;
    std::string temp2 ;
    ccstd::string temp3 ;
    bool result;
    
    arg1 = SE_THIS_OBJECT<cc::SkeletonCacheAnimation>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    
    ok &= sevalue_to_native(args[1], &temp3);
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg3 = (char *) temp3.c_str(); 
    result = (bool)(arg1)->setAttachment((std::string const &)*arg2,(char const *)arg3);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    
    
    return true;
}

static bool js_cc_SkeletonCacheAnimation_setAttachment(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    
    if (argc == 2) {
        ok = js_cc_SkeletonCacheAnimation_setAttachment__SWIG_0(s);
        if (ok) {
            return true; 
        }
    } 
    if (argc == 2) {
        ok = js_cc_SkeletonCacheAnimation_setAttachment__SWIG_1(s);
        if (ok) {
            return true; 
        }
    } 
    SE_REPORT_ERROR("wrong number of arguments: %d", (int)argc);
    return false;
}
SE_BIND_FUNC(js_cc_SkeletonCacheAnimation_setAttachment) 

static bool js_cc_SkeletonCacheAnimation_setColor(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonCacheAnimation *arg1 = (cc::SkeletonCacheAnimation *) NULL ;
    float arg2 ;
    float arg3 ;
    float arg4 ;
    float arg5 ;
    
    if(argc != 4) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 4);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonCacheAnimation>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[1], &arg3, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[2], &arg4, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[3], &arg5, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setColor(arg2,arg3,arg4,arg5);
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonCacheAnimation_setColor) 

static bool js_cc_SkeletonCacheAnimation_setBatchEnabled(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonCacheAnimation *arg1 = (cc::SkeletonCacheAnimation *) NULL ;
    bool arg2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonCacheAnimation>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2);
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setBatchEnabled(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonCacheAnimation_setBatchEnabled) 

static bool js_cc_SkeletonCacheAnimation_setAttachEnabled(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonCacheAnimation *arg1 = (cc::SkeletonCacheAnimation *) NULL ;
    bool arg2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonCacheAnimation>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2);
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setAttachEnabled(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonCacheAnimation_setAttachEnabled) 

static bool js_cc_SkeletonCacheAnimation_setOpacityModifyRGB(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonCacheAnimation *arg1 = (cc::SkeletonCacheAnimation *) NULL ;
    bool arg2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonCacheAnimation>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2);
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setOpacityModifyRGB(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonCacheAnimation_setOpacityModifyRGB) 

static bool js_cc_SkeletonCacheAnimation_isOpacityModifyRGB(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonCacheAnimation *arg1 = (cc::SkeletonCacheAnimation *) NULL ;
    bool result;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonCacheAnimation>(s);
    if (nullptr == arg1) return true;
    result = (bool)((cc::SkeletonCacheAnimation const *)arg1)->isOpacityModifyRGB();
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonCacheAnimation_isOpacityModifyRGB) 

static bool js_cc_SkeletonCacheAnimation_beginSchedule(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonCacheAnimation *arg1 = (cc::SkeletonCacheAnimation *) NULL ;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonCacheAnimation>(s);
    if (nullptr == arg1) return true;
    (arg1)->beginSchedule();
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonCacheAnimation_beginSchedule) 

static bool js_cc_SkeletonCacheAnimation_stopSchedule(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonCacheAnimation *arg1 = (cc::SkeletonCacheAnimation *) NULL ;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonCacheAnimation>(s);
    if (nullptr == arg1) return true;
    (arg1)->stopSchedule();
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonCacheAnimation_stopSchedule) 

static bool js_cc_SkeletonCacheAnimation_onEnable(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonCacheAnimation *arg1 = (cc::SkeletonCacheAnimation *) NULL ;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonCacheAnimation>(s);
    if (nullptr == arg1) return true;
    (arg1)->onEnable();
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonCacheAnimation_onEnable) 

static bool js_cc_SkeletonCacheAnimation_onDisable(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonCacheAnimation *arg1 = (cc::SkeletonCacheAnimation *) NULL ;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonCacheAnimation>(s);
    if (nullptr == arg1) return true;
    (arg1)->onDisable();
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonCacheAnimation_onDisable) 

static bool js_cc_SkeletonCacheAnimation_setUseTint(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonCacheAnimation *arg1 = (cc::SkeletonCacheAnimation *) NULL ;
    bool arg2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonCacheAnimation>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2);
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setUseTint(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonCacheAnimation_setUseTint) 

static bool js_cc_SkeletonCacheAnimation_setAnimation(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonCacheAnimation *arg1 = (cc::SkeletonCacheAnimation *) NULL ;
    std::string *arg2 = 0 ;
    bool arg3 ;
    std::string temp2 ;
    
    if(argc != 2) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 2);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonCacheAnimation>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    
    ok &= sevalue_to_native(args[1], &arg3);
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setAnimation((std::string const &)*arg2,arg3);
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonCacheAnimation_setAnimation) 

static bool js_cc_SkeletonCacheAnimation_addAnimation__SWIG_0(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    cc::SkeletonCacheAnimation *arg1 = (cc::SkeletonCacheAnimation *) NULL ;
    std::string *arg2 = 0 ;
    bool arg3 ;
    float arg4 ;
    std::string temp2 ;
    
    arg1 = SE_THIS_OBJECT<cc::SkeletonCacheAnimation>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    
    ok &= sevalue_to_native(args[1], &arg3);
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    
    ok &= sevalue_to_native(args[2], &arg4, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->addAnimation((std::string const &)*arg2,arg3,arg4);
    
    
    return true;
}

static bool js_cc_SkeletonCacheAnimation_addAnimation__SWIG_1(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    cc::SkeletonCacheAnimation *arg1 = (cc::SkeletonCacheAnimation *) NULL ;
    std::string *arg2 = 0 ;
    bool arg3 ;
    std::string temp2 ;
    
    arg1 = SE_THIS_OBJECT<cc::SkeletonCacheAnimation>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    
    ok &= sevalue_to_native(args[1], &arg3);
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->addAnimation((std::string const &)*arg2,arg3);
    
    
    return true;
}

static bool js_cc_SkeletonCacheAnimation_addAnimation(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    
    if (argc == 3) {
        ok = js_cc_SkeletonCacheAnimation_addAnimation__SWIG_0(s);
        if (ok) {
            return true; 
        }
    } 
    if (argc == 2) {
        ok = js_cc_SkeletonCacheAnimation_addAnimation__SWIG_1(s);
        if (ok) {
            return true; 
        }
    } 
    SE_REPORT_ERROR("wrong number of arguments: %d", (int)argc);
    return false;
}
SE_BIND_FUNC(js_cc_SkeletonCacheAnimation_addAnimation) 

static bool js_cc_SkeletonCacheAnimation_findAnimation(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonCacheAnimation *arg1 = (cc::SkeletonCacheAnimation *) NULL ;
    std::string *arg2 = 0 ;
    std::string temp2 ;
    spine::Animation *result = 0 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonCacheAnimation>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    result = (spine::Animation *)((cc::SkeletonCacheAnimation const *)arg1)->findAnimation((std::string const &)*arg2);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonCacheAnimation_findAnimation) 

static bool js_cc_SkeletonCacheAnimation_setStartListener(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonCacheAnimation *arg1 = (cc::SkeletonCacheAnimation *) NULL ;
    cc::SkeletonCacheAnimation::CacheFrameEvent *arg2 = 0 ;
    cc::SkeletonCacheAnimation::CacheFrameEvent temp2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonCacheAnimation>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    (arg1)->setStartListener((cc::SkeletonCacheAnimation::CacheFrameEvent const &)*arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonCacheAnimation_setStartListener) 

static bool js_cc_SkeletonCacheAnimation_setEndListener(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonCacheAnimation *arg1 = (cc::SkeletonCacheAnimation *) NULL ;
    cc::SkeletonCacheAnimation::CacheFrameEvent *arg2 = 0 ;
    cc::SkeletonCacheAnimation::CacheFrameEvent temp2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonCacheAnimation>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    (arg1)->setEndListener((cc::SkeletonCacheAnimation::CacheFrameEvent const &)*arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonCacheAnimation_setEndListener) 

static bool js_cc_SkeletonCacheAnimation_setCompleteListener(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonCacheAnimation *arg1 = (cc::SkeletonCacheAnimation *) NULL ;
    cc::SkeletonCacheAnimation::CacheFrameEvent *arg2 = 0 ;
    cc::SkeletonCacheAnimation::CacheFrameEvent temp2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonCacheAnimation>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    (arg1)->setCompleteListener((cc::SkeletonCacheAnimation::CacheFrameEvent const &)*arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonCacheAnimation_setCompleteListener) 

static bool js_cc_SkeletonCacheAnimation_updateAnimationCache(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonCacheAnimation *arg1 = (cc::SkeletonCacheAnimation *) NULL ;
    std::string *arg2 = 0 ;
    std::string temp2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonCacheAnimation>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    (arg1)->updateAnimationCache((std::string const &)*arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonCacheAnimation_updateAnimationCache) 

static bool js_cc_SkeletonCacheAnimation_updateAllAnimationCache(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonCacheAnimation *arg1 = (cc::SkeletonCacheAnimation *) NULL ;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonCacheAnimation>(s);
    if (nullptr == arg1) return true;
    (arg1)->updateAllAnimationCache();
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonCacheAnimation_updateAllAnimationCache) 

static bool js_cc_SkeletonCacheAnimation_setToSetupPose(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonCacheAnimation *arg1 = (cc::SkeletonCacheAnimation *) NULL ;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonCacheAnimation>(s);
    if (nullptr == arg1) return true;
    (arg1)->setToSetupPose();
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonCacheAnimation_setToSetupPose) 

static bool js_cc_SkeletonCacheAnimation_setBonesToSetupPose(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonCacheAnimation *arg1 = (cc::SkeletonCacheAnimation *) NULL ;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonCacheAnimation>(s);
    if (nullptr == arg1) return true;
    (arg1)->setBonesToSetupPose();
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonCacheAnimation_setBonesToSetupPose) 

static bool js_cc_SkeletonCacheAnimation_setSlotsToSetupPose(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonCacheAnimation *arg1 = (cc::SkeletonCacheAnimation *) NULL ;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonCacheAnimation>(s);
    if (nullptr == arg1) return true;
    (arg1)->setSlotsToSetupPose();
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonCacheAnimation_setSlotsToSetupPose) 

static bool js_cc_SkeletonCacheAnimation_getSharedBufferOffset(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonCacheAnimation *arg1 = (cc::SkeletonCacheAnimation *) NULL ;
    se_object_ptr result;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonCacheAnimation>(s);
    if (nullptr == arg1) return true;
    result = ((cc::SkeletonCacheAnimation const *)arg1)->getSharedBufferOffset();
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject() /*ctx*/);
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval());
    
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonCacheAnimation_getSharedBufferOffset) 

static bool js_cc_SkeletonCacheAnimation_setMaterial(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonCacheAnimation *arg1 = (cc::SkeletonCacheAnimation *) NULL ;
    cc::Material *arg2 = (cc::Material *) NULL ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonCacheAnimation>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setMaterial(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonCacheAnimation_setMaterial) 

static bool js_cc_SkeletonCacheAnimation_setRenderEntity(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonCacheAnimation *arg1 = (cc::SkeletonCacheAnimation *) NULL ;
    cc::RenderEntity *arg2 = (cc::RenderEntity *) NULL ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonCacheAnimation>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &arg2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments"); 
    (arg1)->setRenderEntity(arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonCacheAnimation_setRenderEntity) 

bool js_register_cc_SkeletonCacheAnimation(se::Object* obj) {
    auto* cls = se::Class::create("SkeletonCacheAnimation", obj, nullptr, _SE(js_new_cc_SkeletonCacheAnimation)); 
    
    cls->defineStaticProperty("__isJSB", se::Value(true), se::PropertyAttribute::READ_ONLY | se::PropertyAttribute::DONT_ENUM | se::PropertyAttribute::DONT_DELETE);
    
    cls->defineFunction("update", _SE(js_cc_SkeletonCacheAnimation_update)); 
    cls->defineFunction("getSkeleton", _SE(js_cc_SkeletonCacheAnimation_getSkeleton)); 
    cls->defineFunction("setTimeScale", _SE(js_cc_SkeletonCacheAnimation_setTimeScale)); 
    cls->defineFunction("getTimeScale", _SE(js_cc_SkeletonCacheAnimation_getTimeScale)); 
    cls->defineFunction("paused", _SE(js_cc_SkeletonCacheAnimation_paused)); 
    cls->defineFunction("findBone", _SE(js_cc_SkeletonCacheAnimation_findBone)); 
    cls->defineFunction("findSlot", _SE(js_cc_SkeletonCacheAnimation_findSlot)); 
    cls->defineFunction("setSkin", _SE(js_cc_SkeletonCacheAnimation_setSkin)); 
    cls->defineFunction("getAttachment", _SE(js_cc_SkeletonCacheAnimation_getAttachment)); 
    cls->defineFunction("setAttachment", _SE(js_cc_SkeletonCacheAnimation_setAttachment)); 
    cls->defineFunction("setColor", _SE(js_cc_SkeletonCacheAnimation_setColor)); 
    cls->defineFunction("setBatchEnabled", _SE(js_cc_SkeletonCacheAnimation_setBatchEnabled)); 
    cls->defineFunction("setAttachEnabled", _SE(js_cc_SkeletonCacheAnimation_setAttachEnabled)); 
    cls->defineFunction("setOpacityModifyRGB", _SE(js_cc_SkeletonCacheAnimation_setOpacityModifyRGB)); 
    cls->defineFunction("isOpacityModifyRGB", _SE(js_cc_SkeletonCacheAnimation_isOpacityModifyRGB)); 
    cls->defineFunction("beginSchedule", _SE(js_cc_SkeletonCacheAnimation_beginSchedule)); 
    cls->defineFunction("stopSchedule", _SE(js_cc_SkeletonCacheAnimation_stopSchedule)); 
    cls->defineFunction("onEnable", _SE(js_cc_SkeletonCacheAnimation_onEnable)); 
    cls->defineFunction("onDisable", _SE(js_cc_SkeletonCacheAnimation_onDisable)); 
    cls->defineFunction("setUseTint", _SE(js_cc_SkeletonCacheAnimation_setUseTint)); 
    cls->defineFunction("setAnimation", _SE(js_cc_SkeletonCacheAnimation_setAnimation)); 
    cls->defineFunction("addAnimation", _SE(js_cc_SkeletonCacheAnimation_addAnimation)); 
    cls->defineFunction("findAnimation", _SE(js_cc_SkeletonCacheAnimation_findAnimation)); 
    cls->defineFunction("setStartListener", _SE(js_cc_SkeletonCacheAnimation_setStartListener)); 
    cls->defineFunction("setEndListener", _SE(js_cc_SkeletonCacheAnimation_setEndListener)); 
    cls->defineFunction("setCompleteListener", _SE(js_cc_SkeletonCacheAnimation_setCompleteListener)); 
    cls->defineFunction("updateAnimationCache", _SE(js_cc_SkeletonCacheAnimation_updateAnimationCache)); 
    cls->defineFunction("updateAllAnimationCache", _SE(js_cc_SkeletonCacheAnimation_updateAllAnimationCache)); 
    cls->defineFunction("setToSetupPose", _SE(js_cc_SkeletonCacheAnimation_setToSetupPose)); 
    cls->defineFunction("setBonesToSetupPose", _SE(js_cc_SkeletonCacheAnimation_setBonesToSetupPose)); 
    cls->defineFunction("setSlotsToSetupPose", _SE(js_cc_SkeletonCacheAnimation_setSlotsToSetupPose)); 
    cls->defineFunction("getSharedBufferOffset", _SE(js_cc_SkeletonCacheAnimation_getSharedBufferOffset)); 
    cls->defineFunction("setMaterial", _SE(js_cc_SkeletonCacheAnimation_setMaterial)); 
    cls->defineFunction("setRenderEntity", _SE(js_cc_SkeletonCacheAnimation_setRenderEntity)); 
    
    
    
    
    cls->defineFinalizeFunction(_SE(js_delete_cc_SkeletonCacheAnimation));
    
    
    cls->install();
    JSBClassType::registerClass<cc::SkeletonCacheAnimation>(cls);
    
    __jsb_cc_SkeletonCacheAnimation_proto = cls->getProto();
    __jsb_cc_SkeletonCacheAnimation_class = cls;
    se::ScriptEngine::getInstance()->clearException();
    return true;
}


se::Class* __jsb_cc_SkeletonCacheMgr_class = nullptr;
se::Object* __jsb_cc_SkeletonCacheMgr_proto = nullptr;
SE_DECLARE_FINALIZE_FUNC(js_delete_cc_SkeletonCacheMgr) 

static bool js_cc_SkeletonCacheMgr_getInstance_static(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonCacheMgr *result = 0 ;
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    result = (cc::SkeletonCacheMgr *)cc::SkeletonCacheMgr::getInstance();
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonCacheMgr_getInstance_static) 

static bool js_cc_SkeletonCacheMgr_destroyInstance_static(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    if(argc != 0) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 0);
        return false;
    }
    cc::SkeletonCacheMgr::destroyInstance();
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonCacheMgr_destroyInstance_static) 

static bool js_cc_SkeletonCacheMgr_removeSkeletonCache(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonCacheMgr *arg1 = (cc::SkeletonCacheMgr *) NULL ;
    std::string *arg2 = 0 ;
    std::string temp2 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonCacheMgr>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    (arg1)->removeSkeletonCache((std::string const &)*arg2);
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonCacheMgr_removeSkeletonCache) 

static bool js_cc_SkeletonCacheMgr_buildSkeletonCache(se::State& s)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    cc::SkeletonCacheMgr *arg1 = (cc::SkeletonCacheMgr *) NULL ;
    std::string *arg2 = 0 ;
    std::string temp2 ;
    cc::SkeletonCache *result = 0 ;
    
    if(argc != 1) {
        SE_REPORT_ERROR("wrong number of arguments: %d, was expecting %d", (int)argc, 1);
        return false;
    }
    arg1 = SE_THIS_OBJECT<cc::SkeletonCacheMgr>(s);
    if (nullptr == arg1) return true;
    
    ok &= sevalue_to_native(args[0], &temp2, s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    arg2 = &temp2;
    
    result = (cc::SkeletonCache *)(arg1)->buildSkeletonCache((std::string const &)*arg2);
    
    ok &= nativevalue_to_se(result, s.rval(), s.thisObject());
    SE_PRECONDITION2(ok, false, "Error processing arguments");
    SE_HOLD_RETURN_VALUE(result, s.thisObject(), s.rval()); 
    
    
    return true;
}
SE_BIND_FUNC(js_cc_SkeletonCacheMgr_buildSkeletonCache) 

static bool js_new_cc_SkeletonCacheMgr(se::State& s) // NOLINT(readability-identifier-naming)
{
    CC_UNUSED bool ok = true;
    const auto& args = s.args();
    size_t argc = args.size();
    
    cc::SkeletonCacheMgr *result;
    result = (cc::SkeletonCacheMgr *)new cc::SkeletonCacheMgr();
    
    
    auto *ptr = JSB_MAKE_PRIVATE_OBJECT_WITH_INSTANCE(result);
    s.thisObject()->setPrivateObject(ptr);
    return true;
}
SE_BIND_CTOR(js_new_cc_SkeletonCacheMgr, __jsb_cc_SkeletonCacheMgr_class, js_delete_cc_SkeletonCacheMgr)

static bool js_delete_cc_SkeletonCacheMgr(se::State& s)
{
    return true;
}
SE_BIND_FINALIZE_FUNC(js_delete_cc_SkeletonCacheMgr) 

bool js_register_cc_SkeletonCacheMgr(se::Object* obj) {
    auto* cls = se::Class::create("SkeletonCacheMgr", obj, nullptr, _SE(js_new_cc_SkeletonCacheMgr)); 
    
    cls->defineStaticProperty("__isJSB", se::Value(true), se::PropertyAttribute::READ_ONLY | se::PropertyAttribute::DONT_ENUM | se::PropertyAttribute::DONT_DELETE);
    
    cls->defineFunction("removeSkeletonCache", _SE(js_cc_SkeletonCacheMgr_removeSkeletonCache)); 
    cls->defineFunction("buildSkeletonCache", _SE(js_cc_SkeletonCacheMgr_buildSkeletonCache)); 
    
    
    cls->defineStaticFunction("getInstance", _SE(js_cc_SkeletonCacheMgr_getInstance_static)); 
    cls->defineStaticFunction("destroyInstance", _SE(js_cc_SkeletonCacheMgr_destroyInstance_static)); 
    
    
    cls->defineFinalizeFunction(_SE(js_delete_cc_SkeletonCacheMgr));
    
    
    cls->install();
    JSBClassType::registerClass<cc::SkeletonCacheMgr>(cls);
    
    __jsb_cc_SkeletonCacheMgr_proto = cls->getProto();
    __jsb_cc_SkeletonCacheMgr_class = cls;
    se::ScriptEngine::getInstance()->clearException();
    return true;
}




bool register_all_spine(se::Object* obj) {
    // Get the ns
    se::Value nsVal;
    if (!obj->getProperty("spine", &nsVal, true))
    {
        se::HandleObject jsobj(se::Object::createPlainObject());
        nsVal.setObject(jsobj);
        obj->setProperty("spine", nsVal);
    }
    se::Object* ns = nsVal.toObject();
    /* Register classes */
    js_register_spine_MathUtil(ns); 
    js_register_spine_Interpolation(ns); 
    js_register_spine_PowInterpolation(ns); 
    js_register_spine_PowOutInterpolation(ns); 
    js_register_spine_Timeline(ns); 
    js_register_spine_Animation(ns); 
    js_register_spine_AnimationStateListenerObject(ns); 
    js_register_spine_TrackEntry(ns); 
    js_register_spine_EventQueueEntry(ns); 
    js_register_spine_EventQueue(ns); 
    js_register_spine_AnimationState(ns); 
    js_register_spine_AnimationStateData(ns); 
    js_register_spine_Attachment(ns); 
    js_register_spine_AttachmentTimeline(ns); 
    js_register_spine_VertexAttachment(ns); 
    js_register_spine_BoundingBoxAttachment(ns); 
    js_register_spine_Bone(ns); 
    js_register_spine_BoneData(ns); 
    js_register_spine_ClippingAttachment(ns); 
    js_register_spine_Color(ns); 
    js_register_spine_CurveTimeline(ns); 
    js_register_spine_CurveTimeline1(ns); 
    js_register_spine_CurveTimeline2(ns); 
    js_register_spine_RGBATimeline(ns); 
    js_register_spine_RGBTimeline(ns); 
    js_register_spine_AlphaTimeline(ns); 
    js_register_spine_RGBA2Timeline(ns); 
    js_register_spine_RGB2Timeline(ns); 
    js_register_spine_DeformTimeline(ns); 
    js_register_spine_DrawOrderTimeline(ns); 
    js_register_spine_Event(ns); 
    js_register_spine_EventData(ns); 
    js_register_spine_EventTimeline(ns); 
    js_register_spine_ConstraintData(ns); 
    js_register_spine_IkConstraint(ns); 
    js_register_spine_IkConstraintData(ns); 
    js_register_spine_IkConstraintTimeline(ns); 
    js_register_spine_MeshAttachment(ns); 
    js_register_spine_PathAttachment(ns); 
    js_register_spine_PathConstraint(ns); 
    js_register_spine_PathConstraintData(ns); 
    js_register_spine_PathConstraintMixTimeline(ns); 
    js_register_spine_PathConstraintPositionTimeline(ns); 
    js_register_spine_PathConstraintSpacingTimeline(ns); 
    js_register_spine_PointAttachment(ns); 
    js_register_spine_RegionAttachment(ns); 
    js_register_spine_TranslateTimeline(ns); 
    js_register_spine_TranslateXTimeline(ns); 
    js_register_spine_TranslateYTimeline(ns); 
    js_register_spine_RotateTimeline(ns); 
    js_register_spine_ScaleTimeline(ns); 
    js_register_spine_ScaleXTimeline(ns); 
    js_register_spine_ScaleYTimeline(ns); 
    js_register_spine_ShearTimeline(ns); 
    js_register_spine_ShearXTimeline(ns); 
    js_register_spine_ShearYTimeline(ns); 
    js_register_spine_Skeleton(ns); 
    js_register_spine_Slot(ns); 
    js_register_spine_Skin(ns); 
    js_register_spine_Skin_AttachmentMap(ns); 
    js_register_spine_Skin_AttachmentMap_Entry(ns); 
    js_register_spine_Skin_AttachmentMap_Entries(ns); 
    js_register_spine_SkeletonBounds(ns); 
    js_register_spine_Polygon(ns); 
    js_register_spine_SkeletonData(ns); 
    js_register_spine_SlotData(ns); 
    js_register_spine_Sequence(ns); 
    js_register_spine_AtlasPage(ns); 
    js_register_spine_AtlasRegion(ns); 
    js_register_spine_Atlas(ns); 
    js_register_spine_TextureLoader(ns); 
    js_register_spine_TextureRegion(ns); 
    js_register_spine_TransformConstraint(ns); 
    js_register_spine_TransformConstraintData(ns); 
    js_register_spine_TransformConstraintTimeline(ns); 
    js_register_cc_SkeletonRenderer(ns); 
    js_register_cc_SkeletonAnimation(ns); 
    js_register_cc_SkeletonDataMgr(ns); 
    js_register_cc_SkeletonCacheAnimation(ns); 
    js_register_cc_SkeletonCacheMgr(ns); 
    
    /* Register global variables & global functions */
    
    
    
    return true;
}


#if defined(__clang__)
#pragma clang diagnostic pop
#elif defined(__GNUC__) || defined(__GNUG__)
#pragma GCC diagnostic pop
#elif defined(_MSC_VER)
#pragma warning(pop)
#endif
// clang-format on
