import * as $protobuf from "./protobuf.js";
/** Properties of a Data. */
export interface IData {

    /** Data path */
    path?: (string|null);

    /** Data serverName */
    serverName?: (string|null);

    /** Data data */
    data?: (string|null);
}

/** Represents a Data. */
export class Data implements IData {

    /**
     * Constructs a new Data.
     * @param [p] Properties to set
     */
    constructor(p?: IData);

    /** Data path. */
    public path: string;

    /** Data serverName. */
    public serverName: string;

    /** Data data. */
    public data: string;

    /**
     * Creates a new Data instance using the specified properties.
     * @param [properties] Properties to set
     * @returns Data instance
     */
    public static create(properties?: IData): Data;

    /**
     * Encodes the specified Data message. Does not implicitly {@link Data.verify|verify} messages.
     * @param m Data message or plain object to encode
     * @param [w] Writer to encode to
     * @returns Writer
     */
    public static encode(m: IData, w?: $protobuf.Writer): $protobuf.Writer;

    /**
     * Decodes a Data message from the specified reader or buffer.
     * @param r Reader or buffer to decode from
     * @param [l] Message length if known beforehand
     * @returns Data
     * @throws {Error} If the payload is not a reader or valid buffer
     * @throws {$protobuf.util.ProtocolError} If required fields are missing
     */
    public static decode(r: ($protobuf.Reader|Uint8Array), l?: number): Data;
}
