/*eslint-disable block-scoped-var, id-length, no-control-regex, no-magic-numbers, no-prototype-builtins, no-redeclare, no-shadow, no-var, sort-vars*/
"use strict";

var $protobuf = protobuf;

// Common aliases
var $Reader = $protobuf.Reader, $Writer = $protobuf.Writer, $util = $protobuf.util;

// Exported root namespace
var $root = $protobuf.roots["default"] || ($protobuf.roots["default"] = {});

$root.Data = (function() {

    /**
     * Properties of a Data.
     * @exports IData
     * @interface IData
     * @property {string|null} [path] Data path
     * @property {string|null} [serverName] Data serverName
     * @property {string|null} [data] Data data
     */

    /**
     * Constructs a new Data.
     * @exports Data
     * @classdesc Represents a Data.
     * @implements IData
     * @constructor
     * @param {IData=} [p] Properties to set
     */
    function Data(p) {
        if (p)
            for (var ks = Object.keys(p), i = 0; i < ks.length; ++i)
                if (p[ks[i]] != null)
                    this[ks[i]] = p[ks[i]];
    }

    /**
     * Data path.
     * @member {string} path
     * @memberof Data
     * @instance
     */
    Data.prototype.path = "";

    /**
     * Data serverName.
     * @member {string} serverName
     * @memberof Data
     * @instance
     */
    Data.prototype.serverName = "";

    /**
     * Data data.
     * @member {string} data
     * @memberof Data
     * @instance
     */
    Data.prototype.data = "";

    /**
     * Creates a new Data instance using the specified properties.
     * @function create
     * @memberof Data
     * @static
     * @param {IData=} [properties] Properties to set
     * @returns {Data} Data instance
     */
    Data.create = function create(properties) {
        return new Data(properties);
    };

    /**
     * Encodes the specified Data message. Does not implicitly {@link Data.verify|verify} messages.
     * @function encode
     * @memberof Data
     * @static
     * @param {IData} m Data message or plain object to encode
     * @param {$protobuf.Writer} [w] Writer to encode to
     * @returns {$protobuf.Writer} Writer
     */
    Data.encode = function encode(m, w) {
        if (!w)
            w = $Writer.create();
        if (m.path != null && Object.hasOwnProperty.call(m, "path"))
            w.uint32(10).string(m.path);
        if (m.serverName != null && Object.hasOwnProperty.call(m, "serverName"))
            w.uint32(18).string(m.serverName);
        if (m.data != null && Object.hasOwnProperty.call(m, "data"))
            w.uint32(26).string(m.data);
        return w;
    };

    /**
     * Decodes a Data message from the specified reader or buffer.
     * @function decode
     * @memberof Data
     * @static
     * @param {$protobuf.Reader|Uint8Array} r Reader or buffer to decode from
     * @param {number} [l] Message length if known beforehand
     * @returns {Data} Data
     * @throws {Error} If the payload is not a reader or valid buffer
     * @throws {$protobuf.util.ProtocolError} If required fields are missing
     */
    Data.decode = function decode(r, l) {
        if (!(r instanceof $Reader))
            r = $Reader.create(r);
        var c = l === undefined ? r.len : r.pos + l, m = new $root.Data();
        while (r.pos < c) {
            var t = r.uint32();
            switch (t >>> 3) {
            case 1:
                m.path = r.string();
                break;
            case 2:
                m.serverName = r.string();
                break;
            case 3:
                m.data = r.string();
                break;
            default:
                r.skipType(t & 7);
                break;
            }
        }
        return m;
    };

    return Data;
})();

module.exports = $root;
