
import { _decorator, Component, Node, ScrollView, UIOpacity, tween, easing, Sprite, Asset, SpriteFrame, Texture2D, resources, error } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('Typescript')
export class Typescript extends Component {
    @property(ScrollView)
    scrollview: ScrollView = null;

    start() {
        let cards = this.scrollview.content.children;
        for (let i = 0; i < cards.length; ++i) {
            let path = "shield/spriteFrame";
            resources.load(path, SpriteFrame, (err, asset) => {
                if (!err) {
                    cards[i].getChildByName("shield").getComponent(Sprite).spriteFrame = asset;
                }
            });
        }

        // opacity = 0,加载图标不显示
        for (let i = 0; i < cards.length; ++i) {
            cards[i].getComponent(UIOpacity).opacity = 0;
            tween(cards[i].getComponent(UIOpacity))
                .delay(1)
                .to(1, { opacity: 255 })
                .start();

        }

        // // opacity = 1，正常
        // for (let i = 0; i < cards.length; ++i) {
        //     cards[i].getComponent(UIOpacity).opacity = 1;
        //     tween(cards[i].getComponent(UIOpacity))
        //         .delay(1)
        //         .to(1, { opacity: 255 })
        //         .start();
        // }

        // // opacity = 0，delay=0.01，正常
        // for (let i = 0; i < cards.length; ++i) {
        //     cards[i].getComponent(UIOpacity).opacity = 0;
        //     tween(cards[i].getComponent(UIOpacity))
        //         .delay(0.01)
        //         .to(1, { opacity: 255 })
        //         .start();
        // }
    }
}
