import { LoadResAsync, LoadPreNode, ShowTips,CreateSpine, showPopLayerV2 } from "../Utils/GameUtils";
import { tab } from "../../Table/table_gen";
import PopLayer from "../Utils/PopLayer";
import Role from "../Common/Role";
import MainScene from "./MainScene";
import CardAttrItem from "../DeckLayer/CardAttrItem";
import { CardDisplayType, CardAttrType, MaterailState, isValidObj, kOneNumber, kZeroNumber, kNegativeOneNumber, kTwoNumber, CardNodeState, kHundredNumber, kTenNumber, isChineseString } from "../Common/CommonInterface";
import { proto } from "../../Protocol/client_protocol";
import { Net } from "../../Protocol/Net";
import { LOCAL_MESSAGE } from "../../Protocol/LocalMessage";
import { build } from "../../Protocol/protobufjs";
import JumpShop from "../DeckLayer/JumpShop";

// Learn TypeScript:
//  - https://docs.cocos.com/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/manual/en/scripting/life-cycle-callbacks.html


const {ccclass, property} = cc._decorator;

//升级按钮状态
enum UplvBtnState{
    CAN_UP_LEVEL = 1,  //能升级
    GOLD_NOT_ENOUGH,  //金币不足
    PIECE_NOT_ENOUGH, //碎片不足
    MAX_LEVEL,        //满级了
}

@ccclass
export default class CardDetail extends PopLayer {

    @property(cc.Sprite)
    spr_bg: cc.Sprite                 = null;

    @property(cc.Label)
    lbl_card_name: cc.Label           = null;

    @property(cc.Button)
    btn_uplv:cc.Button                = null;

    @property(cc.Button)
    btn_use:cc.Button                 = null;

    @property(cc.Button)
    btn_back:cc.Button                = null;

    @property(cc.Sprite)
    spr_quailty_frame:cc.Sprite       = null;

    @property(cc.Sprite)
    spr_portrait_quality:cc.Sprite    = null;

    @property(cc.Node)
    node_attr_node:cc.Node            = null;

    @property(cc.ProgressBar)
    prog_bar_uplv:cc.ProgressBar      = null;

    @property(cc.Label)
    lbl_description:cc.Label          = null;

    @property(cc.Sprite)
    spr_uplv_arrow:cc.Sprite          = null;

    @property(cc.Sprite)
    spr_not_up_arrow: cc.Sprite       = null;

    @property(cc.Label)
    lbl_attr_value:cc.Label           = null;

    @property(cc.Node)
    node_top_btn_function:cc.Node     = null;

    @property(cc.Prefab)
    pfb_bak_attr_item: cc.Prefab      = null;

    @property(cc.Sprite)
    spr_btn_uplv_bg: cc.Sprite        = null;

    @property(cc.Sprite)
    spr_gold_icon: cc.Sprite          = null;

    @property(cc.Label)
    lbl_cost_gold:cc.Label            = null;

    @property(cc.Node)
    node_bottom_btn_layout: cc.Node   = null;

    @property(cc.Node)
    node_portrait_spine: cc.Node      = null;

    @property(cc.Node)
    node_uplv_spine: cc.Node          = null;

    @property(cc.Node)
    node_card_info_layout: cc.Node    = null;

    @property(cc.Sprite)
    spr_bar_full: cc.Sprite           = null;

    @property(cc.Node)
    node_attr_container: cc.Node      = null;

    @property(cc.Button)
    btn_exit_uplv:cc.Button           = null;

    @property(cc.Sprite)
    spr_attr_bg: cc.Sprite            = null;

    @property(cc.Node)
    node_synthesis_strength: cc.Node  = null;

    @property(cc.Button)
    btn_strength: cc.Button           = null;

    @property(cc.Button)
    btn_synthesis: cc.Button          = null;

    @property(cc.Node)
    node_uplv_info: cc.Node           = null;

    @property(cc.Label)
    lbl_uplv_card_name: cc.Label      = null;

    @property(cc.Label)
    lbl_curlv: cc.Label               = null;

    @property(cc.Label)
    lbl_nextlv: cc.Label              = null;

    @property(cc.ProgressBar)
    prog_bar_uplv_info:cc.ProgressBar = null;

    @property(cc.Label)
    lbl_attr_value_uplv_info:cc.Label = null;

    @property(cc.Label)
    lbl_card_quality: cc.Label        = null;

    @property(cc.Label)
    lbl_attr_title: cc.Label          = null;

    @property(cc.Sprite)
    spr_bar_full_uplv_info: cc.Sprite = null;

    @property(cc.Sprite)
    spr_uplv_arrow_info:cc.Sprite     = null;

    @property(cc.Sprite)
    spr_not_up_arrow_info: cc.Sprite  = null;

    @property(cc.Sprite)
    spr_star_lv:cc.Sprite             = null;

    @property(cc.Sprite)
    spr_synthesis_lv: cc.Sprite       = null;

    @property(cc.Node)
    node_level_up_reward: cc.Node     = null;

    @property(cc.Sprite)
    spr_star_reward: cc.Sprite        = null;

    @property(cc.Label)
    lbl_reward_value: cc.Label        = null;

    @property(cc.Label)
    lbl_uplv_tip: cc.Label            = null;

    @property(cc.Label)
    lbl_uplv_tip_gray: cc.Label       = null;

    @property(cc.Label)
    lbl_card_level: cc.Label          = null;

    @property(cc.RichText)
    rich_txt_description: cc.RichText = null;

    @property(cc.Sprite)
    spr_portrait_bg: cc.Sprite        = null;

    @property(cc.Node)
    node_card_item_1: cc.Node     = null;

    @property(cc.Node)
    node_card_item_2: cc.Node     = null;

    @property(cc.Node)
    node_card_item_3: cc.Node     = null;

    @property(cc.Node)
    node_card_item_4: cc.Node     = null;

    @property(cc.Node)
    node_card_item_5: cc.Node     = null;

    @property(cc.Node)
    node_card_item_6: cc.Node     = null;

    protected _card_uuid:string       = "";                    //卡牌UUID
    private _card_static_id: number;                          //卡牌静态id
    private _uplv_btn_state: UplvBtnState;                   //升级按钮的状态
    private _spr_btn_mat_arr: cc.Material[];                //升级按钮材质列表
    private _card_level: number;                           //卡牌等级
    private _card_state: CardNodeState;                   //卡牌当前所处的状态
    private _display_type: CardDisplayType;              //显示类型
    private _current_star_uplv: number = kZeroNumber;   //当前强化升星等级
    private _current_synthesis_lv: number = kOneNumber;//当前合成等级
    private _card_strength_maxlv: number = 0;         //卡牌升星强化最大等级
    private _card_synthesis_maxlv: number = 0;       //卡牌合成最大等级
    private _card_attr_list: CardAttrItem[] = [];        //卡牌属性条列表
    private _card_extra_level: number = 0;         //高级卡牌附加等级数值
    // LIFE-CYCLE CALLBACKS:

     onLoad () {
        this.node_uplv_info.active     = false;
        this.btn_exit_uplv.node.active = false;
        this._spr_btn_mat_arr          = this.spr_btn_uplv_bg.getMaterials(); 
        this.btn_use.node.on      ("click", this.onClickUseCard,   this);
        this.btn_back.node.on     ("click", this.onClickClose,     this);
        this.btn_uplv.node.on     ("click", this.onClickUpLv,      this);
        this.btn_exit_uplv.node.on("click", this.onExitUpLv,       this);
        this.btn_strength.node.on ("click", this.onClickStrength,  this);
        this.btn_synthesis.node.on("click", this.onClickSynthesis, this);
        this._card_strength_maxlv  = tab.Data.GetKeyValue_ConfigTable().CardStrenghtMaxLv;
        this._card_synthesis_maxlv = tab.Data.GetKeyValue_ConfigTable().CardSynthesisMaxLv;

        this._card_attr_list.push(this.node_card_item_1.getComponent(CardAttrItem));
        this._card_attr_list.push(this.node_card_item_2.getComponent(CardAttrItem));
        this._card_attr_list.push(this.node_card_item_3.getComponent(CardAttrItem));
        this._card_attr_list.push(this.node_card_item_4.getComponent(CardAttrItem));
        this._card_attr_list.push(this.node_card_item_5.getComponent(CardAttrItem));
        this._card_attr_list.push(this.node_card_item_6.getComponent(CardAttrItem));

        //升级卡牌协议回调监听
        Net.listenProtocol(proto.Ptl.CardLevelUpRsp, (buffer, ptl)=>{
            let msg = proto.Msg_CardLevelUpRsp.decode(buffer);
            switch(msg.result){
                case proto.Msg_CardLevelUpRsp.ErrorCode.Succeed:
                    this._card_uuid = msg.cardUuid;
                    this.hideAllElementsExcludeSpine();
                    this._display_type = CardDisplayType.CARD_DISPLAY_TYPE_LEVELUP;
                    break;

                case proto.Msg_CardLevelUpRsp.ErrorCode.NotEnoughMoney:
                    ShowTips("GoldNotEnough");
                    break;

                case proto.Msg_CardLevelUpRsp.ErrorCode.NotEnoughPiece:
                    ShowTips("PieceNotEnough");
                    break;

                case proto.Msg_CardLevelUpRsp.ErrorCode.MaxLevel:
                    ShowTips("ReachMaxLevel");
                    break;

                case proto.Msg_CardLevelUpRsp.ErrorCode.OperatorFailed:
                    ShowTips("InvaildOperator");
                    break;
            }
        }, this);

        //监听卡牌信息更新
        Net.listenLoaclMessage(LOCAL_MESSAGE.LocalMsg_UpdateItemData, (param: any)=>{
            if(CardDisplayType.CARD_DISPLAY_TYPE_LEVELUP != this._display_type){return;}
            this.resetCardData();
            this.refreshUplvInfo(true);
            this.refreshUplvBtn();
            this.refreshCurLvAndNextLv();
            this.changeAllAttrDisplayType(this._display_type);
            this.statAttrValuePromoteBar();
            this.playUplvSuccessAnim();
        }, this);

         //监听跳转信息
         Net.listenLoaclMessage(LOCAL_MESSAGE.LocalMsg_JumpShop, (param: any)=>{
            this.setVisible(false);
        }, this);
     }

    start () {
        this.refreshPage();
        this.createAttrBar();
    }

    onDestroy(){
        this._spr_btn_mat_arr = [];
        this._card_attr_list  = [];
    }

    // update (dt) {}

    async setCardData(cardId:number | string, state: CardNodeState) {
        this._card_state = state;
        this._display_type = CardDisplayType.CARD_DISPLAY_TYPE_ATTR;
        if(typeof cardId == "number"){
            this.initWithStaitcId(cardId, kOneNumber, kZeroNumber);
            return;
        }

        this._card_uuid = cardId;
        this.initWithStaitcId();
    }

    public initWithStaitcId(id?: number, lv?: number, count?: number){
        this. resetCardData(id, lv, count);
        //this.refreshPage();
        //this.createAttrBar();
    }

    /**
     * Author: WangZhen
     * Description: 创建属性条
     */
    async createAttrBar(){
        //this._card_attr_list = [];
        let cardAttrLen = this._card_attr_list.length;
        let cardTab = tab.Data.CardTableByID.getValue(this._card_static_id);
        if(isValidObj(cardTab)){
            let idx = kOneNumber;
            for(let attr of cardTab.AttrList){
                //let cell = await LoadPreNode("prefab/CardAttrItem", CardAttrItem);
                let cell = (idx - kOneNumber < cardAttrLen) ? this._card_attr_list[idx - kOneNumber] : null;
                if (isValidObj(cell)){
                    cell.setCardAttrData(   attr, 
                                            CardDisplayType.CARD_DISPLAY_TYPE_ATTR, 
                                            this._card_static_id, 
                                            this._card_level, 
                                            kZeroNumber, 
                                            kOneNumber, 
                                            idx++);
                    //this.node_attr_container.addChild(cell.node);
                    //this._card_attr_list.push(cell);
                }//end of isValidObj(cell)
            }//end of for(cardTab.AttrList)

            this.node_attr_container.getComponent(cc.Layout).updateLayout();
        }//end of isValidObj(cardTab)
    }

    /**
     * Author: WangZhen
     * Description: 重置卡牌数据【等级， id，数量】
     */
    private resetCardData(id?: number, lv?: number, count?: number){
        let item                   = Role.Instance.RoleItemAtrr.getItemByUUID(this._card_uuid);
        let bValidObj              = isValidObj(item);
        this._card_static_id       = ("undefined" == typeof(id))  ? (bValidObj ? item.staticId : id) : id;
        this._card_level           = ("undefined" == typeof(lv))  ? (bValidObj ? item.level    : lv) : lv;
        //this._own_card_piece_count = ("undefined" == typeof(count)) ? (bValidObj ? item.count    : count) : count;
    }

    /**
     * Author: WangZhen
     * Description: 刷新整体界面
     */
    private refreshPage(){
        let itemTab:tab.ItemTable = tab.Data.ItemTableByID.getValue(this._card_static_id);
        if(!isValidObj(itemTab)){
            return;
        }

        let cardTab:tab.CardTable = tab.Data.CardTableByID.getValue(this._card_static_id);
        if(!isValidObj(cardTab)){
            return;
        }
        
        //this.lbl_description.string = cardTab.Describe;
        this.rich_txt_description.string = cardTab.Describe;
        
        let cardUpLevelTab:tab.CardUpLevelTable = tab.Data.CardUpLevelTableByQuality.getValue(cardTab.Quality);
        if(isValidObj(cardUpLevelTab)){
            this._card_extra_level = cardUpLevelTab.ExtraAddLv;
            if( this._card_level > kZeroNumber)this.lbl_card_level.string = `${this._card_level + cardUpLevelTab.ExtraAddLv}`;
        }
        else{
            if( this._card_level > kZeroNumber)this.lbl_card_level.string = `${this._card_level}`;
        }

        this.setCardSpine();
        this.setCardNameAndQuality(itemTab.Name, itemTab.Quality, cardTab.AttrTypeDes, itemTab.Icon);
        this.refreshUplvInfo(false);
        this.refreshUplvBtn();
    }

    /**
     * Author: WangZhen
     * Description: 刷新升级页面信息
     * Date: 2021/1/11
     */
    private refreshUplvInfo(bUplvInfo: boolean = false){
        let itemTab:tab.ItemTable = tab.Data.ItemTableByID.getValue(this._card_static_id);
        if(!isValidObj(itemTab)){
            return;
        }

        this.setCardUpLvData(itemTab.Quality, bUplvInfo);
    }

    /**
     * Author: WangZhen
     * Description: 设置卡牌升级数据
     * Date: 2020/12/15
     * @param cardQuality 卡牌品质
     */
    private setCardUpLvData(cardQuality: number, bUplvInfo: boolean = false){
        let upLvTab = tab.Data.CardUpLevelTableByQuality.getValue(cardQuality);
        if (isValidObj(upLvTab)){
            let cardInfo = Role.Instance.RoleItemAtrr.getItemByStaticID(this._card_static_id);
            if(!isValidObj(cardInfo)){
                this._uplv_btn_state                    = UplvBtnState.PIECE_NOT_ENOUGH;
                this.node_top_btn_function.active       = false;
                this.prog_bar_uplv.node.active          = false;
                this.prog_bar_uplv_info.node.active     = false;

                this.setUplvArrowAndBarFullVisible(false);
                this.setUseBtnDisplay(false);
                return;
            }

            this.setUseBtnDisplay(true);
            let ownCount = isValidObj(cardInfo)   ? cardInfo.count          : kOneNumber;
            ownCount     = ownCount > kZeroNumber ? (ownCount - kOneNumber) : ownCount; //拥有数量必须减掉自身【先前的设计缺陷】
            let cardLv   = isValidObj(cardInfo)   ? cardInfo.level          : kZeroNumber;
            let tempArr  = upLvTab.Count;
            let idx      = kZeroNumber;
            while((idx   = tempArr.indexOf(kZeroNumber, kOneNumber)) > kNegativeOneNumber){
                if (idx  > kNegativeOneNumber) {
                    tempArr.splice(idx, kOneNumber);
                }
            }

            if (cardInfo.level >= tempArr.length){
                this.lbl_cost_gold.string               = `${upLvTab.GoldCount[cardLv - kOneNumber]}`;
                this._uplv_btn_state                    = UplvBtnState.MAX_LEVEL;

                this.setProgressExpValue(cardInfo.count - kOneNumber, tempArr[tempArr.length - kOneNumber]);
                this.setProgressBarValue(kOneNumber, kOneNumber);
                this.setUplvArrowAndBarFullVisible(false);
                this.playUplvAnim(false, bUplvInfo);
            }else{
                let nextCount                           = tempArr[cardLv];
                this._uplv_btn_state                    = (ownCount < nextCount) ?  
                                                            UplvBtnState.PIECE_NOT_ENOUGH : 
                                                            (Role.Instance.RoleData.gold < upLvTab.GoldCount[cardLv] ? 
                                                            UplvBtnState.GOLD_NOT_ENOUGH : 
                                                            UplvBtnState.CAN_UP_LEVEL);
                this.lbl_cost_gold.string               = `${upLvTab.GoldCount[cardLv]}`;
                this.lbl_cost_gold.node.color           = (Role.Instance.RoleData.gold >= upLvTab.GoldCount[cardLv]) ? cc.Color.WHITE : cc.Color.RED;

                this.setProgressBarValue(ownCount, nextCount);
                this.setProgressExpValue(ownCount, nextCount);
                this.setUplvArrowAndBarFullVisible(ownCount >= nextCount);
                this.playUplvAnim(ownCount                  >= nextCount, bUplvInfo);
            }
        }
    }
    
    /**
     * Author: WangZhen 
     * Description: 设置升级箭头和进度bar可见性
     * Date: 2021/1/12
     * @param bVisible 
     */
    private setUplvArrowAndBarFullVisible(bVisible: boolean){
        this.spr_uplv_arrow.node.active         = bVisible;
        this.spr_not_up_arrow.node.active       = !bVisible;
        this.spr_uplv_arrow_info.node.active    = bVisible;
        this.spr_not_up_arrow_info.node.active  = !bVisible;
        this.spr_bar_full.node.active           = bVisible;
        this.spr_bar_full_uplv_info.node.active = bVisible;
    }

    /**
     * Author: WangZhen 
     * Description: 设置进度条进度
     * Date: 2021/1/12
     * @param ownCount
     * @param totalCount
     */
    private setProgressBarValue(ownCount: number, totalCount: number){
        this.prog_bar_uplv.progress       = ownCount / totalCount;
        this.prog_bar_uplv_info.progress  = ownCount / totalCount;
    }

    /**
     * Author: WangZhen 
     * Description: 设置进度条数值
     * Date: 2021/1/12
     * @param ownCount
     * @param needCount
     */
    private setProgressExpValue(ownCount: number, needCount: number){
        this.lbl_attr_value.string            = `${ownCount}/${needCount}`;
        this.lbl_attr_value_uplv_info.string  = `${ownCount}/${needCount}`;
    }

    /**
     * Author: WangZhen
     * Description: 播放可以升级动画
     * Date: 2020/12/16
     */
    private playUplvAnim(bPlay: boolean, bUplvInfo: boolean = false){
        /*if(!bUplvInfo){
            if(!this.spr_uplv_arrow.node.active){
                return;
            }
            
            let animNode = this.spr_uplv_arrow.getComponent(cc.Animation);
            if(animNode){
                bPlay ? animNode.play("card_detail_uplv") : animNode.stop("card_detail_uplv");
            }
            return;
        }

        if(!this.spr_uplv_arrow_info.node.active){
            return;
        }
        
        let animNode = this.spr_uplv_arrow_info.getComponent(cc.Animation);
        if(animNode){
            bPlay ? animNode.play("card_detail_uplv") : animNode.stop("card_detail_uplv");
        }*/
    }

    /**
     * Author: WangZhen
     * Description: 刷新升级按钮状态
     * Date: 2020/12/16
     */
    private refreshUplvBtn(){
        if(CardNodeState.CARD_NODE_STATE_UNOWN == this._card_state){
            this.btn_uplv.node.active  = false;
            this.btn_uplv.interactable = false;
            return;
        }

        if(CardDisplayType.CARD_DISPLAY_TYPE_LEVELUP == this._display_type){
            this.btn_uplv.node.active  = (UplvBtnState.CAN_UP_LEVEL == this._uplv_btn_state);
            this.btn_uplv.interactable = (UplvBtnState.CAN_UP_LEVEL == this._uplv_btn_state);
            return;
        }

        switch(this._uplv_btn_state){
            case UplvBtnState.CAN_UP_LEVEL:
            case UplvBtnState.GOLD_NOT_ENOUGH:
            case UplvBtnState.PIECE_NOT_ENOUGH:
                this.btn_uplv.node.active  = true;
                this.btn_uplv.interactable = true; 
                break;

            case UplvBtnState.MAX_LEVEL:
            //case UplvBtnState.PIECE_NOT_ENOUGH:
                this.btn_uplv.node.active  = false;
                this.btn_uplv.interactable = false;
                break;
        }

        if( UplvBtnState.GOLD_NOT_ENOUGH  == this._uplv_btn_state || 
            UplvBtnState.MAX_LEVEL        == this._uplv_btn_state || 
            UplvBtnState.PIECE_NOT_ENOUGH == this._uplv_btn_state){
            //升级按钮着色器置灰
            if(this._spr_btn_mat_arr.length > kOneNumber){
                this.spr_btn_uplv_bg.setMaterial(kZeroNumber, this._spr_btn_mat_arr[MaterailState.MATERIAL_STATE_GRAY]);
                this.spr_gold_icon.setMaterial(kZeroNumber, this._spr_btn_mat_arr[MaterailState.MATERIAL_STATE_GRAY]);
            }
        }else{
            if(this._spr_btn_mat_arr.length > kOneNumber){
                this.spr_btn_uplv_bg.setMaterial(kZeroNumber, this._spr_btn_mat_arr[MaterailState.MATERIAL_STATE_NORMAL]);
                this.spr_gold_icon.setMaterial(kZeroNumber, this._spr_btn_mat_arr[MaterailState.MATERIAL_STATE_NORMAL]);
            }
        }

        this.lbl_uplv_tip.node.active      = this._uplv_btn_state == UplvBtnState.CAN_UP_LEVEL;
        this.lbl_uplv_tip_gray.node.active = this._uplv_btn_state != UplvBtnState.CAN_UP_LEVEL;
    }

    /**
     * Author: WangZhen
     * Description: 刷新升级文本
     * Date: 2021/1/7
     */
    private refreshCurLvAndNextLv(){
        let levelVal               = this._card_level + this._card_extra_level;
        this.lbl_curlv.string      = `${levelVal - kOneNumber}`;
        this.lbl_card_level.string = `${levelVal}`;
        this.lbl_nextlv.string     = `${levelVal}`;
    }

    /**
     * Author: WangZhen
     * Description: 检测能不能升级，不能升级给与提示
     * Date: 2020/12/16
     */
    private clickUplvTips():boolean{
        (UplvBtnState.PIECE_NOT_ENOUGH == this._uplv_btn_state) && ShowTips("CardPieceNotEnough");
        (UplvBtnState.GOLD_NOT_ENOUGH  == this._uplv_btn_state) && this.doGoldNotEnoughEvent();
        (UplvBtnState.MAX_LEVEL        == this._uplv_btn_state) && ShowTips("ReachMaxLevel");
        return (UplvBtnState.CAN_UP_LEVEL != this._uplv_btn_state);
    }

    /**
     * Author: WangZhen
     * Description: 处理金币不足事件
     * Date: 2021/1/11
     */
    private doGoldNotEnoughEvent(){
        showPopLayerV2("prefab/JumpShop", JumpShop);
    }
    /**
     * Author: WangZhen
     * Description: 设置卡牌的立绘spine
     * Date: 2020/12/11
     */
    private setCardSpine(){
        let cardTab = tab.Data.CardTableByID.getValue(this._card_static_id);
        if (!isValidObj(cardTab) || kZeroNumber == cardTab.PortraitSpineID){
            return;
        }

        this.node_portrait_spine.removeAllChildren(true);
        let thisTemp = this;
        CreateSpine(cardTab.PortraitSpineID).then(skel=>{
            thisTemp.node_portrait_spine.addChild(skel.node);
            skel.setAnimation(0, "idle", true);
        });
    }

    /**
     * Author: WangZhen
     * Description: 设置卡牌的名称和品质
     * Date: 2020/12/11
     */
    async setCardNameAndQuality(cardName: string, cardQuality: number, cardDes: string, icon: string){
        this.lbl_card_name.string      = cardName;
        this.lbl_uplv_card_name.string = cardName;
        let qualityTab                 = tab.Data.QualityTableByQuality.getValue(cardQuality);
        if(!isValidObj(qualityTab)){
           return;
        }

        this.lbl_card_quality.string       = qualityTab.QualityDescrible;
        this.lbl_card_name.node.color      = cc.color(qualityTab.ColorRGB[kZeroNumber], qualityTab.ColorRGB[kOneNumber], qualityTab.ColorRGB[kTwoNumber]);
        this.lbl_uplv_card_name.node.color = cc.color(qualityTab.ColorRGB[kZeroNumber], qualityTab.ColorRGB[kOneNumber], qualityTab.ColorRGB[kTwoNumber]);
        this.lbl_card_quality.node.color   = cc.color(qualityTab.ColorRGB[kZeroNumber], qualityTab.ColorRGB[kOneNumber], qualityTab.ColorRGB[kTwoNumber]);
        let sf = await LoadResAsync(qualityTab.QualityFrame, cc.SpriteFrame);
        if(sf) {
            if( this.spr_quailty_frame){
                this.spr_quailty_frame.spriteFrame = sf;
            }
        }
        
        sf = await LoadResAsync(icon, cc.SpriteFrame);
        if(sf) {
            if(this.spr_portrait_quality){
                this.spr_portrait_quality.spriteFrame = sf;
            }
        }

        sf = await LoadResAsync(qualityTab.QualityBG, cc.SpriteFrame);
        if(sf) {
            if(this.spr_portrait_bg){
                this.spr_portrait_bg.spriteFrame = sf;
            }
        }

        this.lbl_attr_title.string = cardDes;
    }

    /**
     * Author: WangZhen
     * Description: 隐藏所有页面元素，卡牌立绘除外
     * Date: 2021/1/7
     */
    private hideAllElementsExcludeSpine(){
        this.btn_back.node.active           = false;
        this.node_top_btn_function.active   = false;
        this.node_uplv_info.active          = false;
        this.node_attr_node.active          = false;
        this.node_bottom_btn_layout.active  = false;
        this.node_synthesis_strength.active = false;
        this.node_level_up_reward.active    = false;
        this.btn_use.node.active            = false;
    }

    /**
     * Author: WangZhen
     * Description: 显示升级页面元素
     * Date: 2021/1/7
     */
    private showUpLevelElements(){
        this.node_uplv_info.active          = true;
        this.node_attr_node.active          = true;
        this.spr_attr_bg.node.active        = false;
        this.node_card_info_layout.active   = false;
        this.btn_use.node.active            = false;
        this.node_synthesis_strength.active = false;
        this.node_level_up_reward.active    = false;
        //this.btn_exit_uplv.node.active      = true;
        //this.node_bottom_btn_layout.active  = true;
    }

    /**
     * Author: WangZhen
     * Description: 显示正常页面元素
     * Date: 2021/1/7
     */
    private showNormalElements(){
        this.btn_back.node.active           = true;
        this.node_top_btn_function.active   = true;
        this.node_uplv_info.active          = false;
        this.spr_attr_bg.node.active        = true;
        this.node_card_info_layout.active   = true;
        this.btn_exit_uplv.node.active      = false;
        this.node_synthesis_strength.active = true;
        this.node_level_up_reward.active    = true;
        this._display_type                  = CardDisplayType.CARD_DISPLAY_TYPE_ATTR;
        this.setUseBtnDisplay(true);
        this.changeAllAttrDisplayType(this._display_type);
        this.resumeAllAttrBarVisible();
        this.refreshUplvBtn();
        this.resetStrengthAndSynthesisBtn();
    }

    private setUseBtnDisplay(bDisplay: boolean){
        if(CardNodeState.CARD_NODE_STATE_OWN != this._card_state){
            this.btn_use.node.active = false;
            return;
        }

        if(CardDisplayType.CARD_DISPLAY_TYPE_LEVELUP == this._display_type){return;}
        this.btn_use.node.active = bDisplay;
    }

    /**
     * Author: WangZheng
     * Description: 切换强化升星按钮状态
     * Create: 2021/1/7
     */
    private async switchStarUplvBtnState(){
        this._current_star_uplv += kOneNumber;
        this._current_star_uplv = (this._current_star_uplv > this._card_strength_maxlv) ? 
                                    kZeroNumber : this._current_star_uplv;
        let iconData: tab.CardStrengthLvTable = tab.Data.CardStrengthLvTableByLevel.getValue(this._current_star_uplv);
        if(!isValidObj(iconData)){
            return;
        }

        let sf = await LoadResAsync(iconData.IconPath, cc.SpriteFrame);
        if(sf) {
            this.spr_star_lv.spriteFrame = sf;
        }
    }

    /**
     * Author: WangZheng
     * Description: 切换合成按钮状态
     * Create: 2021/1/7
     */
    private async switchSynthesisBtnState(){
        this._current_synthesis_lv += kOneNumber;
        this._current_synthesis_lv = (this._current_synthesis_lv > this._card_synthesis_maxlv) ? 
                                        kOneNumber : this._current_synthesis_lv;
        let iconData: tab.CardStrengthLvTable = tab.Data.CardSynthesisLvTableByLevel.getValue(this._current_synthesis_lv);
        if(!isValidObj(iconData)){
            return;
        }

        let sf = await LoadResAsync(iconData.IconPath, cc.SpriteFrame);
        if(sf) {
            this.spr_synthesis_lv.spriteFrame = sf;
        }
    }

    /**
     * Author: WangZhen
     * Description: 播放升级成功动画
     * Date: 2020/12/17
     */
    private playUplvSuccessAnim(){
        this.node_uplv_spine.removeAllChildren(true);
        let thisTemp = this;
        CreateSpine(tab.Data.ConfigTable[0].UplvSpineId).then(skel=>{
            thisTemp.node_uplv_spine.addChild(skel.node);
            skel.setAnimation(0, "idle", false);
            skel.addAnimation(0, "idle2", true);
            skel.setCompleteListener(()=>{
                skel.setCompleteListener(null);
                //this.node_uplv_spine.removeAllChildren(true);
            });

            thisTemp.scheduleOnce(()=>{
                this.showUpLevelElements();
            }, kOneNumber / kTwoNumber);
            

            thisTemp.scheduleOnce(()=>
            {
                thisTemp.playAttrBarEffectOrder(kZeroNumber);
            }, kOneNumber);
        });
    }

    /**
     * Author: WangZhen
     * Description: 统计属性值有提升的属性条
     * Date: 2021/1/7
     */
    private statAttrValuePromoteBar(){
        let cardItem = Role.Instance.RoleItemAtrr.getItemByUUID(this._card_uuid);
        let curLv    = !isValidObj(cardItem) ? kZeroNumber : cardItem.level;
        for(let attr of this._card_attr_list){
            attr.statAttrValuePromoteBar(curLv);
        }
    }

    /**
     * Author: WangZhen
     * Description: 改变所有属性条显示类型
     * Date: 2021/1/7
     * @param displayType    显示类型
     */
    private changeAllAttrDisplayType(displayType: CardDisplayType){
        for(let attr of this._card_attr_list){
            attr.changeAttrDisplayType(displayType);
        }
    }

    /**
     * Author: WangZhen
     * Description: 依次播放属性条特效
     * Date: 2021/1/8
     * @param idx 属性条数值下标
     */
    private playAttrBarEffectOrder(idx: number){
        if(idx >= this._card_attr_list.length){
            this.btn_exit_uplv.node.active      = true;
            this.node_bottom_btn_layout.active  = true;
            return;
        }

        this._card_attr_list[idx].refreshAttrData();
        let thisTemp = this;
        this.scheduleOnce(()=>{
            thisTemp.playAttrBarEffectOrder(++idx);
        }, kOneNumber / kTenNumber);
    }

    /**
     * Author: WangZhen
     * Description: 恢复所有属性条的可见性
     * Date: 2021/1/8
     */
    private resumeAllAttrBarVisible(){
        for(let attr of this._card_attr_list){
            attr.resumeNodeVisible();
        }
    }

    /**
     * Author: WangZhen
     * Description: 隐藏或者显示底部功能按钮【升级、使用】
     * Date: 2020/12/17
     * @param bHide 
     */
    public hideBottomFuncBtn(bHide: boolean){
        this.node_bottom_btn_layout.active = bHide;
        this.btn_use.node.active           = bHide;
    }

/*************************************************************************所有按钮点击事件区域 *********************************************************************/
    /**
     * Author: WangZhen
     * Description: 使用按钮事件
     * Date: 2020/12/17
     */
    public onClickUseCard(){
        if(this._card_uuid.length > kZeroNumber){
            MainScene.Instance.selectCard(this._card_uuid);
            this.setVisible(false);
        }
    }

    /**
     * Author: WangZhen
     * Description: 设置立绘事件
     * Date: 2020/12/17
     */
    public onClickUseLiHui(){
        let msg         = new proto.Msg_ChangeIndexCardReq();
        msg.indexCardId = this._card_static_id;
        Net.Send(proto.Ptl.ChangeIndexCardReq, msg);
    }

    /**
     * Author: WangZhen
     * Description: 关闭按钮事件
     * Date: 2020/12/17
     */
    public onClickClose() {
        this.setVisible(false);
    }

    /**
     * Author: WangZhen
     * Description: 隐藏所有元素除立绘外事件
     * Date: 2020/12/17
     */
    public onClickHideUI(){
        this.node_attr_node.active           = !this.node_attr_node.active;
        this.node_bottom_btn_layout.active   = !this.node_bottom_btn_layout.active;
        this.node_synthesis_strength.active  = !this.node_synthesis_strength.active;
        this.node_level_up_reward.active     = !this.node_level_up_reward.active;
        if(this._card_state != CardNodeState.CARD_NODE_STATE_IN_TEAM){
            this.btn_use.node.active         = !this.btn_use.node.active
        }else{
            this.btn_use.node.active         = false;
        }
    }

    /**
     * Author: WangZhen
     * Description: 升级按钮事件
     * Date: 2020/12/17
     */
    public onClickUpLv(){
        if(this.clickUplvTips()){
            return;
        }

        let msg      = new proto.Msg_CardLevelUpReq();
        msg.cardUuid = this._card_uuid;
        Net.Send(proto.Ptl.CardLevelUpReq, msg);
    }

    /**
     * Author: WangZhen
     * Description: 退出升级页面
     * Date: 2021/1/6
     */
    private onExitUpLv(){
        this.showNormalElements();
        this.node_uplv_spine.removeAllChildren(true);
    }

    /**
     * Author: WangZhen
     * Description: 强化升星
     * Date: 2021/1/7
     */
    private onClickStrength(){
        this.switchStarUplvBtnState();
        Net.pushLoaclMessage(LOCAL_MESSAGE.LocalMsg_UpdateCardStrengthLv, {displayState: CardDisplayType.CARD_DISPLAY_TYPE_STAR_UPLV, curLv: this._current_star_uplv});
    }

    /**
     * Author: WangZhen
     * Description: 合成
     * Date: 2021/1/7
     */
    private onClickSynthesis(){
        this.switchSynthesisBtnState();
        Net.pushLoaclMessage(LOCAL_MESSAGE.LocalMsg_UpdateCardSynthesisLv, {displayState: CardDisplayType.CARD_DISPLAY_TYPE_SYNTHESIS, curLv: this._current_synthesis_lv});
    }

    /**
     * Author: WangZhen
     * Description: 重置合成和升星按钮
     * Date: 2021/1/14
     */
    private resetStrengthAndSynthesisBtn(){
        if(this._current_star_uplv != kZeroNumber){
            this._current_star_uplv = kNegativeOneNumber;
            this.switchStarUplvBtnState();
        }
       
        if(this._current_synthesis_lv != kOneNumber){
            this._current_synthesis_lv = kZeroNumber;
            this.switchSynthesisBtnState();
        }

        Net.pushLoaclMessage(LOCAL_MESSAGE.LocalMsg_ResetCardState, null);
    }
}
