import Model from './Model'
export default class ConfigMgr{
    private mapDt:Map<string, Model> = new Map();
    private static _instance:ConfigMgr = null;
    static getInstance(){
        if(!this._instance){
            this._instance = new ConfigMgr();
        }
        return this._instance;
    }
    setData(key:string, data:Model){
        if (key.length <= 0 || !data) {
            return;
        }
        this.mapDt.set(key, data);
    }

    removeData(key:string){
        this.mapDt.delete(key);
    }

    getData(key:string){
        return this.mapDt.get(key);
    }
}