import ResMgr from '../ResMgr'

const {ccclass, property} = cc._decorator;

@ccclass
export default class Blast extends cc.Component {
    init(info:any){
        let animCom = this.getComponent(cc.Animation);
        if('center' === info.dir){
            animCom.play('blast');
        }
        else
        {
            let nameObj = {up:'blastU_0_0', down:'blastD_0_0', left:'blastL_0_0', right:'blastR_0_0'};
            let spriteName = nameObj[info.dir];
            let spriteFrame = ResMgr.getInstance().getSpriteFrame(spriteName, 'blast.plist');
            let spriteCom = this.getComponent(cc.Sprite);
            spriteCom.spriteFrame = spriteFrame;
        }

        this.scheduleOnce(()=>{
            this.node.destroy();
        }, 0.3);
    }
}
