import ModuleBase from '../Module/ModuleBase'
import TiledMapCtrl from './TiledMapCtrl'
import Blast from './Blast'
import ResMgr from '../ResMgr'
export default class BlastMgr extends ModuleBase{
    private blastParent:cc.Node = null;
    onInit(){
        this.blastParent = cc.find('Game/tileMap');
    }
    addBlastByInfo(arrInfo:any [], param1:any, param2:any){
        let tiledMapCtrl = this.getModule('TiledMapCtrl') as TiledMapCtrl;
        for(let info of arrInfo){
            let prefab = ResMgr.getInstance().getPrefab('blast');
            let blastN = cc.instantiate(prefab);
            blastN.parent = this.blastParent;
            let pos = tiledMapCtrl.getPosByTile(info.tile);
            blastN.x = pos.x;
            blastN.y = pos.y;

            let blastJs = blastN.getComponent(Blast);
            blastJs.init(info);
        }
    }
    // handleMsg(strMsg:string, data:any){
    //     if('aaa' === strMsg){
    //         this.addBlastByInfo(data);
    //     }
    // }
}
