import ModuleBase from '../Module/ModuleBase'
import TiledMapCtrl from './TiledMapCtrl'
import Bubble from './Bubble'
import ResMgr from '../ResMgr'
export default class BubbleMgr extends ModuleBase{
    private _bubbleParent:cc.Node = null;
    private _arrBubble:Bubble [] = [];
    private _arrBlastInfo:any[] = [];
    //存放可以被炸毁的障碍物的格子坐标
    private _arrTile:cc.Vec2 [] = [];
    onInit(){
        this._bubbleParent = cc.find('Game/tileMap');
    }
    addBubble(params:any){
        //判断tile位置是否有泡泡
        if(this.getBubbleByTile(params.tile)){
            return;
        }
        //判断泡泡数量是否达到上限
        let num = this._getBubbleSizeByOwner(params.owner);
        if(num >= params.bubbleNum){
            return;
        }
        let prefab = ResMgr.getInstance().getPrefab('bubble');
        let bubbleN = cc.instantiate(prefab);
        let tiledMapCtrl = this.getModule('TiledMapCtrl') as TiledMapCtrl;
        bubbleN.parent = this._bubbleParent;
        let pos = tiledMapCtrl.getPosByTile(params.tile);
        bubbleN.x = pos.x;
        bubbleN.y = pos.y;
        let bubbleJs = bubbleN.getComponent('Bubble');
        bubbleJs.init(params.tile, params.power, params.owner);
        this._arrBubble.push(bubbleJs);
    }

    _removeBubble(bubble:Bubble){
        let index = this._arrBubble.indexOf(bubble);
        this._arrBubble.splice(index, 1);
        bubble.node.destroy();
    }
    toBomb(bubble:Bubble){
        this._arrBlastInfo.length  = 0;
        this._arrTile.length  = 0;
        this.bomb(bubble);
        //处理水花的创建和格子的移除
        //console.log(this._arrBlastInfo);
        //this.sendMsg('BlastMgr', 'aaa', this._arrBlastInfo);
        this.sendMsg('BlastMgr', 'addBlastByInfo', this._arrBlastInfo, '苍老师', '波老师');
        this.sendMsg('TiledMapCtrl', 'removeTiles', this._arrTile);
        //this._arrBlastInfo = [];
        //console.log(this._arrTile);
    }
    bomb(bubble:Bubble){
        let arrDir:cc.Vec2 [] = [cc.v2(0,1), cc.v2(0,-1), cc.v2(-1,0), cc.v2(1,0)];
        let arrDirName = ['up', 'down','left','right']
        let bubbleTile = bubble.tile;
        let power = bubble.power;
        this._addBlastInfo({tile:bubbleTile, dir:'center'});
        //销毁
        this._removeBubble(bubble);

        let tiledMapCtrl = <TiledMapCtrl>this.getModule('TiledMapCtrl');
        for(let i = 0; i < arrDir.length; i++){
            let dir = arrDir[i];
            for(let j = 1; j <= power; j++){
                let newTile = cc.v2(bubbleTile.x + dir.x*j, bubbleTile.y - dir.y*j);
                //越界
                if(tiledMapCtrl.checkOutOf(newTile)){
                    break;
                }
                let tileInfo = tiledMapCtrl.getTiledInfo(newTile);
                if(!tileInfo){
                    this._addBlastInfo({tile:newTile, dir:arrDirName[i]});
                    //是否有其他泡泡
                    let newBubble = this.getBubbleByTile(newTile);
                    if(newBubble){
                        this.bomb(newBubble);
                    }
                }
                if(tileInfo){
                    if(tileInfo.blast){
                        this._addTile(newTile);
                    }
                    if(tileInfo.colli){
                        break;
                    } 
                }
            }
            
        }
    }

    getBubbleByTile(tile:cc.Vec2){
        for(let bubble of this._arrBubble){
            if(bubble.tile.equals(tile)){
                return bubble;
            }
        }
        return null;
    }
    _addBlastInfo(tileInfo:any){
        for(let info of this._arrBlastInfo){
            if(info.tile.equals(tileInfo.tile)){
                if('center' === tileInfo.dir){
                    info.dir = 'center';
                }
                return;
            }
        }
        this._arrBlastInfo.push(tileInfo);
    }
    //添加可以被炸毁的障碍物的格子
    _addTile(tile:cc.Vec2){
        for(let temp of this._arrTile){
            if(temp.equals(tile)){
                return;
            }
        }
        this._arrTile.push(tile);
    }
    //统计owner的泡泡数
    _getBubbleSizeByOwner(owner:any){
        let size = 0;
        for(let bubble of this._arrBubble){
            if(bubble.owner === owner){
                size++;
            }
        }
        return size;
    }
}