const { ccclass, property } = cc._decorator;
import GameData from '../GameData';
import ConfigMgr from '../ConfigMgr';
import ResMgr from '../ResMgr';
import ModuleMgr from '../Module/ModuleMgr';
import TiledMapCtrl from './TiledMapCtrl';
import PlayerMgr from './PlayerMgr';
import BubbleMgr from './BubbleMgr';
import BlastMgr from './BlastMgr';
import ItemMgr from './ItemMgr';
// import AModule from '../Module/AMoulde'
// import BModule from '../Module/BMoudle'
@ccclass
export default class GameScene extends cc.Component {

    // @property(cc.TiledMap)
    // tiledMap: cc.TiledMap = null;

    // LIFE-CYCLE CALLBACKS:

    // onLoad () {}

    start() {
        // //获取选择的关卡id
        // let levelID = GameData.getInstance().getData('LevelID');
        // //通过关卡ID找ConfigMgr获取关卡数据
        // let levelDt = ConfigMgr.getInstance().getData('LevelDt').getDataByID(levelID);
        // //通过关卡数据的地图名字找ResMgr拿到TiledMap资源
        // this.tiledMap.tmxAsset = ResMgr.getInstance().getTiledMap(levelDt.tiledMap);

        let moduleMgr = ModuleMgr.getInstance();
        // moduleMgr.register('AModule', new AModule());
        // moduleMgr.register('BModule', new BModule());
        this._registerModule();

        moduleMgr.onInit();
        moduleMgr.onLateInit();
        let touchNode = this.node.getChildByName("TouchNode");
        touchNode.on(cc.Node.EventType.TOUCH_START, this.onTouchStart, this);
    }

    update(dt) {
        ModuleMgr.getInstance().onUpdate(dt);
    }

    lateUpdate(dt) {
        ModuleMgr.getInstance().onLateUpdate(dt);
    }

    onDestroy() {
        ModuleMgr.getInstance().onRelease();
    }

    _registerModule() {
        let moduleMgr = ModuleMgr.getInstance();

        let arrKey = ['TiledMapCtrl', 'PlayerMgr', 'BubbleMgr', 'BlastMgr', 'ItemMgr'];
        let arrClass = [TiledMapCtrl, PlayerMgr, BubbleMgr, BlastMgr, ItemMgr];
        for (let i = 0; i < arrKey.length; i++) {
            let obj = new arrClass[i];
            moduleMgr.register(arrKey[i], obj);
        }
    }

    private onTouchStart(event: cc.Touch) {
        let tileMapCtrl = <TiledMapCtrl>ModuleMgr.getInstance().getModule('TiledMapCtrl');
        let v2TiledPos = tileMapCtrl.getTiledByPos(event.getLocation());
        let bTiled = tileMapCtrl.IsExistTiled(v2TiledPos);
        console.log("当前是否存在地图块", bTiled, v2TiledPos.x, v2TiledPos.y);
    }
}
