const { ccclass, property } = cc._decorator;
import MoveCtrl from './MoveCtrl';
import StateCtrl from './StateCtrl';
import TiledMapCtrl from '../TiledMapCtrl';
import BubbleMgr from '../BubbleMgr';
import ModuleMgr from '../../Module/ModuleMgr';
import Item from '../Item';
@ccclass
export default class Player extends cc.Component {
    // LIFE-CYCLE CALLBACKS:
    public keyDt: any = null;
    public keyCode: any = null;
    private roleDt: any = null;
    private bubbleNum: number = 0;
    private speed: number = 0;
    private power: number = 0;
    public id: number = 0;
    private dir: cc.Vec2 = cc.v2(0, 0);
    private moveCtrl: MoveCtrl = null;
    private stateCtrl: StateCtrl = null;
    init(roleDt: any, keyDt: any) {
        this.keyDt = keyDt;
        this.keyCode = keyDt.codes;
        this.roleDt = roleDt;
        this.bubbleNum = roleDt.bubbleNum;
        this.speed = roleDt.speed;
        this.power = roleDt.power;
        this.id = roleDt.id;

        this.moveCtrl = new MoveCtrl(this);
        this.stateCtrl = new StateCtrl(this);
        this.refreshZIndex();
    }
    eatItem(item: Item) {
        if ('addAttr' === item.config.type) {
            let key = item.config.attrKey;
            let maxAttr = key + 'Max';
            if (item.config.value) {
                this[key] += item.config.value;
                if (this[key] > this.roleDt[maxAttr]) {
                    this[key] = this.roleDt[maxAttr];
                }
            }
            else {
                this[key] = this.roleDt[maxAttr];
            }
        }
        else if ('reverseDir' == item.config.type) {
            this.keyCode = this.keyDt.reverseCodes;
            this.unscheduleAllCallbacks();
            this.scheduleOnce(() => {
                this.keyCode = this.keyDt.codes;
            }, 2);
        }
    }
    onKeyDownEvent(eventName) {
        //console.log(this.id + ':' + eventName);
        if (eventName !== 'addBubble') {
            let dirObj = { runUp: cc.v2(0, 1), runDown: cc.v2(0, -1), runLeft: cc.v2(-1, 0), runRight: cc.v2(1, 0) };
            this.dir = dirObj[eventName];
            this.moveCtrl.velocity = this.dir.mul(this.speed);
            this.stateCtrl.changeState(eventName);
        }
    }
    onKeyUpEvent(eventName) {
        if ('addBubble' !== eventName) {
            this.moveCtrl.velocity.x = 0;
            this.moveCtrl.velocity.y = 0;
            this.stateCtrl.changeState('idle');
        }
        else {
            let bubbleMgr = ModuleMgr.getInstance().getModule('BubbleMgr') as BubbleMgr;

            let params = {
                tile: this.getTile(),
                power: this.power,
                bubbleNum: this.bubbleNum,
                owner: this
            };
            bubbleMgr.addBubble(params);
        }
    }

    getTile() {
        let tiledMapCtrl = ModuleMgr.getInstance().getModule('TiledMapCtrl') as TiledMapCtrl;
        let tile = tiledMapCtrl.getTiledByPos(cc.v2(this.node.x, this.node.y));
        return tile;
    }

    getCollicTile(dir: cc.Vec2) {
        let pos = this.node.position;
        let colliPos = cc.v2(pos.x, pos.y);

        colliPos.x += dir.x * this.node.width / 2;
        if (dir.y > 0) {
            colliPos.y += dir.y * this.node.height / 4;
        }
        else {
            colliPos.y += dir.y * this.node.height / 2;
        }

        let tiledMapCtrl = ModuleMgr.getInstance().getModule('TiledMapCtrl') as TiledMapCtrl;
        let collicTile = tiledMapCtrl.getTiledByPos(colliPos);
        return collicTile;
    }

    refreshZIndex() {
        let tiledMapCtrl = ModuleMgr.getInstance().getModule('TiledMapCtrl') as TiledMapCtrl;
        let tile = tiledMapCtrl.getTiledByPos(cc.v2(this.node.x, this.node.y));
        this.node.zIndex = 2 * tile.y + 1;
    }
    onUpdate(dt: number) {
        this.moveCtrl.onUpdate(dt);
    }
}
