import CtrlBase from './CtrlBase'
import Player from './Player'
import ResMgr from '../../ResMgr'
export default class StateCtrl extends CtrlBase{
    public state:string = 'none';
    public animCom:cc.Animation = null;
    public spriteCom:cc.Sprite = null;
    constructor(owner:Player){
        super(owner);
        this.animCom = this.owner.getComponent(cc.Animation);
        this.spriteCom = this.owner.getComponent(cc.Sprite);
    }

    changeState(state:string){
        if(this.state === state){
            return;
        }
        let preAnimName = this.state;
        this.state = state;
        this.animCom.stop();
        
        
        let animName = this.state;
        let index = (this.owner.id - 2000);
        if(this.state === 'idle'){
            preAnimName = ('runLeft' === preAnimName)?'runRight':preAnimName;
            animName = preAnimName + index + '_' + 0;
            this.spriteCom.spriteFrame = ResMgr.getInstance().getSpriteFrame(animName,'player.plist');
            return;
        }
        let scaleX = ('runLeft' === this.state)?-1:1;
        this.owner.node.scaleX = scaleX;
        animName = ('runLeft' === this.state)?'runRight':this.state;
        this.animCom.play(animName + index);
    }

    onUpdate(dt:number){
        
    }
}