import ModuleBase from '../Module/ModuleBase';
import GameData from '../GameData';
import ConfigMgr from '../ConfigMgr';
import ResMgr from '../ResMgr';
import TiledMapCtrl from './TiledMapCtrl';
import Player from './Player/Player';
export default class PlayerMgr extends ModuleBase {
    private arrPlayer: Player[] = [];
    onInit() {

    }
    onLateInit() {
        //

        this._initPlayer();
        this._initKeyEvent();
    }
    _initPlayer() {
        let tiledMapN = cc.find('Game/tileMap');
        let arrRoleID = GameData.getInstance().getData('RoleID');
        let configMgr = ConfigMgr.getInstance();
        let tiledMapCtrl = this.getModule('TiledMapCtrl') as TiledMapCtrl;
        let arrBirthPos = tiledMapCtrl.getBirthPos();
        let arrBirthIndex = [0, 1, 2, 3, 4, 5, 6, 7];
        for (let roleID of arrRoleID) {
            let roleConfig = configMgr.getData('RoleDt').getDataByID(roleID);
            let prefabName = roleConfig.prefab;
            let prefab = ResMgr.getInstance().getPrefab(prefabName);
            let roleN = cc.instantiate(prefab);
            roleN.parent = tiledMapN;
            let index = Math.floor(Math.random() * arrBirthIndex.length);
            let birthIndex = arrBirthIndex[index];
            let birthPos = arrBirthPos[birthIndex];
            arrBirthIndex.splice(index, 1);
            roleN.x = birthPos.x;
            roleN.y = birthPos.y;


            let keyDt = ConfigMgr.getInstance().getData('KeyCode').getDataByID(1001 + (roleID - 2001));
            let playerCom = roleN.getComponent('Player') as Player;
            playerCom.init(roleConfig, keyDt);
            this.arrPlayer.push(playerCom);
        }
    }
    _initKeyEvent() {
        cc.systemEvent.on(cc.SystemEvent.EventType.KEY_DOWN, this.onKeyDown, this);
        cc.systemEvent.on(cc.SystemEvent.EventType.KEY_UP, this.onKeyUp, this);
    }

    getPlayerByTile(tile: cc.Vec2) {
        let tileMapCtrl = <TiledMapCtrl>this.getModule('TiledMapCtrl');
        for (let player of this.arrPlayer) {
            let playerTile = tileMapCtrl.getTiledByPos(cc.v2(player.node.x, player.node.y));
            if (tile.equals(playerTile)) {
                return player;
            }
        }
        return null;
    }

    onKeyDown(event) {
        for (let i = 0; i < this.arrPlayer.length; i++) {
            //let keyDt = ConfigMgr.getInstance().getData('KeyCode').getDataByID(1001 + i);
            let player = this.arrPlayer[i];
            let eventName = player.keyCode[event.keyCode];
            if (eventName) {
                this.arrPlayer[i].onKeyDownEvent(eventName);
            }
        }
    }

    onKeyUp(event) {
        for (let i = 0; i < this.arrPlayer.length; i++) {
            let player = this.arrPlayer[i];
            let eventName = player.keyCode[event.keyCode];
            if (eventName) {
                this.arrPlayer[i].onKeyUpEvent(eventName);
            }
        }
    }

    onRelease() {
        cc.systemEvent.off(cc.SystemEvent.EventType.KEY_DOWN, this.onKeyDown, this);
        cc.systemEvent.off(cc.SystemEvent.EventType.KEY_UP, this.onKeyUp, this);
    }

    onUpdate(dt: number) {
        for (let player of this.arrPlayer) {
            player.onUpdate(dt);
        }
    }
}
