const { ccclass, property } = cc._decorator;

@ccclass
export default class SelfRole extends cc.Component {

    @property(cc.Node)
    arrArrow: cc.Node[] = [];

    @property(cc.Node)
    arrRoleN: cc.Node[] = [];
    arrRoleIndex: number[] = [0, 1];

    // LIFE-CYCLE CALLBACKS:

    onLoad() {
        cc.systemEvent.on(cc.SystemEvent.EventType.KEY_DOWN, this.onKeyDown, this);
        //cc.systemEvent.on(cc.SystemEvent.EventType.KEY_UP, this.onKeyUp, this);
    }

    start() {

    }
    onDestroy() {
        cc.systemEvent.off(cc.SystemEvent.EventType.KEY_DOWN, this.onKeyDown, this);
    }
    onKeyDown(event) {
        switch (event.keyCode) {
            case cc.macro.KEY.a:
                this.process(0, 1, -1);
                break;
            case cc.macro.KEY.d:
                this.process(0, 1, 1);
                break;
            case cc.macro.KEY.left:
                this.process(1, 0, -1);
                break;
            case cc.macro.KEY.right:
                this.process(1, 0, 1);
                break;
        }
        //console.log(event);
    }
    // onKeyUp(event){
    //     console.log(event);
    // }
    private process(selfRole: number, otherRole: number, dir: number) {
        //所有的索引     
        let arrIndex = [0, 1, 2, 3];
        //去除要处理的角色的索引
        arrIndex.splice(this.arrRoleIndex[otherRole], 1);
        //判断要处理角色的索引在可选索引中的位置
        let index = arrIndex.indexOf(this.arrRoleIndex[selfRole]);
        let nextIndex = (index + dir + arrIndex.length) % arrIndex.length;
        this.arrRoleIndex[selfRole] = arrIndex[nextIndex];
        this.arrArrow[selfRole].x = this.arrRoleN[arrIndex[nextIndex]].x;
    }
    getCurLevelID() {

    }
    // update (dt) {}
}
