const {ccclass, property} = cc._decorator;
import ConfigMgr from './ConfigMgr'
import Model from './Model'
import ResMgr from './ResMgr'
@ccclass
export default class NewClass extends cc.Component {
    @property(cc.ProgressBar)
    progreesBar:cc.ProgressBar = null;
    // onLoad () {}

    start () {
        cc.resources.loadDir('./', (finish:number, total:number, item: cc.AssetManager.RequestItem)=>{
            let percent = finish/total;
            this.progreesBar.progress = percent;
        }, (err, assets)=>{
            //console.log(assets);
            for(let asset of assets){
                if(asset instanceof cc.JsonAsset){
                    let model = new Model(asset.json)
                    ConfigMgr.getInstance().setData(asset.name, model);
                }
                else{
                    ResMgr.getInstance().addRes(asset.name, asset);
                }
            }
            cc.director.loadScene('LevelSel');
        })
    }

    // update (dt) {}
}
