import ModuleBase from './ModuleBase';

export default class ModuleMgr {
    private static _instance: ModuleMgr = null;
    static getInstance() {
        if (!this._instance) {
            this._instance = new ModuleMgr();
        }
        return this._instance;
    }
    private _mapModule: Map<string, ModuleBase> = new Map();
    onInit() {
        let arr = Array.from(this._mapModule.values());
        for (let myModule of arr) {
            if (myModule) {
                myModule.onInit();
            }
        }
    }
    onLateInit() {
        let arr = Array.from(this._mapModule.values());
        for (let myModule of arr) {
            if (myModule) {
                myModule.onLateInit();
            }
        }
    }
    onUpdate(dt: number) {
        let arr = Array.from(this._mapModule.values());
        for (let myModule of arr) {
            if (myModule) {
                myModule.onUpdate(dt);
            }
        }
    }
    onLateUpdate(dt: number) {
        let arr = Array.from(this._mapModule.values());
        for (let myModule of arr) {
            if (myModule) {
                myModule.onLateUpdate(dt);
            }
        }
    }
    onRelease() {
        let arr = Array.from(this._mapModule.values());
        for (let myModule of arr) {
            if (myModule) {
                myModule.onRelease();
            }
        }
    }
    //参数1:模块名
    //参数2:
    // sendMsg(moduleName:string, strMsg:string, data:any){
    //     let myModule = this._mapModule.get(moduleName);
    //     if(!myModule){
    //         return;
    //     }
    //     let func = myModule[strMsg];
    //     if(func){
    //         func.call(myModule, data);
    //     }
    //     else{
    //         myModule.handleMsg(strMsg, data);
    //     }
    // }

    sendMsg(moduleName: string, strMsg: string, ...rest) {
        let myModule = this._mapModule.get(moduleName);
        if (!myModule) {
            return;
        }
        let func = myModule[strMsg];
        //arguments

        if (func) {
            let params = [].slice.call(arguments, 2);
            func.apply(myModule, params);
        }
        else {
            let params = [].slice.call(arguments, 1);
            myModule.handleMsg.apply(myModule, params);
        }
    }

    register(key: string, module: ModuleBase) {
        if (!module || key.length <= 0) {
            return;
        }
        this._mapModule.set(key, module);
    }

    unregister(key: string) {
        if (key.length <= 0) {
            return;
        }
        let myModule = this._mapModule.get(key);
        if (myModule) {
            myModule.onRelease();
        }
        this._mapModule.delete(key);
    }
    getModule(key: string) {
        return this._mapModule.get(key);
    }
}