export default class ResMgr{
    private static _instance:ResMgr = null;
    private _mapPrefabs:Map<string, cc.Prefab> = new Map();
    private _tiledMap:Map<string, cc.TiledMapAsset> = new Map();
    private _mapAtlas:Map<string, cc.SpriteAtlas> = new Map();
    private _mapSpriteFrame:Map<string, cc.SpriteFrame> = new Map();
    public static getInstance(){
        if(!this._instance){
            this._instance = new ResMgr();
        }
        return this._instance;
    }
    addRes(key:string, res:any){
        if(res instanceof cc.Prefab){
            this._mapPrefabs.set(key, res);
        }
        else if(res instanceof cc.TiledMapAsset){
            this._tiledMap.set(key, <cc.TiledMapAsset>res);
        }
        else if(res instanceof cc.SpriteAtlas){
            this._mapAtlas.set(key, <cc.SpriteAtlas>res);
        }
        else if(res instanceof cc.SpriteFrame){
            this._mapSpriteFrame.set(key, <cc.SpriteFrame>res);
        }
    }
    getPrefab(key:string){
        return this._mapPrefabs.get(key);
    }

    getTiledMap(key:string){
        return this._tiledMap.get(key);
    }
    //预制体
    //Atlas
    getAtlas(key:string){
        return this._mapAtlas.get(key);
    }
    //精灵帧
    getSpriteFrame(spriteFrameName:string, atlasName?:string){
        if(spriteFrameName.length <= 0){
            return null;
        }
        if(atlasName && atlasName.length > 0){
            let atlas = this._mapAtlas.get(atlasName);
            return atlas.getSpriteFrame(spriteFrameName);
        }
        else{
            return this._mapSpriteFrame.get(spriteFrameName);;
        }
    }
}