// Learn TypeScript:
//  - https://docs.cocos.com/creator/2.4/manual/en/scripting/typescript.html
// Learn Attribute:
//  - https://docs.cocos.com/creator/2.4/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - https://docs.cocos.com/creator/2.4/manual/en/scripting/life-cycle-callbacks.html

import { DynamicAtlas } from "./DynamicAtlas";

const { ccclass, property } = cc._decorator;

@ccclass
export default class NewClass extends cc.Component {

    // onLoad () {}

    @property(sp.Skeleton)
    spineSkeleton: sp.Skeleton = null;

    @property(cc.Sprite)
    sprite: cc.Sprite = null;

    private atlas:DynamicAtlas;
    start() {

        this.initSkin();
    }

    private initSkin(): void {


        let source = this.spineSkeleton.skeletonData.getRuntimeData();
        let sourceSlot;

        let slotName: string = "left-hand";

        cc.resources.load("goblins", sp.SkeletonData, (err, assets) => {
            sourceSlot = source.findSlot(slotName);
            let data: sp.spine.SkeletonData = assets.getRuntimeData();
            let skin1: sp.spine.Skin = data.findSkin("goblingirl");
            let slotIndex = data.findSlotIndex(slotName);
            let attachment = skin1.getAttachment(slotIndex, slotName);

            this.atlas=new DynamicAtlas(1024,1024);
            let copyAttachment=this.atlas.allocation(attachment as sp.spine.RegionAttachment);

            //用于显示整个图集
            this.sprite.spriteFrame=new cc.SpriteFrame(this.atlas.texture);

            //换装
            let slot = this.spineSkeleton.findSlot(slotName);
            slot.setAttachment(copyAttachment);
        });
    }
}
