"use strict";
cc._RF.push(module, '95804y+Z3BBIJFZ/DYjMPY6', 'RGBA8888Texture');
// resources/RGBA8888Texture.ts

"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.RGBA8888Texture = void 0;
/**
 * RGBA8888二进制纹理
 */
var RGBA8888Texture = /** @class */ (function (_super) {
    __extends(RGBA8888Texture, _super);
    function RGBA8888Texture(width, height) {
        var _this = _super.call(this) || this;
        _this.__width = width;
        _this.__height = height;
        _this.__buffer = new Uint8Array(width * height * 4);
        return _this;
    }
    RGBA8888Texture.prototype.fillRect = function (x, y, width, height, color) {
        for (var ix = 0; ix < width; ix++) {
            for (var iy = 0; iy < height; iy++) {
                this.setPixelColor(color, ix + x, iy + y);
            }
        }
    };
    /**
     * 颜色数据写入
     * @param data
     * @param width
     * @param height
     * @param tx
     * @param ty
     */
    RGBA8888Texture.prototype.setPixels = function (data, width, tx, ty) {
        var x, y;
        var tIndex;
        var sIndex;
        var len = Math.floor(data.byteLength / 4);
        for (var index = 0; index < len; index++) {
            x = index % width;
            y = Math.floor(index / width);
            sIndex = (y * width + x) * 4;
            tIndex = ((ty + y) * this.__width + (tx + x)) * 4;
            this.__buffer[tIndex] = data[sIndex];
            this.__buffer[tIndex + 1] = data[sIndex + 1];
            this.__buffer[tIndex + 2] = data[sIndex + 2];
            this.__buffer[tIndex + 3] = data[sIndex + 3];
        }
    };
    /**
     * 通过颜色分量设置
     * @param r
     * @param g
     * @param b
     * @param a
     * @param x
     * @param y
     */
    RGBA8888Texture.prototype.setPixel = function (r, g, b, a, x, y) {
        var index = (y * this.__width + x) * 4;
        this.__buffer[index] = r;
        this.__buffer[index + 1] = g;
        this.__buffer[index + 2] = b;
        this.__buffer[index + 3] = a;
    };
    /**
     * 通过单个颜色值设置
     * @param color
     * @param x
     * @param y
     */
    RGBA8888Texture.prototype.setPixelColor = function (color, x, y) {
        var a = ((color >> 24) & 0xff);
        var r = ((color >> 16) & 0xff);
        var g = ((color >> 8) & 0xff);
        var b = ((color) & 0xff);
        this.setPixel(r, g, b, a, x, y);
    };
    /**
     * 获取矩形范围内的颜色
     * @param x
     * @param y
     * @param width
     * @param height
     * @param result
     * @returns
     */
    RGBA8888Texture.prototype.getPixels = function (x, y, width, height, result) {
        result = result || new Uint8Array(width * height * 4);
        var fx, fy;
        var index = 0;
        var sIndex = 0;
        var color;
        for (var ix = 0; ix < width; ix++) {
            for (var iy = 0; iy < height; iy++) {
                fx = x + ix;
                fy = y + iy;
                sIndex = ((y + iy) * this.__width + (x + ix)) * 4;
                color = this.getPixel(fx, fy);
                result[index] = color.r;
                result[index + 1] = color.g;
                result[index + 2] = color.b;
                result[index + 3] = color.a;
                index += 4;
            }
        }
        return result;
    };
    /**
     * 获取指定像素点的颜色
     * @param x
     * @param y
     * @returns
     */
    RGBA8888Texture.prototype.getPixel = function (x, y) {
        var index = (y * this.__width + x) * 4;
        return {
            r: this.__buffer[index],
            g: this.__buffer[index + 1],
            b: this.__buffer[index + 2],
            a: this.__buffer[index + 3]
        };
    };
    /**
     * 将数据同步到纹理
     */
    RGBA8888Texture.prototype.update2Texture = function () {
        this.initWithData(this.__buffer, cc.Texture2D.PixelFormat.RGBA8888, this.__width, this.__height);
    };
    return RGBA8888Texture;
}(cc.Texture2D));
exports.RGBA8888Texture = RGBA8888Texture;

cc._RF.pop();