"use strict";
cc._RF.push(module, 'dd82a4rRPpGR6HsdKrIP0N4', 'DynamicAtlas');
// resources/DynamicAtlas.ts

"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DynamicAtlas = void 0;
var MaxRectsBinPack_1 = require("./MaxRectsBinPack");
var RGBA8888Texture_1 = require("./RGBA8888Texture");
var DynamicAtlas = /** @class */ (function () {
    function DynamicAtlas(width, height) {
        this.__temporaryTexture = new cc.RenderTexture();
        this.__temporaryTexture = new cc.RenderTexture();
        this.__temporaryTexture.initWithSize(width, height);
        this.__regions = new Map();
        this.__maxRectsBinPack = new MaxRectsBinPack_1.MaxRectBinPack(width, height, false);
        this.__texture = new RGBA8888Texture_1.RGBA8888Texture(width, height);
        this.__texturePage = new sp.spine.TextureAtlasPage();
        this.__texturePage.name = "page";
        this.__texturePage.width = width;
        this.__texturePage.height = height;
        this.__texturePage.minFilter = sp.spine.TextureFilter.Linear;
        this.__texturePage.magFilter = sp.spine.TextureFilter.Linear;
        this.__texturePage.uWrap = sp.spine.TextureWrap.ClampToEdge;
        this.__texturePage.vWrap = sp.spine.TextureWrap.ClampToEdge;
        //纹理
        var tex = new sp["SkeletonTexture"]({ width: width, height: height });
        tex.setRealTexture(this.__texture);
        this.__texturePage.texture = tex;
        this.__texturePage.texture.setFilters(this.__texturePage.minFilter, this.__texturePage.magFilter);
        this.__texturePage.texture.setWraps(this.__texturePage.uWrap, this.__texturePage.vWrap);
    }
    DynamicAtlas.prototype.allocation = function (attachment) {
        var result = this.copyRegionAttachment(attachment);
        result.name = attachment.name;
        var region = result["region"];
        var spTexture = region["texture"];
        var texture = spTexture["_texture"];
        //将纹理绘制到临时纹理上
        this.__temporaryTexture["drawTextureAt"](texture, 0, 0);
        //从临时纹理中获取需要的纹理区块
        this.device.setFrameBuffer(this.__temporaryTexture["_framebuffer"]);
        var byte = this.__temporaryTexture.readPixels(null, region.x, region.y, region.width, region.height);
        //分配空间
        var rect = this.__maxRectsBinPack.insert(region.width, region.height, MaxRectsBinPack_1.FindPosition.ShortSideFit);
        if (rect.isEmpty) {
            throw new Error("图集分配空间失败！");
        }
        //合并到共享图集
        this.__texture.setPixels(byte, region.width, rect.x, rect.y);
        this.__texture.update2Texture();
        var copy = new sp.spine.TextureAtlasRegion();
        copy.name = region.name;
        copy.width = copy.originalWidth = region.width;
        copy.height = copy.originalHeight = region.height;
        copy.x = rect.x;
        copy.y = rect.y;
        copy.degrees = 0;
        copy.index = -1;
        copy.texture = this.__texturePage.texture;
        copy.u = rect.x / this.__texturePage.width;
        copy.v = rect.y / this.__texturePage.height;
        copy.u2 = (rect.x + rect.width) / this.__texturePage.width;
        copy.v2 = (rect.y + rect.height) / this.__texturePage.height;
        copy.offsetX = copy.offsetY = 0;
        copy.page = this.__texturePage;
        copy.renderObject = copy;
        this.__regions.set(copy.name, copy);
        result.setRegion(copy);
        return result;
    };
    DynamicAtlas.prototype.copyRegionAttachment = function (data) {
        var copy = new sp.spine.RegionAttachment(data.name);
        copy.region = data.region;
        copy.rendererObject = data.rendererObject;
        copy.path = data.path;
        copy.x = data.x;
        copy.y = data.y;
        copy.scaleX = data.scaleX;
        copy.scaleY = data.scaleY;
        copy.rotation = data.rotation;
        copy.width = data.width;
        copy.height = data.height;
        sp.spine.Utils.arrayCopy(data.uvs, 0, copy.uvs, 0, 8);
        sp.spine.Utils.arrayCopy(data.offset, 0, copy.offset, 0, 8);
        copy.color.setFromColor(data.color);
        return copy;
    };
    Object.defineProperty(DynamicAtlas.prototype, "device", {
        get: function () {
            return cc.renderer["device"];
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(DynamicAtlas.prototype, "texture", {
        get: function () {
            return this.__texture;
        },
        enumerable: false,
        configurable: true
    });
    return DynamicAtlas;
}());
exports.DynamicAtlas = DynamicAtlas;

cc._RF.pop();