import ComponentBase from "./ComponentBase";
import Message, { MessageType } from "./Message";
import MessageCenter from "./MessageCenter";

const {ccclass, property} = cc._decorator;

@ccclass
export default class ManagerBase extends ComponentBase {

    //管理类，需要有管理的消息接受者数组
    ReceiveList: ComponentBase[] = [];
    messageType:number;
    
    onLoad(){
        //设置当前管理类接收的消息类型
        this.messageType = this.SetMessageType();
        //把管理类加到消息中心
        MessageCenter.Managers.push(this);
    }

    //管理基类中，默认是UI的中间管理器
    SetMessageType(){
        return MessageType.Type_UI;
    }

    //把底层的小类加入数组
    //注册消息监听
    RegisterReceiver(cb:ComponentBase){
        this.ReceiveList.push(cb);
    }

    UnregisterReceiver(){
        this.ReceiveList.pop();
    }

    ReceiveMessage(message: Message){
        //继承父类，在执行自己的方法之前，把父类的方法执行一遍
        super.ReceiveMessage(message);

        //判断是不是自己的管理的类型
        if(message.Type != this.messageType){
            return;
        }
        //向下层分发消息
            for(let cb of this.ReceiveList){
                cb.ReceiveMessage(message);
            }
        }
}
