const {ccclass, property} = cc._decorator;

//消息类
export default class Message {
    //消息类型
    Type:number;
    //命令
    Command:number;
    //参数-消息的内容，可能是任何类型
    Content:any;

    constructor(type:number,command:number,content:any){
        this.Type = type;
        this.Command = command;
        this.Content = content;
    }
}

//定义消息类型对应的值
export class MessageType{
    //中间层，定义消息是对UI发的，还是对NPC发的，...
    static Type_UI = 1;
    static Type_NPC = 2;
    static Type_Player = 3;
    static Type_Enemy = 4;
    static Type_Audio = 5;
    static Type_FallingObject = 6;

    static UI_RefreshHp = 101;
    static UI_RefreshScore = 102;
    static UI_RefreshInventory = 103;
    static UI_RefreshCoin = 104;
    
    static UI_EndGame = 180;

    static NPC_npc1 = 201;
    static NPC_npc2 = 202;

    static Player_attack = 301;
    static Player_hurt = 302;
    static Player_downPedal = 303;

    static Player_Bullet1 = 321; 

    static Enemy_enemy1 = 401;
    static Enemy_enemy2 = 402;



    static Falling_ObjectNum = 601;// 掉落物品数量
    static Falling_ObjectPos = 602;// 触发掉落物品的方法
    static Falling_ManyObjectPos = 603; // 触发掉落大量物品的方法

}