import ComponentBase from "./ComponentBase";
import Message from "./Message";

const {ccclass, property} = cc._decorator;

export default class MessageCenter{

    //管理类列表
    static Managers:ComponentBase[]=[];

    //消息中心最重要的一个内容就是发消息
    //让数组中的所有管理类转发消息
    static SendMessage(msg:Message){
        for(let manager of this.Managers){
            manager.ReceiveMessage(msg);
        }
    }

    //这样发消息每次都要将一个消息类作为参数发送出去
    //于是简化一下
    static SendCustomMessage(type:number,command:number,content:any){
        let msg = new Message(type, command, content);
        this.SendMessage(msg);//调用前面写的发消息方法
    }
}
