import ComponentBase from "./ComponentBase";
import FSMManager from "./FSMManager";
import FSMState from "./FSMState";
import PlayerRunState from "./FSMState/PlayerRunState";
import PlayerStandState from "./FSMState/PlayerStandState";

import Message, { MessageType } from "./Message";
import MessageCenter from "./MessageCenter";
import PlayerProperty from "./PlayerProperty";
import PlayerManager from "./PlayerState/PlayerManager";
import TagDescribe from "./TagDescribe";

const {ccclass, property} = cc._decorator;

enum PlayerState{
    Stand,
    StandR,
    Run,
    Jump,
    Attack,
    Die
    }

class GateType{
    static RightBottom   :cc.Vec2 = cc.v2( 1600,200);
    static LeftBottom    :cc.Vec2 = cc.v2(-1600,200);
    static LeftTop       :cc.Vec2 = cc.v2(100,50);
    static RightTop      :cc.Vec2 = cc.v2(0  ,1000);
    static middle        :cc.Vec2 = cc.v2(100,50);
    static RightUpStair  :cc.Vec2 = cc.v2(0  ,900);
    static LeftUpStair   :cc.Vec2 = cc.v2(0  ,1000);
    static LeftDownStair :cc.Vec2 = cc.v2(100,50);
    static RightDownStair:cc.Vec2 = cc.v2(100,50);
    static trap          :cc.Vec2 = cc.v2(100,50);
    static treasure      :cc.Vec2 = cc.v2(100,50);
}

@ccclass
export default class PlayerControl extends ComponentBase {

    @property
    speed:number = 100;

    @property([cc.SpriteFrame])
    sprites:cc.SpriteFrame[] = [];

    //面向右边的动画
    @property([cc.SpriteFrame])
    spritesR:cc.SpriteFrame[] = [];

    @property(cc.Prefab)
    attackMeleePre:cc.Prefab = null;

    @property(cc.Prefab)
    attackBulletPre:cc.Prefab = null;

    ani:cc.Animation;
    //增加一个状态机类的属性
    // fsmManager:FSMManager;
    // 禁用状态机，使用一个number属性代替
    curState:number = 0;



    //角色如果在地上，就可以跳跃
    isOnGround:boolean = false;
    

    // //角色属性
    // playerProperty:PlayerProperty = new PlayerProperty();
    // 弃用
    // 角色的近战远程攻击判断
    // playerMelee:boolean = false;

    horizontal: number = 0;
    // isDown: boolean = false;

    attackHorizontal:number  = 0;
    attackVertical:number = 0;
    playerIsAttacting:boolean = false;
    // 攻击间隔计时
    attackTime:number = 0.5;
    // 角色被击中后，应该有1秒的无敌时间
    invincible:boolean = false;

    //触碰传送门的判断
    waitForMove:boolean = false;
    //当触碰传送门，且按下e键时进行传送,并没有用上
    //按下E键之后，可以进入下一房间，游戏中通过穿墙进入下一房间
    isBtnEDown:boolean = false;
    //当前门的类型 对应传送位置
    currentGateType:cc.Vec2 = cc.v2(0,0);

    // 在可穿透的踏板上，按下s键可以掉下去
    isBtnSDown:boolean = false;
    btnSDownTime:number = 0;// 长按1秒可以掉下去
    downAble: boolean = false;

    //AnimRun动画参数
    RunIndex:number = 0;
    RunTimer:number = 0;

    //解决contact End不触发问题的参数
    // Cposx: number = 0;
    // Cposy: number = 0;
    // CWidth: number = 0;
    // CHeight: number = 0;

    onLoad(): void {
        cc.director.getPhysicsManager().enabled = true;
        
    }

    protected onDestroy(): void {
        // this.fsmManager.StateList = [];
    }

    start () {
        //注册为Player消息的接受者
        PlayerManager.Instance.RegisterReceiver(this);

        this.ani = this.getComponent(cc.Animation);
        //创建状态机
        // this.fsmManager = new FSMManager();

        // let stand = new PlayerStandState(PlayerState.Stand, this, this.fsmManager);
        // let standR = new PlayerStandState(PlayerState.StandR, this, this.fsmManager);
        // let run   = new PlayerRunState(PlayerState.Run, this, this.fsmManager);
        // let jump  = new FSMState(PlayerState.Jump, this, this.fsmManager);
        // let die   = new FSMState(PlayerState.Die, this, this.fsmManager);
        
        // this.fsmManager.StateList = [stand, standR, run];
        // this.fsmManager.ChangeState(PlayerState.Stand);
        this.stand();
        this.curState = PlayerState.Stand;
        //加载场景
        // cc.director.preloadScene("scene1_4_1",function(){
        //     this.loadDone = true;
        //     console.debug('gate true');
        // });

        //键盘输入空格跳跃
        cc.systemEvent.on(cc.SystemEvent.EventType.KEY_DOWN,(event)=>{           
            if(event.keyCode == cc.macro.KEY.space){
                if(this.isOnGround == true){
                    this.pJump(PlayerProperty.Instance.playerJumpSpeed);
                }
            }


            if(event.keyCode == cc.macro.KEY.a ){
                this.horizontal = -1;
                if(this.attackHorizontal == 0 ){ 
                    // this.node.getComponent(cc.Sprite).spriteFrame = this.sprites[0];
                }
                this.run();
            }else if(event.keyCode == cc.macro.KEY.d ){
                this.horizontal = 1;
                if(this.attackHorizontal == 0 ){ 
                    // this.node.getComponent(cc.Sprite).spriteFrame = this.spritesR[0];
                }
                this.run();
            }

            if(event.keyCode == cc.macro.KEY.left ){
                this.playerIsAttacting = true;
                this.attackHorizontal = -1;
                // this.node.getComponent(cc.Sprite).spriteFrame = this.sprites[0];
            }else if(event.keyCode == cc.macro.KEY.right ){
                this.playerIsAttacting = true;
                this.attackHorizontal = 1;
                // this.node.getComponent(cc.Sprite).spriteFrame = this.spritesR[0];
            }
            if(event.keyCode == cc.macro.KEY.up){
                this.playerIsAttacting = true;
                this.attackVertical = 1;
            }else if(event.keyCode == cc.macro.KEY.down){
                this.playerIsAttacting = true;
                this.attackVertical = -1;
            }    
            
            if(event.keyCode == cc.macro.KEY.e){
                if(this.waitForMove == true && this.isOnGround){
                    this.isBtnEDown = true;
                    this.onTouchGate(this.currentGateType);
                    this.scheduleOnce(()=>{
                        this.isBtnEDown = false;
                    },2);
                }
            }

            if(event.keyCode == cc.macro.KEY.s){
                this.isBtnSDown = true;
            }
        });

        
        this.speed = PlayerProperty.Instance.playerMoveSpeed;

        //键盘抬起
        cc.systemEvent.on(cc.SystemEvent.EventType.KEY_UP,(event)=>{

            if(event.keyCode == cc.macro.KEY.a ){
                this.stand();
                if(this.horizontal == -1){
                    this.horizontal = 0;
                }
            }else if(event.keyCode == cc.macro.KEY.d){
                this. standR();
                if(this.horizontal == 1){
                    this.horizontal = 0;
                }
            }

            if(event.keyCode == cc.macro.KEY.right && this.attackHorizontal == 1){
                this.attackHorizontal = 0;
                this.playerIsAttacting = false;
            }else if(event.keyCode == cc.macro.KEY.left && this.attackHorizontal == -1){
                this.attackHorizontal = 0;
                this.playerIsAttacting = false;
            }

            if(event.keyCode == cc.macro.KEY.up && this.attackVertical == 1){
                this.attackVertical = 0;
                this.playerIsAttacting = false;
            }else if(event.keyCode == cc.macro.KEY.down && this.attackVertical == -1){
                this.attackVertical = 0;
                this.playerIsAttacting = false;
            }

            if(event.keyCode == cc.macro.KEY.s){
                this.isBtnSDown = false;
            }
        });

        
    }

    update (dt) {
    

        //镜头跟随主角
        // cc.Camera.main.node.x = this.node.x;
        // cc.Camera.main.node.y = this.node.y + 200;
        cc.Camera.main.node.setPosition(this.node.convertToWorldSpaceAR(cc.v2(-480,-200)));

        // 主角移动
        this.node.x += this.speed * dt * this.horizontal;

        // 角色动画
        if(this.horizontal == -1){
            this.RunTimer += dt;
            if(this.RunTimer > 0.25){
                this.RunTimer = 0;
                this.RunIndex ++;
                if(this.RunIndex >= this.sprites.length){
                    this.RunIndex = 0;
                }
            // this.getComponent(cc.Sprite).spriteFrame = this.sprites[this.RunIndex];
            }
        }else if(this.horizontal == 1){
            this.RunTimer += dt;
            if(this.RunTimer > 0.25){
                this.RunTimer = 0;
                this.RunIndex ++;
                if(this.RunIndex >= this.spritesR.length){
                    this.RunIndex = 0;
                }
            // this.getComponent(cc.Sprite).spriteFrame = this.spritesR[this.RunIndex];
            }
        }
            
        

        if(this.playerIsAttacting == true){
            this.attackTime += dt;
            if(this.attackTime > PlayerProperty.Instance.playerAttackInterval){
                let attackNode = cc.instantiate(this.attackBulletPre);
                // 如果父节点为cc.director.getScene()的设置
                attackNode.setParent(cc.director.getScene());
                attackNode.setPosition(this.node.convertToWorldSpaceAR(cc.v2(-20,0)));
                attackNode.getComponent('BulletControl').tarPos = cc.v2(this.attackHorizontal,this.attackVertical);
                this.attackTime = 0;
            }
        }

        if(this.isBtnSDown == true){
            this.btnSDownTime += dt;
            if(this.btnSDownTime > 0.8){
                this.downAble = true;
                this.btnSDownTime = 0;
                MessageCenter.SendCustomMessage(MessageType.Type_Player, MessageType.Player_downPedal,null);
            }
        }else{
            this.btnSDownTime = 0;
        }

        // 刷新角色物体碰撞体积
        let physicsPlayer = this.node.getComponent(cc.PhysicsBoxCollider);
        physicsPlayer.apply();

        //如果与地板接触，进行碰撞判断，使其走到边缘的时候掉落
        // if(this.isOnGround == true){
        //     // 判断是否应该掉了
        //     // if((this.node.x > this.Cposx + this.CWidth/2 + this.node.width/2 ||
        //     // this.node.x < this.Cposx - this.CWidth/2 - this.node.width/2) &&
        //     // this.node.y < this.Cposy + this.CHeight/2 + this.node.height/2 + 10 ){
        //     //     this.pJump(1);
        //     // }
        //     //走到边缘掉落的时候掉落
        // }

        /* 弃用
        // // 角色碰撞射线
        // let rayNodePos2 = this.node.convertToWorldSpaceAR(cc.v2(0,0));
        // let rayNodePos4 = this.node.convertToWorldSpaceAR(cc.v2(-100,0));
        // // console.log(rayNodePos2 + '' + rayNodePos4);
        // let results = cc.director.getPhysicsManager().rayCast(rayNodePos2,
        //     rayNodePos4,cc.RayCastType.Closest);

        // if(results.length != 0){
        //         this.playerMelee = true;
        //         // console.log('playerMelee true');
        // }else{
        //     this.playerMelee = false;
        //     // console.log('playerMelee false');
        // }
        */
    }




    // 碰撞回调
    // 0 是default的地板
    // 10~19是各种可破坏道具， 
    // 20~29对应的是传送门
    // 
    onBeginContact(contact, self, other){
        if(other.tag == TagDescribe.Tag_Default){
            this.isOnGround = true;
            // 手动解决不触发碰撞的方法
            // this.Cposx = other.node.x;
            // this.Cposy = other.node.y;
            // this.CWidth = other.node.width;
            // this.CHeight = other.node.height;
            // console.debug(other.node.x + "") ;
            // console.debug(other.node.height + "") ;
            // console.debug(this.node.x + " this") ;
        }
        else if(other.tag == TagDescribe.Tag_Enemy){
            let contactP = contact.getWorldManifold().points[0];
            let reboundDir = 1;
            let myPos = this.node.convertToWorldSpaceAR(cc.v2(0,0));
            if(contactP.x > myPos.x){
                reboundDir = -1;
            }
            // console.log(contactP.x + " " + myPos.x);
            this.node.getComponent(cc.RigidBody).linearVelocity = cc.v2(reboundDir * 50,20);
        }
        else if(other.tag == TagDescribe.Tag_EnemyBullet){
            MessageCenter.SendCustomMessage(MessageType.Type_Player,MessageType.Player_hurt,1);
        }
        else if(other.tag == TagDescribe.Tag_wall){
            if(this.isBtnEDown == true){
                contact.disabled = true;
            }
        }
        else if(other.tag == TagDescribe.Tag_WoodBox){
            let contactP = contact.getWorldManifold().points[0];
            let myPos = this.node.convertToWorldSpaceAR(cc.v2(0,0));
            if(contactP.y < myPos.y ){
                this.isOnGround = true;
            }
            // 木箱子
        }
        else if(other.tag == TagDescribe.Gate_RightBottom){
            this.waitForMove = true;
            this.currentGateType = GateType.RightBottom;
        }
        else if(other.tag == TagDescribe.Gate_LeftBottom){
            this.waitForMove = true;
            this.currentGateType = GateType.LeftBottom;
            // let shiftPos:cc.Vec2 = cc.v2(-100,50);
            // this.onTouchGate(shiftPos);
            // 不能使用setPosition
            // this.node.setPosition(-1500,-200);
        }        
        else if(other.tag == TagDescribe.Gate_RightUpStair){
            this.waitForMove = true;
            this.currentGateType = GateType.RightUpStair;
        }
        else if(other.tag == TagDescribe.Gate_RightDownStair){
            this.waitForMove = true;
            this.currentGateType = GateType.RightDownStair;
        }
        else if(other.tag == TagDescribe.Tag_CoinSmall){
            // MessageCenter.SendCustomMessage(MessageType.Type_UI,MessageType.UI_RefreshCoin,1);
        }
        else if(other.tag == TagDescribe.Gate_trap){
            this.node.getComponent(cc.RigidBody).linearVelocity = cc.v2(0,PlayerProperty.Instance.playerJumpSpeed * 1.8);
        }
        else if(other.tag == TagDescribe.Pedal_Wornable){
            this.isOnGround = true;
            if(this.node.getComponent(cc.RigidBody).linearVelocity.y > 0 || this.downAble == true){
                contact.disabled = true;
            }
        }
    }

    onEndContact(contact, self, other){
        this.isOnGround = false;

        if(other.tag >= 20 || other.tag < 30 ){
                this.waitForMove = false;
            }
    }

    pJump(pJumpSpeed:number){
        this.node.getComponent(cc.RigidBody).linearVelocity = cc.v2(0,pJumpSpeed);
    }


    //碰到门触发事件
    //参数：在当前位置上移动的距离
    //可以使用moveBy
    //但是moveBy有可能有风险，因为跳跃的时候刚体位置没有跟上，导致移动位置出现偏差
    //moveTo也会出现这个问题
    //所以解决办法是，指定目标坐标，但是会多写很多脚本
    //或者加个挡板，不让人跳进传送门
    onTouchGate(shiftPos:cc.Vec2){
        // let tmpThisPos = this.node.getPosition();
        // let tarPos = tmpThisPos.add(shiftPos);
        if(this.currentGateType == GateType.RightUpStair){
            let tmpAction1 = cc.fadeOut(0.5);
            let tmpAction2 = cc.moveBy(0.3,shiftPos);
            let tmpAction3 = cc.moveBy(0.2,cc.v2(-300,300));
            let tmpAction4 = cc.fadeIn(0.5);
            let tmpSeq = cc.sequence(tmpAction1, tmpAction2, tmpAction3,cc.delayTime(0.5), tmpAction4);
            this.node.runAction(tmpSeq);        
            return;
        }
        if(this.currentGateType == GateType.RightDownStair){
            let tmpAction1 = cc.fadeOut(0.5);
            let tmpAction2 = cc.moveBy(0.3,cc.v2(200,100));
            let tmpAction3 = cc.fadeIn(0.5);
            let tmpSeq = cc.sequence(tmpAction1, tmpAction2,cc.delayTime(0.5), tmpAction3);
            this.node.runAction(tmpSeq);        
            return;
        }
        let tmpAction1 = cc.fadeOut(0.5);
        let tmpAction2 = cc.moveBy(0.5,shiftPos);
        let tmpAction3 = cc.fadeIn(0.5);
        let tmpSeq = cc.sequence(tmpAction1, tmpAction2,cc.delayTime(0.5), tmpAction3);
        this.node.runAction(tmpSeq);        
    }



    //状态机对应的状态方法
    standR(){
        // this.node.getComponent(cc.Sprite).spriteFrame = this.spritesR[0];
        this.curState = PlayerState.StandR;
        // this.fsmManager.ChangeState(PlayerState.StandR);
    }

    stand(){
        // this.node.getComponent(cc.Sprite).spriteFrame = this.sprites[0];
        this.curState = PlayerState.Stand;
        // this.fsmManager.ChangeState(PlayerState.Stand);

    }
    
    run(){
        this.curState = PlayerState.Run;
        // this.fsmManager.ChangeState(PlayerState.Run);
        //...其他代码，小鸟移动方向，速度，等等
    }

    jump(){

    }

    die(){
        //this.ani.play("die");
    }

    ReceiveMessage(msg:Message){
        super.ReceiveMessage(msg);
            if(msg.Command == MessageType.Player_hurt){
                if(this.invincible == false){
                    this.invincible = true;
                    this.node.color = cc.color(255,0,0);
                    // this.node.getComponent(cc.RigidBody).linearVelocity = cc.v2(this.node.scaleX * this.speed,20);
                    this.scheduleOnce(function(){
                        this.node.color = cc.color(255,255,255);
                    },0.1);
                    MessageCenter.SendCustomMessage(MessageType.Type_UI, MessageType.UI_RefreshHp, msg.Content);
                    this.scheduleOnce(function(){
                        this.invincible = false;
                    },2);
                }
            }
            else if(msg.Command == MessageType.Player_downPedal){
                this.scheduleOnce(function(){
                    this.downAble = false;
            },1);
        }
    }    


    /*弃用
    // // 接收到消息
    // ReceiveMessage(msg:Message){
    //     super.ReceiveMessage(msg);
    //     if(msg.Command == MessageType.Player_attack){
    //         if(this.playerMelee == true){
    //             this.attackMelee();
    //         }else{
    //             //强转类型
    //             let tarPos = <cc.Vec2>msg.Content;
    //             let myPos = this.node.convertToWorldSpaceAR(cc.v2(0,0));
    //             let pos = tarPos.sub(myPos).normalize();// 归一化向量
    //             this.attackRemote(pos);
    //         }

    //     }
    // }


    // attackMelee(){
    //     // let att = cc.instantiate(this.attackMeleePre);
    //     // att.setParent(this.node);
    //     // att.x = this.node.x - 20;
    //     // att.y = this.node.y;
    //     // console.log('aa');

    // }

    // attackRemote(pos:cc.Vec2){
    //     let attackNode = cc.instantiate(this.attackBulletPre);
    //     // 如果父节点为cc.director.getScene()的设置
    //     attackNode.setParent(cc.director.getScene());
    //     attackNode.setPosition(this.node.convertToWorldSpaceAR(cc.v2(-20,0)));
    //     MessageCenter.SendCustomMessage(MessageType.Type_Player, MessageType.Player_Bullet1, pos);
    //     // 如果父节点为this.node的设置
    //     // attackNode.setParent(this.node);
    //     // attackNode.setPosition(this.node.convertToWorldSpaceAR(cc.v2(-450,0)));
    //     // 使用动画容器做不出正确的效果
    //     // attackNode.runAction(cc.moveBy(3,(pos.x * 1000, pos.y * 1000)));
    //     // attackNode.destroy();
    // }
    */
        
}
