import HotUpdate from "./HotUpdate";

const {ccclass, property} = cc._decorator;

@ccclass
export default class Helloworld extends cc.Component {


    @property(cc.Label)
    label_state: cc.Label = null;

    @property(cc.ProgressBar)
    proBar_hotUpdate: cc.ProgressBar = null;

    @property(cc.Label)
    label_hotUpdate: cc.Label = null;

    @property(cc.Label)
    label_version: cc.Label = null;

    @property(cc.Asset)
    asset_manifest: cc.Asset = null;

    onEnable() {
        this.label_version.string = "0.0.0";
        this.proBar_hotUpdate.progress = 0;
        this.label_hotUpdate.string = "更新...0%";
        this.hotUpdateInit();
    }

    hotUpdateInit() {
        if (cc.sys.isBrowser) return;
        let self = this;
        HotUpdate.init(this.asset_manifest, (curV: string) => {
            this.label_version.string = curV;
        });

        HotUpdate.isNeedUpdateFn = function (isNeed: boolean, msg: string) {
            self.label_state.string = msg;
            if (isNeed) {
                self.label_state.string = "检测到新版本，需要更新";

                setTimeout(() => {
                    self.label_state.string = "开始更新";
                    HotUpdate.hotUpdate();
                }, 3000);
            }
        }.bind(this);

        HotUpdate.versionCompareFn = function (data: { local: string, server: string }) {
            let { local, server } = data;
            self.label_version.string = local == server ? local : `${local} -> ${server}`;
        }.bind(this);

        HotUpdate.updateFailFn = function (msg: string) {
            self.label_state.string = msg;
            // TODO 是否需要重新进行热更新
        }.bind(this);

        HotUpdate.updateSuccFn = function (tarV: string) {
            self.label_hotUpdate.string = "热更新...100%";
            self.proBar_hotUpdate.progress = 1;

            self.label_state.string = "热更完毕";
            console.log("需要重启游戏");
            self.label_version.string = tarV;

            setTimeout(() => {
                cc.game.restart();
            }, 3000);

        }.bind(this);

        HotUpdate.updateProgressFn = function (num: number) {
            self.label_state.string = "更新中......";
            this.label_hotUpdate.string = num == 0 ? "热更检测" : "热更..." + (num * 100).toFixed(2);
            this.proBar_hotUpdate.progress = num;
        }.bind(this);

        HotUpdate.checkHotUpdate();
        // HotUpdate.customerHotUpdate();

    }
}
