"use strict";
cc._RF.push(module, '19fcbtZAK1NWaSzUL8rOvg7', 'HotUpdate');
// Script/HotUpdate.ts

"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var HotUpdate = /** @class */ (function () {
    function HotUpdate() {
        this.manifestUrl = null;
        this.strogeKey_curVersion = "curVersion";
        /**当前版本 */
        this._curVersion = "";
        /**存储路径 */
        this._storagePath = "";
        // 热更管理器
        this._assetMgr = null;
        this.isUpdating = false;
    }
    Object.defineProperty(HotUpdate.prototype, "versionCompareFn", {
        set: function (fn) { this._versionCompareFn = fn; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(HotUpdate.prototype, "isNeedUpdateFn", {
        set: function (fn) { this._isNeedUpdateFn = fn; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(HotUpdate.prototype, "updateFailFn", {
        set: function (fn) { this._updateFailFn = fn; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(HotUpdate.prototype, "updateSuccFn", {
        set: function (fn) { this._updateSuccFn = fn; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(HotUpdate.prototype, "updateProgressFn", {
        set: function (fn) { this._updateProgressFn = fn; },
        enumerable: false,
        configurable: true
    });
    /**初始化 */
    HotUpdate.prototype.init = function (manifest, cb) {
        this.isUpdating = false;
        this.manifestUrl = manifest;
        this._curVersion = this.getCurVersion();
        this._storagePath = this.getRootPath();
        this._assetMgr = new jsb.AssetsManager("", this._storagePath, this.versionCompare.bind(this));
        this._assetMgr.setVerifyCallback(this.setVerifycb.bind(this));
        // 返回当前版本号
        cb && cb(this._curVersion);
    };
    HotUpdate.prototype.getCurVersion = function () {
        // 尝试从缓存中获取
        var curVersion = cc.sys.localStorage.getItem(this.strogeKey_curVersion);
        if (curVersion)
            return curVersion;
        var storagePath = this.getRootPath();
        storagePath = this.manifestUrl.nativeUrl;
        if (storagePath) {
            // 从本地缓存路径读取manifest文件
            cc.log(storagePath);
            var loadManifest = jsb.fileUtils.getStringFromFile(storagePath);
            var manifestObject = JSON.parse(loadManifest);
            curVersion = manifestObject.version;
        }
        return curVersion;
    };
    HotUpdate.prototype.getRootPath = function () {
        return (jsb.fileUtils ? jsb.fileUtils.getWritablePath() : "/") + "remote-asset";
    };
    /**比较版本号 */
    HotUpdate.prototype.versionCompare = function (v1, v2) {
        this._versionCompareFn && this._versionCompareFn({ local: v1, server: v2 });
        console.log("================= 客户端版本：%s, 当前最新版本：%s ====================", v1, v2);
        var arr1 = v1.split(".");
        var arr2 = v2.split(".");
        for (var i = 0; i < arr1.length; ++i) {
            var num1 = parseInt(arr1[i]);
            var num2 = parseInt(arr2[i] || "0");
            if (num1 == num2) {
                continue;
            }
            else {
                return -1;
            }
        }
        if (arr1.length < arr2.length) {
            return -1;
        }
        else {
            return 0;
        }
    };
    HotUpdate.prototype.setVerifycb = function (assetFullPath, asset) {
        // When asset is compressed, we don't need to check its md5, because zip file have been deleted.
        var compressed = asset.compressed;
        // Retrieve the correct md5 value.
        var expectedMD5 = asset.md5;
        // asset.path is relative path and path is absolute.
        var relativePath = asset.path;
        // The size of asset file, but this value could be absent.
        var size = asset.size;
        if (compressed) {
            console.log("Verification passed : " + relativePath);
            return true;
        }
        else {
            console.log("Verification passed : " + relativePath + ' (' + expectedMD5 + ')');
            return true;
        }
    };
    /**检测是否能够热更新 */
    HotUpdate.prototype.checkHotUpdate = function () {
        if (this.isUpdating) {
            return;
        }
        var url = this.manifestUrl.nativeUrl;
        console.log("原包版本信息url: ", url);
        if (this._assetMgr.getState() == jsb.AssetsManager.State.UNINITED) {
            if (cc.loader.md5Pipe) {
                url = cc.loader.md5Pipe.transformURL(url);
            }
            this._assetMgr.loadLocalManifest(url);
        }
        if (!this._assetMgr.getLocalManifest() || !this._assetMgr.getLocalManifest()) {
            console.log("加载本地manifest文件失败");
            return;
        }
        console.log("localManifest packageUrl：", this._assetMgr.getLocalManifest().getPackageUrl());
        this._assetMgr.setEventCallback(this.checkUpdateEvent.bind(this));
        this._assetMgr.checkUpdate();
        this.isUpdating = true;
    };
    HotUpdate.prototype.checkUpdateEvent = function (event) {
        console.log("checkUpdateEvent Code: %s", event.getEventCode());
        switch (event.getEventCode()) {
            case jsb.EventAssetsManager.ERROR_NO_LOCAL_MANIFEST:
                // this.label.string = "没有本地manifest文件，跳过热更.";
                this._isNeedUpdateFn && this._isNeedUpdateFn(false, "没有本地manifest文件，跳过热更.");
                break;
            case jsb.EventAssetsManager.ERROR_DOWNLOAD_MANIFEST:
            case jsb.EventAssetsManager.ERROR_PARSE_MANIFEST:
                // this.label.string = "下载远程manifest文件失败，跳过热更.";
                this._isNeedUpdateFn && this._isNeedUpdateFn(false, "下载远程manifest文件失败，跳过热更.");
                break;
            case jsb.EventAssetsManager.ALREADY_UP_TO_DATE:
                // this.label.string = "已经更新到远程最新版本.";
                this._isNeedUpdateFn && this._isNeedUpdateFn(false, "已经更新到远程最新版本.");
                break;
            case jsb.EventAssetsManager.NEW_VERSION_FOUND:
                // this.label.string = '发现新版本，请尝试热更';
                this._isNeedUpdateFn && this._isNeedUpdateFn(true, "发现新版本，请尝试热更");
                break;
            default:
                return;
        }
        this._assetMgr.setEventCallback(null);
        this.isUpdating = false;
    };
    /**热更新 */
    HotUpdate.prototype.hotUpdate = function () {
        if (this.isUpdating)
            return;
        if (!this._assetMgr)
            return;
        this._assetMgr.setEventCallback(this.hotUpdateEvent.bind(this));
        if (this._assetMgr.getState() == jsb.AssetsManager.State.UNINITED) {
            var url = this.manifestUrl.nativeUrl;
            if (cc.loader.md5Pipe) {
                url = cc.loader.md5Pipe.transformURL(url);
            }
            this._assetMgr.loadLocalManifest(url);
        }
        this._assetMgr.update();
        this.isUpdating = true;
    };
    HotUpdate.prototype.hotUpdateEvent = function (event) {
        console.log("hotUpdateEvent Code: [%s]  Msg: [%s]", event.getEventCode(), event.getMessage());
        switch (event.getEventCode()) {
            case jsb.EventAssetsManager.ERROR_NO_LOCAL_MANIFEST:
                // this.label.string = '没有本地manifest文件，跳过热更.';
                // failed = true;
                this.hotUpdateFail(event, "没有本地manifest文件，跳过热更.");
                break;
            case jsb.EventAssetsManager.UPDATE_PROGRESSION:
                console.log("当前下载文件数", event.getDownloadedFiles());
                console.log("总文件数", event.getTotalFiles());
                // var msg = event.getMessage();
                // if (msg) {
                //     this.label.string = '更新的文件：: ' + msg;
                // }
                this.hotUpdating(event, '更新的文件：: ' + event.getMessage());
                break;
            case jsb.EventAssetsManager.ERROR_DOWNLOAD_MANIFEST:
            case jsb.EventAssetsManager.ERROR_PARSE_MANIFEST:
                // this.label.string = '下载远程manifest文件失败，跳过热更.';
                // failed = true;
                this.hotUpdateFail(event, "下载远程manifest文件失败，跳过热更.");
                break;
            case jsb.EventAssetsManager.ALREADY_UP_TO_DATE:
                // this.label.string = '已经更新到远程最新版本.';
                // failed = true;
                this.hotUpdateFail(event, "已经更新到远程最新版本.");
                break;
            case jsb.EventAssetsManager.UPDATE_FINISHED:
                // this.label.string = '更新完成，即将重启游戏. ' + event.getMessage();
                // needRestart = true;
                this.hotUpdateSucc(event, '更新完成，即将重启游戏. ' + event.getMessage());
                break;
            case jsb.EventAssetsManager.UPDATE_FAILED:
                // this.label.string = '更新失败. ' + event.getMessage();
                // this.updating = false;
                // // this._canRetry = true;
                this.hotUpdateFail(event, '更新失败. ' + event.getMessage());
                break;
            case jsb.EventAssetsManager.ERROR_UPDATING:
                // this.label.string = 'Asset 更新错误: ' + event.getAssetId() + ', ' + event.getMessage();
                this.hotUpdateFail(event, 'Asset 更新错误: ' + event.getAssetId() + ', ' + event.getMessage());
                break;
            case jsb.EventAssetsManager.ERROR_DECOMPRESS:
                // this.label.string = event.getMessage();
                this.hotUpdateFail(event, event.getMessage());
                break;
            default:
                break;
        }
    };
    HotUpdate.prototype.hotUpdateFail = function (event, msg) {
        console.log("hotUpdateFail Msg: [%s]", msg);
        this.isUpdating = false;
        this._updateFailFn && this._updateFailFn(msg);
    };
    HotUpdate.prototype.hotUpdateSucc = function (event, msg) {
        this._assetMgr.setEventCallback(null);
        var searchPaths = jsb.fileUtils.getSearchPaths();
        var newPaths = this._assetMgr.getLocalManifest().getSearchPaths();
        Array.prototype.unshift(searchPaths, newPaths);
        cc.sys.localStorage.setItem("HotUpdateSearchPaths", JSON.stringify(searchPaths));
        jsb.fileUtils.setSearchPaths(searchPaths);
        var remoteVersion = this.getRemoteVersion();
        cc.sys.localStorage.setItem(this.strogeKey_curVersion, remoteVersion);
        this._updateSuccFn && this._updateSuccFn(remoteVersion);
    };
    HotUpdate.prototype.hotUpdating = function (event, msg) {
        var count_Download = event.getDownloadedFiles();
        var count_Total = event.getTotalFiles();
        this._updateProgressFn && this._updateProgressFn(count_Download / count_Total, msg);
    };
    HotUpdate.prototype.getRemoteVersion = function () {
        var storagePath = this.getRootPath();
        console.log("有下载的manifest文件", storagePath);
        var loadManifest = jsb.fileUtils.getStringFromFile(storagePath + "/project.manifest");
        var manifestObject = JSON.parse(loadManifest);
        return manifestObject.version;
    };
    /**自定义热更新 */
    HotUpdate.prototype.customerHotUpdate = function () {
        var _this = this;
        var curV = this.getCurVersion();
        this.reqHotUpdateInfo(curV, function (info) {
            cc.log(info);
            /* // 大版本更新 1.x.x -> 2.x.x 需要重新下载并安装apk
            let rootpath = this.getRootPath();
            // 清除之前缓存的版本号 和 版本路径
            cc.sys.localStorage.removeItem(this.strogeKey_curVersion);
            jsb.fileUtils.removeDirectory(rootpath);
            // 打开新版本应用下载页
            let packageUrl = "";
            cc.sys.openURL(packageUrl); */
            // 小版本更新
            var needUpdate = _this.versionCompare(info.curV, info.tarV);
            if (needUpdate == 0) {
                console.log("小版本相同，不用更新");
                return;
            }
            _this._modifyAppLoadUrlForManifestFile(info.tarPath, _this.manifestUrl.nativeUrl);
        });
    };
    /**
    * 修改.manifest文件,如果有缓存则比较缓存的版本和应用包的版本，取较高者 热更，如果没有缓存则下载远程的版本文件 取版本号，这里统一修改地址为
    * 远程地址，不管 如何变化 都是从最新的地址下载版本文件。这里远程
    * @param {新的升级包地址} newAppHotUpdateUrl
    * @param {本地project.manifest文件地址} localManifestPath
    */
    HotUpdate.prototype._modifyAppLoadUrlForManifestFile = function (newAppHotUpdateUrl, localManifestPath) {
        var isWritten = false;
        if (jsb.fileUtils.isFileExist(this.getRootPath() + '/project.manifest')) {
            var storagePath = this.getRootPath();
            console.log("有下载的manifest文件", storagePath);
            var loadManifest = jsb.fileUtils.getStringFromFile(storagePath + '/project.manifest');
            var manifestObject = JSON.parse(loadManifest);
            manifestObject.packageUrl = newAppHotUpdateUrl;
            manifestObject.remoteManifestUrl = newAppHotUpdateUrl + "/project.manifest";
            manifestObject.remoteVersionUrl = newAppHotUpdateUrl + "/version.manifest";
            var afterString = JSON.stringify(manifestObject);
            isWritten = jsb.fileUtils.writeStringToFile(afterString, storagePath + '/project.manifest');
        }
        else {
            /**
             * 执行到这里说明App之前没有进行过热更，所以不存在热更的plane文件夹。
             */
            /**
             * plane文件夹不存在的时候，我们就主动创建“plane”文件夹，并将打包时候的project.manifest文件中升级包地址修改后，存放到“plane”文件夹下面。
             */
            var initializedManifestPath = this.getRootPath();
            if (!jsb.fileUtils.isDirectoryExist(initializedManifestPath)) {
                jsb.fileUtils.createDirectory(initializedManifestPath);
            }
            //修改原始manifest文件
            var originManifestPath = localManifestPath;
            var originManifest = jsb.fileUtils.getStringFromFile(originManifestPath);
            var originManifestObject = JSON.parse(originManifest);
            originManifestObject.packageUrl = newAppHotUpdateUrl;
            originManifestObject.remoteManifestUrl = newAppHotUpdateUrl + '/project.manifest';
            originManifestObject.remoteVersionUrl = newAppHotUpdateUrl + '/version.manifest';
            var afterString = JSON.stringify(originManifestObject);
            isWritten = jsb.fileUtils.writeStringToFile(afterString, initializedManifestPath + '/project.manifest');
        }
        cc.log("Written Status : ", isWritten);
        if (isWritten) {
            this.checkHotUpdate();
        }
    };
    HotUpdate.prototype.reqHotUpdateInfo = function (curV, cb) {
        var xhr = cc.loader.getXMLHttpRequest();
        xhr.onreadystatechange = function () {
            if (xhr.readyState == 4 && xhr.status == 200) {
                var txt = xhr.responseText;
                console.log("get hotupdate info from server %s", txt);
                var data = JSON.parse(txt);
                cb && cb(data);
            }
        };
        xhr.withCredentials = false;
        xhr.open("GET", "http://192.168.3.94:3000//hotUpdate?curV=" + curV);
        xhr.send();
    };
    HotUpdate.prototype.reqLocalManifest = function (url, cb) {
        var xhr = cc.loader.getXMLHttpRequest();
        xhr.onreadystatechange = function () {
            if (xhr.readyState == 4 && xhr.status == 200) {
                var txt = xhr.responseText;
                console.log("get localManifest from server %s", txt);
                var data = JSON.parse(txt);
                cb && cb(data);
            }
        };
        xhr.withCredentials = false;
        xhr.open("GET", url, true);
        xhr.send();
    };
    return HotUpdate;
}());
var hotInstance = new HotUpdate();
exports.default = hotInstance;

cc._RF.pop();