
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/Script/HotUpdate.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '19fcbtZAK1NWaSzUL8rOvg7', 'HotUpdate');
// Script/HotUpdate.ts

"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var HotUpdate = /** @class */ (function () {
    function HotUpdate() {
        this.manifestUrl = null;
        this.strogeKey_curVersion = "curVersion";
        /**当前版本 */
        this._curVersion = "";
        /**存储路径 */
        this._storagePath = "";
        // 热更管理器
        this._assetMgr = null;
        this.isUpdating = false;
    }
    Object.defineProperty(HotUpdate.prototype, "versionCompareFn", {
        set: function (fn) { this._versionCompareFn = fn; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(HotUpdate.prototype, "isNeedUpdateFn", {
        set: function (fn) { this._isNeedUpdateFn = fn; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(HotUpdate.prototype, "updateFailFn", {
        set: function (fn) { this._updateFailFn = fn; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(HotUpdate.prototype, "updateSuccFn", {
        set: function (fn) { this._updateSuccFn = fn; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(HotUpdate.prototype, "updateProgressFn", {
        set: function (fn) { this._updateProgressFn = fn; },
        enumerable: false,
        configurable: true
    });
    /**初始化 */
    HotUpdate.prototype.init = function (manifest, cb) {
        this.isUpdating = false;
        this.manifestUrl = manifest;
        this._curVersion = this.getCurVersion();
        this._storagePath = this.getRootPath();
        this._assetMgr = new jsb.AssetsManager("", this._storagePath, this.versionCompare.bind(this));
        this._assetMgr.setVerifyCallback(this.setVerifycb.bind(this));
        // 返回当前版本号
        cb && cb(this._curVersion);
    };
    HotUpdate.prototype.getCurVersion = function () {
        // 尝试从缓存中获取
        var curVersion = cc.sys.localStorage.getItem(this.strogeKey_curVersion);
        if (curVersion)
            return curVersion;
        var storagePath = this.getRootPath();
        storagePath = this.manifestUrl.nativeUrl;
        if (storagePath) {
            // 从本地缓存路径读取manifest文件
            cc.log(storagePath);
            var loadManifest = jsb.fileUtils.getStringFromFile(storagePath);
            var manifestObject = JSON.parse(loadManifest);
            curVersion = manifestObject.version;
        }
        return curVersion;
    };
    HotUpdate.prototype.getRootPath = function () {
        return (jsb.fileUtils ? jsb.fileUtils.getWritablePath() : "/") + "remote-asset";
    };
    /**比较版本号 */
    HotUpdate.prototype.versionCompare = function (v1, v2) {
        this._versionCompareFn && this._versionCompareFn({ local: v1, server: v2 });
        console.log("================= 客户端版本：%s, 当前最新版本：%s ====================", v1, v2);
        var arr1 = v1.split(".");
        var arr2 = v2.split(".");
        for (var i = 0; i < arr1.length; ++i) {
            var num1 = parseInt(arr1[i]);
            var num2 = parseInt(arr2[i] || "0");
            if (num1 == num2) {
                continue;
            }
            else {
                return -1;
            }
        }
        if (arr1.length < arr2.length) {
            return -1;
        }
        else {
            return 0;
        }
    };
    HotUpdate.prototype.setVerifycb = function (assetFullPath, asset) {
        // When asset is compressed, we don't need to check its md5, because zip file have been deleted.
        var compressed = asset.compressed;
        // Retrieve the correct md5 value.
        var expectedMD5 = asset.md5;
        // asset.path is relative path and path is absolute.
        var relativePath = asset.path;
        // The size of asset file, but this value could be absent.
        var size = asset.size;
        if (compressed) {
            console.log("Verification passed : " + relativePath);
            return true;
        }
        else {
            console.log("Verification passed : " + relativePath + ' (' + expectedMD5 + ')');
            return true;
        }
    };
    /**检测是否能够热更新 */
    HotUpdate.prototype.checkHotUpdate = function () {
        if (this.isUpdating) {
            return;
        }
        var url = this.manifestUrl.nativeUrl;
        console.log("原包版本信息url: ", url);
        if (this._assetMgr.getState() == jsb.AssetsManager.State.UNINITED) {
            if (cc.loader.md5Pipe) {
                url = cc.loader.md5Pipe.transformURL(url);
            }
            this._assetMgr.loadLocalManifest(url);
        }
        if (!this._assetMgr.getLocalManifest() || !this._assetMgr.getLocalManifest()) {
            console.log("加载本地manifest文件失败");
            return;
        }
        console.log("localManifest packageUrl：", this._assetMgr.getLocalManifest().getPackageUrl());
        this._assetMgr.setEventCallback(this.checkUpdateEvent.bind(this));
        this._assetMgr.checkUpdate();
        this.isUpdating = true;
    };
    HotUpdate.prototype.checkUpdateEvent = function (event) {
        console.log("checkUpdateEvent Code: %s", event.getEventCode());
        switch (event.getEventCode()) {
            case jsb.EventAssetsManager.ERROR_NO_LOCAL_MANIFEST:
                // this.label.string = "没有本地manifest文件，跳过热更.";
                this._isNeedUpdateFn && this._isNeedUpdateFn(false, "没有本地manifest文件，跳过热更.");
                break;
            case jsb.EventAssetsManager.ERROR_DOWNLOAD_MANIFEST:
            case jsb.EventAssetsManager.ERROR_PARSE_MANIFEST:
                // this.label.string = "下载远程manifest文件失败，跳过热更.";
                this._isNeedUpdateFn && this._isNeedUpdateFn(false, "下载远程manifest文件失败，跳过热更.");
                break;
            case jsb.EventAssetsManager.ALREADY_UP_TO_DATE:
                // this.label.string = "已经更新到远程最新版本.";
                this._isNeedUpdateFn && this._isNeedUpdateFn(false, "已经更新到远程最新版本.");
                break;
            case jsb.EventAssetsManager.NEW_VERSION_FOUND:
                // this.label.string = '发现新版本，请尝试热更';
                this._isNeedUpdateFn && this._isNeedUpdateFn(true, "发现新版本，请尝试热更");
                break;
            default:
                return;
        }
        this._assetMgr.setEventCallback(null);
        this.isUpdating = false;
    };
    /**热更新 */
    HotUpdate.prototype.hotUpdate = function () {
        if (this.isUpdating)
            return;
        if (!this._assetMgr)
            return;
        this._assetMgr.setEventCallback(this.hotUpdateEvent.bind(this));
        if (this._assetMgr.getState() == jsb.AssetsManager.State.UNINITED) {
            var url = this.manifestUrl.nativeUrl;
            if (cc.loader.md5Pipe) {
                url = cc.loader.md5Pipe.transformURL(url);
            }
            this._assetMgr.loadLocalManifest(url);
        }
        this._assetMgr.update();
        this.isUpdating = true;
    };
    HotUpdate.prototype.hotUpdateEvent = function (event) {
        console.log("hotUpdateEvent Code: [%s]  Msg: [%s]", event.getEventCode(), event.getMessage());
        switch (event.getEventCode()) {
            case jsb.EventAssetsManager.ERROR_NO_LOCAL_MANIFEST:
                // this.label.string = '没有本地manifest文件，跳过热更.';
                // failed = true;
                this.hotUpdateFail(event, "没有本地manifest文件，跳过热更.");
                break;
            case jsb.EventAssetsManager.UPDATE_PROGRESSION:
                console.log("当前下载文件数", event.getDownloadedFiles());
                console.log("总文件数", event.getTotalFiles());
                // var msg = event.getMessage();
                // if (msg) {
                //     this.label.string = '更新的文件：: ' + msg;
                // }
                this.hotUpdating(event, '更新的文件：: ' + event.getMessage());
                break;
            case jsb.EventAssetsManager.ERROR_DOWNLOAD_MANIFEST:
            case jsb.EventAssetsManager.ERROR_PARSE_MANIFEST:
                // this.label.string = '下载远程manifest文件失败，跳过热更.';
                // failed = true;
                this.hotUpdateFail(event, "下载远程manifest文件失败，跳过热更.");
                break;
            case jsb.EventAssetsManager.ALREADY_UP_TO_DATE:
                // this.label.string = '已经更新到远程最新版本.';
                // failed = true;
                this.hotUpdateFail(event, "已经更新到远程最新版本.");
                break;
            case jsb.EventAssetsManager.UPDATE_FINISHED:
                // this.label.string = '更新完成，即将重启游戏. ' + event.getMessage();
                // needRestart = true;
                this.hotUpdateSucc(event, '更新完成，即将重启游戏. ' + event.getMessage());
                break;
            case jsb.EventAssetsManager.UPDATE_FAILED:
                // this.label.string = '更新失败. ' + event.getMessage();
                // this.updating = false;
                // // this._canRetry = true;
                this.hotUpdateFail(event, '更新失败. ' + event.getMessage());
                break;
            case jsb.EventAssetsManager.ERROR_UPDATING:
                // this.label.string = 'Asset 更新错误: ' + event.getAssetId() + ', ' + event.getMessage();
                this.hotUpdateFail(event, 'Asset 更新错误: ' + event.getAssetId() + ', ' + event.getMessage());
                break;
            case jsb.EventAssetsManager.ERROR_DECOMPRESS:
                // this.label.string = event.getMessage();
                this.hotUpdateFail(event, event.getMessage());
                break;
            default:
                break;
        }
    };
    HotUpdate.prototype.hotUpdateFail = function (event, msg) {
        console.log("hotUpdateFail Msg: [%s]", msg);
        this.isUpdating = false;
        this._updateFailFn && this._updateFailFn(msg);
    };
    HotUpdate.prototype.hotUpdateSucc = function (event, msg) {
        this._assetMgr.setEventCallback(null);
        var searchPaths = jsb.fileUtils.getSearchPaths();
        var newPaths = this._assetMgr.getLocalManifest().getSearchPaths();
        Array.prototype.unshift(searchPaths, newPaths);
        cc.sys.localStorage.setItem("HotUpdateSearchPaths", JSON.stringify(searchPaths));
        jsb.fileUtils.setSearchPaths(searchPaths);
        var remoteVersion = this.getRemoteVersion();
        cc.sys.localStorage.setItem(this.strogeKey_curVersion, remoteVersion);
        this._updateSuccFn && this._updateSuccFn(remoteVersion);
    };
    HotUpdate.prototype.hotUpdating = function (event, msg) {
        var count_Download = event.getDownloadedFiles();
        var count_Total = event.getTotalFiles();
        this._updateProgressFn && this._updateProgressFn(count_Download / count_Total, msg);
    };
    HotUpdate.prototype.getRemoteVersion = function () {
        var storagePath = this.getRootPath();
        console.log("有下载的manifest文件", storagePath);
        var loadManifest = jsb.fileUtils.getStringFromFile(storagePath + "/project.manifest");
        var manifestObject = JSON.parse(loadManifest);
        return manifestObject.version;
    };
    /**自定义热更新 */
    HotUpdate.prototype.customerHotUpdate = function () {
        var _this = this;
        var curV = this.getCurVersion();
        this.reqHotUpdateInfo(curV, function (info) {
            cc.log(info);
            /* // 大版本更新 1.x.x -> 2.x.x 需要重新下载并安装apk
            let rootpath = this.getRootPath();
            // 清除之前缓存的版本号 和 版本路径
            cc.sys.localStorage.removeItem(this.strogeKey_curVersion);
            jsb.fileUtils.removeDirectory(rootpath);
            // 打开新版本应用下载页
            let packageUrl = "";
            cc.sys.openURL(packageUrl); */
            // 小版本更新
            var needUpdate = _this.versionCompare(info.curV, info.tarV);
            if (needUpdate == 0) {
                console.log("小版本相同，不用更新");
                return;
            }
            _this._modifyAppLoadUrlForManifestFile(info.tarPath, _this.manifestUrl.nativeUrl);
        });
    };
    /**
    * 修改.manifest文件,如果有缓存则比较缓存的版本和应用包的版本，取较高者 热更，如果没有缓存则下载远程的版本文件 取版本号，这里统一修改地址为
    * 远程地址，不管 如何变化 都是从最新的地址下载版本文件。这里远程
    * @param {新的升级包地址} newAppHotUpdateUrl
    * @param {本地project.manifest文件地址} localManifestPath
    */
    HotUpdate.prototype._modifyAppLoadUrlForManifestFile = function (newAppHotUpdateUrl, localManifestPath) {
        var isWritten = false;
        if (jsb.fileUtils.isFileExist(this.getRootPath() + '/project.manifest')) {
            var storagePath = this.getRootPath();
            console.log("有下载的manifest文件", storagePath);
            var loadManifest = jsb.fileUtils.getStringFromFile(storagePath + '/project.manifest');
            var manifestObject = JSON.parse(loadManifest);
            manifestObject.packageUrl = newAppHotUpdateUrl;
            manifestObject.remoteManifestUrl = newAppHotUpdateUrl + "/project.manifest";
            manifestObject.remoteVersionUrl = newAppHotUpdateUrl + "/version.manifest";
            var afterString = JSON.stringify(manifestObject);
            isWritten = jsb.fileUtils.writeStringToFile(afterString, storagePath + '/project.manifest');
        }
        else {
            /**
             * 执行到这里说明App之前没有进行过热更，所以不存在热更的plane文件夹。
             */
            /**
             * plane文件夹不存在的时候，我们就主动创建“plane”文件夹，并将打包时候的project.manifest文件中升级包地址修改后，存放到“plane”文件夹下面。
             */
            var initializedManifestPath = this.getRootPath();
            if (!jsb.fileUtils.isDirectoryExist(initializedManifestPath)) {
                jsb.fileUtils.createDirectory(initializedManifestPath);
            }
            //修改原始manifest文件
            var originManifestPath = localManifestPath;
            var originManifest = jsb.fileUtils.getStringFromFile(originManifestPath);
            var originManifestObject = JSON.parse(originManifest);
            originManifestObject.packageUrl = newAppHotUpdateUrl;
            originManifestObject.remoteManifestUrl = newAppHotUpdateUrl + '/project.manifest';
            originManifestObject.remoteVersionUrl = newAppHotUpdateUrl + '/version.manifest';
            var afterString = JSON.stringify(originManifestObject);
            isWritten = jsb.fileUtils.writeStringToFile(afterString, initializedManifestPath + '/project.manifest');
        }
        cc.log("Written Status : ", isWritten);
        if (isWritten) {
            this.checkHotUpdate();
        }
    };
    HotUpdate.prototype.reqHotUpdateInfo = function (curV, cb) {
        var xhr = cc.loader.getXMLHttpRequest();
        xhr.onreadystatechange = function () {
            if (xhr.readyState == 4 && xhr.status == 200) {
                var txt = xhr.responseText;
                console.log("get hotupdate info from server %s", txt);
                var data = JSON.parse(txt);
                cb && cb(data);
            }
        };
        xhr.withCredentials = false;
        xhr.open("GET", "http://192.168.3.94:3000//hotUpdate?curV=" + curV);
        xhr.send();
    };
    HotUpdate.prototype.reqLocalManifest = function (url, cb) {
        var xhr = cc.loader.getXMLHttpRequest();
        xhr.onreadystatechange = function () {
            if (xhr.readyState == 4 && xhr.status == 200) {
                var txt = xhr.responseText;
                console.log("get localManifest from server %s", txt);
                var data = JSON.parse(txt);
                cb && cb(data);
            }
        };
        xhr.withCredentials = false;
        xhr.open("GET", url, true);
        xhr.send();
    };
    return HotUpdate;
}());
var hotInstance = new HotUpdate();
exports.default = hotInstance;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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