
import { _decorator, Component, Node, Sprite } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('BlendDemo')
export class BlendDemo extends Component {
    @property(Sprite)
    closeSprite: Sprite = null;

    start() {
        this.schedule(
            () => this.closeSprite.srcBlendFactor = this.closeSprite.srcBlendFactor == Sprite.BlendState.SRC_ALPHA ? Sprite.BlendState.ZERO : Sprite.BlendState.SRC_ALPHA,
            1);
    }
}
