/**
 * Zepto v1.2.0 - zepto event ajax form ie - zeptojs.com/license 
 * @description: 
 * 在zepto的基础上精简一个ajax框架出来
 * @author: luomj 
 * @copyright: alading.tech 
 * @date: 2020-11-05 07:42:51
 * @version V1.0.0 
 * @update 
 */
module.exports = (function (global, factory) {
    return factory(global)
}(this, function (win) {
    let Zepto = (function () {
        let undefined, key, $ = {}, emptyArray = [], concat = emptyArray.concat, filter = emptyArray.filter, slice = emptyArray.slice,
            class2type = {},
            toString = class2type.toString,
            isArray = Array.isArray ||
                function (object) { return object instanceof Array }

        function type(obj) {
            return obj == null ? String(obj) :
                class2type[toString.call(obj)] || "object"
        }

        function isFunction(value) { return type(value) == "function" }
        function isWindow(obj) { return obj != null && obj == obj.window }
        function isObject(obj) { return type(obj) == "object" }
        function isPlainObject(obj) {
            return isObject(obj) && !isWindow(obj) && Object.getPrototypeOf(obj) == Object.prototype
        }

        function likeArray(obj) {
            let length = !!obj && 'length' in obj && obj.length,
                type = $.type(obj)
            return 'function' != type && !isWindow(obj) && (
                'array' == type || length === 0 ||
                (typeof length == 'number' && length > 0 && (length - 1) in obj)
            )
        }

        function compact(array) { return filter.call(array, function (item) { return item != null }) }
        function flatten(array) { return array.length > 0 ? concat.apply([], array) : array }
        function camelize(str) { return str.replace(/-+(.)?/g, function (match, chr) { return chr ? chr.toUpperCase() : '' }) }
        function dasherize(str) {
            return str.replace(/::/g, '/')
                .replace(/([A-Z]+)([A-Z][a-z])/g, '$1_$2')
                .replace(/([a-z\d])([A-Z])/g, '$1_$2')
                .replace(/_/g, '-')
                .toLowerCase()
        }

        function extend(target, source, deep) {
            for (key in source)
                if (deep && (isPlainObject(source[key]) || isArray(source[key]))) {
                    if (isPlainObject(source[key]) && !isPlainObject(target[key]))
                        target[key] = {}
                    if (isArray(source[key]) && !isArray(target[key]))
                        target[key] = []
                    extend(target[key], source[key], deep)
                }
                else if (source[key] !== undefined) target[key] = source[key]
        }

        $.extend = function (target) {
            let deep, args = slice.call(arguments, 1)
            if (typeof target == 'boolean') {
                deep = target
                target = args.shift()
            }
            args.forEach(function (arg) { extend(target, arg, deep) })
            return target
        }

        function funcArg(context, arg, idx, payload) {
            return isFunction(arg) ? arg.call(context, idx, payload) : arg
        }

        // "true"  => true
        // "false" => false
        // "null"  => null
        // "42"    => 42
        // "42.5"  => 42.5
        // "08"    => "08"
        // JSON    => parse if valid
        // String  => self
        $.deserializeValue = function (value) {
            try {
                return value ?
                    value == "true" ||
                    (value == "false" ? false :
                        value == "null" ? null :
                            +value + "" == value ? +value :
                                /^[\[\{]/.test(value) ? $.parseJSON(value) :
                                    value)
                    : value
            } catch (e) {
                return value
            }
        }

        $.type = type
        $.isString = (obj) => { return $.type(obj) === 'string' }
        $.isFunction = isFunction
        $.isWindow = isWindow
        $.isArray = isArray
        $.isPlainObject = isPlainObject
        $.camelCase = camelize
        $.parseJSON = JSON.parse

        $.isEmptyObject = function (obj) {
            for (let name in obj) return false
            return true
        }

        $.isNumeric = function (val) {
            let num = Number(val), type = typeof val
            return val != null && type != 'boolean' &&
                (type != 'string' || val.length) &&
                !isNaN(num) && isFinite(num) || false
        }

        $.inArray = function (elem, array, i) {
            return emptyArray.indexOf.call(array, elem, i)
        }


        $.trim = function (str) {
            return str == null ? "" : String.prototype.trim.call(str)
        }
        $.each = function (elements, callback) {
            let i, key
            if (isArray(elements)) {
                for (i = 0; i < elements.length; i++)
                    if (callback.call(elements[i], i, elements[i]) === false) return elements
            } else {
                for (key in elements)
                    if (callback.call(elements[key], key, elements[key]) === false) return elements
            }

            return elements
        }
        // Populate the class2type map
        $.each("Boolean Number String Function Array Date RegExp Object Error".split(" "), function (i, name) {
            class2type["[object " + name + "]"] = name.toLowerCase()
        })
        return $
    })()
        ; (function ($) {
            let jsonpID = +new Date(),
                key,
                name,
                rscript = /<script\b[^<]*(?:(?!<\/script>)<[^<]*)*<\/script>/gi,
                scriptTypeRE = /^(?:text|application)\/javascript/i,
                xmlTypeRE = /^(?:text|application)\/xml/i,
                jsonType = 'application/json',
                htmlType = 'text/html',
                blankRE = /^\s*$/

            // trigger a custom event and return false if it was cancelled
            function triggerAndReturn(context, eventName, data) {
            }

            // trigger an Ajax "global" event
            function triggerGlobal(settings, context, eventName, data) {
            }

            // Number of active Ajax requests
            $.active = 0

            function ajaxStart(settings) {
                if (settings.global && $.active++ === 0) triggerGlobal(settings, null, 'ajaxStart')
            }
            function ajaxStop(settings) {
                if (settings.global && !(--$.active)) triggerGlobal(settings, null, 'ajaxStop')
            }

            // triggers an extra global event "ajaxBeforeSend" that's like "ajaxSend" but cancelable
            function ajaxBeforeSend(xhr, settings) {
                let context = settings.context
                if (settings.beforeSend.call(context, xhr, settings) === false ||
                    triggerGlobal(settings, context, 'ajaxBeforeSend', [xhr, settings]) === false)
                    return false

                triggerGlobal(settings, context, 'ajaxSend', [xhr, settings])
            }
            function ajaxSuccess(data, xhr, settings, deferred) {
                let context = settings.context, status = 'success'
                settings.success.call(context, data, status, xhr)

                if (deferred) deferred.resolveWith(context, [data, status, xhr])
                triggerGlobal(settings, context, 'ajaxSuccess', [xhr, settings, data])
                ajaxComplete(status, xhr, settings)
            }
            function ajaxError(error, type, xhr, settings, deferred) {
                let context = settings.context
                settings.error.call(context, xhr, type, error)
                if (deferred) deferred.rejectWith(context, [xhr, type, error])
                triggerGlobal(settings, context, 'ajaxError', [xhr, settings, error || type])
                ajaxComplete(type, xhr, settings)
            }

            function ajaxComplete(status, xhr, settings) {
                let context = settings.context
                settings.complete.call(context, xhr, status)
                triggerGlobal(settings, context, 'ajaxComplete', [xhr, settings])
                ajaxStop(settings)
            }

            function ajaxDataFilter(data, type, settings) {
                if (settings.dataFilter == empty) return data
                let context = settings.context
                return settings.dataFilter.call(context, data, type)
            }

            // Empty function, used as default callback
            function empty() { }

            $.ajaxSettings = {
                // Default type of request
                type: 'GET',
                // Callback that is executed before request
                beforeSend: empty,
                // Callback that is executed if the request succeeds
                success: empty,
                // Callback that is executed the the server drops error
                error: empty,
                // Callback that is executed on request complete (both: error and success)
                complete: empty,
                // The context for the callbacks
                context: null,
                // Whether to trigger "global" Ajax events
                global: true,
                // Transport
                xhr: function () {
                    return new XMLHttpRequest()
                },
                // MIME types mapping
                // IIS returns Javascript as "application/x-javascript"
                accepts: {
                    script: 'text/javascript, application/javascript, application/x-javascript',
                    json: jsonType,
                    xml: 'application/xml, text/xml',
                    html: htmlType,
                    text: 'text/plain'
                },
                // Default timeout
                timeout: 0,
                // Whether data should be serialized to string
                processData: true,
                // Whether the browser should be allowed to cache GET responses
                cache: true,
                //Used to handle the raw response data of XMLHttpRequest.
                //This is a pre-filtering function to sanitize the response.
                //The sanitized response should be returned
                dataFilter: empty
            }

            function mimeToDataType(mime) {
                if (mime) mime = mime.split(';', 2)[0]
                return mime && (mime == htmlType ? 'html' :
                    mime == jsonType ? 'json' :
                        scriptTypeRE.test(mime) ? 'script' :
                            xmlTypeRE.test(mime) && 'xml') || 'text'
            }

            function appendQuery(url, query) {
                if (query == '') return url
                return (url + '&' + query).replace(/[&?]{1,2}/, '?')
            }

            // serialize payload and append it to the URL for GET requests
            function serializeData(options) {
                console.log(options.processData && options.data && $.type(options.data) != "string")
                console.log(options.data && (!options.type || options.type.toUpperCase() == 'GET' || 'jsonp' == options.dataType))
                if (options.processData && options.data && $.type(options.data) != "string")
                    options.data = $.param(options.data, options.traditional)
                if (options.data && (!options.type || options.type.toUpperCase() == 'GET' || 'jsonp' == options.dataType))
                    options.url = appendQuery(options.url, options.data), options.data = undefined
            }

            $.ajax = function (options) {
                let settings = $.extend({}, options || {}),
                    deferred = $.Deferred && $.Deferred(),
                    urlAnchor, hashIndex
                for (key in $.ajaxSettings) if (settings[key] === undefined) settings[key] = $.ajaxSettings[key]

                ajaxStart(settings)

                if (!settings.url) settings.url = window.location.toString()
                if ((hashIndex = settings.url.indexOf('#')) > -1) settings.url = settings.url.slice(0, hashIndex)
                serializeData(settings)

                let dataType = settings.dataType, hasPlaceholder = /\?.+=\?/.test(settings.url)
                if (hasPlaceholder) dataType = 'jsonp'

                if (settings.cache === false || (
                    (!options || options.cache !== true) &&
                    ('script' == dataType || 'jsonp' == dataType)
                ))
                    settings.url = appendQuery(settings.url, '_=' + Date.now())

                let mime = settings.accepts[dataType],
                    headers = {},
                    setHeader = function (name, value) { headers[name.toLowerCase()] = [name, value] },
                    protocol = /^([\w-]+:)\/\//.test(settings.url) ? RegExp.$1 : window.location.protocol,
                    xhr = settings.xhr(),
                    nativeSetHeader = xhr.setRequestHeader,
                    abortTimeout

                if (deferred) deferred.promise(xhr)

                setHeader('X-Requested-With', 'XMLHttpRequest')
                setHeader('Accept', mime || '*/*')

                if (mime = settings.mimeType || mime) {
                    if (mime.indexOf(',') > -1) mime = mime.split(',', 2)[0]
                    xhr.overrideMimeType && xhr.overrideMimeType(mime)
                }
                if (settings.contentType || (settings.contentType !== false && settings.data && settings.type.toUpperCase() != 'GET'))
                    setHeader('Content-Type', settings.contentType || 'application/x-www-form-urlencoded')

                if (settings.headers) for (name in settings.headers) setHeader(name, settings.headers[name])
                xhr.setRequestHeader = setHeader

                xhr.responseType = settings.responseType

                xhr.onreadystatechange = function () {
                    if (xhr.readyState == 4) {
                        xhr.onreadystatechange = empty
                        clearTimeout(abortTimeout)
                        let result, error = false
                        if ((xhr.status >= 200 && xhr.status < 300) || xhr.status == 304 || (xhr.status == 0 && protocol == 'file:')) {
                            dataType = dataType || mimeToDataType(settings.mimeType || xhr.getResponseHeader('content-type'))

                            if (xhr.responseType == 'arraybuffer' || xhr.responseType == 'blob')
                                result = xhr.response
                            else {
                                result = xhr.responseText

                                try {
                                    // http://perfectionkills.com/global-eval-what-are-the-options/
                                    // sanitize response accordingly if data filter callback provided
                                    result = ajaxDataFilter(result, dataType, settings)
                                    if (dataType == 'script') (1, eval)(result)
                                    else if (dataType == 'xml') result = xhr.responseXML
                                    else if (dataType == 'json') result = blankRE.test(result) ? null : $.parseJSON(result)
                                } catch (e) { error = e }

                                if (error) return ajaxError(error, 'parsererror', xhr, settings, deferred)
                            }

                            ajaxSuccess(result, xhr, settings, deferred)
                        } else {
                            ajaxError(xhr.statusText || null, xhr.status ? 'error' : 'abort', xhr, settings, deferred)
                        }
                    }
                }

                if (ajaxBeforeSend(xhr, settings) === false) {
                    xhr.abort()
                    ajaxError(null, 'abort', xhr, settings, deferred)
                    return xhr
                }

                let async = 'async' in settings ? settings.async : true
                xhr.open(settings.type, settings.url, async, settings.username, settings.password)

                if (settings.xhrFields) for (name in settings.xhrFields) xhr[name] = settings.xhrFields[name]

                for (name in headers) nativeSetHeader.apply(xhr, headers[name])

                if (settings.timeout > 0) abortTimeout = setTimeout(function () {
                    xhr.onreadystatechange = empty
                    xhr.abort()
                    ajaxError(null, 'timeout', xhr, settings, deferred)
                }, settings.timeout)

                // avoid sending empty string (#319)
                xhr.send(settings.data ? settings.data : null)
                return xhr
            }

            // handle optional data/success arguments
            function parseArguments(url, data, success, dataType) {
                if ($.isFunction(data)) dataType = success, success = data, data = undefined
                if (!$.isFunction(success)) dataType = success, success = undefined
                return {
                    url: url
                    , data: data
                    , success: success
                    , dataType: dataType
                }
            }

            $.get = function (/* url, data, success, dataType */) {
                return $.ajax(parseArguments.apply(null, arguments))
            }

            $.post = function (/* url, data, success, dataType */) {
                let options = parseArguments.apply(null, arguments)
                options.type = 'POST'
                return $.ajax(options)
            }

            $.getJSON = function (/* url, data, success */) {
                let options = parseArguments.apply(null, arguments)
                options.dataType = 'json'
                return $.ajax(options)
            }

            let escape = encodeURIComponent

            function serialize(params, obj, traditional, scope) {
                let type, array = $.isArray(obj), hash = $.isPlainObject(obj)
                $.each(obj, function (key, value) {
                    type = $.type(value)
                    if (scope) {
                        key = traditional ? scope :
                            scope + '[' + (hash || type == 'object' || type == 'array' ? key : '') + ']'

                    }
                    // handle data in serializeArray() format
                    if (!scope && array) {
                        params.add(value.name, value.value)
                    } else if (type == "array" || (!traditional && type == "object")) {
                        // recurse into nested objects

                        serialize(params, value, traditional, key)
                    } else {
                        params.add(key, value)
                    }
                })
            }

            $.param = function (obj, traditional) {
                let params = []
                params.add = function (key, value) {
                    if ($.isFunction(value)) value = value()
                    if (value == null) value = ""
                    this.push(escape(key) + '=' + escape(value))
                }
                serialize(params, obj, traditional)

                return params.join('&').replace(/%20/g, '+')
            }
        })(Zepto)

        ; (function ($) {
            let slice = Array.prototype.slice

            function Deferred(func) {
                // 用于储存状态切换的方法名，与对应的执行方法
                // $.Callback({once:1,memory:1}) 用来表示只执行一次，且立即触发
                let tuples = [
                    ["resolve", "done", $.Callbacks({ once: 1, memory: 1 }), "resolved"],
                    ["reject", "fail", $.Callbacks({ once: 1, memory: 1 }), "rejected"],
                    ["notify", "progress", $.Callbacks({ memory: 1 })]
                ],
                    // 执行状态，默认为 执行中
                    state = "pending",
                    promise = {
                        // 返回执行状态
                        state: function () {
                            return state
                        },
                        // 最后一定要执行的函数，通过调用  deferred.done, deferred.fail 来执行
                        always: function () {
                            deferred.done(arguments).fail(arguments)
                            return this
                        },
                        then: function () {
                            let fns = arguments
                            // 其实是返回 deferred 对象上的一个 promise 方法。这样就可以一直链式调用下去，子子孙孙无穷尽也
                            return Deferred(function (defer) {
                                $.each(tuples, function (i, tuple) {
                                    // 判断对应位置的参数是不是一个函数 
                                    let fn = $.isFunction(fns[i]) && fns[i]
                                    // deferred[tuple[1]] 对应着 done, fail, process 三个方法，依次执行
                                    deferred[tuple[1]](function () {
                                        // 调用指定回调，并将结果返回到 returned 中
                                        let returned = fn && fn.apply(this, arguments)
                                        // 如果 returned 是一个 promise ，那么那对应的回调方法传入，并返回 defer.promise()
                                        if (returned && $.isFunction(returned.promise)) {
                                            returned.promise()
                                                .done(defer.resolve)
                                                .fail(defer.reject)
                                                .progress(defer.notify)
                                        } else {
                                            // 否则将它修改上下文状态
                                            let context = this === promise ? defer.promise() : this,
                                                values = fn ? [returned] : arguments
                                            defer[tuple[0] + "With"](context, values)
                                        }
                                    })
                                })
                                fns = null
                            }).promise()
                        },

                        // 返回 promise 对象，如果 obj 上有值，那么将其扩展到 promise 上
                        promise: function (obj) {
                            return obj != null ? $.extend(obj, promise) : promise
                        }
                    },
                    deferred = {}

                // 通过遍历 tuples 生成方法
                $.each(tuples, function (i, tuple) {
                    let list = tuple[2],
                        stateString = tuple[3]

                    promise[tuple[1]] = list.add

                    // 状态切换
                    if (stateString) {
                        list.add(function () {
                            state = stateString
                        }, tuples[i ^ 1][2].disable, tuples[2][2].lock)
                    }

                    deferred[tuple[0]] = function () {
                        deferred[tuple[0] + "With"](this === deferred ? promise : this, arguments)
                        return this
                    }
                    deferred[tuple[0] + "With"] = list.fireWith
                })
                // 使用 promise 扩展 deferred, 让其存在 done, fail, process 三个方法
                promise.promise(deferred)
                if (func) func.call(deferred, deferred)
                return deferred
            }

            // 类似于 Promise 对象中的 all 方法
            $.when = function (sub) {
                let resolveValues = slice.call(arguments),
                    len = resolveValues.length,
                    i = 0,
                    remain = len !== 1 || (sub && $.isFunction(sub.promise)) ? len : 0,
                    deferred = remain === 1 ? sub : Deferred(),
                    progressValues, progressContexts, resolveContexts,
                    // 更新回调，在每个 promise 对象执行 resolve, process 时调用
                    updateFn = function (i, ctx, val) {
                        return function (value) {
                            ctx[i] = this
                            val[i] = arguments.length > 1 ? slice.call(arguments) : value
                            if (val === progressValues) {
                                deferred.notifyWith(ctx, val)
                            } else if (!(--remain)) {
                                deferred.resolveWith(ctx, val)
                            }
                        }
                    }

                // 依次处理异步队列
                if (len > 1) {
                    progressValues = new Array(len)
                    progressContexts = new Array(len)
                    resolveContexts = new Array(len)
                    for (; i < len; ++i) {
                        if (resolveValues[i] && $.isFunction(resolveValues[i].promise)) {
                            resolveValues[i].promise()
                                .done(updateFn(i, resolveContexts, resolveValues))
                                .fail(deferred.reject)
                                .progress(updateFn(i, progressContexts, progressValues))
                        } else {
                            --remain
                        }
                    }
                }
                if (!remain) deferred.resolveWith(resolveContexts, resolveValues)
                return deferred.promise()
            }

            $.Deferred = Deferred
        })(Zepto)
        //为"deferred"模块提供 $.Callbacks。
        ; (function ($) {
            // Create a collection of callbacks to be fired in a sequence, with configurable behaviour
            // Option flags:
            //   - once: 回调只能触发一次
            //   - memory: 记住最近的上下文和参数，如果memory为true则添加的时候会执行一次
            //   - stopOnFalse: 当某个回调函数返回false时中断执行
            //   - unique: 一个回调函数只能被添加一次
            $.Callbacks = function (options) {
                options = $.extend({}, options);

                var memory, // 记录上一次触发回调函数列表时的参数，之后添加的函数都用这参数立即执行
                    fired,  // 是否回调过标志量
                    firing,  // 回调函数列表是否正在执行中
                    firingStart, // 开始回调函数的下标
                    firingLength, // 回调函数列表长度
                    firingIndex, // 回调列表索引值
                    list = [], // 回调数据源:回调列表
                    stack = !options.once && [], //回调只能触发一次的时候，stack永远为false；多次触发永远为数组
                    //触发回调底层函数
                    fire = function (data) {
                        memory = options.memory && data;
                        fired = true;
                        firingIndex = firingStart || 0;
                        firingStart = 0;
                        firingLength = list.length;
                        firing = true;
                        //遍历回调列表，全部回调函数都执行，参数是传递过来的data
                        for (; list && firingIndex < firingLength; ++firingIndex) {
                            //如果 list[ firingIndex ] 为false，且stopOnFalse（中断）模式，则中断回掉执行，设置memory为false
                            if (list[firingIndex].apply(data[0], data[1]) === false && options.stopOnFalse) {
                                memory = false;
                                break
                            }
                        }
                        //回调执行完毕
                        firing = false;
                        if (list) {
                            //stack里还缓存有未执行的回调，则执行stack里的回调
                            if (stack) stack.length && fire(stack.shift());
                            //如果只执行一次而且memory为true(类型转换),那么清空回调函数(不禁用是因为设置了memory，add执行时会调用)
                            else if (memory) list.length = 0;
                            //如果只执行一次而且memory为false(类型转换),那么禁用回调函数
                            else Callbacks.disable();
                        }
                    },
                    Callbacks = {
                        //添加回调函数
                        add: function () {
                            if (list) {
                                var start = list.length,
                                    add = function (args) {
                                        $.each(args, function (_, arg) {
                                            if (typeof arg === "function") {
                                                //非unique，或者是unique，但回调列表未添加过
                                                if (!options.unique || !Callbacks.has(arg)) list.push(arg)
                                            }
                                            //是数组/伪数组，添加，重新遍历
                                            else if (arg && arg.length && typeof arg !== 'string') add(arg)
                                        })
                                    };
                                //添加进列表
                                add(arguments);
                                //如果列表正在执行中，修正长度，使得新添加的回调也可以执行
                                if (firing) firingLength = list.length;
                                else if (memory) {
                                    //memory 模式下，修正开始下标
                                    firingStart = start;
                                    //立即执行所有回调
                                    fire(memory)
                                }
                            }
                            return this
                        },
                        //从回调列表里删除一个或一组回调函数
                        remove: function () {
                            if (list) {
                                $.each(arguments, function (_, arg) {
                                    var index;
                                    while ((index = $.inArray(arg, list, index)) > -1) {
                                        list.splice(index, 1);
                                        // Handle firing indexes
                                        if (firing) {
                                            //避免回调列表溢出
                                            if (index <= firingLength) --firingLength;
                                            //如果移除的函数已经执行过了，则将迭代下标减一，否则会漏掉回调函数没执行
                                            if (index <= firingIndex) --firingIndex
                                        }
                                    }
                                })
                            }
                            return this
                        },
                        //检查指定的回调函数是否在回调列表中；如果参数为空，则方法用来表明是否存在回调函数
                        has: function (fn) {
                            return !!(list && (fn ? $.inArray(fn, list) > -1 : list.length))
                        },
                        //清空回调函数
                        empty: function () {
                            firingLength = list.length = 0;
                            return this
                        },
                        //禁用回调函数
                        disable: function () {
                            list = stack = memory = undefined;
                            return this
                        },
                        //是否禁用了回调函数
                        disabled: function () {
                            return !list
                        },
                        //锁定回调函数
                        lock: function () {
                            stack = undefined;
                            //非memory模式下，禁用列表
                            if (!memory) Callbacks.disable();
                            return this
                        },
                        //是否是锁定的(一次性调用的时，为true)
                        locked: function () {
                            return !stack
                        },
                        //用上下文、参数执行列表中的所有回调函数
                        fireWith: function (context, args) {
                            //如果调用过一次了fired被设置为true，如果设置once为true的话(可类型转换)，则不执行回调函数
                            if (list && (!fired || stack)) {
                                args = args || [];
                                args = [context, args.slice ? args.slice() : args];
                                //正在回调中,存入stack
                                if (firing) stack.push(args);
                                //否则立即回调,外层fire函数
                                else fire(args);
                            }
                            return this
                        },
                        //执行回调
                        fire: function () {
                            return Callbacks.fireWith(this, arguments)
                        },
                        //回调列表是否被回调过
                        fired: function () {
                            return !!fired
                        }
                    };
                return Callbacks
            }
        })(Zepto);
    return Zepto
}))