
export interface HttpRequestData {
    url?: string;
    data?: any;
    method?: string;
    timeout?: number;
    isZip?: any;
}
export class HttpMgr {
    private static _instance: HttpMgr = null;
    static getInstance() {
        if (!this._instance) {
            this._instance = new HttpMgr();
        }
        return this._instance;
    }
    private quest(option: HttpRequestData, callback) {
        let url = option.url;
        let method = option.method;
        let data = option.data ? option.data : null;
        let timeout = option.timeout || 10000;
        let isZip = option.isZip;
        let info = JSON.stringify(data);
        // console.log("info==>",info,url);
        let xhr = new XMLHttpRequest();
        (timeout > 0) && (xhr.timeout = timeout);
        if (isZip) {
            //监听进度事件
            xhr.addEventListener("progress", function (evt) {
                if (evt.lengthComputable) {
                    let percentComplete = evt.loaded / evt.total;
                }
            }, false);
            xhr.responseType = "arraybuffer";
        }
        xhr.onreadystatechange = function () {
            if (xhr.readyState == 4) {
                if (xhr.status >= 200 && xhr.status < 400) {
                    let result = isZip ? xhr.response : xhr.responseText;
                    if (!isZip) {
                        try {
                            result = JSON.parse(xhr.responseText);
                            cc.log("Http Msg " + url + " status : " + xhr.status + " response: " + JSON.stringify(result));
                        } catch (e) {
                            cc.error("http " + url + " status : " + xhr.status + " errorMsg: " + JSON.stringify(result));
                        }
                        // console.log("result====>>>", xhr.status);
                        if (result) {
                            let hintStr = result.errMsg ? result.errMsg : result.message;
                            if (result.code == 999) {
                                console.log(hintStr)
                            } else if (result.code != 200 && result.code != 0) {
                                if (result.code == 401) {
                                    //TODO ERROR
                                } else {
                                    console.log(result.errMsg ? result.errMsg : result.message);
                                }
                                result = undefined;
                            }
                        }
                        callback && callback(result ? result.data : undefined);
                        return
                    }
                    console.log("result=2=> ", result.byteLength);
                    if (result.byteLength < 2000) result = null
                    callback && callback(result ? result : undefined);

                } else {
                    cc.error("http " + url + " status : " + xhr.status);
                    callback && callback(undefined);
                }
            }
        }.bind(this);
        xhr.open(method, url, true);
        if (method == "post") {
            console.log("post");
            let token = "";

            if (token) {
                token = token.indexOf("Bearer ") < 0 ? `Bearer ${token}` : token
                console.log(token);
                xhr.setRequestHeader('Authorization', token);
            }
            xhr.setRequestHeader('Content-Type', 'application/json;charset=UTF-8');
            xhr.send(info);
            xhr.ontimeout = function () {
                cc.error(`HttpMgr ${url} connect timeout.`);
                // ErrorNotice();
                callback && callback(undefined);
            };
        } else {
            // console.log("get")
            xhr.send();
        }
        // xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded;charset=UTF-8');
    };


    public get(option, callback) {
        option.method = 'get';
        this.quest(option, callback);
    };

    public post(option, callback) {
        option.method = 'post';
        this.quest(option, callback);
    };


    private onReadyStateChange = () => {

    }

    private onAbort = () => {

    }

    private onTimeout() {

    }
}
export let httpMgr = HttpMgr.getInstance();
