export class MapClass<T> {
    private keys = new Array<T>();
    private data = {};
    /**
     * 添加数据
     * @param key 
     * @param value 
     * @param isFirst 是否从开头添加
     */
    set(key: any, value: any, isFirst: boolean = false) {
        if (this.data[key] == null) {
            if (!isFirst)
                this.keys.push(key);
            else
                this.keys.unshift(key);
        } else {
            if (isFirst) {
                let pos = this.keys.indexOf(key);
                if (pos > -1) {
                    this.keys.splice(pos, 1);
                }
                this.keys.unshift(key);
            }
        }
        this.data[key] = value;
    };
    /**
     * 设置位置
     * @param key 
     * @param tarPos 目标位置
     */
    setPos(key: any, tarPos: number) {
        let data = this.data[key];
        let pos = this.keys.indexOf(key);
        if (pos > -1) {
            this.keys.splice(pos, 1);
        }
        this.keys.splice(tarPos, 0, key);
        this.data[key] = data;
    }
    /**
     * 获取某键对应的值
     * @param {String} key
     * @return {Object} value
     */
    get(key) {
        return this.data[key];
    };
    /**根据num获取value */
    getValue(num: number) {
        let key: any = this.keys[num];
        let value: any = this.data[key];
        return value;
    }

    /**
     * 删除一个键值对
     * @param {String} key
     */
    remove(key) {
        this.delete(key);
    };
    /**删除 */
    private delete(key) {
        delete this.data[key];
        let pos = this.keys.indexOf(key);
        if (pos > -1) {
            this.keys.splice(pos, 1);
            this.data;
        }
        // this.data[key] = null;
    };
    /**移除所有 */
    removeAll() {
        let len = this.keys.length;
        for (let i = 0; i < len; i++) {
            let k = this.keys[i];
            this.delete(k);
        }
        this.keys = [];
        this.data = {};
    }
    /**
     * key值是否存在
     */
    has(key) {
        if (this.keys.indexOf(key) < 0) {
            return false;
        } else {
            return true;
        }
    }
    /**根据Num获取当前key值 */
    getKey(num: number) {
        return this.keys[num];
    }
    /**获取全部key */
    getAllKey() {
        return this.keys;
    }


    /**获取map长度 */
    get length() {
        return this.keys.length;
    }
    /**
     * 遍历Map,执行处理函数
     * @param {Function} 回调函数 function(key,value,index){..}
     */
    each(fn: any) {
        if (typeof fn != 'function') {
            return;
        }
        let len = this.keys.length;
        for (let i = 0; i < len; i++) {
            let k = this.keys[i] as any;
            fn(k, this.data[k], i);
        }
    }

    /**
     * 获取键值数组(类似<a href="http://lib.csdn.net/base/java" class='replace_word' title="Java 知识库" target='_blank' style='color:#df3434; font-weight:bold;'>Java</a>的entrySet())
     * @return 键值对象{key,value}的数组
     */
    entrys = function () {
        var len = this.keys.length;
        var entrys = new Array(len);
        for (var i = 0; i < len; i++) {
            entrys[i] = {
                key: this.keys[i],
                value: this.data[i]
            };
        }
        return entrys;
    };

    /** 判断Map是否为空*/
    isEmpty = function () {
        return this.keys.length == 0;
    };

    empty() {
        let len = this.keys.length;
        this.keys.splice(0, len);
        this.data = {};
    };

    /**获取键值对数量*/
    size() {
        return this.keys.length;
    };

    /**重写toString*/
    toString() {
        let s = "{";
        for (let i = 0; i < this.keys.length; i++, s += ',') {
            let k = this.keys[i] as any;
            s += k + "=" + this.data[k];
        }
        s += "}";
        return s;
    };
    /**key值排序 */
    sortKeys() {
        let newKeys = this.keys.sort((a: any, b: any) => {
            return a - b;
        });
        this.keys = newKeys;
    }
}
