export class SingleBase extends cc.EventTarget {
    public static getInstance<T>(this: new () => T): T {
        if (!(<any>this).instance) {
            (<any>this).instance = new this();
            (<any>this).instance.init();
        }
        return (<any>this).instance;
    }

    public static deleteInstance() {
        if ((<any>this).instance) {
            (<any>this).instance.clear();
            delete (<any>this).instance;
        }
    }

    public init(name: any, ...args) {
        return this;
    }

    public clear(): void {
    }
}