import { HttpRequestData } from "../common/net/HttpMgr";
import item from "./item";
import { preGameData } from "./prefabTestGameData";
import { preHttpMgr } from "./zip/prefabHttpMagr";
import ZipManager from "./zip/ZipManager";

const { ccclass, property } = cc._decorator;

@ccclass
export default class prefabTest extends cc.Component {

    private _startView: cc.Node = null;
    private _startView2: cc.Node = null;

    @property(cc.Node)
    sp: cc.Node = null;
    @property(cc.Node)
    sp2: cc.Node = null;
    @property(cc.Node)
    sp3: cc.Node = null;
    @property(cc.EditBox)
    eb: cc.EditBox = null;

    @property(cc.Label)
    tipsLab: cc.Label = null;

    onLoad() {
        this._itme1 = this.sp.getComponent(item);
        this._itme2 = this.sp2.getComponent(item);
        this._itme3 = this.sp3.getComponent(item);
    }
    /**预加载测试---未发现内存增加 */
    onPreLoadClick() {
        cc.resources.preloadDir("prefabs", (finish: number, total: number, item) => {
            cc.log(finish / total);
        }, (error: Error, items) => {
            cc.log(items);
        });
    }
    /**动态生成Prefab---按照要求内存会回收 */
    onInitStartViewClick() {
        if (this._startView) {
            this._startView.destroy();
            this._startView = null;
            cc.resources.release("prefabs/startView");
            // cc.assetManager.releaseAll();
            return
        }
        cc.resources.load("prefabs/startView", cc.Prefab, (err, prefab: cc.Prefab) => {
            this._startView = cc.instantiate(prefab);
            this._startView.setParent(this.node);
            this._startView.setPosition(0, 0);
        })
    }
    /**动态生成Prefab---按照要求内存会回收 */
    onInitStartView2Click() {
        if (this._startView2) {
            this._startView2.destroy();
            this._startView2 = null;
            cc.resources.release("prefabs/startView2");
            return
        }
        cc.resources.load("prefabs/startView2", cc.Prefab, (err, prefab: cc.Prefab) => {
            this._startView2 = cc.instantiate(prefab);
            this._startView2.setParent(this.node);
            this._startView2.setPosition(0, 0);
        })
    }
    /**下载资源按钮点击 */
    onDownloadResClick() {
        this.downloadRes();
    }
    /**切换场景 */
    onNextScene() {
        cc.director.loadScene("norScene");
    }

    private downloadRes() {
        this.clearData();
        let num = this.eb.string ? Number(this.eb.string) : 1;
        if (num > 6 || num < 1) {
            this.tipsLab.string = "资源id只能输入1~6";
            return
        }
        let url = `http://static.tope365.com/xxbg/cocos/gif_${num}.zip`
        this.tipsLab.string = `下载中:${num}`;
        let data: HttpRequestData = {
            url: url,
            isZip: true,
        }
        preHttpMgr.get(data, (zip) => {
            this.tipsLab.string = `资源${num}下载完成!!,\n资源解析中，请稍后`;
            ZipManager.loadSubZip(zip, () => {
                // preGameData.zipData.gifMap = zipData.gifMap;
                // cc.log("zipData111=", zipData);
                zip = null;
                // zipData = null;
                // cc.log("zipData222=", zipData);
                // resolve();
                cc.log("11111111111")
                this.tipsLab.string = `资源${num}解析完成!!,\n请点击create按钮`;
            })
        })
    }
    /**创建gif图 */
    createGifBtnClick() {
        this._itme1.createGif(0);
        this._itme2.createGif(1);
        this._itme3.createGif(2);
    }

    private _itme1: item = null
    private _itme2: item = null
    private _itme3: item = null

    clearData() {
        this._itme1.clearData();
        this._itme2.clearData();
        this._itme3.clearData();
        preGameData.clearData();
    }

    clearDataBtnClick() {
        this.clearData();
        this._itme1.removeNode();
        this._itme2.removeNode();
        this._itme3.removeNode();
    }

    // /**
    //  * 创建gif图
    //  * @param word 单词
    //  * @returns 
    //  */
    // createGif(clip, sp, num) {
    //     let key = preGameData.gifRes.getKey(num);
    //     let t_frames: Array<cc.SpriteFrame> = preGameData.gifRes.get(key);
    //     if (this._clip) {
    //         this._clip.decRef();
    //         this._clip = null;
    //     }
    //     this._clip = cc.AnimationClip.createWithSpriteFrames(t_frames, t_frames.length);
    //     this._clip.name = "anim";
    //     this._clip.sample = 60;
    //     this._clip.speed = 0.4;
    //     this._clip.wrapMode = cc.WrapMode.Loop;
    //     this._clip.addRef();
    //     let anim = sp.getComponent(cc.Animation);
    //     if (!anim) {
    //         anim = sp.addComponent(cc.Animation);
    //     }
    //     anim.addClip(this._clip);
    //     anim.play("anim");
    // }

}
