import { MapClass } from "../list/MapClass";
import { SingleBase } from "../list/SingleBase";
import { ZipData } from "./zip/ZipManager";


const { ccclass, property } = cc._decorator;

@ccclass
export default class prefabTestGameData extends SingleBase {
    isListening: boolean = true;
    zipData: ZipData = {
        picMap: new MapClass(),
        audioMap: new MapClass(),
        gifMap: new MapClass(),
    };

    clearData() {
        this.zipData.gifMap.getAllKey().forEach(key => {
            let t_arr: cc.SpriteFrame[] = this.zipData.gifMap.get(key);
            t_arr.forEach((tar: cc.SpriteFrame) => {
                tar.decRef();
                tar.destroy();
            });
            this.zipData.gifMap.remove(key);
        });

        // this.zipData.gifMap.removeAll();
        // this.mp3Res.removeAll();
    }
}

export let preGameData = prefabTestGameData.getInstance();
if (CC_DEBUG) {
    let win: any = window
    win.preGameData = preGameData
}