import { HttpRequestData } from "../../common/net/HttpMgr";
import { SingleBase } from "../../list/SingleBase";


export class prefabHttpMagr extends SingleBase {
    private quest(option: HttpRequestData, callback) {
        let t_url = option.url;
        let t_method = option.method;
        let t_data = option.data ? option.data : null;
        let t_timeout = option.timeout || 20000;
        let t_isZip = option.isZip;
        let t_info = JSON.stringify(t_data);
        // cc.log("info==>",info,url);
        let t_xhr = new XMLHttpRequest();
        (t_timeout > 0) && (t_xhr.timeout = t_timeout);
        if (t_isZip) {
            //监听进度事件
            t_xhr.addEventListener("progress", function (evt) {
                if (evt.lengthComputable) {
                    let t_percentComplete = evt.loaded / evt.total;
                    cc.log("下载进度:", t_percentComplete);
                    // EVT.emit(GameEvents.UpdateProgress, t_percentComplete);
                }
            }, false);
            t_xhr.responseType = "arraybuffer";
        }
        t_xhr.onreadystatechange = function () {
            if (t_xhr.readyState == 4) {
                if (t_xhr.status >= 200 && t_xhr.status < 400) {
                    let t_result = t_isZip ? t_xhr.response : t_xhr.responseText;
                    if (!t_isZip) {
                        try {
                            t_result = JSON.parse(t_xhr.responseText);
                            // cc.log("Http Msg " + url + " status : " + xhr.status + " response: " + JSON.stringify(result));
                            // cc.log(JSON.stringify(result));
                        } catch (e) {
                            cc.error("http " + t_url + " status : " + t_xhr.status + " errorMsg: " + JSON.stringify(t_result));
                        }
                        // cc.log("result====>>>", xhr.status);
                        if (t_result) {
                            let t_hintStr = t_result.errMsg ? t_result.errMsg : t_result.message;
                            if (t_result.code == 999) {
                                cc.log(t_hintStr);
                            } else if (t_result.code != 200 && t_result.code != 0) {
                                if (t_result.code == 401) {
                                    //TODO ERROR
                                } else {
                                    cc.log(t_result.errMsg ? t_result.errMsg : t_result.message);
                                }
                                t_result = undefined;
                            }
                        }
                        callback && callback(t_result ? (t_result.data ? t_result.data : t_result) : undefined);
                        return
                    }
                    cc.log("result=2=> ", t_result.byteLength);
                    if (t_result.byteLength < 2000) t_result = null
                    callback && callback(t_result ? t_result : undefined);

                } else {
                    cc.error("http " + t_url + " status : " + t_xhr.status);

                    // EVT.emit(GameEvents.HideWait);
                    callback && callback(undefined);
                }
            }
        }.bind(this);
        t_xhr.open(t_method, t_url, true);
        // let t_token = gameData.token;
        // if (t_token) {
        //     t_token = t_token.indexOf("Bearer ") < 0 ? `Bearer ${t_token}` : t_token
        //     cc.log(t_token);
        //     t_xhr.setRequestHeader('Authorization', t_token);
        // }
        if (t_method == "post") {
            cc.log("post");
            t_xhr.setRequestHeader('Content-Type', 'application/json;charset=UTF-8');
            t_xhr.send(t_info);
            t_xhr.ontimeout = function () {
                cc.error(`HttpMgr ${t_url} connect timeout.`);
                // ErrorNotice();
                callback && callback(undefined);
            };
        } else {
            // cc.log("get")
            t_xhr.send();
        }
        // xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded;charset=UTF-8');
    };

    public get(option, callback) {
        option.method = 'get';
        this.quest(option, callback);
    };

    public post(option, callback) {
        option.method = 'post';
        this.quest(option, callback);
    };


    private onReadyStateChange = () => {

    }

    private onAbort = () => {

    }

    private onTimeout() {

    }
}
export let preHttpMgr = prefabHttpMagr.getInstance();
