"use strict";
cc._RF.push(module, '5f993Y25CNJeLoEqSXtPnF8', 'prefabHttpMagr');
// scripts/prefabTest/zip/prefabHttpMagr.ts

"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.preHttpMgr = exports.prefabHttpMagr = void 0;
var SingleBase_1 = require("../../list/SingleBase");
var prefabHttpMagr = /** @class */ (function (_super) {
    __extends(prefabHttpMagr, _super);
    function prefabHttpMagr() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.onReadyStateChange = function () {
        };
        _this.onAbort = function () {
        };
        return _this;
    }
    prefabHttpMagr.prototype.quest = function (option, callback) {
        var t_url = option.url;
        var t_method = option.method;
        var t_data = option.data ? option.data : null;
        var t_timeout = option.timeout || 20000;
        var t_isZip = option.isZip;
        var t_info = JSON.stringify(t_data);
        // cc.log("info==>",info,url);
        var t_xhr = new XMLHttpRequest();
        (t_timeout > 0) && (t_xhr.timeout = t_timeout);
        if (t_isZip) {
            //监听进度事件
            t_xhr.addEventListener("progress", function (evt) {
                if (evt.lengthComputable) {
                    var t_percentComplete = evt.loaded / evt.total;
                    cc.log("下载进度:", t_percentComplete);
                    // EVT.emit(GameEvents.UpdateProgress, t_percentComplete);
                }
            }, false);
            t_xhr.responseType = "arraybuffer";
        }
        t_xhr.onreadystatechange = function () {
            if (t_xhr.readyState == 4) {
                if (t_xhr.status >= 200 && t_xhr.status < 400) {
                    var t_result = t_isZip ? t_xhr.response : t_xhr.responseText;
                    if (!t_isZip) {
                        try {
                            t_result = JSON.parse(t_xhr.responseText);
                            // cc.log("Http Msg " + url + " status : " + xhr.status + " response: " + JSON.stringify(result));
                            // cc.log(JSON.stringify(result));
                        }
                        catch (e) {
                            cc.error("http " + t_url + " status : " + t_xhr.status + " errorMsg: " + JSON.stringify(t_result));
                        }
                        // cc.log("result====>>>", xhr.status);
                        if (t_result) {
                            var t_hintStr = t_result.errMsg ? t_result.errMsg : t_result.message;
                            if (t_result.code == 999) {
                                cc.log(t_hintStr);
                            }
                            else if (t_result.code != 200 && t_result.code != 0) {
                                if (t_result.code == 401) {
                                    //TODO ERROR
                                }
                                else {
                                    cc.log(t_result.errMsg ? t_result.errMsg : t_result.message);
                                }
                                t_result = undefined;
                            }
                        }
                        callback && callback(t_result ? (t_result.data ? t_result.data : t_result) : undefined);
                        return;
                    }
                    cc.log("result=2=> ", t_result.byteLength);
                    if (t_result.byteLength < 2000)
                        t_result = null;
                    callback && callback(t_result ? t_result : undefined);
                }
                else {
                    cc.error("http " + t_url + " status : " + t_xhr.status);
                    // EVT.emit(GameEvents.HideWait);
                    callback && callback(undefined);
                }
            }
        }.bind(this);
        t_xhr.open(t_method, t_url, true);
        // let t_token = gameData.token;
        // if (t_token) {
        //     t_token = t_token.indexOf("Bearer ") < 0 ? `Bearer ${t_token}` : t_token
        //     cc.log(t_token);
        //     t_xhr.setRequestHeader('Authorization', t_token);
        // }
        if (t_method == "post") {
            cc.log("post");
            t_xhr.setRequestHeader('Content-Type', 'application/json;charset=UTF-8');
            t_xhr.send(t_info);
            t_xhr.ontimeout = function () {
                cc.error("HttpMgr " + t_url + " connect timeout.");
                // ErrorNotice();
                callback && callback(undefined);
            };
        }
        else {
            // cc.log("get")
            t_xhr.send();
        }
        // xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded;charset=UTF-8');
    };
    ;
    prefabHttpMagr.prototype.get = function (option, callback) {
        option.method = 'get';
        this.quest(option, callback);
    };
    ;
    prefabHttpMagr.prototype.post = function (option, callback) {
        option.method = 'post';
        this.quest(option, callback);
    };
    ;
    prefabHttpMagr.prototype.onTimeout = function () {
    };
    return prefabHttpMagr;
}(SingleBase_1.SingleBase));
exports.prefabHttpMagr = prefabHttpMagr;
exports.preHttpMgr = prefabHttpMagr.getInstance();

cc._RF.pop();