
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/scripts/common/net/HttpMgr.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '668034lgUhIMo3+sj3PUz3S', 'HttpMgr');
// scripts/common/net/HttpMgr.ts

"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.httpMgr = exports.HttpMgr = void 0;
var HttpMgr = /** @class */ (function () {
    function HttpMgr() {
        this.onReadyStateChange = function () {
        };
        this.onAbort = function () {
        };
    }
    HttpMgr.getInstance = function () {
        if (!this._instance) {
            this._instance = new HttpMgr();
        }
        return this._instance;
    };
    HttpMgr.prototype.quest = function (option, callback) {
        var url = option.url;
        var method = option.method;
        var data = option.data ? option.data : null;
        var timeout = option.timeout || 10000;
        var isZip = option.isZip;
        var info = JSON.stringify(data);
        // console.log("info==>",info,url);
        var xhr = new XMLHttpRequest();
        (timeout > 0) && (xhr.timeout = timeout);
        if (isZip) {
            //监听进度事件
            xhr.addEventListener("progress", function (evt) {
                if (evt.lengthComputable) {
                    var percentComplete = evt.loaded / evt.total;
                }
            }, false);
            xhr.responseType = "arraybuffer";
        }
        xhr.onreadystatechange = function () {
            if (xhr.readyState == 4) {
                if (xhr.status >= 200 && xhr.status < 400) {
                    var result = isZip ? xhr.response : xhr.responseText;
                    if (!isZip) {
                        try {
                            result = JSON.parse(xhr.responseText);
                            cc.log("Http Msg " + url + " status : " + xhr.status + " response: " + JSON.stringify(result));
                        }
                        catch (e) {
                            cc.error("http " + url + " status : " + xhr.status + " errorMsg: " + JSON.stringify(result));
                        }
                        // console.log("result====>>>", xhr.status);
                        if (result) {
                            var hintStr = result.errMsg ? result.errMsg : result.message;
                            if (result.code == 999) {
                                console.log(hintStr);
                            }
                            else if (result.code != 200 && result.code != 0) {
                                if (result.code == 401) {
                                    //TODO ERROR
                                }
                                else {
                                    console.log(result.errMsg ? result.errMsg : result.message);
                                }
                                result = undefined;
                            }
                        }
                        callback && callback(result ? result.data : undefined);
                        return;
                    }
                    console.log("result=2=> ", result.byteLength);
                    if (result.byteLength < 2000)
                        result = null;
                    callback && callback(result ? result : undefined);
                }
                else {
                    cc.error("http " + url + " status : " + xhr.status);
                    callback && callback(undefined);
                }
            }
        }.bind(this);
        xhr.open(method, url, true);
        if (method == "post") {
            console.log("post");
            var token = "";
            if (token) {
                token = token.indexOf("Bearer ") < 0 ? "Bearer " + token : token;
                console.log(token);
                xhr.setRequestHeader('Authorization', token);
            }
            xhr.setRequestHeader('Content-Type', 'application/json;charset=UTF-8');
            xhr.send(info);
            xhr.ontimeout = function () {
                cc.error("HttpMgr " + url + " connect timeout.");
                // ErrorNotice();
                callback && callback(undefined);
            };
        }
        else {
            // console.log("get")
            xhr.send();
        }
        // xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded;charset=UTF-8');
    };
    ;
    HttpMgr.prototype.get = function (option, callback) {
        option.method = 'get';
        this.quest(option, callback);
    };
    ;
    HttpMgr.prototype.post = function (option, callback) {
        option.method = 'post';
        this.quest(option, callback);
    };
    ;
    HttpMgr.prototype.onTimeout = function () {
    };
    HttpMgr._instance = null;
    return HttpMgr;
}());
exports.HttpMgr = HttpMgr;
exports.httpMgr = HttpMgr.getInstance();

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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