
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/scripts/list/MapClass.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '21910FuHYZHlL4DruhIDWFk', 'MapClass');
// scripts/list/MapClass.ts

"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MapClass = void 0;
var MapClass = /** @class */ (function () {
    function MapClass() {
        this.keys = new Array();
        this.data = {};
        /**
         * 获取键值数组(类似<a href="http://lib.csdn.net/base/java" class='replace_word' title="Java 知识库" target='_blank' style='color:#df3434; font-weight:bold;'>Java</a>的entrySet())
         * @return 键值对象{key,value}的数组
         */
        this.entrys = function () {
            var len = this.keys.length;
            var entrys = new Array(len);
            for (var i = 0; i < len; i++) {
                entrys[i] = {
                    key: this.keys[i],
                    value: this.data[i]
                };
            }
            return entrys;
        };
        /** 判断Map是否为空*/
        this.isEmpty = function () {
            return this.keys.length == 0;
        };
    }
    /**
     * 添加数据
     * @param key
     * @param value
     * @param isFirst 是否从开头添加
     */
    MapClass.prototype.set = function (key, value, isFirst) {
        if (isFirst === void 0) { isFirst = false; }
        if (this.data[key] == null) {
            if (!isFirst)
                this.keys.push(key);
            else
                this.keys.unshift(key);
        }
        else {
            if (isFirst) {
                var pos = this.keys.indexOf(key);
                if (pos > -1) {
                    this.keys.splice(pos, 1);
                }
                this.keys.unshift(key);
            }
        }
        this.data[key] = value;
    };
    ;
    /**
     * 设置位置
     * @param key
     * @param tarPos 目标位置
     */
    MapClass.prototype.setPos = function (key, tarPos) {
        var data = this.data[key];
        var pos = this.keys.indexOf(key);
        if (pos > -1) {
            this.keys.splice(pos, 1);
        }
        this.keys.splice(tarPos, 0, key);
        this.data[key] = data;
    };
    /**
     * 获取某键对应的值
     * @param {String} key
     * @return {Object} value
     */
    MapClass.prototype.get = function (key) {
        return this.data[key];
    };
    ;
    /**根据num获取value */
    MapClass.prototype.getValue = function (num) {
        var key = this.keys[num];
        var value = this.data[key];
        return value;
    };
    /**
     * 删除一个键值对
     * @param {String} key
     */
    MapClass.prototype.remove = function (key) {
        this.delete(key);
    };
    ;
    /**删除 */
    MapClass.prototype.delete = function (key) {
        delete this.data[key];
        var pos = this.keys.indexOf(key);
        if (pos > -1) {
            this.keys.splice(pos, 1);
            this.data;
        }
        // this.data[key] = null;
    };
    ;
    /**移除所有 */
    MapClass.prototype.removeAll = function () {
        var len = this.keys.length;
        for (var i = 0; i < len; i++) {
            var k = this.keys[i];
            this.delete(k);
        }
        this.keys = [];
        this.data = {};
    };
    /**
     * key值是否存在
     */
    MapClass.prototype.has = function (key) {
        if (this.keys.indexOf(key) < 0) {
            return false;
        }
        else {
            return true;
        }
    };
    /**根据Num获取当前key值 */
    MapClass.prototype.getKey = function (num) {
        return this.keys[num];
    };
    /**获取全部key */
    MapClass.prototype.getAllKey = function () {
        return this.keys;
    };
    Object.defineProperty(MapClass.prototype, "length", {
        /**获取map长度 */
        get: function () {
            return this.keys.length;
        },
        enumerable: false,
        configurable: true
    });
    /**
     * 遍历Map,执行处理函数
     * @param {Function} 回调函数 function(key,value,index){..}
     */
    MapClass.prototype.each = function (fn) {
        if (typeof fn != 'function') {
            return;
        }
        var len = this.keys.length;
        for (var i = 0; i < len; i++) {
            var k = this.keys[i];
            fn(k, this.data[k], i);
        }
    };
    MapClass.prototype.empty = function () {
        var len = this.keys.length;
        this.keys.splice(0, len);
        this.data = {};
    };
    ;
    /**获取键值对数量*/
    MapClass.prototype.size = function () {
        return this.keys.length;
    };
    ;
    /**重写toString*/
    MapClass.prototype.toString = function () {
        var s = "{";
        for (var i = 0; i < this.keys.length; i++, s += ',') {
            var k = this.keys[i];
            s += k + "=" + this.data[k];
        }
        s += "}";
        return s;
    };
    ;
    /**key值排序 */
    MapClass.prototype.sortKeys = function () {
        var newKeys = this.keys.sort(function (a, b) {
            return a - b;
        });
        this.keys = newKeys;
    };
    return MapClass;
}());
exports.MapClass = MapClass;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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