
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/scripts/prefabTest/zip/ZipManager.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '22b354h6XhBAq8vWghQFOMg', 'ZipManager');
// scripts/prefabTest/zip/ZipManager.ts

"use strict";
// import DialogPanel from "../../dialog/DialogPanel";
// import { AC } from "../AndroidConnecter";
// import { prefabTestGameData } from "../data/GameData";
// import { EVT } from "../event/EventCenter";
// import { DialogType, GameEvents } from "../GameEnums";
// import { MapClass } from "../MapClass";
Object.defineProperty(exports, "__esModule", { value: true });
var prefabTestGameData_1 = require("../prefabTestGameData");
var ZipManager = /** @class */ (function () {
    function ZipManager() {
    }
    ZipManager.loadSubZip = function (zippath, cb) {
        var _this = this;
        this._jsonData = {};
        this._textureMap = {};
        prefabTestGameData_1.preGameData.clearData();
        var t_newZip = new JSZip(); // 因为将jszip导入为插件，所以可以全局直接访问
        // if (!this._newZip) this._newZip = new JSZip();
        t_newZip.loadAsync(zippath).then(function (zip) {
            var t_fileList = zip.files;
            var t_keys = Object.keys(t_fileList);
            _this.loadSubZipAll(0, t_keys, zip, cb);
            // this._newZip.remove(zippath)
            t_newZip = null;
        });
    };
    ZipManager.loadSubZipAll = function (num, keys, zip, cb) {
        var _this = this;
        if (num >= keys.length) {
            prefabTestGameData_1.preGameData.zipData.audioMap.sortKeys();
            cb && cb();
            return;
        }
        var t_fileName = keys[num];
        // cc.log(filename);
        var t_strs = t_fileName.split("/");
        var t_wordName = t_strs[t_strs.length - 2];
        t_strs = t_strs[t_strs.length - 1].split(".");
        var t_word = t_strs[0];
        if (!t_wordName) {
            t_wordName = t_word;
        }
        // cc.log("wordName : " + wordName);
        var t_file = t_strs[1];
        if (t_strs.length < 2) {
            num++;
            this.loadSubZipAll(num, keys, zip, cb);
            return;
        }
        if (this.imageTypeArr.indexOf(t_strs[1]) != -1) {
            t_file = "gif";
        }
        switch (t_file) {
            case "jpg":
            case "png":
            case "jpeg":
                if (t_strs[1] == "db") {
                    num++;
                    this.loadSubZipAll(num, keys, zip, cb);
                }
                else {
                    this.loadSprite(zip, t_fileName, function (sp) {
                        prefabTestGameData_1.preGameData.zipData.picMap.set(t_word, sp);
                        num++;
                        _this.loadSubZipAll(num, keys, zip, cb);
                    });
                }
                break;
            case "mp3":
                if (t_strs[1] == "db") {
                    num++;
                    this.loadSubZipAll(num, keys, zip, cb);
                }
                else {
                    this.loadAudio(zip, t_fileName, function (audioClip) {
                        prefabTestGameData_1.preGameData.zipData.audioMap.set(t_word, audioClip);
                        num++;
                        _this.loadSubZipAll(num, keys, zip, cb);
                    });
                }
                break;
            case "gif":
                if (t_strs[1] == "db") {
                    num++;
                    this.loadSubZipAll(num, keys, zip, cb);
                }
                else {
                    var t_array_1 = prefabTestGameData_1.preGameData.zipData.gifMap.get(t_wordName);
                    if (!t_array_1)
                        t_array_1 = new Array();
                    this.loadSprite(zip, t_fileName, function (buffer) {
                        t_array_1.push(buffer);
                        prefabTestGameData_1.preGameData.zipData.gifMap.set(t_wordName, t_array_1);
                        num++;
                        _this.loadSubZipAll(num, keys, zip, cb);
                    });
                }
                break;
            default:
                cc.log("error type ==>", t_fileName);
                num++;
                this.loadSubZipAll(num, keys, zip, cb);
                break;
        }
    };
    /**排序----解决的key值的错乱问题 */
    ZipManager.objOrder = function (obj) {
        var t_newKey = obj.sort(function (a, b) {
            return a - b;
        });
        return t_newKey;
    };
    /**读取图片 */
    ZipManager.loadSprite = function (zip, fileName, cb, isGif) {
        if (isGif === void 0) { isGif = false; }
        zip.file(fileName).async("base64").then(function (data) {
            if (!data) {
                cc.log("not fond image:", fileName);
                // AC.delZip(prefabTestGameData.getZipUrl());
                return;
            }
            var t_arr = fileName.split(".");
            if (t_arr.length < 1) {
                cc.log("res error:", fileName);
            }
            var t_suffix = t_arr[1];
            var t_strImg = "data:image/" + t_suffix + ";base64," + data;
            var t_img = new Image();
            t_img.src = t_strImg;
            var t_texture = new cc.Texture2D();
            t_texture.initWithElement(t_img);
            var t_spriteFrame = null;
            if (!isGif) {
                t_spriteFrame = new cc.SpriteFrame(t_texture);
                t_spriteFrame.addRef();
                cb && cb(t_spriteFrame);
            }
            else {
                cb && cb(t_texture);
            }
        }).catch(function (error) {
            cc.log(fileName + "\u56FE\u7247\u52A0\u8F7D\u5931\u8D25", error);
        });
    };
    /**读取音频 */
    ZipManager.loadAudio = function (zip, fileName, cb) {
        zip.file(fileName).async("arraybuffer").then(function (buffer) {
            var t_arrayBuffer = buffer;
            var t_audioSupport = cc.sys.__audioSupport;
            var t_context = t_audioSupport.context;
            t_context.decodeAudioData(t_arrayBuffer, function (buffer) {
                var t_audioClip = new cc.AudioClip();
                t_audioClip._nativeAsset = buffer;
                t_audioClip.duration = buffer.duration;
                cb && cb(t_audioClip);
            }, function (error) {
                cc.log(fileName, '解析失败-', error);
            });
        });
    };
    /**读取gif图---视听4.0不使用图集资源，使用散图 */
    ZipManager.loadGif = function (zip, fileName, word, cb) {
        var _this = this;
        var t_frames = this._textureMap[fileName];
        if (t_frames) {
            cb && cb(t_frames);
            return;
        }
        t_frames = [];
        var t_json = this._jsonData[word];
        this.loadSprite(zip, fileName, function (texture) {
            for (var frameKey in t_json.frames) {
                var t_frame = t_json.frames[frameKey].frame;
                var t_tex = new cc.SpriteFrame(texture);
                var t_tmpRect = new cc.Rect(t_frame.x, t_frame.y, t_frame.w, t_frame.h);
                t_tex.setRect(t_tmpRect);
                t_tex.setRotated(t_frame.rotated);
                t_frames.push(t_tex);
            }
            var t_len = Object.keys(t_json.frames).length;
            var t_speed = 0;
            if (t_len < 10) {
                t_speed = 0.018 * t_len;
            }
            else if (t_len >= 10 && t_len < 20) {
                t_speed = 0.015 * t_len;
            }
            else {
                t_speed = 0.008 * t_len;
            }
            cc.log("speed=>", word, t_speed, t_len, t_json);
            _this._textureMap[word] = t_frames;
            cb && cb(t_frames, t_speed);
        }, true);
    };
    /**json数据 */
    ZipManager._jsonData = {};
    /**gif图数据Map */
    ZipManager._gifDataMap = null;
    /**zip数据解析 */
    ZipManager.fileTypeArr = ["jpg", "mp3", "gif", "png", "jpeg"];
    ZipManager.imageTypeArr = ["jpg", "png", "jpeg"];
    ZipManager._textureMap = {};
    return ZipManager;
}());
exports.default = ZipManager;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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