"use strict";
cc._RF.push(module, '668034lgUhIMo3+sj3PUz3S', 'HttpMgr');
// scripts/common/net/HttpMgr.ts

"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.httpMgr = exports.HttpMgr = void 0;
var HttpMgr = /** @class */ (function () {
    function HttpMgr() {
        this.onReadyStateChange = function () {
        };
        this.onAbort = function () {
        };
    }
    HttpMgr.getInstance = function () {
        if (!this._instance) {
            this._instance = new HttpMgr();
        }
        return this._instance;
    };
    HttpMgr.prototype.quest = function (option, callback) {
        var url = option.url;
        var method = option.method;
        var data = option.data ? option.data : null;
        var timeout = option.timeout || 10000;
        var isZip = option.isZip;
        var info = JSON.stringify(data);
        // console.log("info==>",info,url);
        var xhr = new XMLHttpRequest();
        (timeout > 0) && (xhr.timeout = timeout);
        if (isZip) {
            //监听进度事件
            xhr.addEventListener("progress", function (evt) {
                if (evt.lengthComputable) {
                    var percentComplete = evt.loaded / evt.total;
                }
            }, false);
            xhr.responseType = "arraybuffer";
        }
        xhr.onreadystatechange = function () {
            if (xhr.readyState == 4) {
                if (xhr.status >= 200 && xhr.status < 400) {
                    var result = isZip ? xhr.response : xhr.responseText;
                    if (!isZip) {
                        try {
                            result = JSON.parse(xhr.responseText);
                            cc.log("Http Msg " + url + " status : " + xhr.status + " response: " + JSON.stringify(result));
                        }
                        catch (e) {
                            cc.error("http " + url + " status : " + xhr.status + " errorMsg: " + JSON.stringify(result));
                        }
                        // console.log("result====>>>", xhr.status);
                        if (result) {
                            var hintStr = result.errMsg ? result.errMsg : result.message;
                            if (result.code == 999) {
                                console.log(hintStr);
                            }
                            else if (result.code != 200 && result.code != 0) {
                                if (result.code == 401) {
                                    //TODO ERROR
                                }
                                else {
                                    console.log(result.errMsg ? result.errMsg : result.message);
                                }
                                result = undefined;
                            }
                        }
                        callback && callback(result ? result.data : undefined);
                        return;
                    }
                    console.log("result=2=> ", result.byteLength);
                    if (result.byteLength < 2000)
                        result = null;
                    callback && callback(result ? result : undefined);
                }
                else {
                    cc.error("http " + url + " status : " + xhr.status);
                    callback && callback(undefined);
                }
            }
        }.bind(this);
        xhr.open(method, url, true);
        if (method == "post") {
            console.log("post");
            var token = "";
            if (token) {
                token = token.indexOf("Bearer ") < 0 ? "Bearer " + token : token;
                console.log(token);
                xhr.setRequestHeader('Authorization', token);
            }
            xhr.setRequestHeader('Content-Type', 'application/json;charset=UTF-8');
            xhr.send(info);
            xhr.ontimeout = function () {
                cc.error("HttpMgr " + url + " connect timeout.");
                // ErrorNotice();
                callback && callback(undefined);
            };
        }
        else {
            // console.log("get")
            xhr.send();
        }
        // xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded;charset=UTF-8');
    };
    ;
    HttpMgr.prototype.get = function (option, callback) {
        option.method = 'get';
        this.quest(option, callback);
    };
    ;
    HttpMgr.prototype.post = function (option, callback) {
        option.method = 'post';
        this.quest(option, callback);
    };
    ;
    HttpMgr.prototype.onTimeout = function () {
    };
    HttpMgr._instance = null;
    return HttpMgr;
}());
exports.HttpMgr = HttpMgr;
exports.httpMgr = HttpMgr.getInstance();

cc._RF.pop();