"use strict";
cc._RF.push(module, '21910FuHYZHlL4DruhIDWFk', 'MapClass');
// scripts/list/MapClass.ts

"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MapClass = void 0;
var MapClass = /** @class */ (function () {
    function MapClass() {
        this.keys = new Array();
        this.data = {};
        /**
         * 获取键值数组(类似<a href="http://lib.csdn.net/base/java" class='replace_word' title="Java 知识库" target='_blank' style='color:#df3434; font-weight:bold;'>Java</a>的entrySet())
         * @return 键值对象{key,value}的数组
         */
        this.entrys = function () {
            var len = this.keys.length;
            var entrys = new Array(len);
            for (var i = 0; i < len; i++) {
                entrys[i] = {
                    key: this.keys[i],
                    value: this.data[i]
                };
            }
            return entrys;
        };
        /** 判断Map是否为空*/
        this.isEmpty = function () {
            return this.keys.length == 0;
        };
    }
    /**
     * 添加数据
     * @param key
     * @param value
     * @param isFirst 是否从开头添加
     */
    MapClass.prototype.set = function (key, value, isFirst) {
        if (isFirst === void 0) { isFirst = false; }
        if (this.data[key] == null) {
            if (!isFirst)
                this.keys.push(key);
            else
                this.keys.unshift(key);
        }
        else {
            if (isFirst) {
                var pos = this.keys.indexOf(key);
                if (pos > -1) {
                    this.keys.splice(pos, 1);
                }
                this.keys.unshift(key);
            }
        }
        this.data[key] = value;
    };
    ;
    /**
     * 设置位置
     * @param key
     * @param tarPos 目标位置
     */
    MapClass.prototype.setPos = function (key, tarPos) {
        var data = this.data[key];
        var pos = this.keys.indexOf(key);
        if (pos > -1) {
            this.keys.splice(pos, 1);
        }
        this.keys.splice(tarPos, 0, key);
        this.data[key] = data;
    };
    /**
     * 获取某键对应的值
     * @param {String} key
     * @return {Object} value
     */
    MapClass.prototype.get = function (key) {
        return this.data[key];
    };
    ;
    /**根据num获取value */
    MapClass.prototype.getValue = function (num) {
        var key = this.keys[num];
        var value = this.data[key];
        return value;
    };
    /**
     * 删除一个键值对
     * @param {String} key
     */
    MapClass.prototype.remove = function (key) {
        this.delete(key);
    };
    ;
    /**删除 */
    MapClass.prototype.delete = function (key) {
        delete this.data[key];
        var pos = this.keys.indexOf(key);
        if (pos > -1) {
            this.keys.splice(pos, 1);
            this.data;
        }
        // this.data[key] = null;
    };
    ;
    /**移除所有 */
    MapClass.prototype.removeAll = function () {
        var len = this.keys.length;
        for (var i = 0; i < len; i++) {
            var k = this.keys[i];
            this.delete(k);
        }
        this.keys = [];
        this.data = {};
    };
    /**
     * key值是否存在
     */
    MapClass.prototype.has = function (key) {
        if (this.keys.indexOf(key) < 0) {
            return false;
        }
        else {
            return true;
        }
    };
    /**根据Num获取当前key值 */
    MapClass.prototype.getKey = function (num) {
        return this.keys[num];
    };
    /**获取全部key */
    MapClass.prototype.getAllKey = function () {
        return this.keys;
    };
    Object.defineProperty(MapClass.prototype, "length", {
        /**获取map长度 */
        get: function () {
            return this.keys.length;
        },
        enumerable: false,
        configurable: true
    });
    /**
     * 遍历Map,执行处理函数
     * @param {Function} 回调函数 function(key,value,index){..}
     */
    MapClass.prototype.each = function (fn) {
        if (typeof fn != 'function') {
            return;
        }
        var len = this.keys.length;
        for (var i = 0; i < len; i++) {
            var k = this.keys[i];
            fn(k, this.data[k], i);
        }
    };
    MapClass.prototype.empty = function () {
        var len = this.keys.length;
        this.keys.splice(0, len);
        this.data = {};
    };
    ;
    /**获取键值对数量*/
    MapClass.prototype.size = function () {
        return this.keys.length;
    };
    ;
    /**重写toString*/
    MapClass.prototype.toString = function () {
        var s = "{";
        for (var i = 0; i < this.keys.length; i++, s += ',') {
            var k = this.keys[i];
            s += k + "=" + this.data[k];
        }
        s += "}";
        return s;
    };
    ;
    /**key值排序 */
    MapClass.prototype.sortKeys = function () {
        var newKeys = this.keys.sort(function (a, b) {
            return a - b;
        });
        this.keys = newKeys;
    };
    return MapClass;
}());
exports.MapClass = MapClass;

cc._RF.pop();