"use strict";
cc._RF.push(module, '22b354h6XhBAq8vWghQFOMg', 'ZipManager');
// scripts/prefabTest/zip/ZipManager.ts

"use strict";
// import DialogPanel from "../../dialog/DialogPanel";
// import { AC } from "../AndroidConnecter";
// import { prefabTestGameData } from "../data/GameData";
// import { EVT } from "../event/EventCenter";
// import { DialogType, GameEvents } from "../GameEnums";
// import { MapClass } from "../MapClass";
Object.defineProperty(exports, "__esModule", { value: true });
var prefabTestGameData_1 = require("../prefabTestGameData");
var ZipManager = /** @class */ (function () {
    function ZipManager() {
    }
    ZipManager.loadSubZip = function (zippath, cb) {
        var _this = this;
        this._jsonData = {};
        this._textureMap = {};
        prefabTestGameData_1.preGameData.clearData();
        var t_newZip = new JSZip(); // 因为将jszip导入为插件，所以可以全局直接访问
        // if (!this._newZip) this._newZip = new JSZip();
        t_newZip.loadAsync(zippath).then(function (zip) {
            var t_fileList = zip.files;
            var t_keys = Object.keys(t_fileList);
            _this.loadSubZipAll(0, t_keys, zip, cb);
            // this._newZip.remove(zippath)
            t_newZip = null;
        });
    };
    ZipManager.loadSubZipAll = function (num, keys, zip, cb) {
        var _this = this;
        if (num >= keys.length) {
            prefabTestGameData_1.preGameData.zipData.audioMap.sortKeys();
            cb && cb();
            return;
        }
        var t_fileName = keys[num];
        // cc.log(filename);
        var t_strs = t_fileName.split("/");
        var t_wordName = t_strs[t_strs.length - 2];
        t_strs = t_strs[t_strs.length - 1].split(".");
        var t_word = t_strs[0];
        if (!t_wordName) {
            t_wordName = t_word;
        }
        // cc.log("wordName : " + wordName);
        var t_file = t_strs[1];
        if (t_strs.length < 2) {
            num++;
            this.loadSubZipAll(num, keys, zip, cb);
            return;
        }
        if (this.imageTypeArr.indexOf(t_strs[1]) != -1) {
            t_file = "gif";
        }
        switch (t_file) {
            case "jpg":
            case "png":
            case "jpeg":
                if (t_strs[1] == "db") {
                    num++;
                    this.loadSubZipAll(num, keys, zip, cb);
                }
                else {
                    this.loadSprite(zip, t_fileName, function (sp) {
                        prefabTestGameData_1.preGameData.zipData.picMap.set(t_word, sp);
                        num++;
                        _this.loadSubZipAll(num, keys, zip, cb);
                    });
                }
                break;
            case "mp3":
                if (t_strs[1] == "db") {
                    num++;
                    this.loadSubZipAll(num, keys, zip, cb);
                }
                else {
                    this.loadAudio(zip, t_fileName, function (audioClip) {
                        prefabTestGameData_1.preGameData.zipData.audioMap.set(t_word, audioClip);
                        num++;
                        _this.loadSubZipAll(num, keys, zip, cb);
                    });
                }
                break;
            case "gif":
                if (t_strs[1] == "db") {
                    num++;
                    this.loadSubZipAll(num, keys, zip, cb);
                }
                else {
                    var t_array_1 = prefabTestGameData_1.preGameData.zipData.gifMap.get(t_wordName);
                    if (!t_array_1)
                        t_array_1 = new Array();
                    this.loadSprite(zip, t_fileName, function (buffer) {
                        t_array_1.push(buffer);
                        prefabTestGameData_1.preGameData.zipData.gifMap.set(t_wordName, t_array_1);
                        num++;
                        _this.loadSubZipAll(num, keys, zip, cb);
                    });
                }
                break;
            default:
                cc.log("error type ==>", t_fileName);
                num++;
                this.loadSubZipAll(num, keys, zip, cb);
                break;
        }
    };
    /**排序----解决的key值的错乱问题 */
    ZipManager.objOrder = function (obj) {
        var t_newKey = obj.sort(function (a, b) {
            return a - b;
        });
        return t_newKey;
    };
    /**读取图片 */
    ZipManager.loadSprite = function (zip, fileName, cb, isGif) {
        if (isGif === void 0) { isGif = false; }
        zip.file(fileName).async("base64").then(function (data) {
            if (!data) {
                cc.log("not fond image:", fileName);
                // AC.delZip(prefabTestGameData.getZipUrl());
                return;
            }
            var t_arr = fileName.split(".");
            if (t_arr.length < 1) {
                cc.log("res error:", fileName);
            }
            var t_suffix = t_arr[1];
            var t_strImg = "data:image/" + t_suffix + ";base64," + data;
            var t_img = new Image();
            t_img.src = t_strImg;
            var t_texture = new cc.Texture2D();
            t_texture.initWithElement(t_img);
            var t_spriteFrame = null;
            if (!isGif) {
                t_spriteFrame = new cc.SpriteFrame(t_texture);
                t_spriteFrame.addRef();
                cb && cb(t_spriteFrame);
            }
            else {
                cb && cb(t_texture);
            }
        }).catch(function (error) {
            cc.log(fileName + "\u56FE\u7247\u52A0\u8F7D\u5931\u8D25", error);
        });
    };
    /**读取音频 */
    ZipManager.loadAudio = function (zip, fileName, cb) {
        zip.file(fileName).async("arraybuffer").then(function (buffer) {
            var t_arrayBuffer = buffer;
            var t_audioSupport = cc.sys.__audioSupport;
            var t_context = t_audioSupport.context;
            t_context.decodeAudioData(t_arrayBuffer, function (buffer) {
                var t_audioClip = new cc.AudioClip();
                t_audioClip._nativeAsset = buffer;
                t_audioClip.duration = buffer.duration;
                cb && cb(t_audioClip);
            }, function (error) {
                cc.log(fileName, '解析失败-', error);
            });
        });
    };
    /**读取gif图---视听4.0不使用图集资源，使用散图 */
    ZipManager.loadGif = function (zip, fileName, word, cb) {
        var _this = this;
        var t_frames = this._textureMap[fileName];
        if (t_frames) {
            cb && cb(t_frames);
            return;
        }
        t_frames = [];
        var t_json = this._jsonData[word];
        this.loadSprite(zip, fileName, function (texture) {
            for (var frameKey in t_json.frames) {
                var t_frame = t_json.frames[frameKey].frame;
                var t_tex = new cc.SpriteFrame(texture);
                var t_tmpRect = new cc.Rect(t_frame.x, t_frame.y, t_frame.w, t_frame.h);
                t_tex.setRect(t_tmpRect);
                t_tex.setRotated(t_frame.rotated);
                t_frames.push(t_tex);
            }
            var t_len = Object.keys(t_json.frames).length;
            var t_speed = 0;
            if (t_len < 10) {
                t_speed = 0.018 * t_len;
            }
            else if (t_len >= 10 && t_len < 20) {
                t_speed = 0.015 * t_len;
            }
            else {
                t_speed = 0.008 * t_len;
            }
            cc.log("speed=>", word, t_speed, t_len, t_json);
            _this._textureMap[word] = t_frames;
            cb && cb(t_frames, t_speed);
        }, true);
    };
    /**json数据 */
    ZipManager._jsonData = {};
    /**gif图数据Map */
    ZipManager._gifDataMap = null;
    /**zip数据解析 */
    ZipManager.fileTypeArr = ["jpg", "mp3", "gif", "png", "jpeg"];
    ZipManager.imageTypeArr = ["jpg", "png", "jpeg"];
    ZipManager._textureMap = {};
    return ZipManager;
}());
exports.default = ZipManager;

cc._RF.pop();