import { _decorator, Component, Node } from 'cc';
import { polymorphism } from './Polymorphism';
const { ccclass, property } = _decorator;

class Shape { }

@ccclass('Circle')
class Circle extends Shape {
    @property({ displayName: '半径' })
    public radius = 0.0;
}

@ccclass('Rectangle')
class Rectangle extends Shape {
    @property({ displayName: '宽' })
    public width = 0.0;

    @property({ displayName: '高' })
    public height = 0.0;
}

@ccclass('PolymorphismDemo')
export class PolymorphismDemo extends Component {
    @property({ displayName: '形状' })
    @polymorphism({
        types: [
            [Circle, '圆形'],
            [Rectangle, '矩形'],
        ],
        displayName: '形状类型',
    })
    public shape: Shape = new Circle();
}