import FileList from "../FileList.js"
import * as fs from "fs"

const AutoAtlasPacName = "auto-atlas.pac";
const AutoAtlasMetaName = "auto-atlas.pac.meta";

export class AutoAtlas {

    _assetDir = "";
    _assetDirData = null;

    constructor( dir ){
        const self = this;
        self._assetDir = dir;
        self.initFileList();
    }

    initFileList(){
        const self = this;
        const fl = new FileList();
        fl.initData( self._assetDir );
        self._assetDirData = fl._data;
    }

    checkPngDir( arrFiles ){
        if( !Array.isArray(arrFiles) ) return false;
        if( arrFiles.length < 2 ) return false;

        let count = 0;
        for( const fileName of arrFiles ){
            if( fileName == AutoAtlasPacName ){
                return false;
            }

            if( fileName.endsWith( ".png" ) ){
                ++count;
            }
        }
        return count >= 2;
    }

    /**
     * {
     *    name: "",
     *    dir: [],
     *    files: []
     * }
     */
    dirForeach( basePath, dirData, callback ){
        if( dirData == null ) return;

        const self = this;

        let fullPath = "";
        if( basePath == null ){
            fullPath = dirData.name + "/";
        }else{
            fullPath = basePath + dirData.name + "/"
        }

        if( self.checkPngDir( dirData.files ) ){            
            callback( fullPath );
        }

        for( const dir of dirData.dir ){
            self.dirForeach( fullPath, dir, callback );
        }
    }

    run(){
        const self = this;
        console.log( "=========start Add AutoAtlas=========" );
        self.dirForeach( null, self._assetDirData, (dir)=>{
            const fullPath = self._assetDir + dir;
            console.log( fullPath );
            fs.copyFileSync( "./AutoAtlas/" + AutoAtlasPacName, fullPath + AutoAtlasPacName );
            fs.copyFileSync( "./AutoAtlas/" + AutoAtlasMetaName, fullPath + AutoAtlasMetaName );
        } );
        console.log( "=========Add AutoAtlas finised=========" );
    }

}