import FileList from "./FileList.js";
import FileTool from "./FileTool.js";

export default class CheckNotUsedRes {

    _assetDir = "";
    _checkDir = "";

    _projectFiles = [];
    _resFiles = [];
    _resMap = new Map();

    constructor( assetDir, dir ){
        const self = this;
        self._assetDir = assetDir;
        self._checkDir = dir;
    }

    initData(){
        const self = this;
        self.initAsset();
        self.initRes();
    }

    initAsset(){
        console.log( "---------init asset data---------" );
        const self = this;

        const fl = new FileList();
        fl.initData( self._assetDir );

        const arrPrefab = fl.filterByType( "prefab" );
        arrPrefab.forEach((fileName)=>{
            self._projectFiles.push( fileName );
        });

        const arrScene = fl.filterByType( "scene" );
        arrScene.forEach((fileName)=>{
            self._projectFiles.push( fileName );
        });
    }

    initRes(){
        console.log( "---------init res data---------" );
        const self = this;
        const fl = new FileList();
        fl.initData( self._checkDir );
        const arrMetaFile = fl.filterByType( "meta" );
        arrMetaFile.forEach((fileName)=>{
            const jsonData = FileTool.readJsonInFile( self._checkDir + "/" + fileName );
            if( jsonData == null ) return;
            if( jsonData[ "importer" ] == "directory" ) return;
            if( jsonData[ "uuid" ] == null ) return;
            self._resMap.set( jsonData[ "uuid" ], { file: fileName, used: false } );
        });
    }

    markUUIDUsedByObj( obj ){
        if( obj == null ) return;

        const self = this;
        for( const key in obj ){
            if( key == "__uuid__" ){
                const strUUID = obj[ "__uuid__" ];
                const idx = strUUID.indexOf( "@" );

                let uuid = "";
                if( idx == -1 ){
                    uuid = strUUID;
                }else{
                    uuid = strUUID.substr( 0, idx );
                }

                const resInfo = self._resMap.get( uuid );
                if( resInfo != null ){
                    resInfo.used = true;
                }
            }else if( typeof obj[key] == "object" ){
                self.markUUIDUsedByObj( obj[key] );
            }
        }
    }

    markResUsed(){
        const self = this;
        console.log( "---------mark res used---------" );
        self._projectFiles.forEach((projectFile)=>{
            console.log( "handle file:" + projectFile );
            const jsonData = FileTool.readJsonInFile( self._assetDir + "/" + projectFile );
            if( jsonData == null ){
                console.warn( "read json failt !" );
                return;
            }

            if( !Array.isArray(jsonData) ){
                console.warn( "jsonData is not Array !" );
                return;
            }

            jsonData.forEach((jsData)=>{
                self.markUUIDUsedByObj( jsData );
            });
        });
    }

    printNotUsed(){
        const self = this;
        console.log( "\n---------not used res---------" );
        self._resMap.forEach((info, key)=>{
            if( info.used ) return;
            console.log( info.file );
        });
    }

    run(){
        console.log( "=========start check not used res=========" );
        const self = this;
        self.initData();
        self.markResUsed();
        self.printNotUsed();        
        console.log( "=========check not used res finished=========\n" );
    }

}