import FileList from "./FileList.js";
import * as fs from "fs";

export default class CopyPng {

    _srcDir = "";
    _pngPathList = [];
    _outDir = "";

    constructor(){
        const self = this;
    }

    setOutDir( dir ){
        this._outDir = dir;
    }

    setPath( assetsPath, arrExcludeDir = [] ){
        const self = this;
        self._srcDir = assetsPath;
        
        const fl = new FileList();
        fl.initData( self._srcDir, arrExcludeDir );
        self._pngPathList = fl.filterByStr( ".png" );
    }

    //创建文件夹
    createDir( dir ){
        if (!fs.existsSync(dir)) {
            fs.mkdirSync(dir, { recursive: true });
        }
    }

    //循环创建文件夹
    createDirDeep( basePath, arrDir ){
        let dir = basePath;
        for( const dirTmp of arrDir ){
            dir += dirTmp + "/";
            this.createDir( dir );
        }
    }

    run(){
        console.log( "=========start copy png=========" );
        const self = this;

        self._pngPathList.forEach((fileName)=>{
            const arrDir = fileName.split( "/" );
            if( arrDir.length > 1 ){
                arrDir.splice( arrDir.length - 1, 1 );
                self.createDirDeep( self._outDir, arrDir );
            }

            fs.copyFileSync( self._srcDir + fileName, self._outDir + fileName );
            console.log( "copy file:" + self._outDir + fileName );
        });
        
        console.log( "=========copy png finished=========\n\n" );
    }

}