import FileTool from "./FileTool.js";

const txtStart = `txt("`;

export default class FindTxtInSearch {

    _searchLogFile = "";
    _outKeyFile = "";
    _cnTxtFile = "";
    _outTxtFile = "";

    _arrLogStr = [];
    _logOtherStr = [];
    _arrTxtKey = [];

    _cnTxtJson = [];

    constructor( searchLog, cnTxtFile, outTxtFile ){
        const self = this;
        self._searchLogFile = searchLog;
        self._cnTxtFile = cnTxtFile;
        self._outTxtFile = outTxtFile;
    }

    readSearchLog(){
        const self = this;
        console.log( "---------read log file---------" );
        console.log( self._searchLogFile + "\n" );
        const str = FileTool.readFile( self._searchLogFile );
        if( str == null || str == "" ){
            console.log( "read log error !" );
            return;
        }
        const newStr = str.replace( /txt\(\s+"/g, txtStart );
        self._arrLogStr = newStr.split( "\n" );
    }

    checkTxtOtherFormat( str ){
        const self = this;
        const idx = str.indexOf( txtStart.substring( 0, txtStart.length - 1 ) );
        if( idx == -1 ) return;

        let endIdx = str.indexOf( ")", idx+txtStart.length );
        if( endIdx == -1 ){
            endIdx = str.indexOf( ",", idx+txtStart.length );
        }

        let keyOthers = "";
        if( endIdx == -1 ){
            keyOthers = str.substring( idx + txtStart.length - 1 );
        }else{
            keyOthers = str.substring( idx + txtStart.length - 1, endIdx );
        }
        if( self._logOtherStr.indexOf(keyOthers) == -1 ){
            self._logOtherStr.push( keyOthers );
        }
    }

    FindTxtInSearch(){
        const self = this;
        console.log( "---------find txt key in log---------" );
        for( const strLog of self._arrLogStr ){
            let txtIdx = -1;
            
            txtIdx = strLog.indexOf( txtStart, txtIdx + 1 );
            if( txtIdx == -1 ){
                self.checkTxtOtherFormat( strLog );
                continue;
            } 
            
            do {
                const endIdx = strLog.indexOf( `"`, txtIdx + txtStart.length + 1 );
                if( endIdx == -1 ) break;

                const key = strLog.substring( txtIdx + txtStart.length, endIdx );
                if( self._arrTxtKey.indexOf(key) == -1 ){
                    self._arrTxtKey.push( key );
                }

                txtIdx = strLog.indexOf( txtStart, txtIdx + txtStart.length + 1 );
            } while ( txtIdx != -1 );
        }

        if( self._logOtherStr.length > 0 ){
            console.warn( "---------other format---------" );
            for( const str of self._logOtherStr ){
                console.warn( str );
            }
        }
    }

    initCnTxt(){
        const self = this;
        console.log( "\n---------read cnTxt json file---------" );
        console.log( self._cnTxtFile );
        self._cnTxtJson = FileTool.readJsonInFile( self._cnTxtFile );
    }

    writeUsedTxt(){
        const self = this;
        console.log( "\n---------find used txt---------" );
        const usedObj = {};
        for( const key in self._cnTxtJson ){
            const value = self._cnTxtJson[ key ];
            if( self._arrTxtKey.indexOf(key) == -1 ) continue;
            usedObj[key] = value;
        }

        const arrNotFoundKey = [];
        for( const key of self._arrTxtKey ){
            let txt = self._cnTxtJson[ key ];
            if( txt == null ){
                arrNotFoundKey.push( key );
            }
        }
        if( arrNotFoundKey.length > 0 ){
            console.log( "\n---------not found key---------" );
            for( const key of arrNotFoundKey ){
                console.log( key );
            }
        }

        console.log( "\n---------write used txt---------" );
        console.log( self._outTxtFile );
        FileTool.writeJsonToFile( self._outTxtFile, usedObj );
    }

    writeTxtKey(){
        const self = this;
        console.log( "\n---------write txt key to file---------" );
        console.log( self._outKeyFile );
        FileTool.writeJsonToFile( self._outKeyFile, self._arrTxtKey );
    }
    
    run(){
        console.log( "=========start find txt in search file=========" );

        const self = this;
        self.readSearchLog();
        self.FindTxtInSearch();
        //self.writeTxtKey();
        self.initCnTxt();
        self.writeUsedTxt();
        
        console.log( "=========find txt in search file end=========" );
    }
}