import FileList from "./FileList.js";
import * as fs from "fs";

export default class PngFileDiff {

    _cnDir = "";
    _enDir = "";
    _outDir = "";

    _cnFilePath = [];
    _enFilePath = [];

    constructor(){

    }

    setDir( cn, en, out ){
        const self = this;
        self._cnDir = cn;
        self._enDir = en;
        self._outDir = out;
        self._cnFilePath = self.initDirData( cn );
        self._enFilePath = self.initDirData( en );
    }

    initDirData( dir ){
        const fl = new FileList();
        fl.initData( dir );
        return fl.filterByType( "png" );
    }

    //创建文件夹
    createDir( dir ){
        if (!fs.existsSync(dir)) {
            fs.mkdirSync(dir, { recursive: true });
        }
    }

    //循环创建文件夹
    createDirDeep( basePath, arrDir ){
        let dir = basePath;
        for( const dirTmp of arrDir ){
            dir += dirTmp + "/";
            this.createDir( dir );
        }
    }

    run(){
        console.log( "=========start files diff=========" );

        const self = this;
        self._cnFilePath.forEach((fileName)=>{
            const idx = self._enFilePath.indexOf( fileName );
            if( idx != -1 ) return;
            
            const arrDir = fileName.split( "/" );
            if( arrDir.length > 1 ){
                arrDir.splice( arrDir.length - 1, 1 );
                self.createDirDeep( self._outDir, arrDir );
            }

            fs.copyFileSync( self._cnDir + fileName, self._outDir + fileName );
            console.log( "copy file:" + self._cnDir + fileName );
        });

        console.log( "=========files diff finished=========" );

    }
}